    @extends('layouts.app')
    @section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
        <li><a href="#">{{__('administrator.dashboard')}}</a></li>
        <li class="active">{{__('administrator.driver')}}</li>
        </ol>
    </div>
    <div class="page">
    <div class=container-fluid>
        <div class="top-content">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="title-add">
                        <div class="pull-left">
                            <h3><span class="fa fa-th"></span> {{__('administrator.driver')}}</h3>
                        </div>
                        <div class="pull-right">
                        @if(Gate::check('Driver Create'))
                        <a href="{{route('driver.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.new_driver')}}</a>
                        @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="wrapper-table ">
            <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.image')}}</th>
                    <th>{{__('administrator.driver_name')}}</th>
                    <th>{{__('administrator.date_of_birth')}}</th>
                    <th>{{__('administrator.email')}}</th>
                    <th>{{__('administrator.phone')}}</th>
                    <th>{{__('administrator.join_date')}}</th>
                    <th>{{__('administrator.share_commision')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
                </thead>
                <tbody>

                </tbody>
            </table>
        </div>
    </div>

    <div class="modal fade" id="myModal" role="dialog" data-keyboard="false" data-backdrop="static">
        <div class="modal-dialog driver-info" style="width: 50%; margin: 0 auto">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-9 col-sm-9" >
                            <ul class="nav nav-tabs">
                                <li class="active"><a class="active show" href="#personal_info" data-toggle="tab">{{ __('administrator.personal_info') }}</a></li>
                                {{-- <li><a href="#place_of_birth" data-toggle="tab">{{ __('administrator.place_of_birth') }}</a></li> --}}
                                <!-- <li><a href="#current_address" data-toggle="tab">Current Address</a></li> -->

                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane active" id="personal_info">
                                    <div class="personal-info">
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    {{-- <p>{{ __('administrator.driver_id') }} :</p> --}}
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="driver_id"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.full_name') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="full_name"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.email') }} / {{ __('administrator.user') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="email"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.id_card_number') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="card_number"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p> {{ __('administrator.date_of_birth') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="dob"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.gender') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="gender"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.phone') }}:</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="personal_phone"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.join_date') }} :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="join_date"></p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p>{{ __('administrator.share_fee') }}:</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="share_fee">

                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p> {{ __('administrator.place_of_birth') }}  :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="place_of_birth"></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                {{-- <div class="tab-pane " id="place_of_birth">
                                    <div class="personal-info">
                                        <div class="list">
                                            <div class="row">
                                                <div class="col-sm-4 col-xs-12">
                                                    <p> {{ __('administrator.place_of_birth') }}  :</p>
                                                </div>
                                                <div class="col-sm-8 col-xs-12">
                                                    <p id="place_of_birth"></p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div> --}}

                            </div>
                        </div>
                        {{-- <div class="col-md-3 col-sm-3">
                            <div class="row text-center sign-with">
                                <div class="col-md-12 col-sm-12">
                                    <h3>Profile</h3>
                                </div>
                                <div class="col-md-12 col-sm-12">
                                    <span id="driver-profile"></span>
                                </div>
                            </div>
                        </div> --}}
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-danger btn-sm" data-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
    @endsection



    @section('script')
    <script type="text/javascript">

        $(document).on('click', '.viewPopLink', function() {
            var showid = $(this).data('id');
            $(".main-spinner").show();
            var part = "{{asset('images/upload')}}";
            $.ajax({
              type: 'GET',
              url: '/nso/driver-info/'+showid,
              dataType: 'json',
              data: {'showid': showid},
              success: function (data) {
                        /////////////////// Personal Info /////////////////
                        ///////////////////////////////////////////////////
                        $('#full_name').empty();
                        $('#driver_id').empty();
                        $('#card_number').empty();
                        $('#dob').empty();
                        $('#personal_phone').empty();
                        $('#join_date').empty();
                        $('#driver-profile').empty();
                        $('#gender').empty();
                        $('#share_fee').empty();
                        $('#email').empty();
                        
                        
                        $('#email').append(data.email);
                        $('#full_name').append(data.name);
                        $('#driver_id').append(data.driver_id_card);
                        $('#card_number').append(data.card_number);
                        $('#dob').append(data.date_of_birth);
                        if(data.gender == 'Male'){ $('#gender').append("Male");}else{$('#gender').append("Female");}
                        $('#personal_phone').append(data.phone);
                        $('#join_date').append(data.join_date);
                        $('#share_fee').append(data.share_fee);
                        if(data.share_fee_type == 1){
                            $('#share_fee').append('$');

                        }else{
                            $('#share_fee').append('%');
                        }

                        /////////////////// Place Of Birth ////////////////
                        ///////////////////////////////////////////////////
                        $('#place_of_birth').empty();

                        $('#place_of_birth').append(data.place_of_birth);

                        $('#reference_phone').append(data.reference_phone);

                        $('#driver-profile').append('<img src="'+part+'/'+data.avartar+'">');

                 $('#myModal').modal('show');
                 $(".main-spinner").hide();

                },

            });
        });
          $(document).on('click', '.bt_action', function() {

            var user_id = $(this).find('.data-id').data('id');
            var status = $(this).hasClass( "off" ) == true ? 1 : 0;

            $.ajax({
                type: "GET",
                dataType: "json",
                url: '/nso/driver-status',
                data: {'status': status, 'user_id': user_id, "_token": "{{ csrf_token() }}"},
                success: function(data){
                console.log(data.success)
                }
            });

            $(this).toggleClass("off");
        });


        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax: "{{route('driver.index')}}",
            columns:
                [
                {data: 'DT_RowIndex'},

                {data: 'image' },
                {data: 'name' },
                {data: 'date_of_birth' },
                {data: 'email' },
                {data: 'phone' },
                {data: 'join_date' },
                {data: 'share_fee' },
                {data: 'action' },


                ],

            "initComplete": function (settings, json) {
            }
        });




    </script>
    @stop



