@extends('layouts.app')
@section('css')

@stop
@section('content')
<?php Fun::lang()?>
<style>
    .fileinput-upload{
        display: none !important;
    }
</style>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
            <li><a href="{{route('users.index')}}">{{__('administrator.driver')}}</a></li>
            <li class="active">{{__('administrator.create_driver')}}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3><span class="fa fa-th"></span> {{__('administrator.create_driver')}}</h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            {!! Form::open(array('route' => 'driver.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
            @csrf
            <div class="row">
                <div class="col-sm-12">
                    <div class="master-form">
                        <div class="title-note">
                            <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.create_driver')}} <i>( {{__('administrator.fields_in_red_are_required')}} )</i></h3>
                        </div> 
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.driver_name')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('name', null, array('placeholder' => __('administrator.driver_name'),'class' => 'form-control' ,'required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.id_card_number')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('card_number', null, array('placeholder' => __('administrator.id_card_number') ,'class' => 'form-control' ,'required')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class=" ">{{__('administrator.date_of_birth')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('date_of_birth', null, array('placeholder' =>  __('administrator.date_of_birth'),'class' => 'form-control date_picker','autocomplete'=>'off')) !!}

                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required ">{{__('administrator.gender')}} </label>
                            </div>
                            <div class="col-sm-9">
                                <select class="chosen-select form-control" name="gender">
                                    <option value="Male"> {{ __('administrator.male') }}   </option>
                                    <option value="Female"> {{ __('administrator.female') }}  </option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.phone')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('phone', null, array('placeholder' =>  __('administrator.phone'),'class' => 'form-control' )) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.join_date')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::text('join_date', null, array('placeholder' =>  __('administrator.join_date'),'class' => 'form-control date_picker','autocomplete'=>'off')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class=" ">{{__('administrator.place_of_birth')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::textarea('place_of_birth',null, array('placeholder' =>__('administrator.place_of_birth'),'class' => 'form-control', 'rows'=>'2')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class=" ">{{__('administrator.current_address')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::textarea('current_address',null, array('placeholder' =>__('administrator.current_address'),'class' => 'form-control', 'rows'=>'2')) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.share_fee_type')}}   </label>
                            </div>
                            <div class="col-sm-2">
                                <input type="checkbox" class="checkbox" checked data-toggle="toggle" data-on=" {{__('administrator.share_fee_type_')}} ($)" data-off=" {{__('administrator.share_fee_type_')}} (%)" data-onstyle="danger" data-offstyle="success">
                                <input type="hidden" class="share_fee_type" value="1" name="share_fee_type" >
                            </div>

                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.share_fee')}}  </label>
                            </div>
                            <div class="col-sm-4">
                                {!! Form::text('share_fee', null, array('placeholder' => __('administrator.share_fee'),'class' => 'form-control share_fee')) !!}
                            </div>
                        </div>


                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.email')}} </label>
                            </div>
                            <div class="col-sm-9">
                            {!! Form::text('email', null, array('placeholder' => __('administrator.email'),'class' => 'form-control','required')) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.password')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::password('password', array('placeholder' => __('administrator.password'),'class' => 'form-control','required','autocomplete'=>"off",)) !!}
                            </div>
                        </div>
                        <div class="form-group col-sm-6 col-xs-6">
                            <div class="col-sm-3 col-xs-12 ">
                                <label class="required">{{__('administrator.password_confirm')}} </label>
                            </div>
                            <div class="col-sm-9">
                                {!! Form::password('confirm_password', array('placeholder' => __('administrator.password_confirm'),'class' => 'form-control','required','autocomplete'=>"off",)) !!}
                            </div>
                        </div>

                        <div class="form-group col-sm-12 col-xs-12">
                            <div class="col-sm-3 col-xs-12">
                                <label >{{__('administrator.profile')}}</label>
                            </div>
                            <div class="form-group col-sm-12">
                                <input id="file-input" type="file" name="image" class="file">
                            </div>
                        </div>

                        <div class="col-sm-12 col-xs-12">
                            <div class="form-group footer-save">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                                <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
@endsection

@section('script')
<script type="text/javascript">
    $(document).on('change', '.toggle',function(){
        var status = $(this).hasClass( "off" ) == true ? 2 : 1;
        $('.share_fee_type').val(status);
        $('.share_fee').val("");
    });

    $("#file-input").fileinput({
          initialPreview: images,
          initialPreviewAsData: true,
          uploadUrl: "/",
          maxFilePreviewSize: 10240,
          overwriteInitial: true,
          showUpload:true
      });
    
</script>
@stop



