@extends('layouts.app')
@section('content')
    <?php Fun::lang(); ?>
    <style>
        .buttons-html5 {
            background: coral !important;
        }

        div.dt-button-collection {
            width: 80px;
        }

        div.dt-button-collection span {
            color: black;
        }

        div.dt-button-collection {
            width: 182px;

        }

        .select2-container.select2-container--default.select2-container--open {
            z-index: 99999999;
        }

        /* .ui-datepicker-calendar {
            display: none;
        } */

    </style>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{ __('administrator.dashboard') }}</a></li>
            <li><a href="#">{{ __('administrator.report') }}</a></li>
            <li class="active">{{ __('administrator.driver') }}</li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content" style="margin-top: 15px">
                <div class="row">
                    <div class="col-md-12">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">{{ __('administrator.driver') }}</label>
                                    {!! Form::select('driver', \Globals::getDrivers($disactive=false), null, ['class' => 'form-control chosen-select','id'=>'driver','required']) !!}
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">{{ __('administrator.from') }}</label>
                                    <input type="text" class="form-control date-year" id="from_date"
                                        placeholder="{{ __('administrator.from') }}" value="{{date("Y-m-d",strtotime("first day of this month"))}}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="exampleInputEmail1">{{ __('administrator.to') }}</label>
                                    <input type="text" class="form-control date-year" id="to_date"
                                        placeholder="{{ __('administrator.from') }}" value="{{date("Y-m-d")}}">
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="row">
                                    @if (Gate::check("Export Monthy Staff Report"))
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1" style="opacity: 0">{{ __('administrator.to') }}</label>
                                                <input type="button" class="btn btn-sm btn-primary form-control"
                                                    placeholder="{{ __('administrator.export_to_excel') }}" value="{{ __('administrator.export_to_excel') }}" id="btn-export_to_excel">
                                            </div>
                                        </div>
                                    @endif
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="exampleInputEmail1" style="opacity: 0">{{ __('administrator.to') }}</label>
                                            <input type="button" class="btn btn-sm btn-primary form-control"
                                                placeholder="{{ __('administrator.from') }}" value="Search" id="btn-search">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">




                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="datatable_show" width="100%" class="table table-bordered table-striped hover  ">
                    <thead>
                        <tr>
                            <th width="3%">{{ __('administrator.no') }}</th>
                            <th width="7%">{{ __('administrator.driver_name') }}</th>
                            <th width="4%">{{ __('administrator.income') }}</th>
                            @for ($i = 1; $i < 32; $i++)
                                <th width="2.50%">{{ $i }}</th>
                            @endfor


                        </tr>
                    <tbody class="tbody">

                    </tbody>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th colspan="2" style="border: 1px solid #ddd;text-align: right">Total Box :</th>

                            <th style="border: 1px solid #ddd">1</th>
                            @for ($i = 1; $i < 32; $i++)
                                <th style="border: 1px solid #ddd">1</th>
                            @endfor
                        </tr>
                    </tfoot>


                </table>
            </div>
        </div>
    @endsection
    @section('script')
        <script type="text/javascript">
            $(document).ready(function() {
                $(document).on('click','#btn-export_to_excel',function(){
                    let from_date = $('#from_date').val();
                    let to_date = $('#to_date').val();
                    let driver_id = $('#driver').val();
                    window.open("{{route('report-driver-revenue.index')}}?from_date="+from_date+"&to_date="+to_date+"&driver_id="+driver_id+"&export=excel","_blank")
                });
                $('.date-year').datepicker({
                    changeMonth: true,
                    changeYear: true,

                    onClose: function(dateText, inst) {
                        // getData();
                    }
                });
                // $(document).on('change','#driver',function(){
                //    getData();
                // });
                $(document).on('click','#btn-search',function(){
                   getData();
                });


                function getData() {
                    let from_date = $('#from_date').val();
                    let to_date = $('#to_date').val();
                    let driver_id = $('#driver').val();
                    $("#btn-export_to_excel").attr("disabled",true);
                    $("#btn-search").attr("disabled",true);
                    $.get(window.location, {
                            from_date,
                            to_date,
                            driver_id
                        },
                        function(response, textStatus, jqXHR) {
                            $('.tbody').html(response.data);
                            total();
                            $("#btn-export_to_excel").attr("disabled",false);
                            $("#btn-search").attr("disabled",false);
                        },
                        "json"
                    );
                }

                function total() {
                    let b = 1;
                    for (let i = 1; i < 33; i++) {
                        let total = 0;
                        b += 1;
                        $.each($('#datatable_show tbody tr').find('td:eq(' + (b) + ')'), function(key, v) {
                            total += $(this).closest('td').text() ? parseFloat($(this).closest('td').text().replace(/[$,]/g, '')) : 0;
                        });
                        console.log(total);
                        if (total > 0 && total < 5) {
                            $('#datatable_show tfoot tr th:eq("' + (b - 1) + '")').attr('style',
                                'background-color:yellow !important')
                        } else if (total > 5) {
                            $('#datatable_show tfoot tr th:eq("' + (b - 1) + '")').attr('style',
                                'background-color:green !important')
                        }else{
                            $('#datatable_show tfoot tr th:eq("' + (b - 1) + '")').attr('style',
                                'background-color:')
                        }
                        $('#datatable_show tfoot tr th:eq("' + (b - 1) + '")').text('$ '+total.toFixed(2));
                    }
                }
            });
        </script>
    @stop
