@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
      <li><a href="#">{{__('administrator.discount')}}</a></li> 
    </ol>
</div>
<div class="page">
<div class=container>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3>{{__('administrator.discount')}}</h3>
                    </div>

                </div>
            </div>
        </div>
    </div>
    @if ($data == date('Y-m-d')) 
    {!! Form::model($discountmodel, ['method' => 'PATCH','route' => ['discount.update', $discountmodel->id]]) !!} 
    <div class="row">
        <div class="col-sm-12">
            <div class="master-form">
                <div class="title-note">
                    <h3><span class="fa fa-exclamation-triangle"></span>{{__('administrator.packed')}} <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="show">
                    
                            <div class="show1">
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.discount_name')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('discount_name',null, array('placeholder' => __('administrator.discount_name'),'class' => 'form-control ' ,'required' )) !!}
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.merchant')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::select('shop_id[]', $merchant, explode(',', $discountmodel->shop_id) , ['class' => 'form-control merchant','multiple'=>'multiple' ,'required']) !!}
                                    </div>
                                </div> 
                                
                                <input type="hidden" class="discount_type" value="3" name="discount_type" >
                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.discount_amount')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('discount',null, array('placeholder' => __('administrator.discount'),'class' => 'form-control discount  number-only ' ,'required' )) !!} 
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.discount')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','readonly')) !!} 
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.description')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('description',null, array('placeholder' => __('administrator.description'),'class' => 'form-control  ' )) !!}
                                    </div>
                                </div>
                                
                            </div>
                    
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                            <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
    @else
    {!! Form::open(array('route' => 'discount.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
        <div class="row">
            <div class="col-sm-12">
                <div class="master-form">
                    <div class="title-note">
                        <h3><span class="fa fa-exclamation-triangle"></span>{{__('administrator.packed')}} <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                    </div>
                    <div class="show">
                       
                            <div class="show1">
                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name" class="required">{{__('administrator.discount_name')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('discount_name',null, array('placeholder' => __('administrator.discount_name'),'class' => 'form-control ' ,'required' )) !!}
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12">
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name" class="required"  >{{__('administrator.merchant')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::select('shop_id[]', $merchant, null, ['class' => 'form-control merchant','multiple'=>'multiple' ,'required']) !!}
                                    </div>
                                </div> 
                                
                                <input type="hidden" class="discount_type " value="3" name="discount_type" >

                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name" class="required">{{__('administrator.discount_amount')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('discount',null, array('placeholder' => __('administrator.discount'),'class' => 'form-control discount number-only ' ,'required' )) !!} 
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name" class="required">{{__('administrator.date')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker','readonly')) !!} 
                                    </div>
                                </div>

                                <div class="form-group col-sm-12 col-xs-12"> 
                                    <div class="col-sm-3 col-xs-12 ">
                                        <label for="name">{{__('administrator.description')}}</label>
                                    </div>
                                    <div class="col-sm-9">
                                        {!! Form::text('description',null, array('placeholder' => __('administrator.description'),'class' => 'form-control   ' )) !!}
                                    </div>
                                </div> 
                            </div>
                      
                    </div>

                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> {{__('administrator.save')}}</button>
                            <button type="button" onClick="javascript:history.go(-1)" class="button_sm button_warning pull-right">
                                <span class=" fa fa-arrow-circle-left"></span> {{__('administrator.back')}}</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {!! Form::close() !!}
    @endif
    
</div> 
@endsection 
@section('script')
<script type="text/javascript">
    $(document).ready(function(){
       
        var share_fee_type = $('.discount_type').val();
        if(share_fee_type==2){
            $(".toggle").removeClass("btn-danger");
            $(".toggle").addClass("btn-success off");
        }
    });


    $(document).on('change', '.toggle',function(){
        var status = $(this).hasClass( "off" ) == true ? 2 : 1;
        $('.discount_type').val(status);
        $('.discount').val("");
    });
</script>
@stop
