@extends('layouts.app') @section('content')
<?php Fun::lang() ?>
<style>
    .select2-dropdown.select2-dropdown--below{
        z-index: 10000000;
    }
</style>
<div class="top-header">
    <ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active"><a href="#">{{__('administrator.assign_to_driver')}}</a></li>
    </ol>
</div>

<div class="page-purchases">
    {!! Form::open(array('route' => 'delivery-order.store','method'=>'POST','enctype'=>'multipart/form-data','id'=>'submit_post')) !!}
    <div class="preview">
        <div class="col-sm-5">
            <div class="col-sm-4 paddin-10">
                <div class="form-group" >
                    <strong>{{__('administrator.product_code')}}</strong>
                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.search_product_name') ,'class' => ' search_text form-control', "autocomplete" => "on" ,"onkeydown"=>"return (event.keyCode!=13);")) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div>
                {{-- <div class="form-group" >
                    <strong>{{__('administrator.zone')}}</strong>
                    {!! Form::select('from_location[]', @$loc_zone??[],null, array('class' => 'from_location select2 form-control', "autocomplete" => "on",'multiple')) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div> --}}
            </div>
            {{-- <div class="col-sm-4 paddin-10">
                <div class="form-group" >
                    <strong>{{__('administrator.location')}}</strong>
                    {!! Form::select('zone[]', @$zone??[],null, array('class' => 'zone select2 form-control', "autocomplete" => "on",'multiple')) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div>
            </div>
            <div class="col-sm-4 paddin-10">
                <div class="form-group" >
                    <strong>{{__('administrator.shop_name')}}</strong>
                    {!! Form::select('shop', @$shop??[],null, array('placeholder' => __('administrator.shop_name') ,'class' => 'shop select2 form-control', "autocomplete" => "on")) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div>
            </div> --}}
            <div class="col-sm-4 paddin-10">
                    <strong>Check All</strong>
                    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                    <input class="form-check-input" type="checkbox" value="" id="check_all">
            </div>
            <div class="col-sm-4 paddin-10 text-right" id="box_add_all">
                <div class="form-check">
                    <input type="button" class=" btn btn-sm btn-primary" id="add-all" value="Add All">
                 </div>
            </div>
            <div class="product-item-list">
                <div class="item-list box-addtocart">
                    <div class="row show_product" id="tag_container">
                        {{-- @include('administrator.delivery-order.result-create') --}}
                    </div>
                </div>
            </div>
    </div>
        <div class="col-sm-7">

            <div class="check-bill">
                <div class="row">

                    <div class="check-bill-table">
                        <div class="product-view-table">
                            <div class="tbl-header">
                                <table width="100%" class="table table-striped">
                                    <thead class="text-center">
                                        <tr>
                                            <th width="5%">{{__('administrator.no')}}</th>
                                            <th width="15%">{{__('administrator.box_code')}} </th>
                                            <th width="15%">{{__('administrator.location')}}</th>
                                            <th width="15%">{{__('administrator.customer')}}</th>
                                            <th width="15%">{{__('administrator.price')}}</th>
                                            <th width="15%">{{__('administrator.delivery_fee')}} </th>
                                            <th width="10%">{{__('administrator.action')}}</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <div class="tbl-content">
                                <div class="overflow">
                                    <table width="100%" class="table table-striped">
                                        <tbody class="resultbody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="form-group">
                        <strong>{{__('administrator.date')}}<span  class="required">*</span></strong>
                        <input type="text" name="delivery_date" value="<?php echo date("d-m-Y")?>" class="form-control date_picker_min_date" required>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
{{--                        <strong>{{__('administrator.driver')}} <span  class="required">*</span></strong>--}}
{{--                        <select name="driver_id" id=""  class="form-control chosen-select driver_id">--}}
{{--                            @foreach (@$drivers??[] as $key=>$val)--}}
{{--                                <option value="{{$drivers}}" data-timpe_id="{{$drivers}}">{{$drivers}}</option>--}}
{{--                            <option value="{{$key}}" data-timpe_id="{{$key}}">{{$val}}</option>--}}
{{--                            @endforeach--}}
{{--                        </select>--}}
                        <strong>{{__('administrator.driver')}} <span  class="required">*</span></strong>
                        <select name="driver_id" id=""  class="form-control chosen-select driver_id">
                            <option value="">{{__('administrator.please_select')}}</option>
                            @foreach (@$drivers??[] as $key=>$val)
                                <option value="{{$drivers[$key]['id']}}||{{$drivers[$key]['time_policy_id']}}" data-timpe_id="{{$drivers[$key]['time_policy_id']}}">{{$drivers[$key]['name']}}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <div class="blog-payment ">
                    <div class="col-sm-12 ">
                        <div class="button_payment pull-right">
                            <button type="button" class="form-button button_warning button_lg" onclick="history.back(1)">{{__('administrator.back')}}</button>
                            <button type="button" class="form-button button_danger remove_all button_lg">{{__('administrator.remove')}}</button>
                            <button type="submit" class="form-button button_info button_lg">{{__('administrator.save')}}</button>
                        </div>
                    </div>
                </div>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>



<style type="text/css">

</style>
@endsection
@section('script')
<script type="text/javascript">
    $(document).ready(function(){
        $('.search_text').focus();
        $(document).on('change','.zone',function(){
            let from_location = $('.from_location').val();
            // if(from_location == ''){
            //     $('.zone').val('');
            // }
            let shop_id = $('.shop').val();
            let zone_id = $('.zone').val();

            console.log(zone_id);
            $.get(window.location, {
                shop_id:shop_id,
                zone_id:zone_id,
                from_location:from_location,
            },
                function (data, textStatus, jqXHR) {
                    $('#tag_container').html(data);
                    // get_list_view();
                    get_item_show_hide();
                },
            );
        });
        $(document).on('change','.shop,.from_location',function(){
            let from_location = $('.from_location').val();
            if(from_location == ''){
                $('.zone').val('');
            }
            let shop_id = $('.shop').val();
            let zone_id = $('.zone').val();

            console.log(zone_id);
            $.get(window.location, {
                shop_id:shop_id,
                zone_id:zone_id,
                from_location:from_location,
            },
                function (data, textStatus, jqXHR) {
                    $('#tag_container').html(data);
                    // get_list_view();
                    get_item_show_hide();
                },
            );
        });
        $(document).on('change','.from_location',function(){
            let shop_id = $('.shop').val();
            let zone_id = $('.zone').val();
            let from_location = $('.from_location').val();
            $.get(window.location, {
               'need_location':'need_location',
                shop_id:shop_id,
                zone_id:zone_id,
                from_location:from_location,
            },
                function (data, textStatus, jqXHR) {
                    let opt = '';
                    $.each(data, function (i, val) {
                         opt += '<option value="'+i+'">'+val+'</option>';
                    });
                   $('.zone').html(opt).select2();
                },
            );
        });
        $(document).on('click','#check_all',function(){
            if($(this).is(':checked')){
                $('.product_check').prop('checked',true);
                // $('#box_add_all').css({'display':'block'});
            }else{
                $('.product_check').prop('checked',false);
                // $('#box_add_all').css({'display':'none'})
            }
        });
        $(document).on('click','#add-all',function(){
            let array = [];
            $.each($('.product_check'), function (i, value) {
                 let checked = $(this).prop('checked');
                 if(checked == true){
                    if($(this).closest('.box_code_show').attr('style') == undefined){
                        array.push($(this).data('id'));
                    }
                 }
            });
            if(!array.length){
                $.alert('Data is Invalid!')
                return false;
            }
            $.ajax({
                        url: "{{ Route('search-box-array') }}",
                        method: "POST",
                        dataType: "Text",
                        data: {
                            id: array,
                            _token: '{{ csrf_token() }}',
                        },
                        success: function (data) {
                            if(data == 'success'  || data == '"success"'){
                                    {{-- $(".search_text").val(''); --}}
                                    $(".search_text").focus();
                                get_list_view();
                                get_item_show_hide() ;
                                $('#check_all').prop('checked',false);

                            }else{
                                status_(data);
                            }
                        }
                    });
        })
        $(document).on('click', '.pagination a',function(event){
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var myurl = $(this).attr('href');
            var page=$(this).attr('href').split('page=')[1];
            getData(page);
        });
    });

    function getData(page){
        $.ajax({
            url: '?page=' + page,
            type: "get",
            datatype: "html"
        }).done(function(data){
            get_item_show_hide();
            $("#tag_container").empty().html(data);
            location.hash = page;
        }).fail(function(jqXHR, ajaxOptions, thrownError){
                alert('No response from server');
        });
    }


    $(document).ready(function(){
        getData(1);
        get_list_view(load=true);
        // get_item_show_hide();
        $('#submit_post').submit(function(evt){
            evt.preventDefault();
            $(".form-button").attr("disabled", true);
            let form = $('#submit_post');
            let data = new FormData(form[0]);
            $.ajax({
                type: "POST",
                url: form.attr('action'),
                cache:false,
                contentType:false,
                processData:false,
                data: data,
                dataType:"JSON",
                success: function (response) {
                    window.location.href = response.url_redirect;
                    // window.location.reload();
                },error:function(xhr){
                    alertErrorFormController(xhr);
                }
            });
        })
    });

    $(document).on('click','.add-product',function(){
        var id = $(this).data('id');
        $.ajax({
            url: "{{ Route('search-box') }}",
            method: "POST",
            dataType: "JSON",
            data: {
                id: id,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                if(data.status == 'success'  || data.status == '"success"'){
                        {{-- $(".search_text").val(''); --}}
                        $(".search_text").focus();
                    get_list_view();
                    get_item_show_hide();

                }else{
                    status_(data.status);
                }
            }
        });
    });

    $('.typeahead').keyup(function () {
        $('#ajax-loading').show();
        var value = $(this).val();
        $.ajax({
            url: "{{ route('delivery-order-autocomplete') }}",
            method: "post",
            data: {
                value: value,
                _token: '{{ csrf_token() }}',
            },
            dataType: 'json',
            success: function (response) {
                $('#ajax-loading').hide();
                console.log(response);
                $('#autocomplete').html(response.html);
            }
        });
    });

        $(".search_text").autocomplete({
            source: function(request, response) {
                var type = $('.search_text').data('type');
            $.ajax({
                url: "{{ Route('search-box') }}",
                dataType: "json",
                method: "get",
                async:true,
                data: {
                 term : request.term,

                },
                success: function(data) {
                   if(data.status == 'success'){
                        get_list_view();
                        get_item_show_hide() ;
                       $(".main-spinner").hide();
                       $(".search_text").val('');
                       $(".search_text").focus();
                   }else{
                       $(".search_text").focus();
                   }
                   if(data.incorrect){
                        $(".search_text").val('');
                       $(".search_text").focus();
                        $.confirm({
                            title: 'error!',
                            content: data.status,
                            type: 'red',
                            typeAnimated: true,
                            buttons: {
                                tryAgain: {
                                    text: 'Try again',
                                    btnClass: 'btn-red',
                                    action: function(){
                                    }
                                },
                                close: function () {
                                }
                            }
                        });
                   }
                 }
             });
            },
            minLength: 3,
        });

    function get_list_view(load = false)  {
        $.ajax({
           url: '{{ route("get_list_view") }}',
           method: "get",
           type:'text',
           success: function (data) {
               $('.resultbody').html(data);
               if(!load){
                $('.tbl-content').animate({scrollTop: $('.resultbody').height() }, 'slow')
               }
           }
       });
    }

    function get_item_show_hide()  {
        $.ajax({
           url: '{{ route("get_item_show_hide") }}',
           method: "get",
           type:'json',
           success: function (data) {
            $.each(data, function (index, element) {
                $("#"+element ).hide();
                $("."+element ).hide();
            });
           }
       });
    }

    $(document).on('click','.btn-remove',function(){
        var content='';
        var id = $(this).data('id');
        var type = 'remove-one';
            content="<b> {{__('administrator.alert_delete')}} </b>"
        $('#loading').show();
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content:content,
            type: "red",
            buttons: {
                '{{__('administrator.cancel')}}':
                {
                    btnClass: 'btn-red',
                    action:
                        function () {
                        }
                }
            ,
            '{{__('administrator.ok')}}':
                {
                    btnClass: 'btn-blue',
                    action:
                    function () {
                        $.ajax({
                            url: '{{ route("delivery_order_removecart") }}',
                            method: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                id: id,
                                type: type,
                            },
                            success: function (data) {
                                get_list_view();
                                $('.box_code_show').each(function(){

                                    $(this).show();
                                });
                                get_item_show_hide() ;
                            }
                        });
                    }
                }
            }
        }))
        return false;
    });

    $(document).on('click','.remove_all',function(){
        var type = 'remove-one-all';
        var content='';
            content="<b> {{__('administrator.alert_delete_all')}} </b>"
        $('#loading').show();
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content:content,
            type: "red",
            buttons: {
                '{{__('administrator.cancel')}}':
                {
                    btnClass: 'btn-red',
                    action:
                        function () {
                        }
                }
            ,
            '{{__('administrator.ok')}}':
                {
                    btnClass: 'btn-blue',
                    action:
                    function () {
                        $.ajax({
                            url: '{{ route("delivery_order_removecart") }}',
                            method: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                type: type,
                            },
                            success: function (data) {
                                $('.resultbody').html('');
                                get_list_view();
                                $('.box_code_show').each(function(){
                                    $(this).show();
                                });
                                get_item_show_hide() ;
                            }
                        });
                    }
                }
            }
        }))

        return false;
    });

    function status_(status) {
        $('#loading').show();
        var statusvalue = "";
        if (status == 'alert_already_exist') {
            statusvalue = "<span style='color:blue;'>{{__('administrator.alert_already_exist')}}</span>";
        }
        if  (status == 'incorrect') {
            statusvalue = "<span style='color:blue;'>{{__('administrator.incorrect')}}</span>";
        }
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content: statusvalue,
            type: "red",
            buttons: {

                '{{__('administrator.cancel')}}':
                    {
                        btnClass: 'btn-red',
                        action:
                            function () {
                            }
                    }
                ,
                '{{__('administrator.ok')}}':
                    {
                        btnClass: 'btn-blue',
                        action:
                            function () {
                                $.ajax({
                                    type: "GET",
                                    dataType: "json",
                                    url: '{{route("category_changeStatus")}}',
                                    data: {'status': check_status, 'id': id},
                                    success: function (data) {
                                        $('#loading').hide();
                                        location.reload();
                                    }
                                });
                            }
                    }
            }
        }))
            return false;
    }
</script>
@endsection
