<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>Sammaki Delivery</title>
    <meta property="og:type" content="website" />
    <meta property="og:title" content="2U Delivery" />
    <meta property="og:image" content="{{ asset('images/logo.jpg') }}" />
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('images/logo.jpg') }}">
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <link rel="stylesheet" href="{{ asset('assets/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="{{ asset('assets/font-awesome-4.7.0/css/font-awesome.css') }}">
    <link rel="stylesheet" href="{{ asset('assets/AdminLTE/AdminLTE.min.css') }}">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,600,700,300italic,400italic,600italic">

    <script src="{{asset('assets/js/jquery3.4.1.min.js')}}"></script>
    <link rel="stylesheet" href="{{asset('assets/jquery-confirm/css/jquery-confirm.min.css')}}">
        
</head>

<body>

    <style type="text/css">
        body,
        #main-container {
            height: auto;
        }
        .table-bordered>thead>tr>th,
        .table-bordered>tbody>tr>th,
        .table-bordered>tfoot>tr>th,
        .table-bordered>thead>tr>td,
        .table-bordered>tbody>tr>td,
        .table-bordered>tfoot>tr>td {
            border: 1px solid black !important;
        }
        .table-striped{
            font-size: 16px !important;
        }
    </style>


    <div class="wrapper" id="main-container">
        <!-- Main content -->
        <section class="invoice">
            <!-- title row -->
            <div class="row">
                <div class="col-xs-12">
                    <h2 class="page-header">
                        <img src="{{ asset('images/logo.jpg') }}" width="70px;" height="70px;">Sammaki Delivery
                        <small class="pull-right bt-date"  > Date: {{ date("m-d-Y") }} </small>
                    </h2>
                </div>
            </div>
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    From
                    <address>
                        <strong>Sammaki Delivery</strong><br>
                        Address: {{ $branch->address }}<br>
                        Phone: {{ $branch->phone }} <br>
                    </address>
                </div>
            </div>
            <div class="row">
                <div class="col-xs-12 table-responsive">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th rowspan="2">#</th>
                                <th rowspan="2" > Code</th>
                                <th rowspan="2" > Shop</th>
                                <th rowspan="2" > Phone Number</th>
                                <th rowspan="2" > Zone</th>
                                <th rowspan="2" > Driver</th>
                                <th rowspan="2" > Import Date</th> 
                                <th rowspan="2" > Export Date</th> 
                                <th rowspan="2" > Delivery Fee</th>
                                <th rowspan="2" > Car service</th>
                                <th rowspan="2" > Price</th>
                                {{-- <th rowspan="2" > Total Itam</th> --}}
                                <th colspan="2" style="text-align: center;"> Collected Prices</th>
                                <th colspan="2" style="text-align: center;"> Collected Prices From Customer</th>
                                <th rowspan="2" > Description</th>
                            </tr>
                            <tr>
                                <th > Dollar</th>
                                <th > Riel</th>
                                {{-- <th > (ABA) To Shop</th> --}}
                                <th > Dollar</th>
                                <th > Riel</th>
                                {{-- <th > (ABA) To Shop</th> --}}

                            </tr>
                        </thead>
                        <tbody>

                            @php
                                $total_riel                             = 0 ;
                                $total_dollar                           = 0 ;
						        $total_delivery_fee                     = 0;
                                $arrangement_service                    = 0;
                                $total_item                             = 0;
                                $total_car_service                      = 0;
                                $total_extra_fee                        = 0;
                                $total_service_charge                   = 0;
                                $total_other_fee                        = 0;
                                $សេវាផ្សេងៗ                               = 0;
                                $total_net_price_list                   =0;
                                $total_aba_to_shop                      =0;
                                $total_aba_to_delivery                  =0;
                                $last_delivery_fee                      =0;
                                $last_driver_fee                        =0;
                                $last_taxi_fee                          = 0;
                                $last_delivery_fee_riel                  = 0;
                                $last_delivery_fee_dollar                = 0;

                                
                                
                            @endphp
 
                            @foreach ($data as $key => $value)
                            <?php
                                $last_delivery_fee_riel                  = 0;
                                $last_delivery_fee_dollar                = 0;
                                $Paid  =0;
                                $delivery_fee_shop = 0;
                                if($value->status == 4){
                                    $style = 'background: #f3cccf !important';
                                }else if($value->status == 2){
                                    $style = 'background: #ddd !important';
                                }else if($value->status == 1){
                                    $style = 'background: #fefdf0 !important';
                                }else{
                                    $style = '';
                                }
                            ?>
                                <tr style="{{$style}}" >
                                    <td>{{ $key + 1 }}</td>
                                    <td>{{ $value->box_code }}</td>

                                    <td>{{ $value->shop_name }}  </td>
                                    <td style="width:120px ;">{{ $value->customer_receive }}</td>
                                    <td>{{ $value->location_name }}</td>
                                    <td>{{ $value->driver_name }}</td>
                                    <td>{{ date('d-m-Y', strtotime($value->export_date)) }}</td>
                                    <td>{{ date('d-m-Y', strtotime($value->delivery_date)) }}</td>
                                    
                                    
                                 
                                    <td>
                                        <?php

                                            $delivery_fee   = 0;
                                            $discount = 0;
                                            if( $value->discount_id != null)
                                            {
                                                $dis = DB::table('nso007_discount')->find($value->discount_id);
                                                if($dis->discount_type == 1){
                                                    $delivery_fee = $dis->discount;
                                                }
                                                elseif($dis->discount_type == 2){
                                                    $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee ) / 100;
                                                }
                                                else{
                                                    $delivery_fee =$value->delivery_fee;

                                                    if($value->delivery_status == 1){
                                                        $discount = ($dis->discount/100)*$value->delivery_fee;

                                                    }
                                                    else{
                                                        $discount = 0;
                                                    }
                                                    /* echo $discount; */
                                                }
                                            }
                                            else{
                                                $delivery_fee  =  $value->delivery_fee;
                                            }
                                            if($value->delivery_status == 1){                                                
                                                $delivery_fee_view  =  '$'.numberFormat( $delivery_fee) . ' s';
                                                if($value->delivery_fee_symbol == '៛'){
                                                    $delivery_fee_view  =  numberFormat( $delivery_fee) . '៛ s';
                                                }
                                                
                                            }else{
                                                $delivery_fee_view =   '$'.numberFormat( $delivery_fee) . ' c';
                                                
                                                if($value->delivery_fee_symbol == '៛'){
                                                    $last_delivery_fee_riel = $value->delivery_fee;
                                                    $delivery_fee_view  =  numberFormat( $delivery_fee) . '៛ c';
                                                }
                                                if($value->delivery_fee_symbol == '$'){
                                                    $last_delivery_fee_dollar = $value->delivery_fee;
                                                }
                                                
                                            }
                                            // if($value->delivery_pay_or_paid == 'paid'){
                                            //     echo  '  <strike> '.$delivery_fee_view . '  </strike>';
                                            //     $delivery_fee  = 0;
                                            // }else{
                                            //     if($value->status == 2 || $value->status == 4){
                                            //         echo  0 ;
                                            //     }else{
                                            //         echo  $delivery_fee_view  ;

                                            //     }
                                            // }


                                        ?>
                                        {{ $delivery_fee_view }}
                                    </td>
                                    <td>
                                            ​@if ($value->taxi_status  == '1')
                                                @if($value->taxi_fee_symbol == '$')
                                                {{ $value->taxi_fee ? '$ '.numberFormat( $value->taxi_fee ).' s' : '' }}
                                                @else
                                                {{ $value->taxi_fee ? numberFormat( $value->taxi_fee ).'៛ s' : '' }}
                                                @endif
                                            @else
                                                    @if($value->taxi_fee_symbol == '$')
                                                        {{ $value->taxi_fee ? '$ '.numberFormat( $value->taxi_fee ).' c' : '' }}
                                                    @else
                                                        {{ $value->taxi_fee ? numberFormat( $value->taxi_fee ).'៛ c' : '' }}
                                                    @endif
                                                    @php
                                                        $last_taxi_fee = $value->taxi_fee;
                                                        $value->taxi_fee = 0;
                                                    @endphp
                                                @endif
                                            
                                    </td>
                                    <td>
                                       
                                        {{    $value->total_product_symbol == '$' ? '$'.number_format($value->total_price,2) : number_format($value->total_price).' ៛'}}
                                        
                                       
                                    </td> 
                                    <td> 
                                        <?php
                                        $total_price = 0;
                                        if($value->total_product_symbol == "$")
                                            $total_price = $value->total_price;

                                        ?>
                                        {{$total_price + $last_delivery_fee_dollar}}
                                        {{-- {{$value->total_price ? '$ '.number_format($value->total_price + $last_delivery_fee + $last_taxi_fee,2) : ''}} --}}
                                            {{-- @if ($value->taxi_status  == '1')
                                                ${{ $value->taxi_fee ? numberFormat( $value->taxi_fee ).' s' : '' }}
                                            @else
                                                ${{ $value->taxi_fee ? numberFormat( $value->taxi_fee ).' c' : '' }}

                                                @php
                                                    $value->taxi_fee = 0;
                                                @endphp
                                            @endif --}}
                                    </td>
                                    
                                    {{-- <td>
                                        @if ($value->other_services_type  == '1')
                                            {{ $value->other_services_fee ? numberFormat($value->other_services_fee).' s' : '' }}
                                            @php
                                                $value->other_services_fee = 0;
                                            @endphp

                                        @else
                                            {{ $value->other_services_fee ? numberFormat($value->other_services_fee).' c' : '' }}

                                        @endif
                                    </td> --}}
                                    
                                    <td>
                                        <?php
                                        $total_price = 0;
                                        if($value->total_product_symbol == "៛")
                                            $total_price = $value->total_price;
                                        ?>
                                        {{$total_price + $last_delivery_fee_riel}}
                                    </td>
                                    {{-- <td>

                                        @if ($value->pay_to == 'delivery')
                                            {{  numberFormat( $value->amount_pay_to )}}
                                        @else
                                            {{ 'N/A' }}
                                        @endif
                                    </td> --}}

                                    <td>
                                        {{-- @if ($value->pay_to == 'shop')
                                            {{  numberFormat( $value->amount_pay_to)}}
                                        @else
                                            {{ 'N/A' }}
                                        @endif --}}
                                    </td>

                                    
                                    <td>
                                        {{-- @if($value->status == 1)
                                            <strong class="text-primary"><span class=" fa fa-spinner"></span> កំពុងដឹក</strong>
                                        @elseif($value->status == 2)
                                            <strong class="text-warning"><span class="fa fa-bullseye"></span> មិនជោគជ័យ   </strong>
                                        @elseif($value->status == 3)
                                            <strong class="text-info"><span class="fa fa-check"></span> ជោគជ័យ </strong>
                                        @elseif($value->status == 4)
                                            <strong class="text-danger"><span class="fa fa-ban"></span> មិនយក  </strong>
                                        @else($value->status == null)
                                            <strong class="text-secondary"><span class="fa fa-square"></span> ក្នុងការចែកចាយ </strong>
                                        @endif --}}
                                    </td>
                                    <td>
                                        {{ $value->description }}
                                    </td>
                                </tr>
                                @php
                                 


                                    if($value->delivery_status == 1){
                                        $delivery_fee = 0; 
                                    }   
                                    if($value->extra_fee_type == 1){
                                        $extra_fee_shop = 0; 
                                    }   
                                    
                                    
                                    if(  $value->status == 3 && $value->clear_box_code != 1 ){
                                        $total_riel                         +=  $value->total_riel;
                                        $total_dollar                       +=  $value->total_dollar;
                                        $total_delivery_fee                 +=  $delivery_fee   + $extra_fee_shop ;
                                        $total_item                         +=  $value->total_product ;
                                        $total_car_service                  +=  $value->taxi_fee;
                                        $total_service_charge               +=  $value->service_charge;
                                        $total_other_fee                    +=  $value->other_services_fee;

                                        if ($value->pay_to == 'delivery'){
                                            $total_aba_to_delivery              +=   $value->amount_pay_to;
                                        }
                                        if ($value->pay_to == 'shop'){
                                            $total_aba_to_shop              +=   $value->amount_pay_to;
                                        } 
                                        //$សេវារៀបចំ                          +=   $value->service_charge ;
                                    }

                                @endphp
                            @endforeach
                        </tbody>
                        {{-- <tfoot>
                            <tr>
                                <th colspan="8" style="text-align:right">Total:</th>
                                <th colspan="2" style="text-align: center;"> ${{ numberFormat( $total_delivery_fee)}}</th>
                                <th> {{number_format(round($total_car_service * 4000, -2,PHP_ROUND_HALF_ODD) ,0).'៛'}}</th>
                                <th>  ${{ numberFormat( $total_other_fee)}} </th>
                                <th>  ${{ numberFormat( $total_item)}}</th>
                                <th  >  ${{ numberFormat( $total_dollar)}}</th>
                                <th  > {{number_format(round($total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛'}}</th>
                                <th>  ${{ numberFormat( $total_aba_to_delivery)}}</th>
                                <th>  ${{ numberFormat( $total_aba_to_shop)}}</th>
                            </tr>
                        </tfoot> --}}
                    </table>
                </div>
            </div>
        </section>
    </div>


    
</body>

</html>
    <link rel="stylesheet" type="text/css" href="{{asset('js/datepicker/datepicker.min.css')}}">
    <script src="{{asset('js/datepicker/datepicker.min.js')}}"></script>
    <script src="{{asset('assets/js/barcode/barcode.js')}}"></script>
    <script src="{{asset('assets/js/bootstrap.min.js')}}"></script>
    <script src="{{asset('assets/mobile/js/jquery-confirm.js')}}"></script>
    <script>

        
    </script>


    </body>

</html>

