@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="/">{{__('administrator.dashboard')}}</a></li>
	  <li class="active"> {{__('administrator.delivery')}}</li>
	  <li class="active">{{__('administrator.driver_voucher')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.driver_voucher')}}</h3>
	                </div>
	                <div class="pull-right">
                        @can('Clear Voucher')
                            <span class="btn btn-sm btn-primary clear-multi-driver">Clear Multi Driver</span>
                        @endcan
                    {{--  <a href="{{route('out-stock.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>  --}}
	                </div>
	            </div>
	        </div>
            <div class="col-md-4">
                <div class="form-group">
                    <label for="">{{__('administrator.driver')}}</label>
                    {!! Form::select('driver_id', compressDriver(), null, ['class' => 'form-control','placeholder'=>__('administrator.please_select')]) !!}
                </div>
            </div>
	    </div>
    </div>
    <div class="wrapper-table ">
        <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
            <thead>
            <tr>
                <th style="width: 5% !important">{{__('administrator.no')}}</th>
                <th style="width: 5% !important">
                    <input type="checkbox" id="parent" name="scales">
                </th>
                <th>{{__('administrator.date')}}</th>
                <th>Total Box</th>
                <th>{{__('administrator.driver')}}</th>
                <th>{{__('administrator.action')}}</th>
            </tr>
            <tbody class="tbody">

            </tbody>

        </table>
    </div>
</div>
</div>

@endsection

@section('script')
<script type="text/javascript">

    $(document).ready(function () {

        $('#datatable_location').DataTable({
            "oLanguage": {
                "sSearch": "{{__('administrator.search')}}:",
                "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                "oPaginate": {
                    "sFirst": "{{__('administrator.first')}}",
                    "sLast": "{{__('administrator.last')}}",
                    "sNext": "{{__('administrator.next')}}",
                    "sPrevious": "{{__('administrator.prevoius')}}"
                },
            },
            ordering: false,
            serverSide: true,
            lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            ajax:{
                url:'{{route('delivery-order-new.index')}}',
                data:function(d){
                    d.driver_id = $('select[name=driver_id]').val()
                }
            },
            columns:
                [
                    {data: 'DT_RowIndex','searchable':false},
                    {data: 'clear_all','searchable':false},
                    {data: 'delivery_date'},
                    {data: 'total','searchable':false},
                    {data: 'name'},
                    {data: 'action','searchable':false},

                ],

            "initComplete": function (settings, json) {
            }
        });
        $(document).find('.dataTables_filter').prepend(`

                                                <label style="border: solid #ffe4e4 2px;">
                                                    <space class="text-primary">Processing</space>&nbsp; ,
                                                    <space class="text-success">Success</space>&nbsp;,
                                                    <space class="text-warning"> Pending</space>&nbsp;,
                                                    <space class="text-danger">Cancel</space>&nbsp;
                                                     `);
    });
    $(document).on('change','select[name=driver_id]',function(){
        $('#datatable_location').DataTable().ajax.reload();
    })
    $(document).on('click','#parent',function(e){
        if($(this).is(':checked')){
            $(document).find('.sub').prop('checked',true);
        }else{
            $(document).find('.sub').prop('checked',false);
        }
    })
    $(document).on('click','.clear-multi-driver',function(){
        let check = false;
        let arr = [];
        $.each($('.sub'), function (i, v) {
            if($(this).is(":checked")){
                check = true;
                arr.push({
                    'driver_id':$(this).data('driver_id'),
                    'date':$(this).data('date'),
                    'time_policy':$(this).data('time_policy')
                });
            }
        });
       if(!check){
            $.alert("Please Check Driver !");
            return false;
       }
       $.confirm({
            title: 'Clear Multi Driver',
            content: 'Do you want to clear multi Driver ?',
            type: 'blue',
            typeAnimated: true,
            buttons: {
                tryAgain: {
                    text: 'Clear',
                    btnClass: 'btn-blue',
                    action: function(){
                        $.ajax({
                            type: "POST",
                            url: "{{route('clear-multi-driver')}}",
                            data: {
                                'obj':arr,
                                _token:'{{csrf_token()}}'
                            },
                            dataType: "JSON",
                            success: function (data) {
                                if(data.status == 200){
                                    Toast.fire({
                                        icon: 'success',
                                        title: 'Clear Successfully !'
                                    });
                                    $('#datatable_location').DataTable().ajax.reload();
                                }
                            }
                        });
                    }
                },
                close: {
                    text: 'Close',
                    btnClass: 'btn-danger',
                    action: function(){

                    }
                },
            }
        });

    });
    $(document).on('click','.bt_clear_driver',function (e) {
        e.preventDefault();
        let route = $(this).data('route');
        $.confirm({
            title: 'Clear',
            content: 'Do You Want To Clear ?',
            type: 'blue',
            typeAnimated: true,
            buttons: {
                Clear: {
                    text: 'Clear',
                    btnClass: 'btn-primary',
                    action: function(){
                        $.get(route, {

        },
            function (data, textStatus, jqXHR) {
                Toast.fire({
                    icon: 'success',
                    title: 'Clear Successfully !'
                });
                $('#datatable_location').DataTable().ajax.reload();
                // $("#mySelector").printThis({
                //     debug: false,               // show the iframe for debugging
                //     importCSS: true,            // import parent page css
                //     importStyle: false,         // import style tags
                //     printContainer: true,       // print outer container/$.selector
                //     loadCSS: "",                // path to additional css file - use an array [] for multiple
                //     pageTitle: "",              // add title to print page
                //     removeInline: false,        // remove inline styles from print elements
                //     removeInlineSelector: "*",  // custom selectors to filter inline styles. removeInline must be true
                //     printDelay: 333,            // variable print delay
                //     header: null,               // prefix to html
                //     footer: null,               // postfix to html
                //     base: false,                // preserve the BASE tag or accept a string for the URL
                //     formValues: true,           // preserve input/form values
                //     canvas: false,              // copy canvas content
                //     doctypeString: data,       // enter a different doctype for older markup
                //     removeScripts: false,       // remove script tags from print content
                //     copyTagClasses: false,      // copy classes from the html & body tag
                //     beforePrintEvent: null,     // function for printEvent in iframe
                //     beforePrint: null,          // function called before iframe is filled
                //     afterPrint: null            // function called before iframe is removed
                // });
            },
        ).fail(function(xhr) {
            alertErrorFormController(xhr);
        });

                    }
                },
                close: function () {

                }
            }
        });
    });

</script>
@stop



