@extends('layouts.app') @section('content')
<?php Fun::lang() ?>
<div class="top-header">
    <ol class="breadcrumb">
    <li><a href="#">{{__('administrator.dashboard')}}</a></li>
    <li class="active"><a href="#">{{__('administrator.new_order')}}</a></li>
    </ol>
</div>

<div class="page-purchases">
    {!! Form::open(array('route' => 'delivery-order.store','method'=>'POST','enctype'=>'multipart/form-data')) !!}
    <div class="preview">
        <div class="col-sm-5">
            <div class="col-sm-12 paddin-10">
                <div class="form-group" >
                    <strong>{{__('administrator.product_code')}}</strong>
                    {!! Form::text('barcode', null, array('placeholder' => __('administrator.search_product_name') ,'class' => ' search_text form-control typeahead', "autocomplete" => "on")) !!}
                    <div id="autocomplete" class="col-sm-12" style="position: absolute; z-index: 99;left: -12px">
                    </div>
                </div>
            </div>
            <div class="product-item-list">
                <div class="item-list box-addtocart">
                    <div class="row show_product" id="tag_container">
                    @include('administrator.delivery-order.result-create')
                    </div>
                </div>
            </div>
    </div>
        <div class="col-sm-7">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <strong>{{__('administrator.date')}}<span  class="required">*</span></strong>
                        <input type="text" name="delivery_date" value="<?php echo date("d-m-Y")?>" class="form-control date_picker" required>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <strong>{{__('administrator.driver')}} <span  class="required">*</span></strong>
                        {!! Form::select('driver_id', $drivers, null, ['class' => 'form-control chosen-select' ,'required']) !!}
                    </div>
                </div>
            </div>
            <div class="check-bill">
                <div class="row">
                    <div class="blog-payment ">
                        <div class="col-sm-12 ">
                            <div class="button_payment pull-right">
                                <button type="button" class="button_warning button_lg" onclick="history.back(1)">{{__('administrator.back')}}</button>
                                <button type="button" class="button_danger remove_all button_lg">{{__('administrator.remove')}}</button>
                                <button type="submit" class="button_info button_lg">{{__('administrator.save')}}</button>

                            </div>
                        </div>
                    </div>
                    <div class="check-bill-table">
                        <div class="product-view-table">
                            <div class="tbl-header">
                                <table width="100%" class="table table-striped">
                                    <thead class="text-center">
                                        <tr>
                                            <th width="5%">{{__('administrator.no')}}</th>
                                            <th width="15%">{{__('administrator.box_code')}} </th>
                                            <th width="15%">{{__('administrator.location')}}</th>
                                            <th width="15%">{{__('administrator.customer')}}</th>
                                            <th width="15%">{{__('administrator.price')}}</th>
                                            <th width="15%">{{__('administrator.delivery_fee')}} </th>
                                            <th width="10%">{{__('administrator.action')}}</th>
                                        </tr>
                                    </thead>
                                </table>
                            </div>
                            <div class="tbl-content">
                                <div class="overflow">
                                    <table width="100%" class="table table-striped">
                                        <tbody class="resultbody">

                                        </tbody>
                                    </table>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>
</div>



<style type="text/css">

</style>
@endsection
@section('script')
<script type="text/javascript">

    $(document).ready(function(){
        $(document).on('click', '.pagination a',function(event){
            event.preventDefault();
            $('li').removeClass('active');
            $(this).parent('li').addClass('active');
            var myurl = $(this).attr('href');
            var page=$(this).attr('href').split('page=')[1];
            getData(page);
        });
    });

    function getData(page){
        $.ajax({
            url: '?page=' + page,
            type: "get",
            datatype: "html"
        }).done(function(data){
            get_item_show_hide();
            $("#tag_container").empty().html(data);
            location.hash = page;
        }).fail(function(jqXHR, ajaxOptions, thrownError){
                alert('No response from server');
        });
    }


    $(document).ready(function(){
        get_list_view();
        get_item_show_hide();
    });

    $('.typeahead').blur(function () {
        if($(this).val() == ""){
            $('#autocomplete').html("");
        }
     });

    $(document).on('click','.add-product',function(){
        var id = $(this).data('id');
        $.ajax({
            url: "{{ Route('search-box') }}",
            method: "POST",
            dataType: "Text",
            data: {
                id: id,
                _token: '{{ csrf_token() }}',
            },
            success: function (data) {
                if(data == 'success'  || data == '"success"'){
                        {{-- $(".search_text").val(''); --}}
                        $(".search_text").focus();
                    get_list_view();
                    get_item_show_hide() ;

                }else{
                    status_(data);
                }
            }
        });
    });

    $('.typeahead').keyup(function () {
        $('#ajax-loading').show();
        var value = $(this).val();
        $.ajax({
            url: "{{ route('delivery-order-autocomplete') }}",
            method: "post",
            data: {
                value: value,
                _token: '{{ csrf_token() }}',
            },
            dataType: 'json',
            success: function (response) {
                $('#ajax-loading').hide();
                console.log(response);
                $('#autocomplete').html(response.html);
            }
        });
    });

    $(".search_text").autocomplete({
        source: function(request, response) {
        var type = $('.search_text').data('type');
        $.ajax({
            url: "{{ Route('search-box') }}",
            dataType: "json",
            method: "get",
            data: {
             term : request.term,

            },
            success: function(data) {
                // alert(data);
               if(data == 'success'){
                    get_list_view();
                    get_item_show_hide() ;
                   $(".main-spinner").hide();
                   $(".search_text").val('');
                   $(".search_text").focus();
               }else{
                   $(".search_text").focus();
               }
             }
         });
        },
        minLength: 3,
    });

    function get_list_view()  {
        $.ajax({
           url: '{{ route("get_list_view") }}',
           method: "get",
           type:'text',
           success: function (data) {
               $('.resultbody').html(data);
           }
       });
    }

    function get_item_show_hide()  {
        $.ajax({
           url: '{{ route("get_item_show_hide") }}',
           method: "get",
           type:'json',
           success: function (data) {
            $.each(data, function (index, element) {
                $("#"+element ).hide();
                $("."+element ).hide();
            });
           }
       });
    }

    $(document).on('click','.btn-remove',function(){
        var content='';
        var id = $(this).data('id');
        var type = 'remove-one';
            content="<b> {{__('administrator.alert_delete')}} </b>"
        $('#loading').show();
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content:content,
            type: "red",
            buttons: {
                '{{__('administrator.cancel')}}':
                {
                    btnClass: 'btn-red',
                    action:
                        function () {
                        }
                }
            ,
            '{{__('administrator.ok')}}':
                {
                    btnClass: 'btn-blue',
                    action:
                    function () {
                        $.ajax({
                            url: '{{ route("delivery_order_removecart") }}',
                            method: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                id: id,
                                type: type,
                            },
                            success: function (data) {
                                get_list_view();
                                $('.box_code_show').each(function(){

                                    $(this).show();
                                });
                                get_item_show_hide() ;
                            }
                        });
                    }
                }
            }
        }))
        return false;
    });

    $(document).on('click','.remove_all',function(){
        var type = 'remove-one-all';
        var content='';
            content="<b> {{__('administrator.alert_delete_all')}} </b>"
        $('#loading').show();
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content:content,
            type: "red",
            buttons: {
                '{{__('administrator.cancel')}}':
                {
                    btnClass: 'btn-red',
                    action:
                        function () {
                        }
                }
            ,
            '{{__('administrator.ok')}}':
                {
                    btnClass: 'btn-blue',
                    action:
                    function () {
                        $.ajax({
                            url: '{{ route("delivery_order_removecart") }}',
                            method: "post",
                            data: {
                                _token: '{{ csrf_token() }}',
                                type: type,
                            },
                            success: function (data) {
                                $('.resultbody').html('');
                                get_list_view();
                                $('.box_code_show').each(function(){
                                    $(this).show();
                                });
                                get_item_show_hide() ;
                            }
                        });
                    }
                }
            }
        }))

        return false;
    });

    function status_(status) {
        $('#loading').show();
        var statusvalue = "";
        if (status == 'alert_already_exist') {
            statusvalue = "<span style='color:blue;'>{{__('administrator.alert_already_exist')}}</span>";
        }
        if  (status == 'incorrect') {
            statusvalue = "<span style='color:blue;'>{{__('administrator.incorrect')}}</span>";
        }
        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.warning')}}</strong>',
            content: statusvalue,
            type: "red",
            buttons: {

                '{{__('administrator.cancel')}}':
                    {
                        btnClass: 'btn-red',
                        action:
                            function () {
                            }
                    }
                ,
                '{{__('administrator.ok')}}':
                    {
                        btnClass: 'btn-blue',
                        action:
                            function () {
                                $.ajax({
                                    type: "GET",
                                    dataType: "json",
                                    url: '{{route("category_changeStatus")}}',
                                    data: {'status': check_status, 'id': id},
                                    success: function (data) {
                                        $('#loading').hide();
                                        location.reload();
                                    }
                                });
                            }
                    }
            }
        }))
            return false;
    }
</script>
@endsection
