@extends('layouts.app')

@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="#">{{__('administrator.dashboard')}}</a></li>
                  <li><a href="#">{{__('administrator.manage_setting')}}</a></li>
            <li><a href="{{route('currency.index')}}">{{__('administrator.currency')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class="container-fluid" >
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-offset-3 col-sm-3 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.currency')}} </h3>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="box-body">
                <div class="row">
                    <div class="col-sm-offset-3 col-sm-6">
                        <div class="master-form ">
                            <div class="title-note">
                                <h3><span class="fa fa-exclamation-triangle"></span> {{__('administrator.currency')}}
                                    <i>({{__('administrator.fields_in_red_are_required')}})</i></h3>
                            </div>
                            <div class="col-xs-3 col-sm-4 col-md-3">
                                <div class="form-group">
                                    <strong> {{ __('administrator.dollars') }} (USD) :</strong>
                                    <input type="text" name="currency_main" class="form-control" value="{{$data[0]->currency_main}}" readonly>
                                    <input type="hidden" name="id"value="{{$data[0]->id}}" class="id" readonly>
                                </div>
                            </div>
                            <div class="col-xs-3 col-sm-4 col-md-3">
                                <div class="form-group">
                                    <strong>	{{ __('administrator.riel') }} (Riel):</strong> <input type="checkbox" class="checkbox1" value=""> <span class="message label label-success fa fa-check ">Success!</span>
                                    <input type="text" name="currency_exchange_to" class="form-control currency_exchange_to number-only change " value="{{$data[0]->currency_exchange_to}}" disabled="true">
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-4 col-md-3">
                                <div class="form-group">
                                    <strong>	{{ __('administrator.Buy') }} (Riel):</strong> <input type="checkbox" class="checkbox2"  value=""> <span class="message label label-success fa fa-check">Success!</span>
                                    <input type="text" name="buy_currency" class="form-control buy_currency number-only change" value="{{$data[0]->buy_currency}}" disabled="true">
                                </div>
                            </div>

                            <div class="col-xs-3 col-sm-4 col-md-3">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endsection

    @section('script')
    <script type="text/javascript">
        $(document).ready(function(){
            $('.message').hide();
            $('.checkbox1').click(function(){

                if($(this).prop("checked") == true){
                    $('input[name="currency_exchange_to"]').removeAttr('disabled','false');
                }else if($(this).prop("checked") == false){
                    $('input[name="currency_exchange_to"]').attr('disabled','true');
                }
            });


            $('.checkbox2').click(function(){
                if($(this).prop("checked") == true){
                    $('input[name="buy_currency"]').removeAttr('disabled','false');
                }else if($(this).prop("checked") == false){
                    $('input[name="buy_currency"]').attr('disabled','true');
                }
            });

            $('.change').change(function(){

                var id = $('.id').val();
                var currency_exchange_to =$('.currency_exchange_to').val();
                var buy_currency =  $('.buy_currency').val();

                $.ajax({
                    method:'POST',
                    dataType:'json',
                    url: "{{ Route('currency.store') }}",
                    async: false,
                    data: {
                        _token: '{{ csrf_token() }}',
                        id: id,
                        currency_exchange_to: currency_exchange_to,
                        buy_currency: buy_currency,

                    },
                    success: function (data) {
                        setTimeout(function(){
                            $(".message").show();
                            setTimeout(function() {
                                $(".message").hide()
                            }, 1000);
                        });
                        $('input[type="checkbox"').prop("checked", false);
                        $('input[name="currency_exchange_to"]').attr('disabled','true');
                    }
                });
            });
        });
    </script>
    @endsection


