@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
    <ol class="breadcrumb">
      <li><a href="#">{{__('administrator.dashboard')}}</a></li>
         <li><a href="#">{{__('administrator.products')}}</a></li>
        <li><a href="{{route('category.index')}}">{{__('administrator.manage_category')}}</a></li>
      <li class="active">{{__('administrator.show')}}</li>
    </ol>
</div>
<div class="page">
<div class=container-fluid>
    <div class="top-content">
        <div class="row">
            <div class="col-sm-12 col-xs-12">
                <div class="title-add">
                    <div class="pull-left">
                        <h3>{{__('administrator.sub_category')}}</h3>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <div class="list-detail">
       <div class="col-sm-12">
            <div class="summary-footer">
                <div class="list">
                    <label class="left">{{__('administrator.category_name')}} :</label>
                    <label class="right">{{$parent_name->category_name}}</label>
                </div>
                <div class="list">
                    <label class="left">{{__('administrator.date')}} :</label>
                    <label class="right">{{date('d-m-Y', strtotime($parent_name->created_at)) }}</label>
                </div>

            </div>
       </div>
    </div>
     <div class="wrapper-table">
        <table  id="users" width="100%" class="table table-striped table-hover ">
             <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.category_name')}}</th>

                    <th>{{__('administrator.created_at')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($data as $key => $value)
                <tr>
                    <td>{{$key+1}}</td>
                    <td>{{$value->category_name}}</td>
                    <td>{{date('d-m-Y', strtotime($value->created_at)) }}</td>
                    <td>
                        <a href="{{route('category.edit',$value->id)}}" class="button_info">{{__('administrator.edit')}}</a>
                        <button type="button" class="button_danger delete_category" data-toggle="modal"
                        data-id="{{ $value->id }}" > {{__('administrator.delete')}}</button>

                    </td>
                </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>


<div class="modal fade bs-modal-lg" id="form_delete" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-dm">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h3 class="modal-title">Are you sure?</h3>
            </div>
            <br/>
            <form role="form" method="delete" id="delete">
                {{csrf_field()}}
                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-10">
                            <h4>Are you want to delete?</h4>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="button_danger"><i class="fa fa-close"></i> No</button>
                    <button type="button" class="button_primary deleteRecord" data-toggle="modal"><i class="fa fa-save"></i> OK</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection



@section('script')

    <script type="text/javascript">
        $(document).on('click', '.delete_category', function() {
            $('#form_delete').modal('show');
            var id = $(this).data("id");
            $(".deleteRecord").click(function(){
                var token = $("meta[name='csrf-token']").attr("content");
                $.ajax({
                    url: "/pos/category/"+id,
                    type: 'DELETE',
                    data: {
                        "id": id,
                        "_token": token,
                    },
                    success: function (){
                        $('#form_delete').modal('hide');
                        location.reload();
                    }
                });
            });
        });
    </script>
@stop









