@extends('layouts.app')
@section('content')
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="{{route('app_dashboard')}}">{{__('administrator.dashboard')}}</a></li>
            <li><a href="">{{__('administrator.bus_list')}}</a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            <div class="pull-left">
                                <h3>{{__('administrator.manage_bus')}}</h3>
                            </div>
                            <div class="pull-right">
                                <a href="{{route('bus.create')}}" class="button_sm button_info"><span
                                            class="fa fa-plus"></span> {{__('administrator.new_bus')}}</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="data_table" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th>{{__('administrator.company_name')}}</th>
                        <th>{{__('administrator.price')}}</th>
                        <th>{{__('administrator.action')}}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($data as $key => $value)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>{{$value->company_name}}</td>
                            <td>${{  number_format( $value->price,2) }}</td>
                            <td>
                                <a href="{{route('bus.edit',$value->id)}}"
                                   class="button_info">{{__('administrator.edit')}}
                               </a>
                                <a class="button_sm @if($value->status==1) button_primary @else button_danger @endif"
                                   onclick="status('{{$value->id}}','{{$value->status}}')">@if($value->status==1) {{__('administrator.active')}} @else {{__('administrator.deactive')}} @endif</a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="modal fade bs-modal-lg" id="form_delete" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dm">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h3 class="modal-title">Are you sure?</h3>
                </div>
                <br/>
                <form role="form" method="delete" id="delete">
                    {{csrf_field()}}
                    <div class="row">
                        <div class="col-md-12">
                            <div class="col-md-10">
                                <h4>Are you want to delete?</h4>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" data-dismiss="modal" class="button_danger"><i class="fa fa-close"></i> No
                        </button>
                        <button type="button" data-dismiss="modal" class="button_primary deleteRecord"
                                data-toggle="modal"><i class="fa fa-save"></i> OK
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div id=model_image class="modal_img">
        <span class="close_image" style="margin-top: 45px;" >&times;</span>
        <img class="modal-content" id="img01">
        <div id="caption"></div>
    </div>
@endsection
@section('js')
    <script type="text/javascript"> 
        $(document).ready(function () {
            $('#data_table').DataTable({
                "oLanguage": {
                    "sSearch": "{{__('administrator.search')}}:",
                    "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
                    "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
                    "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
                    "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
                    "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
                    "oPaginate": {
                        "sFirst": "{{__('administrator.first')}}",
                        "sLast": "{{__('administrator.last')}}",
                        "sNext": "{{__('administrator.next')}}",
                        "sPrevious": "{{__('administrator.prevoius')}}"
                    },
                },
                lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
            });


            $(document).on('click', '.delete_bus', function () {
                $('#form_delete').modal('show');
                var id = $(this).data("id");
                $(".deleteRecord").click(function () {
                    var token = $("meta[name='csrf-token']").attr("content");
                    $.ajax({
                        type: 'GET',
                        dataType: "json",
                        url: "",
                        data: {
                            "id": id,
                            "_token": token,
                        },
                        success: function () {
                            $('#form_delete').modal('hide');
                            location.reload();
                        }
                    });

                });
            });


            
            function status(id, status) {
                $('#loading').show();
                var check_status = status == 1 ? 0 : 1;
                var statusvalue = "";
                if (status == 0) {
                    statusvalue = "<span style='color:blue;'>{{__('administrator.active')}}</span>";
                }
                else {
                    statusvalue = "<span style='color:blue;'>{{__('administrator.deactive')}}</span>";
                }
                if ($.confirm({
                    title: '<strong style="color:darkcyan;">{{__('administrator.change_status')}}</strong>',
                    content: "<b> {{__('administrator.status_alert')}} "
                    + statusvalue + " ?</b>",
                    type: "red",
                    buttons: {

                        '{{__('administrator.cancel')}}':
                            {
                                btnClass: 'btn-red',
                                action:
                                    function () {
                                    }
                            }
                        ,
                        '{{__('administrator.ok')}}':
                            {
                                btnClass: 'btn-blue',
                                action:

                                    function () {
                                        $.ajax({
                                            type: "GET",
                                            dataType: "json",
                                            url: '{{route("bus_changeStatus")}}',
                                            data: {'status': check_status, 'id': id},
                                            success: function (data) {
                                                $('#loading').hide();
                                                location.reload();

                                            }

                                        });
                                    }
                            }
                    }
                }))

                    return false;
            }
        });

    </script>
@endsection




