@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.report_income')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
        <div class="row">
            <div class="col-sm-12">
                {!! Form::open(array('route' => 'reportExpensePrint','method'=>'POST')) !!}
                <div class="form-search">
                    <div class="form-group col-sm-4 col-xs-4">
                            {!! Form::text('from_date', date('d-m-Y',strtotime('first day of this month')), array('placeholder' => __('administrator.from_date'),'class' => 'form-control date_picker')) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-4">
                            {!! Form::text('to_date',date('d-m-Y',strtotime('last day of this month')), array('placeholder' => __('administrator.to_date'),'class' => 'form-control date_picker')) !!}
                    </div>
                    <div class="form-group col-sm-4 col-xs-4">
                            {!! Form::select('account_code', $account_chart, null, ['class' => 'form-control chosen-select']) !!}
                    </div>
                    <div class="col-sm-12 col-xs-12">
                        <div class="form-group footer-save">
                            <button class="button_sm button_info pull-right" onclick="searching()" type="button"><span class="fa fa-search"></span> Searching</button>
                            <button type="submit" class="button_sm button_info pull-right buttons-print"><span class="fa fa-print"></span> Print</button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            </div>
        </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_expense" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.account_name')}}</th>
                    <th>{{__('administrator.description')}}</th>
                    <th>{{__('administrator.reference')}}</th>
                    <th>{{__('administrator.amount')}}</th>
                    <th>{{__('administrator.created_by')}}</th>
                    <th>{{__('administrator.modify_by')}}</th>
                    <th>{{__('administrator.created_at')}}</th>
                    <th>{{__('administrator.updated_at')}}</th>
                </tr>
            </thead>
            <tbody class="tbody">

            </tbody>
        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">

    $('#datatable_expense').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[20, 30, 50, 100, 200, 500, 1000], [20, 30, 50, 100, 200, 500, 1000]],
        ajax: "{{route('getReportExpense')}}",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'journal_paydate'},
                {data: 'account_name'},
                {data: 'journal_des'},
                {data: 'journal_invoice'},
                {data: 'amount'},
                {data: 'created_by'},
                {data: 'modify_by'},
                {data: 'created_at'},
                {data: 'updated_at'},
            ],

        "initComplete": function (settings, json) {
        }
    });

    function searching() {
        var from_date = $('input[name="from_date"]').val();
        var to_date = $('input[name="to_date"]').val();
        var account_code = $('select[name="account_code"]').val();
        var table = ''; var account_name = '';
        $.ajax({
            url: "{{ Route('getReportExpense') }}",
            method: "POST",
            dataType: "json",
            data: { from_date: from_date,
                    to_date: to_date,
                    account_code: account_code,
                    _token: '{{ csrf_token() }}',
            },
            success:function (data) {
                $.each(data, function(index, val) {
                    str = val.journal_paydate;
                    st2 = str.split("-");
                    yr = st2[0];
                    mo = st2[1];
                    dy = st2[2];
                    var new_date = dy+'-'+mo+'-'+yr;
                    if('{{\Globals::check_lang()}}' =='en'){
                        account_name = val.account_code+' '+val.acc_name_en;
                    }else{
                        account_name = val.account_code+' '+val.acc_name_km;
                    }
                    table += `
                        <tr>
                            <td>${index+1}</td>
                            <td>${new_date}</td>
                            <td>${account_name}</td>
                            <td>${val.journal_des}</td>
                            <td>${val.journal_invoice}</td>
                            <td>${parseFloat(val.journal_debit).toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')}</td>
                            <td>${val.created_by}</td>
                            <td>${val.modify_by}</td>
                            <td>${val.created_at}</td>
                            <td>${val.updated_at}</td>
                        </tr>
                    `;
                });
                $('.tbody').empty().append(table);
            }
        });
    }


</script>
@stop



