@extends('layouts.print') @section('content')
<?php Fun::lang();$branch = DB::table('nso007_branch')->find(1);?>
<style>
    @media print{
        .col-sm-8 {
            width: 66.66666667%;
            float: left;
        }
        .col-sm-4 {
            width: 33.33333333%;
            float: left;
        }
    }
</style>

    <div class="page-purchases">
        <div class="container">
            <div class="row">
                <div class="col-sm-12 col-xs-12">
                    <div class="pull-left mr-bt">
                        <img src="{{asset('images/logo.png')}}" width="200">
                    </div>
                    <div class="pull-right">
                        <div class="title-add">
                            <h2>{{__('administrator.income_statement')}}</h2>
                            <table class="table table-striped">
                                <tr>
                                    <td><b class="pull-left">Company :</b></td>
                                    <td><span class="pull-left">{{ $branch->company_name }}</span></td>
                                </tr>
                                <tr>
                                    <td><b class="pull-left">Address :</b></td>
                                    <td><span class="pull-left">{{ $branch->address }}</span></td>
                                </tr>
                                <tr>
                                    <td><b class="pull-left">Phone :</b></td>
                                    <td><span class="pull-left">{{ $branch->phone }}</span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            @if(empty($from_date) && empty($to_date))
            <p>From date /..................../ To date /..................../</p>
            @else
            <p>From date / {{date('d-m-Y',strtotime($from_date))}} / To date / {{date('d-m-Y',strtotime($to_date))}} /</p>
            @endif
            <div class="income-statement" style="border:1px solid !important; float: left !important;width:100% !important;">
                <div class="list" style="border-bottom: 1px solid !important;">
                    <div class="left">
                        <div class="col-sm-8">
                            <h2 class="statement_blue">Income</h2>
                        </div>
                        <div class="col-sm-4">
                            <h2 class="statement_blue total_income">${{number_format($total_income,2)}}</h2>
                        </div>
                    </div>
                    <div class="incomes">
                        @foreach($statement['income'] as $key => $income)
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-8">
                                    <h4>{{$income->journal_acccode}} {{$income->acc_name_en}} {{$income->acc_name_km}}</h4>
                                </div>
                                <div class="col-sm-4">
                                    <h4>${{number_format($income->in_total,2)}}</h4>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="list" style="border-bottom: 1px solid !important;">
                    <div class="left">
                        <div class="col-sm-8">
                            <h2 class="statement_red ">Expense</h2>
                        </div>
                        <div class="col-sm-4">
                            <h2 class="statement_red total_expense">${{number_format($total_expense,2)}}</h2>
                        </div>
                    </div>
                    <div class="expenses">
                        @foreach($statement['expense'] as $key => $exp)
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-sm-8">
                                    <h4>{{$exp->journal_acccode}} {{$exp->acc_name_en}} {{$exp->acc_name_km}}</h4>
                                </div>
                                <div class="col-sm-4">
                                    <h4>${{number_format($exp->ex_total,2)}}</h4>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
                <div class="list">
                    <div class="left">
                        <div class="col-sm-8">
                            <h2 class="statement_green">Income Statement</h2>
                        </div>
                        <div class="col-sm-4">
                            <h2 class="statement_green total">${{number_format($total_income-$total_expense,2)}}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @endsection
