@extends('layouts.app')
@section('content')
<?php Fun::lang()?>
<div class="top-header">
	<ol class="breadcrumb">
	  <li><a href="#">{{__('administrator.dashboard')}}</a></li>
	  <li class="active">{{__('administrator.expense')}}</li>
	</ol>
</div>
<div class="page">
<div class=container-fluid>
	<div class="top-content">
		<div class="row">
	        <div class="col-sm-12 col-xs-12">
	            <div class="title-add">
	                <div class="pull-left">
	                    <h3><span class="fa fa-th"></span> {{__('administrator.expense')}}</h3>
	                </div>
	                <div class="pull-right">
	                   <a href="{{route('expense.create')}}" class="button_sm button_info"><span class="fa fa-plus"></span> {{__('administrator.create_new')}}</a>
	                </div>
	            </div>
	        </div>
	    </div>
    </div>

    <div class="wrapper-table ">
        <table id="datatable_income" width="100%" class="table table-striped table-hover  ">
            <thead>
                <tr>
                    <th>#</th>
                    <th>{{__('administrator.date')}}</th>
                    <th>{{__('administrator.account_name')}}</th>
                    <th>{{__('administrator.description')}}</th>
                    <th>{{__('administrator.reference')}}</th>
                    <th>{{__('administrator.amount')}}</th>
                    <th>{{__('administrator.created_by')}}</th>
                    <th>{{__('administrator.modify_by')}}</th>
                    <th>{{__('administrator.created_at')}}</th>
                    <th>{{__('administrator.updated_at')}}</th>
                    <th>{{__('administrator.action')}}</th>
                </tr>
            </thead>
        </table>
    </div>
</div>


@endsection



@section('script')
<script type="text/javascript">

    $('#datatable_income').DataTable({
        "oLanguage": {
            "sSearch": "{{__('administrator.search')}}:",
            "sLengthMenu": "{{__('administrator.display')}} _MENU_ {{__('administrator.record_per_page')}}",
            "sZeroRecords": "{{__('administrator.Nothing_foundsorry')}}",
            "sInfo": "{{__('administrator.showing')}} _START_ {{__('administrator.to')}} _END_ {{__('administrator.of')}} _TOTAL_ {{__('administrator.record')}}",
            "sInfoEmpty": "{{__('administrator.showing')}} 0 {{__('administrator.to')}} 0 {{__('administrator.of')}} 0 {{__('administrator.record')}}",
            "sInfoFiltered": "({{__('administrator.filter_form')}} _MAX_ {{__('administrator.total_records')}})",
            "oPaginate": {
                "sFirst": "{{__('administrator.first')}}",
                "sLast": "{{__('administrator.last')}}",
                "sNext": "{{__('administrator.next')}}",
                "sPrevious": "{{__('administrator.prevoius')}}"
            },
        },
        ordering: false,
        serverSide: true,
        lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
        ajax: "{{route('expense.index')}}",
        columns:
            [
                {data: 'DT_RowIndex'},
                {data: 'journal_paydate'},
                {data: 'account_name'},
                {data: 'journal_des'},
                {data: 'journal_invoice'},
                {data: 'amount'},
                {data: 'created_by'},
                {data: 'modify_by'},
                {data: 'created_at'},
                {data: 'updated_at'},
                {data: 'action'},
            ],

        "initComplete": function (settings, json) {
        }
    });
    $(document).on('click','.delete_income',function(){
        var id = $(this).data('id');

        $('#loading').show();

        if ($.confirm({
            title: '<strong style="color:darkcyan;">{{__('administrator.are_you_sure')}}</strong>',
            content: "<b> {{__('administrator.are_you_sure')}} </b>",
            type: "red",
            buttons: {

                '{{__('administrator.cancel')}}':
                    {
                        btnClass: 'btn-red',
                        action:
                            function () {
                            }
                    }
                ,
                '{{__('administrator.ok')}}':
                    {
                        btnClass: 'btn-blue',
                        action:

                            function () {
                                $.ajax({
                                    type: "POST",
                                    dataType: "json",
                                    url: '{{route("delete_expense")}}',
                                    data: {'id': id,  _token: '{{ csrf_token() }}'},
                                    success: function (data) {
                                        $('#loading').hide();
                                        location.reload();

                                    }

                                });
                            }
                    }
            }
        }))

            return false;
    });





</script>
@stop



