<?php

namespace App\Http\Middleware;

use Closure;
use Auth; //at the top
class MultipleAccess
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    function handle($request, Closure $next, $guard = null)
  {
    if(!empty(Auth::user()->is_role)){
      if(Auth::check()){
          $role = Auth::user()->is_role;
          if($role == 'MerchantIn' || $role == 'MerchantOut' || $role == 'Administrator'){
          	return $next($request);
          }
          else{
          	return response()->view('errors.403', [], 403);
          }
      }
    }
    return redirect()->guest('login');
    
  }
}