<?php

namespace App\Http\Controllers\api\driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\RequestPickup;
use Auth;
use App\CurrencyModel;
use App\BranchModel;

class DriverPickupController extends Controller
{
    public function pickup_history( Request $request)
    {
        $data = RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'shop.phone',
                'driver.name AS driver_name'
        )
        ->whereIn('nso007_request_pickup.status',[3,4])
        ->where('driver_pick_up_id',Auth::user()->id)
        ->groupBy('nso007_request_pickup.id')
        ->groupBy('nso007_request_pickup.date')
        ->orderBy('nso007_request_pickup.id','desc')
        ->paginate(10);
        
        return  response()->json(['data'=> $data->toArray()['data'], 'current_page'=>$data->currentPage()]);
    }

    public function pickup_print($id){
        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        ->select(
                'nso007_request_pickup_detail.customer_receive',
                \DB::raw("(CAST(nso007_request_pickup_detail.price as DECIMAL(10,2))) AS price"),
                \DB::raw("(CAST(nso007_request_pickup_detail.delivery_fee as DECIMAL(10,2))) AS delivery_fee"),
                'nso007_request_pickup_detail.delivery_option',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();



        $master =RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.invoice_pickup',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name'
        )
        ->find($id);

        $company = BranchModel::where('id',1)->
        select('nso007_branch.company_name','nso007_branch.address','nso007_branch.phone')->first();
        // dd($company);
        
        return  response()->json([$company, $master,$data]);
    }
}
