<?php

namespace App\Http\Controllers\api\driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\Http\Resources\driver\delivery\deliverySuccess;
use App\Http\Resources\driver\delivery\ondeliverytoday;
use App\Http\Resources\driver\delivery\dailyCommission;
use App\Http\Resources\driver\delivery\dailyDeliveryDetail;
use App\Http\Resources\driver\delivery\histroyDelivery;

class DriverDetailController extends Controller
{
    public function onDeliveryToDay()
    {
        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_proccessing.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->select(
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            \DB::raw("(CAST(nso007_export_stock.delivery_fee as DECIMAL(10,2))) AS delivery_fee"),
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            'nso007_export_stock.taxi_shop_fee',
            'nso007_export_stock.taxi_cust_fee',
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'users.shop_name',
            'users.phone',
            'nso007_export_stock.extra_fee_type',
            // 'nso007_export_stock.extra_fee',
            \DB::raw("(CAST(nso007_export_stock.extra_fee as DECIMAL(10,2))) AS extra_fee"),
            'nso007_delivery_order_detail_proccessing.total_riel',
            'nso007_delivery_order_detail_proccessing.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM((CAST(nso007_export_stock_details.export_qty * nso007_export_stock_details.price as DECIMAL(10,2)))) AS price')
        )
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        // dd($on_proccess);
        return ondeliverytoday::collection( $on_proccess);
    }
    public function deliveryToSuccessful ()
    {
        $successful = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')

        ->select(
            'nso007_discount.*',
            'nso007_export_stock.*',
            'nso007_export_stock.id',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'users.shop_name',
            'users.phone',
            'nso007_delivery_order_detail_success.total_riel',
            'nso007_delivery_order_detail_success.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
            \DB::raw('(CASE
                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                ELSE nso007_export_stock.taxi_shop_fee
                END) AS taxi_fee')
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        return deliverySuccess::collection( $successful);
    }

    public function dailyCommission()
    {
        $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->select(
            'nso007_export_stock.*' ,
            'nso007_delivery_order.*',
            'nso007_delivery_order_detail.driver_commission AS share_fee',
            'nso007_delivery_order_detail.commission_type AS share_fee_type',
            'nso007_delivery_order.delivery_date',
            'nso007_delivery_order_detail.driver_commission',
            'nso007_delivery_order_detail.commission_type',
            'nso007_delivery_order_detail.status as delivery_status'

        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        // ->groupBy('nso007_delivery_order.delivery_date')
        // ->orderBy('nso007_delivery_order.delivery_date','DESC')
        ->get();


        return dailyCommission::collection( $dailyDelivery);

    }

    public function dailyDeliveryDetail ($date)
    {
        $dailyDeliveryDetail = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')

        ->select(
            'nso007_discount.*',
            'nso007_export_stock.*',
            'nso007_export_stock.id',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'users.shop_name',
            'users.phone',
            'nso007_delivery_order_detail.status',
            'nso007_delivery_order_detail.total_riel',
            'nso007_delivery_order_detail.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'),
            \DB::raw('(CASE
            WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
            WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
            ELSE nso007_export_stock.taxi_shop_fee
            END) AS taxi_fee')
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',$date)
        ->groupBy('nso007_export_stock.box_code')
        ->get();
        return dailyDeliveryDetail::collection( $dailyDeliveryDetail);
    }


    public function deliveryAction($id,$status,$reason=null)
    {
            if($status == 1){
            $money = \DB::table('nso007_export_stock')
            ->join('nso007_export_stock_details', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->select(
                \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                \DB::raw("( CASE WHEN nso007_export_stock.extra_fee_type = 2 THEN nso007_export_stock.extra_fee END ) AS total_extra_fee_cus"),
                \DB::raw("SUM(nso007_export_stock_details.price*nso007_export_stock_details.export_qty) AS total"),
                'nso007_export_stock.delivery_fee',
                    'nso007_export_stock.delivery_status',
                    'nso007_export_stock.id'
                )
                ->whereIn('nso007_export_stock.id', explode(',', $id))->groupBy('nso007_export_stock.id')->get();
                $total = 0;
                foreach ($money as $key => $value) {
                    if ($value->delivery_status == 1) {
                        $total = $value->total  + $value->total_extra_fee_cus;
                    } else {
                        $total = $value->total + $value->delivery_fee + $value->total_extra_fee_cus;
                    }
                    // dd($total );
                    $checkMoney = \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->first();
                    if ($checkMoney->total_riel != 0 || $checkMoney->total_dollar != 0) {
                        \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3]);
                    } else {
                        \DB::table('nso007_delivery_order_detail')->where('export_id', $value->id)->where('status', 1)->update(['status'=>3,'total_dollar'=>$total,'total_riel'=>0]);
                    }
                }

                \DB::table('nso007_export_stock')->whereIn('id', explode(',', $id))->update(['status'=>3]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->whereIn('export_id', explode(',', $id))->delete();
                $success = json_decode($data, true);
                DeliveryOrderDetailSuccessModel::insert($success);
                return response()->json(['true']);


            }else if($status == 2){
                // this box code is pending
                \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>4]);
                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['status'=>2,'reason'=>$reason]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();
                $padding = json_decode($data, true);
                DeliveryOrderDetailPaddingModel::insert($padding);
                return response()->json(['true']);
            }else if($status == 3){
                //this box code is cancel
                \DB::table('nso007_export_stock')->where('id',$id)->update(['status'=>5]);
                \DB::table('nso007_delivery_order_detail')->where('export_id',$id)->where('status',1)->update(['status'=>4]);
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->update(['reason'=>$reason,'date'=>date('Y-m-d')]);
                $data = \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->get();
                \DB::table('nso007_delivery_order_detail_proccessing')->where('export_id',$id)->delete();
                $cancel = json_decode($data, true);
                DeliveryOrderDetailCancelModel::insert($cancel);
                $cancels =   \DB::table('nso007_export_stock')
                            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
                            ->join('users','users.id','nso007_export_stock.merchant_id')
                            ->join('nso007_products','nso007_products.barcode','nso007_export_stock_details.barcode')
                            ->select(
                                'users.id as merchant_id','nso007_products.barcode',
                                'nso007_export_stock_details.export_qty'
                            )
                            ->where('nso007_export_stock.id',$id)->get();
                foreach ($cancels as $key => $value) {
                    \DB::table('nos007__stocks')
                    ->where('merchant_id',$value->merchant_id)
                    ->where('barcode',$value->barcode)
                    ->increment('stock_qty',$value->export_qty);
                }
                return response()->json(['true']);
            }
            \DB::commit();
    }

    public function historyDriver(Request $request)
    {
        $dailyDelivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('users','users.id','nso007_export_stock.merchant_id')
        ->join('nso007_location','nso007_location.id','nso007_export_stock.location')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->select(
            'nso007_export_stock.id',
            'nso007_export_stock.box_code',
            // 'nso007_export_stock.delivery_fee',
            \DB::raw("(CAST(nso007_export_stock.delivery_fee as DECIMAL(10,2))) AS delivery_fee"),
            'nso007_export_stock.customer_receive',
            'nso007_export_stock.delivery_option',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.taxi_status',
            \DB::raw("(CAST(nso007_export_stock.taxi_shop_fee as DECIMAL(10,2))) AS taxi_shop_fee"),
            \DB::raw("(CAST(nso007_export_stock.taxi_cust_fee as DECIMAL(10,2))) AS taxi_cust_fee"),
            'nso007_export_stock.taxi_number',
            'nso007_location.name_km AS location',
            'nso007_delivery_order.delivery_date',
            'users.shop_name',
            'users.phone',
            'nso007_delivery_order_detail.status',
            'nso007_delivery_order_detail.total_riel',
            'nso007_delivery_order_detail.total_dollar',
            'nso007_export_stock_details.currency',
            \DB::raw('SUM((CAST(nso007_export_stock_details.export_qty * nso007_export_stock_details.price as DECIMAL(10,2)))) AS price')
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->groupBy('nso007_export_stock.box_code')
        ->orderBy('nso007_delivery_order.inovice','desc')
        ->paginate(10);
        return histroyDelivery::collection( $dailyDelivery);
    }


}
