<?php

namespace App\Http\Controllers\api\driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderModel;
use App\RequestPickup;
use Auth;

class DashboardController extends Controller
{
    public function index(){
        $pick = RequestPickup::where('driver_pick_up_id',\Auth::user()->id)->where('status',2)->count();
        $pick_history = RequestPickup::where('driver_pick_up_id',\Auth::user()->id)->where('status',3)->count();

        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail_proccessing','nso007_delivery_order.id','nso007_delivery_order_detail_proccessing.delivery_order_id')
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();
        $on_success = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->count();
        $on_delivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->count();
        $history = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->count();
        $payback = DeliveryOrderModel::join('nso007_delivery_order_detail_success','nso007_delivery_order.id','nso007_delivery_order_detail_success.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail_success.export_id')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id') 
        ->select(
            'nso007_discount.*',
            'nso007_export_stock.*',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail_success.driver_commission AS share_fee', 
            'nso007_delivery_order_detail_success.commission_type AS share_fee_type', 
            \DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price")
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        // ->where('nso007_delivery_order_detail_success.status',3)
        ->groupBy('nso007_export_stock.box_code')
        ->get();
   
        $total_delivery_fee  = 0;
        $total_other_services_fee  = 0;
        $total_extra_fee_cus  = 0;
        $totoal_price  = 0; 
        $totalPay  = 0;

        $commission  = 0; 
        foreach ($payback as $key => $value) {  
            if($value->status == 3){
              
                if($value->discount_type != null || $value->discount_type != '')
                {
                    if($value->discount_type == 1){
                        $delivery_fee = $value->discount; 
                    }
                    else{ 
                        $delivery_fee = ( (100 - $value->discount )* $value->delivery_fee ) / 100;
                    }
                }
                else{
                    $delivery_fee  =  $value->delivery_fee;
                } 

                if($value->delivery_status == 1) {
                    $delivery_fee =  0;
                } 

                if($value->delivery_pay_or_paid == 'paid'){ 
                    $delivery_fee  =   0; 
                }  
                 
                $other_services_fee =  0;   
                if($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2){ 
                    $other_services_fee = $value->other_services_fee ;  
                }    

                if($value->extra_fee_type == 1) {
                    $extra_fee_cus  = 0 ;  }
                else if($value->extra_fee_type == 2)   { 
                    $extra_fee_cus  = $value->extra_fee ;   }
                else  {
                    $extra_fee_cus = 0; 
                }

                if( $value->status == 3 ){ 
                    if($value->share_fee_type == 1){
                        $commission += number_format($value->share_fee, 2) ;
                    }else{
                        $commission += number_format(($value->share_fee/100)*($value->delivery_fee+ $value->extra_fee),2)   ;
                    } 
                    $totoal_price   			+=  $value->price  ; 
                    $total_other_services_fee  	+= $other_services_fee;           	
                    $total_delivery_fee  		+= $delivery_fee;           	
                    $total_extra_fee_cus  		+= $extra_fee_cus;           	
                } 
            } 
        } 
        $totalPay = $totoal_price + $total_other_services_fee + $total_delivery_fee + $total_extra_fee_cus; 
        return response()->json([
            'onprocessing'=> $on_proccess,
            'on_success'=> $on_success,
            'history'=> $history,
            'totalPay'=> number_format($totalPay,2).'$',
            'commission'=> number_format($commission,2).'$',
            'pick'=> $pick,
            'pick_history'=> $pick_history,
            'on_delivery'=> $on_delivery
        ]);

    }
}
