<?php

namespace App\Http\Controllers\Driver;

use App\CategoryModel;
use App\CurrencyModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use App\MerchantRequest;
use App\RequestPendingPickup;
use App\RequestPickup;
use App\RequestPickupDetailModel;
use App\User;
use DB;
use Auth;
class DriverPickupController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'shop.address',
                'shop.phone',
                'driver.name AS driver_name'
        )
        // ->whereDate('nso007_request_pickup.created_at',date('Y-m-d'))
        ->where('nso007_request_pickup.status',2)
        ->where('driver_pick_up_id',Auth::user()->id)
        ->groupBy('nso007_request_pickup.id')
        ->groupBy('nso007_request_pickup.date')
        ->orderBy('nso007_request_pickup.id','desc')
        ->get(); 
        return view('driver.pick.index',compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create($id)
    { 
        $req = RequestPickup::find($id);
        $reqdetail = RequestPickupDetailModel::where('request_pickup_id', '=' , $id)->get();
        $categories = CategoryModel::where('status',1)->pluck('name_km', 'id')->prepend('Please Select Category', '')->toArray(); 
        $zoon = LocationModel::where([['status',1],['pearent_id',null]])->pluck('name_km', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where([['status',1],['pearent_id','!=',null]])->pluck('name_km', 'id')->prepend(__('administrator.location'), '');
        $bus = \DB::table('nso007_bus')->where('status',1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray(); 
        return view('driver.pick.create', compact('req','reqdetail','categories','zoon','location','bus','id')); 
    }

    public function backup_item_store(Request $request){
        // dd($request);
        $mpp = new RequestPendingPickup();
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $mpp->category_id           =  $cat;
        $mpp->customer_receive      = $request->customer_receive;
        $mpp->zoon_id               = $request->zoon_id;
        $mpp->location_id           = $request->location_id;
        $mpp->delivery_fee          = $request->delivery_fee;
        $mpp->delivery_status       = $request->delivery_status;
        $mpp->price                 = $request->price;
        $mpp->delivery_option       = $request->bus_id;
        $mpp->taxi_number           = $request->taxi_number;
        $mpp->description           = $request->description;
        $mpp->save(); 
        $merchant_pending_pickup = DB::table('nso007_pending_pickup')->where('nso007_pending_pickup.id',$mpp->id)
        ->where('user_id','=', Auth::user()->id)
        ->join('nso007_category','nso007_category.id', 'nso007_pending_pickup.category_id')
       ->join('nso007_location','nso007_location.id','nso007_pending_pickup.location_id')
       ->select('nso007_pending_pickup.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();
       $by ='';
       if($merchant_pending_pickup->delivery_status == 1){
            $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_status == 2){
            $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
       <div class="mobile-detail">
           <div class="mobile-text">
               <div class="texted-left">
                   <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                   <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                   <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                   <li>បង់ដោយ: <span>'.$by.'</span></li>
               </div>
               <div class="texted-right">
                   <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                   <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                   <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
               </div>
               <div class="diver-boxdelete">
                   <div class="mobile-button">
                       <span class="btn btn-info btn-xs bt-edit"  data-id="'.$merchant_pending_pickup->id.'" >Edit</span>
                       <span class="btn btn-danger btn-xs bt-delete"  data-id="'.$merchant_pending_pickup->id.'" >Delete</span>
                   </div>
               </div>
           </div>
       </div>
   </div>';
        return response()->json(['box'=>$box]);
    }


    public function backup_item_edit(Request $request){
        $mpp = RequestPendingPickup::find($request->id);
        return $mpp;
    }


//     public function backup_item_update(Request $request){
//          ;
//         $mpp = RequestPendingPickup::find($request->id);
//         $mpp->user_id = Auth::user()->id;
//         $cat ='';
//         if($request->category_id==null){
//             $cat ='another';
//         }
//         else {
//             $cat =$request->category_id;
//         }
//         $mpp->category_id =  $cat;
//         $mpp->customer_receive = $request->customer_receive;
//         $mpp->zoon_id = $request->zoon_id;
//         $mpp->location_id = $request->location_id;
//         $mpp->delivery_fee = $request->delivery_fee;
//         $mpp->delivery_status = $request->delivery_status;
//         $mpp->price = $request->price;
//         $mpp->delivery_option = $request->bus_id;
//         $mpp->taxi_number = $request->taxi_number;
//         $mpp->description = $request->description;
//         $mpp->update();

//         $merchant_pending_pickup = DB::table('nso007_pending_pickup')->where('nso007_pending_pickup.id',$mpp->id)
//         ->join('nso007_category','nso007_category.id', 'nso007_pending_pickup.category_id')
//        ->join('nso007_location','nso007_location.id','nso007_pending_pickup.location_id')
//        ->select('nso007_pending_pickup.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
//        ->first();
//        $by ='';
//        if($merchant_pending_pickup->delivery_status == 1){
//            $by ='ខាងហាង';
//        }
//        elseif($merchant_pending_pickup->delivery_status == 2){
//         $by ='ខាងអតិថិជន';
//        }
//        $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
//        <div class="mobile-detail">
//            <div class="mobile-text">
//                <div class="texted-left">
//                    <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
//                    <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
//                    <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
//                    <li>បង់ដោយ: <span>'.$by.'</span></li>
//                </div>
//                <div class="texted-right">
//                    <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
//                    <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
//                    <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
//                </div>
//                <div class="diver-boxdelete">
//                    <div class="mobile-button">
//                    <span class="btn btn-info btn-xs bt-edit"  data-id="'.$merchant_pending_pickup->id.'" >Edit</span>
//                    <span class="btn btn-danger btn-xs bt-delete"  data-id="'.$merchant_pending_pickup->id.'" >Delete</span>
//                    </div>
//                </div>
//            </div>
//        </div>
//    </div>';
//         return response()->json(['box'=>$box]);
//     }

    public function  pending_pickup_delete(Request $request){
        $mpp = RequestPendingPickup::find($request->id);
        $mpp->delete();
        return $mpp;

    }
    public function store(Request $request)
    {
        // dd($request->all());
        $request_pickup_detail  = new  RequestPickupDetailModel()  ;
            $request_pickup_detail->request_pickup_id   = $request->request_pickup_id;
            $request_pickup_detail->category_id         = $request->category_id;
            $request_pickup_detail->customer_receive    = $request->customer_receive;
            $request_pickup_detail->zoon_id             = $request->zoon_id;
            $request_pickup_detail->location_id         = $request->location_id;
            $request_pickup_detail->delivery_fee        = $request->delivery_fee;
            $request_pickup_detail->delivery_status     = $request->delivery_status;
            $request_pickup_detail->price               = $request->price;
            $request_pickup_detail->delivery_option     = $request->bus_id;
            $request_pickup_detail->taxi_number         = $request->taxi_number;
            $request_pickup_detail->description         = $request->description;
            $request_pickup_detail->delivery_pay_or_paid     = $request->delivery_pay_or_paid;
            $request_pickup_detail->taxi_status               = $request->taxi_status;
                    if($request->taxi_status == 1){
                        $request_pickup_detail->taxi_shop_fee         = $request->taxi_price;
                    }
                    else{
                        $request_pickup_detail->taxi_cust_fee         = $request->taxi_price;
                    }
            $request_pickup_detail->taxi_pay_or_paid     = $request->taxi_pay_or_paid;
            $request_pickup_detail->other_services_fee         = $request->Other_service_fee;
            $request_pickup_detail->other_services_type         = $request->other_services_type;
            $request_pickup_detail->other_services_pay_or_paid         = $request->other_services_pay_or_paid;
            $request_pickup_detail->date_delivery       =    date('Y-m-d', strtotime($request->date_delivery));
            $request_pickup_detail->save();

        $merchant_pending_pickup = DB::table('nso007_request_pickup_detail')->where('nso007_request_pickup_detail.id',$request_pickup_detail->id)

            ->join('nso007_category','nso007_category.id', 'nso007_request_pickup_detail.category_id')
            ->join('nso007_location','nso007_location.id', 'nso007_request_pickup_detail.location_id')

            ->select('nso007_request_pickup_detail.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
            ->first();

       $by ='';
       if($merchant_pending_pickup->delivery_status == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_status == 2){
        $by ='ខាងអតិថិជន';
        }
        $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
            <div class="mobile-detail">
                <div class="mobile-text">
                    <div class="texted-left">
                        <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                        <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                        <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                        <li>បង់ដោយ: <span>'.$by.'</span></li>
                    </div>
                    <div class="texted-right">
                        <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                        <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                        <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
                    </div>
                    <div class="diver-boxdelete">
                        <div class="mobile-button">
                        <span class="btn btn-info btn-xs bt-edit"  data-id="'.$merchant_pending_pickup->id.'" >Edit</span>
                        <span class="btn btn-danger btn-xs bt-delete"  data-id="'.$merchant_pending_pickup->id.'" >Delete</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>';

        return response()->json(['box'=>$box]);

    }
    public function pickup_history( Request $request)
    {

        $data = RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'shop.phone',
                'driver.name AS driver_name'
        )
        ->whereIn('nso007_request_pickup.status',[3,4])
        ->where('driver_pick_up_id',Auth::user()->id)
        ->groupBy('nso007_request_pickup.id')
        ->groupBy('nso007_request_pickup.date')
        ->orderBy('nso007_request_pickup.id','desc')
        ->paginate(10);
        if ($request->ajax()) {
            $view = view('driver.pick.data-list',compact('data'))->render();
            return response()->json(['html'=>$view]);
        }
        return view('driver.pick.pickup_history',compact('data'));

    }


    public function show($id)
    {

        $exchang_rate = CurrencyModel::find(1);
        $currency  = $exchang_rate->currency_exchange_to;
        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        ->select('nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();



        $master =RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name'
        )
        ->find($id);
        return view('driver.pick.show',compact('currency','data','master'));

    }

    public function print_iteam($id)
    {
        $reqdetail = RequestPickupDetailModel::where('request_pickup_id', '=' , $id)->get();

        // $exchang_rate = CurrencyModel::find(1);
        // $currency  = $exchang_rate->currency_exchange_to;
        // $data = RequestPickup::
        // join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        // ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        // ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        // ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        // ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        // ->select('nso007_request_pickup_detail.*',
        //         'shop.shop_name AS shop_name',
        //         'driver.name AS driver_name',
        //         'nso007_location.name_km AS location_name',
        //         'nso007_category.name_km AS category_name'
        // )
        // ->where('request_pickup_id',$id)
        // ->orderBy('nso007_request_pickup.id','desc')
        // ->get();

        // $master =RequestPickup::
        // join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        // ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        // ->select('nso007_request_pickup.*',
        //         'shop.shop_name AS shop_name',
        //         'driver.name AS driver_name'
        // )
        // ->find($id);
        return view('driver.pick.show-item',compact('reqdetail'));

    }

    public function print_invoice($id){

        $exportStock   =   ExportStockModel::where('box_code' ,$id)->first();


        if ($exportStock->type_of_stock == 1) {   //export stock
            $data   =   ExportStockdetailsMode::leftjoin('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->leftjoin('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
                ->leftjoin('nso007_location', 'nso007_export_stock.location', 'nso007_location.id')
                ->leftjoin('users As merchant', 'nso007_export_stock.merchant_id', 'merchant.id')
                ->select(
                    'nso007_export_stock_details.*',
                    'nso007_products.name_en AS items',
                    'nso007_export_stock.*',
                    'nso007_location.name_en AS location_name',
                    'merchant.shop_name',
                    'merchant.phone',
                    'nso007_export_stock.customer_receive'
                )
                ->where('nso007_export_stock.type_of_stock', 1)
                ->where('nso007_export_stock.id', $id)
                ->get();
        } else {   //out stock
            $data   =   ExportStockdetailsMode::leftjoin('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->leftjoin('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
                ->join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
                ->leftjoin('nso007_location', 'nso007_export_stock.location', 'nso007_location.id')
                ->leftjoin('users As merchant', 'nso007_export_stock.merchant_id', 'merchant.id')
                ->select(
                    'nso007_export_stock_details.*',
                    // 'nso007_products.name_en AS items',
                    'nso007_category.name_en AS items',
                    'nso007_export_stock.*',
                    'nso007_location.name_en AS location_name',
                    'merchant.shop_name',
                    'merchant.phone',
                    'nso007_export_stock.customer_receive'
                )
                ->where('nso007_export_stock.type_of_stock', 2)
                ->where('nso007_export_stock.box_code', $id)
                ->get();
        }

        return view('driver.pick.print-invoice',compact('data'));

    }
    public function edit(Request $request)
    {
        $reqdetail = RequestPickupDetailModel::where('id', '=' ,$request->id)->first(); 
        return $reqdetail;

    }


    public function update(Request $request)
    {
        // dd($request->all());
        $mpp = RequestPickupDetailModel::find($request->id);
        $mpp->user_id = Auth::user()->id;
        $cat ='';
        if($request->category_id==null){
            $cat ='another';
        }
        else {
            $cat =$request->category_id;
        }
        $mpp->category_id =  $cat;
        $mpp->customer_receive = $request->customer_receive;
        $mpp->zoon_id = $request->zoon_id;
        $mpp->location_id = $request->location_id;
        $mpp->delivery_fee = $request->delivery_fee;
        $mpp->delivery_status = $request->delivery_status;
        $mpp->price = $request->price;
        $mpp->delivery_option = $request->bus_id;
        $mpp->taxi_number = $request->taxi_number;
        $mpp->taxi_number = $request->taxi_number;
        $mpp->description = $request->description;
        $mpp->delivery_pay_or_paid     = $request->delivery_pay_or_paid;
             $mpp->taxi_status               = $request->taxi_status;
                    if($request->taxi_status == 1){
                         $mpp->taxi_shop_fee         = $request->taxi_price;
                    }
                    else{
                         $mpp->taxi_cust_fee         = $request->taxi_price;
                    }
             $mpp->taxi_pay_or_paid     = $request->taxi_pay_or_paid;
             $mpp->other_services_fee         = $request->Other_service_fee;
             $mpp->other_services_type         = $request->other_services_type;
             $mpp->other_services_pay_or_paid         = $request->other_services_pay_or_paid;
        $mpp->date_delivery = date('Y-m-d', strtotime($request->date_delivery));

        $mpp->update();
        // dd($mpp);

        $merchant_pending_pickup = DB::table('nso007_request_pickup_detail')->where('nso007_request_pickup_detail.id',$mpp->id)
        ->join('nso007_category','nso007_category.id', 'nso007_request_pickup_detail.category_id')
       ->join('nso007_location','nso007_location.id','nso007_request_pickup_detail.location_id')

       ->select('nso007_request_pickup_detail.*','nso007_category.name_km as cat_name','nso007_location.name_km as location_name')
       ->first();
       $by ='';
       if($merchant_pending_pickup->delivery_option == 1){
           $by ='ខាងហាង';
       }
       elseif($merchant_pending_pickup->delivery_option == 2){
        $by ='ខាងអតិថិជន';
       }
       $box='<div class="col-sm-6 col-xs-12 padd-2 '.$merchant_pending_pickup->id.'">
            <div class="mobile-detail">
                <div class="mobile-text">
                    <div class="texted-left">
                        <li>category Name : <span>'.$merchant_pending_pickup->cat_name.'</span></li>
                        <li>Customer Receive: <span>'.$merchant_pending_pickup->customer_receive.'</span></li>
                        <li>Taxi number: <span>'.$merchant_pending_pickup->taxi_number.'</span></li>
                        <li>បង់ដោយ: <span>'.$by.'</span></li>
                    </div>
                    <div class="texted-right">
                        <li>Location: <span>'.$merchant_pending_pickup->location_name.'</span></li>
                        <li>Price: <span>'.$merchant_pending_pickup->price.'$</span></li>
                        <li>Delivery:  <span>'.$merchant_pending_pickup->delivery_fee.'$</span></li>
                    </div>
                    <div class="diver-boxdelete">
                        <div class="mobile-button">
                            <span class="btn btn-info btn-xs bt-edit"  data-id="'.$merchant_pending_pickup->id.'" >Edit</span>
                            <span class="btn btn-danger btn-xs bt-delete"  data-id="'.$merchant_pending_pickup->id.'" >Delete</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>';
        return response()->json(['box'=>$box]);
    }

    public function pickup_delect(Request $request)
    {
        $reqdetail = RequestPickupDetailModel::where('id', '=' ,$request->id)->delete();
        return $reqdetail;
    }

    public function find_location(Request $request)
    {
        $location = LocationModel:: where('status',1)->where('pearent_id',$request->id)
                    ->select('nso007_location.name_km AS name','id')->get();
        return $location;
    }
    public function find_price_location(Request $request){
        $data = LocationModel::find($request->id);
        $price = $data->price;
        return $price ;
    }
    public function pickup_done(Request $request){

        RequestPickup::where('id',$request->id)->update(['status'=>3]);
        $data = 'ok';
        return $data;
    }
}

