<?php

namespace App\Http\Controllers\Driver;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\DeliveryOrderModel;
use App\PickupAdminModel;
use App\RequestPickup;
use Illuminate\Support\Facades\DB;

class DashboardController extends Controller
{

    public function index()
    {
        $pick = RequestPickup::where('driver_pick_up_id',\Auth::user()->id)->where('status',2)->count();
        $pick_history = RequestPickup::where('driver_pick_up_id',\Auth::user()->id)->where('status',3)->count();

        $on_proccess = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order_detail.status',1)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->count();
        $on_success = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order_detail.status',3)
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->count();
        $on_delivery = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->whereNotIn('status',[7])
        ->count();
        $from_date = date('d') > 25 ? date("Y-m-d",strtotime(date("Y-m").'-26')) : date("Y-m-d",strtotime(date("Y-m",strtotime("-1 MONTH")).'-26'));
        $to_date =  date('d') > 25 ? date("Y-m-d",strtotime(date("Y-m",strtotime("+1 MONTH")).'-25')) : date("Y-m-d",strtotime(date("Y-m").'-25'));
        $history = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date])
        ->where('status',3)
        ->count();

  
        
 
        $payback = DeliveryOrderModel::join('nso007_delivery_order_detail','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id') 
        ->select(
            'nso007_discount.*',
            'nso007_export_stock.*',
            'nso007_export_stock.delivery_fee',
            'nso007_export_stock.delivery_status',
            'nso007_export_stock.extra_fee_type',
            'nso007_export_stock.extra_fee',
            'nso007_delivery_order_detail.driver_commission AS share_fee', 
            'nso007_delivery_order_detail.commission_type AS share_fee_type', 
            \DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price")
        )
        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
        ->where('nso007_delivery_order_detail.status',3)
        ->groupBy('nso007_export_stock.box_code')
        ->get();
   
        $total_delivery_fee  = 0;
        $total_other_services_fee  = 0;
        $total_extra_fee_cus  = 0;
        $totoal_price  = 0; 
        $totalPay  = 0;

        $commission  = 0; 
        foreach ($payback as $key => $value) {  
            if($value->status == 3){
              
                if($value->discount_type != null || $value->discount_type != '')
                {
                    if($value->discount_type == 1){
                        $delivery_fee = $value->discount; 
                    }
                    else{ 
                        $delivery_fee = ( (100 - $value->discount )* $value->delivery_fee ) / 100;
                    }
                }
                else{
                    $delivery_fee  =  $value->delivery_fee;
                } 

                if($value->delivery_status == 1) {
                    $delivery_fee =  0;
                } 

                if($value->delivery_pay_or_paid == 'paid'){ 
                    $delivery_fee  =   0; 
                }  
                 
                $other_services_fee =  0;   
                if($value->other_services_fee > 0 && $value->other_services_pay_or_paid == 'pay' && $value->other_services_type == 2){ 
                    $other_services_fee = $value->other_services_fee ;  
                }    

                if($value->extra_fee_type == 1) {
                    $extra_fee_cus  = 0 ;  }
                else if($value->extra_fee_type == 2)   { 
                    $extra_fee_cus  = $value->extra_fee ;   }
                else  {
                    $extra_fee_cus = 0; 
                }

                if( $value->status == 3 ){ 
                    if($value->share_fee_type == 1){
                        $commission += number_format($value->share_fee, 2) ;
                    }else{
                        $commission += number_format(($value->share_fee/100)*(($value->delivery_fee / $value->delivery_fee_rate)+ $value->extra_fee),2)   ;
                    } 
                    $totoal_price   			+=  $value->price / $value->total_product_rate; 
                    $total_other_services_fee  	+= $other_services_fee;           	
                    $total_delivery_fee  		+= $delivery_fee / $value->delivery_fee_rate;           	
                    $total_extra_fee_cus  		+= $extra_fee_cus;           	
                } 
            } 
        } 
        $totalPay = $totoal_price + $total_other_services_fee + $total_delivery_fee + $total_extra_fee_cus; 
        $collected_price = DeliveryOrderModel::join(DB::raw('(select delivery_order_id,status,total_riel,total_dollar,amount_pay_to,pay_to from nso007_delivery_order_detail) as dod'),'dod.delivery_order_id','nso007_delivery_order.id')
                        ->where('dod.status',3)
                        ->where('nso007_delivery_order.driver_id',\Auth::user()->id)
                        ->where('nso007_delivery_order.delivery_date',date('Y-m-d'))
                        ->select(DB::raw('SUM(total_riel) as total_kh'),DB::raw('SUM(CASE WHEN pay_to = "delivery" THEN amount_pay_to + total_dollar  ELSE total_dollar END) as total_usd'))
                        ->first();
        $pickupAdmin = PickupAdminModel::where('status',1)->where('driver_id',auth()->id())
            ->count();
        $pickupAdminHistory = PickupAdminModel::where('status',4)->where('driver_id',auth()->id())
            ->whereBetween(DB::raw("DATE(delivery_date)"),[$from_date,$to_date])
            ->sum("exact_qty");
        return view('driver.dashboard',compact('on_proccess','on_success','on_delivery','history','totalPay','commission','pick','pick_history','collected_price','pickupAdmin','pickupAdminHistory'));
    }


}
