<?php
namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;

use Illuminate\Foundation\Auth\AuthenticatesUsers;

use Illuminate\Http\Request;
use Auth;
use Illuminate\Support\Facades\Session;

class LoginController extends Controller
{
use AuthenticatesUsers;

protected function authenticated(Request $request, $user)
{
     if($user->status != 0){
        if ( $user->is_role == 'Administrator' ) {
            return redirect()->route('app_dashboard');
        }else if($user->is_role == 'Driver'){
            return redirect()->route('dashboard_driver');
        }else if($user->is_role == 'MerchantIn'){
            return redirect()->route('dashboard_merchant');
        }
        else if($user->is_role == 'MerchantOut'){
            return redirect()->route('dashboard_merchant');
        }
        return redirect('/');
     }else{
         Auth::logout($request);
     }
}


public function __construct()
{
    $this->middleware('guest', ['except' => 'logout']);
}
}
