<?php


namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use App\Fun\Fun;
use App\UserGroupModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Spatie\Permission\Models\Role;
use DB;
use Hash;
use GuzzleHttp\Client;
use DataTables;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\File;
use Image;
use session;
use Yajra\DataTables\Facades\DataTables as FacadesDataTables;

class UserController extends Controller
{

    function __construct()
    {
        // $this->middleware('permission:User List', ['only' => ['index']]);
        // $this->middleware('permission:User create', ['only' => ['create', 'store']]);
        // $this->middleware('permission:User Edit', ['only' => ['edit', 'update']]);
    }

    public function index(Request $request)
    {
            // $data = User::where('user_type',3)->get();


            // foreach ($data as $key => $value) {
            //     $seed = str_split('abcdefghijklmnopqrstuvwxyz'
            //     .'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
            //     .'0123456789'); // and any other characters
       

            //     shuffle($seed); // probably optional since array_is randomized; this may be redundant
            //     $rand = '';
            //     foreach (array_rand($seed, 15) as $k) $rand .= $seed[$k];
    


            //     $value->share_links  =  $rand ;
            //     $value->update();

            //     # code...
            // }

            // dd($rand);



        // $data = DeliveryOrderModel::where('driver_id',183)->get();  //172
        // foreach ($data as $key => $value) {
        //     $data1 = DeliveryOrderDetailModel::where('delivery_order_id',$value->id)->update(['commission_type'=>'2']);
        // }


        // dd('Done');


 
        // $data = ExportStockModel::get();

        // foreach ($data as $key => $value) {
        //     $dd = ExportStockdetailsMode::where('export_id',$value->id)->get();

        //     $total_product = 0;
        //     foreach ($dd as $key1 => $value1) {
        //          $total_product +=  $value1->price * $value1->export_qty;
        //     }
            
        //     $value->total_product =  $total_product;
        //     $value->update();
        // }
        // dd($total_product);
       
        if ($request->ajax()) {
            $search = $request->input('search.value');
            $users = User::where('is_role', 'Administrator')
                ->selectRaw('id,name,user_type,phone,gender,status,email,avartar')
                ->where('users.user_type', 1);
            return FacadesDataTables::of($users)
                ->addColumn('image', function ($users) {
                    $path = "images/upload/" . $users->avartar;
                    $full_path = File::exists($path) ?  $path : 'images/default.jpg';
                    return '<img src="/' . $full_path . '" alt="" width="35px" height="35px">';
                })
                ->addColumn('role', function ($users) {
                    return $users->roles->first() ? ucfirst($users->roles->first()->name) : '';
                })
                ->addColumn('action', function ($users) {
                    // if(Auth::user()->id == $users->id){
                    //     return 1;
                    // }
                    $active = '';
                    $edit   = '';
                    $dis_or_en = '';
                    if (Auth::user()->id == $users->id) {
                        $active = '<label class="btn btn-success" style="margin-top:0px;padding:3px 7px" >Active</label>';
                    }else{
                        $check = $users->status == 1 ? 'checked' : 'a';
                        $dis_or_en = '<input data-route="'.route('users.destroy',$users->id).'" ' . $check . ' class="toggle dis_and_en" type="checkbox" data-toggle="toggle" data-on="Enabled" data-off="Disabled" value="'.$users->status.'">';
                    }
                    $edit = '&nbsp;<a href="'.route('users.edit',$users->id).'" data-comf-type="orange" data-route="' . route('users.edit', $users->id) . '"  id="edit" class="btn btn-sm btn-warning fa fa-edit ml-3" data-btn-padding="p-5" data-btn-text="' . __('administrator.update') . '" data-title="Edit User" style="cursor:pointer;margin-top:0px;padding:4px 7px"></a>';
                    
                    return $active . $dis_or_en . $edit;
                })
                ->addIndexColumn()
                ->rawColumns(['image', 'action'])
                ->make(true);
        }
        return view('administrator.users.index');
    }

    public function user_status(Request $request)
    {
        $user = User::find($request->user_id);
        $user->status = $request->status;
        $user->save();
        return response()->json(['success' => 'Status change successfully.']);
    }

    public function create(Request $request)
    {
        $roles = Role::pluck('name', 'name')->all();
        return view('administrator.users.create', compact('roles'));
    }

    public function store(Request $request, $Digit = 4)
    {
        $this->validate($request, [
            'name'    => 'required',
            'gender'    => 'required',
            'phone'    => 'required',
            'email'     => 'required|max:255|unique:users,email',
            'password'  => 'required|same:confirm_password|string|min:8',
        ]);
        try {
            DB::beginTransaction();
            $user = new User;
            
            $gallery = '';

            if ($files = $request->file('image')) {
                $original_name = $files->getClientOriginalName();
                $original_name = date('ymdhis') . $original_name;
                $destinationPath = 'images/upload';
                $thum = Image::make($files->getRealPath())->resize(300, 400);
                $thum->save($destinationPath . '/' . $original_name, 80);
                $destinationPath = 'images/upload';
                $files->move($destinationPath, $original_name);
                $gallery = $original_name;
            } else {
                $gallery = 'default.jpg';
            }
            $user->name     = $request->name;
            $user->email    = $request->email;
            $user->phone    = $request->phone;
            $user->menu_layout    = 'top';
            $user->hover_text    = '1e272e';
            $user->hover_bg    = 'ecf0f1';
            $user->secondary_background    = '34495e';
            $user->primary_background    = '1e272e';
            $user->secondary_text    = '34495e';
            $user->primary_text    = 'f39c12';
            $user->animation_duration    = '0.2';
            $user->animation    = 'zoomInUp';
            $user->is_role  = 'Administrator';
            $user->gender   = $request->gender;
            $user->avartar  = $gallery;
            $user->user_type     = 1;
            $user->password = Hash::make($request['password']);
            $user->save();
            $user->assignRole($request->input('roles'));
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->route('users.index')->with('success', 'User Create successfully');
    }

    public function show($id)
    {
        return view('administrator.users.show');
    }

    public function edit($id)
    {
        $user = User::find($id);
        $roles = Role::pluck('name', 'name')->all();
        $userRole = $user->roles->pluck('name', 'name')->all();
        return view('administrator.users.edit', compact('user', 'roles', 'userRole'));
    }

    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'name'   => 'required',
            'email' => 'required|unique:users,email,' . $id,
            'files' => 'max:2048',

        ]);
        try {
            DB::beginTransaction();
            
            $gallery​ = '';
            if ($files = $request->file('avartar')) {
                $original_name = $files->getClientOriginalName();
                $original_name = date('ymdhis') . $original_name;
                $destinationPath = 'images/upload';
                $thum = Image::make($files->getRealPath())->resize(300, 400);
                $thum->save($destinationPath . '/' . $original_name, 80);
                $destinationPath = 'images/upload';
                $files->move($destinationPath, $original_name);
                $gallery = $original_name;
            } else {
                $gallery = $request->arrayImg;
            }
            $input = $request->all();
            if (!empty($input['password'])) {
                $input['password'] = Hash::make($input['password']);
            } else {
                $input = array_except($input, array('password'));
            }
            User::find($id)->update($input);
            $user = User::find($id);
            $user->name     = $request->name;
            $user->email    = $request->email;
            $user->phone    = $request->phone;
            $user->gender   = $request->gender;
            $user->avartar  = $gallery;
            $user->update();
            DB::table('model_has_roles')->where('model_id', $id)->delete();
            $user->assignRole($request->input('roles'));
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->route('users.index')->with('success', 'User updated successfully');
    }
    public function destroy($id,Request $request)
    {   
        User::where('id',$id)
            ->update(['status'=>$request->status]);
        return [
            'status'=>'ok'
        ];
    }
}
