<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Fun\Fun as FunFun;
use App\Http\Controllers\Controller;
use App\User;
use App\CategoryModel;
use App\DeliveryOrderDetailModel;
use App\ExportStockdetailsMode;
use App\Helpers\Globals;
use App\ProductModel;
use App\StockModel;

class StockController extends Controller
{
    function __construct(){
        FunFun::lang();
        $this->middleware('permission:Report Stock', ['only' => ['index']]);
    }

    public function index()
    {

        $merchant = User::where('user_type',3)->where('status',1)->where('type_of_merchant',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $category = CategoryModel::where('status',1);
        if(\Globals::check_lang() == 'en'){
            $category = $category->select('nso007_category.*','nso007_category.name_en AS category_name')->pluck('category_name', 'id')->prepend(__('administrator.please_select'), '');
        }else{
            $category = $category->select('nso007_category.*','nso007_category.name_km AS category_name')->pluck('category_name', 'id')->prepend(__('administrator.please_select'), '');
        }
        $lang = Globals::check_lang();
        $product = ProductModel::where('status',1)
            ->pluck('name_'. $lang .'','id')
            ->prepend(__('administrator.please_select'), '');

        return view('administrator.stock.index',compact('category','merchant','product'));
    }

    public function data_stock_balance( $category, $merchant ,$barcode,$product)
    {
        $data = StockModel::
        join('users AS merchant','merchant.id','nos007__stocks.merchant_id')
        ->leftJoin('nso007_products AS products','products.barcode','nos007__stocks.barcode')
        ->leftJoin('nso007_category','nso007_category.id','products.category_id')
        ->select(
            'merchant.shop_name',
            'merchant.id as shop_id',
            'merchant.phone',
            'nos007__stocks.barcode',
            'nos007__stocks.price',
            'nos007__stocks.stock_qty',
            'products.name_en AS product_name',
            'products.barcode AS product_code',
            'products.id',
            'products.category_id',
            'nso007_category.name_en AS category_name'
        )
        ->where(function($query) use ($merchant){
            if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                $query->where('merchant_id',\Auth::user()->id);
            }else{
                $query->where('merchant_id','LIKE',$merchant);
            }
        })
        ->when($product,function($q) use($product){
            $q->where('products.id',$product);
        })
        ->where('products.barcode','LIKE',$barcode)
        ->where('products.category_id','LIKE',$category)
        ->get();

            return      $data ;
    }


    public function datatble_stock_balance(Request $request)
    {
        $category       = isset($request->category)?$request->category:null;
        $merchant       = isset($request->merchant)?$request->merchant:null;
        $barcode        = isset($request->barcode)?$request->barcode:null;
        $product        = isset($request->product)?$request->product:null;
        $data = $this->data_stock_balance( $category, $merchant ,$barcode,$product);
                            if ($request->isMethod('GET')) {
                                return \datatables()::of($data)
                                ->editColumn('price', function ($data)  {
                                    return '$'.number_format( $data->price,2);
                                })
                                ->addColumn('out_stock',function($data){
                                    $export_detail_qty = ExportStockdetailsMode::join('nso007_export_stock','nso007_export_stock.id','nso007_export_stock_details.export_id')
                                                ->where('nso007_export_stock_details.barcode',$data->product_code)
                                                ->where('nso007_export_stock.merchant_id',$data->shop_id)
                                                ->where('status','!=',5)
                                                 ->sum('export_qty');
                                    return $export_detail_qty;

                                })
                                ->addColumn('in_stock',function($data){
                                    $export_detail_qty = ExportStockdetailsMode::join('nso007_export_stock','nso007_export_stock.id','nso007_export_stock_details.export_id')
                                                ->where('nso007_export_stock_details.barcode',$data->product_code)
                                                ->where('nso007_export_stock.merchant_id',$data->shop_id)
                                                ->where('status','!=',5)
                                                ->sum('export_qty');
                                    
                                    return $export_detail_qty+$data->stock_qty;

                                })


                                ->addIndexColumn()
                                ->make(true);

                            }else{

                                echo json_encode($data);
                            }
    }
    public function create()
    {
        //
    }


    public function store(Request $request)
    {

    }


    public function show($id)
    {
        //
    }


    public function edit($id)
    {
        //
    }


    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        //
    }
    public function stock_balance_print(Request $request)
    {
        $category       = isset($request->category)?$request->category:null;
        $merchant       = isset($request->merchant)?$request->merchant:null;
        $barcode        = isset($request->barcode)?$request->barcode:null;
        $product        = isset($request->product)?$request->product:null;
        $shop_name = "";
        $data = $this->data_stock_balance( $category, $merchant ,$barcode,$product);

        if( $merchant  != null){
            $shop_name =$data[0]->shop_name;
            $phone =$data[0]->phone;
        }
        else{
            $shop_name = '#';
            $phone = '#';
        }
        return view('administrator.stock.stock_balance_print',compact('data','shop_name','phone') );

    }
}
