<?php

namespace App\Http\Controllers\Administrator;
use App\ProductModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SearchController extends Controller
{
    public  function get_product( Request $request){

        $box_code = (empty($request->id)?$request->get('term') :$request->id);


        $products  = ProductModel:: leftJoin('nso007_category','nso007_category.id','nso007_products.category_id');
        if(\Globals::check_lang() == 'en'){
            $products = $products  ->select('nso007_products.*','nso007_products.name_en AS product_name','nso007_category.name_en AS category_name')
                                    ->where('nso007_products.status',1)->where('nso007_products.barcode',$id)->first();
        }else{
            $products = $products  ->select('nso007_products.*','nso007_products.name_km AS product_name','nso007_category.name_km AS category_name')
                                    ->where('nso007_products.status',1)->where('nso007_products.barcode',$id)->first();
        }
        $status = '';

        $product_session = session()->get('product_session');

        if(!$products) {
            $status = 'Product Code is Incorrect!';
        }
        else{
            if(isset($product_session[$id])) {
                session()->put('product_session', $product_session);
                $status = 'Product is add already exist !';
            }else{
                $product_session[$id] = [
                    "barcode"           => $products->barcode,
                    "product_name"      => $products->product_name,
                    "category_name"     => $products->category_name,
                    "stockin_qty"       => '',
                    "price"             => $products->price,
                    'total'             =>''
                ];
                session()->put('product_session', $product_session);
                $status = 'success';
            }
        }
        echo $status;
    }
}
