<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\Exports\ShopVoucherExport;
use App\Exports\ShopVoucherExportQty;
use App\Exports\ShopVoucherExportShop;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Exception;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ReportShopNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        //1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel  ,5= paid
        $shop = $request->merchant;
        $search = $shop ? "WHERE items.merchant_id = ".$shop : "";

        $data = DeliveryOrderModel::join(DB::raw("(SELECT
                    dod.status,dod.delivery_order_id,
                    exs.merchant_id,users.shop_name,users.phone,dod.export_id
                FROM
                    nso007_delivery_order_detail as dod
                LEFT JOIN
                    nso007_export_stock as exs
                ON
                    exs.id = dod.export_id
                INNER JOIN
                    users
                ON
                    users.id = exs.merchant_id
                WHERE
                    dod.status_paid IS NULL
                AND
                    dod.invoice_payment_id IS NULL) as items"),"items.delivery_order_id","nso007_delivery_order.id")
                ->selectRaw('nso007_delivery_order.id,nso007_delivery_order.delivery_date,items.*,
                        COUNT(( CASE WHEN items.status = 1 THEN items.status END )) AS processing,
                        COUNT(( CASE WHEN items.status = 2 THEN items.status END )) AS pending,
                        COUNT(( CASE WHEN items.status = 3 THEN items.status END )) AS success,
                        COUNT(( CASE WHEN items.status = 4 THEN items.status END )) AS cancel,
                        COUNT(( CASE WHEN items.status = 7 THEN items.status END )) AS return_to_shop,
                        GROUP_CONCAT(items.export_id) as item_export_id
                        '
                        )
                ->when($shop,function($q) use($shop){
                    $q->where('items.merchant_id',$shop);
                })
                ->groupBy(['nso007_delivery_order.delivery_date','items.merchant_id'])
                ->orderBy('nso007_delivery_order.delivery_date','DESC');
        if($request->ajax()){
                return DataTables::of($data)

                    ->addColumn('date_', function ($data ) {
                        return $data->delivery_date;
                    })
                    ->editColumn('clear_all', function ($data ) {
                        return '<input type="checkbox" class="sub" name="scales" data-date="'.$data->delivery_date.'" data-merchant_id="'.$data->merchant_id.'">';
                    })
                    ->editColumn('status', function ($data ){
                        return '
                        <button type="button" class="btn btn-primary">'.$data->processing.'</button>
                        <button type="button" class="btn btn-success">'.$data->success.'</button>
                        <button type="button" class="btn btn-warning"  style="margin-top:0px !important;">'.$data->pending.'</button>
                        <button type="button" class="btn btn-danger">'.$data->cancel.'</button>
                        <button type="button" class="btn btn-info">'.$data->return_to_shop.'</button>
                        ';
                    })
                    ->editColumn('action', function ($data )  {
                        $print = '';
                        $show = '';
                        $clear = '';
                        if(Gate::check('Print Shop Voucher')){
                            $print = '<a href="'.route('report-for-shop-new.print',$data->merchant_id.'?date='.$data->delivery_date) .'" class="button_primary">'.__('administrator.print').'</a>';
                        }
                        if(Gate::check('Show Shop Voucher')){
                            $show = '<a href="'.route('report-for-shop-new.show',$data->merchant_id.'?date='.$data->delivery_date) .'" class="button_primary">'.__('administrator.show').'</a>';
                        }
                        if(Gate::check('Clear Invoice Shop Voucher')){
                            $clear = '<a href="javascript:;" data-route="'.route('report-for-shop-new.print',$data->merchant_id.'?date='.$data->delivery_date) .'" class="button_primary bt-clear">'.__('administrator.clear_invoice').'</a>';
                        }
                        return $show.$print.$clear;
                    })
                    ->rawColumns(['action','status','clear_all','pay_to_shop'])
                    ->addIndexColumn()
                    ->make(true);

            }
            $shop = $data->pluck('merchant_id');
            $shop = User::whereIn('id',$shop)->pluck('shop_name','id');
            return view('administrator.report.shop-new.index',compact('shop'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,Request $request)
    {
        if ($request->ajax()) {
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   $id;
        $status         =   isset($request->status)?$request->status:null ;
        $data = DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.discount',
                    'nso007_discount.discount_type',
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order_detail.clear_box_by',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.amount_pay_to',
                    'nso007_delivery_order_detail.pay_to',
                    'nso007_delivery_order_detail.invoice_payment_id',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                )
                ->whereDate('nso007_delivery_order.delivery_date','=',$request->date)
                ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
                    if($from_date){
                        $query->whereDate('nso007_delivery_order.delivery_date','>=',$from_date) ;
                    }
                    if($to_date){
                        $query->whereDate('nso007_delivery_order.delivery_date','<=',$to_date);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                    }
                })
                ->where('nso007_delivery_order_detail.status_paid',null)
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->where('nso007_export_stock.merchant_id',$merchant)
                ->orderBy('nso007_export_stock.box_code','desc')
                ->get();
            return Datatables::of($data)
                    ->editColumn('pay_to_delivery', function ($data)  {
                        if ($data->pay_to == 'delivery'){
                            return    '$'.numberFormat( $data->amount_pay_to);
                        }else{
                            return    '';
                        }
                    })
                    ->editColumn('pay_to_shop', function ($data)  {
                        if ($data->pay_to == 'shop'){
                            return   '$'.numberFormat( $data->amount_pay_to);
                        }else{
                            return    '';
                        }
                    })
                    ->addColumn('clear_box_code',function($data){
                        if($data->clear_box_code){
                            return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                        }
                    })

                    ->addColumn('date', function ($data) {
                        return date('d-m-Y', strtotime($data->export_date)).' / '. date('d-m-Y', strtotime($data->delivery_date));
                    })
                    ->editColumn('check', function ($data)  {
                        return '<input type="checkbox" name="check" class="checkbox payment_" data-box_code="'.$data->box_code.'"  data-export_id="'.$data->id.'" >';
                    })
                    ->editColumn('total_dollar', function ($data)  {
                        if($data->status_detail != 3){
                            return '<samp>'.($data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '').'</samp>';
                        }else{
                            return $data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '';
                        }
                    })
                    ->editColumn('total_riel', function ($data)  {
                        if($data->status_detail != 3){
                            return '<samp>'.($data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '').'</samp>';
                        }else{
                            return $data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '';
                        }
                    })
                    ->editColumn('other_services_fee', function ($data)  {
                        $return_1 = '';
                        if($data->other_services_type == 1){
                             $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'s') : ''  ;
                        }
                        else if($data->other_services_type == 2){
                             $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'c') : ''  ;
                        }else{
                             $return_1 =   '';
                        }
                        if($data->status_detail != 3){
                            return '<samp>'.$return_1 .'</samp>';
                        }else{
                            return $return_1;
                        }
                    })

                    ->editColumn('taxi_fee', function ($data)  {
                        $return_ = '';
                        if($data->taxi_status == 1){
                            // $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : '';
                            $return_ = '$'.numberFormat( $data->taxi_fee).' s';
                            if($data->taxi_fee_symbol == '៛'){
                                $return_ = numberFormat( $data->taxi_fee).'៛ s';
                            }
                        }
                        else{
                            $return_ =   '';
                        }

                        if($data->status_detail != 3){
                            return '<samp>'.$return_ .'</samp>';
                        }else{
                            if($data->taxi_fee_symbol == '៛'){
                                return '<riel>'.$return_ .'</riel>';
                            }
                            return $return_;
                        }
                    })

                    ->editColumn('description', function ($data)  {
                        return ($data->description == null ? "" :  $data->description) ;
                    })

                    ->editColumn('reason', function ($data)  {
                        return ($data->detail_reason == null ? "" :  $data->detail_reason) .'' . ($data->driver_note == null ? "" :  $data->driver_note) ;
                    })
                    ->editColumn('status_view', function ($data)  {
                        if($data->status_detail == 1)  // 1 = Processing,
                                return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> '.__('administrator.processing').'</strong>';
                        else if($data->status_detail == 2)  // 2 = Padding,
                                return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> '.__('administrator.padding').' </strong>';
                            else if($data->status_detail == 3)  //  3 = Done ,
                            return ' <strong class="text-info"><span class="fa fa-check"></span>  '.__('administrator.done').' </strong>';
                        else if($data->status_detail == 4)  // 4 = Cancel
                            return ' <strong class="text-danger"><span class="fa fa-ban"></span>  '.__('administrator.cancel').'</strong>';
                        else if($data->status_detail == 7)  // 4 = Cancel
                            return ' <strong class="text-danger"><span class="fa fa-ban"></span>  '.__('administrator.return_to_shop').'</strong>';
                        else{
                            return ' <strong class="text-muted"><span class="fa fa-check"></span>  '.__('administrator.paid').'</strong>';
                        }
                    })

                    ->editColumn('status_paid', function ($data)  {
                        if($data->status_paid == 'paid'){
                            $paid = '<strong class="" style="color: #37c61a;"><span class=" fa fa-check"></span> '.__('administrator.paid').'</strong>';
                            }
                            else{
                            $paid = '';
                            }
                            return $paid;
                    })

                    ->editColumn('extra_fee', function ($data)  {

                        $return_ = '';
                        if($data->extra_fee_type == 1) {
                            $return_ =  '$'.numberFormat( $data->extra_fee)  . ' s'; }
                        else if($data->extra_fee_type == 2)   {
                            $return_ =  '$'.numberFormat( $data->extra_fee) . ' c';    }
                        else  {
                            $return_ = '';
                        }

                        if($data->status_detail != 3){
                            return '<samp>'.$return_ .'</samp>';
                        }else{
                            return $return_;
                        }


                    })

                    ->editColumn('total_price', function ($data)  {

                        if($data->status_detail != 3){
                            if($data->total_product_symbol == '៛'){
                                return '<samp>'. @numberFormat( $data->total_price)  .'៛</samp>';
                            }
                            return '<samp>'. '$'.@numberFormat( $data->total_price)  .'</samp>';
                        }else{
                            if($data->total_product_symbol == '៛'){
                                return '<riel>'. @numberFormat( $data->total_price)  .'៛</riel>';
                            }
                            return '$'.@numberFormat( $data->total_price);
                        }
                    })

                    ->addColumn('action', function ($data) {

                    })

                    ->editColumn('delivery_fee', function ($data)  {
                            $delivery_fee  = 0;
                            $dis = DiscountModel::find($data->discount_id);
                            if($dis)
                            {
                                if($data->discount_type == 1){
                                    $delivery_fee = $data->discount;
                                }
                                elseif($data->discount_type == 2){
                                    $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                                }
                                else{
                                    $delivery_fee =$data->delivery_fee;
                                }
                            }
                            else{
                                $delivery_fee  =  $data->delivery_fee;
                            }

                            if($data->delivery_status == 1){
                                if ($data->delivery_fee_symbol == '$') {
                                    $delivery_fee = '$'.numberFormat($delivery_fee) . ' s';
                                }
                                if($data->delivery_fee_symbol == '៛'){
                                    $delivery_fee = numberFormat( $delivery_fee) . '៛ s';;
                                }
                            }
                            else{
                                if ($data->delivery_fee_symbol == '$') {
                                    $delivery_fee = '$'.numberFormat($delivery_fee). ' c';
                                }
                                if($data->delivery_fee_symbol == '៛'){
                                    $delivery_fee = numberFormat( $delivery_fee) . '៛ c';;
                                }
                            }

                            if($data->delivery_pay_or_paid == 'paid'){
                                $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                            }

                            if($data->status_detail != 3){
                                return '<samp>'.$delivery_fee .'</samp>';
                            }else{
                                if($data->delivery_fee_symbol == "៛"){
                                    return '<riel>'.$delivery_fee .'</riel>';
                                }
                                return $delivery_fee;
                            }
                    })

                    ->rawColumns([ 'clear_box_code'=>"clear_box_code" ,'total_riel'=>'total_riel','total_dollar'=>'total_dollar','status_view' => 'status_view','status_paid'=>'status_paid','check'=>'check','delivery_fee'=>'delivery_fee','taxi_fee'=>'taxi_fee','extra_fee'=>'extra_fee','other_services_fee'=>'other_services_fee','total_price'=>'total_price'])
                    ->addIndexColumn()
                    ->make(true);

        }
         return view('administrator.report.shop-new.show',compact('id'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function print_detail($id,Request $request)
    {

            $shop_id = $id;
            $date = array_filter(explode(',',$request->date));
            // អីវ៉ាន់នៅសល់
            $not_success = \DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.discount',
                    'nso007_discount.discount_type',
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order_detail.clear_box_by',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.amount_pay_to',
                    'nso007_delivery_order_detail.pay_to',
                    'nso007_delivery_order_detail.invoice_payment_id',
                    'nso007_delivery_order.driver_name',
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee'),
                    \DB::raw('(CASE WHEN nso007_delivery_order_detail.status = "3" THEN 9 ELSE nso007_delivery_order_detail.status END) AS order_status')
                )
                ->whereIn('nso007_delivery_order_detail.status',[2,4])
                ->where('nso007_delivery_order_detail.status_paid',null)
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->where('nso007_export_stock.merchant_id',$id)
                ->orderBy('nso007_delivery_order.delivery_date','DESC');
            // data
            $data = \DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                            ->select(
                                'nso007_discount.discount',
                                'nso007_discount.discount_type',
                                'nso007_delivery_order_detail.delivery_order_id',
                                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                                'nso007_delivery_order_detail.clear_box_code',
                                'nso007_delivery_order.delivery_date',
                                'nso007_export_stock.*',
                                'nso007_export_stock.total_product AS total_price',
                                'nso007_delivery_order_detail.status AS status_detail',
                                'nso007_delivery_order_detail.status_paid',
                                'nso007_delivery_order_detail.reason AS detail_reason',
                                'nso007_delivery_order_detail.clear_box_by',
                                'nso007_delivery_order_detail.total_dollar',
                                'nso007_delivery_order_detail.total_riel',
                                'nso007_delivery_order_detail.amount_pay_to',
                                'nso007_delivery_order_detail.pay_to',
                                'nso007_delivery_order_detail.invoice_payment_id',
                                'nso007_delivery_order.driver_name',
                                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee'),
                                \DB::raw('(CASE WHEN nso007_delivery_order_detail.status = "3" THEN 9 ELSE nso007_delivery_order_detail.status END) AS order_status')
                            )
                            ->when($date,function($q) use($date){
                                $q->whereIn('nso007_delivery_order.delivery_date',$date);
                            })

                            ->where('nso007_delivery_order_detail.status_paid',null)
                            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                            ->where('nso007_export_stock.merchant_id',$id)
                            ->orderBy('order_status','DESC')
                            ->get();

                            //Clear Invoice
        $currency  = CurrencyModel::first();
        $invoice = '';
        $from_date  = empty  ($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date    = empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant   = isset($id)?$id:null;
        // dd( $merchant );
        $status     = isset($request->status)?$request->status:null ;
        $referance  = isset($request->referance)?$request->referance:null ;
        $ids = array(3,1,2,4);
        $ids_ordered = implode(',', $ids);
        $cus = User::find($merchant);
        $clear_invoice = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
                // ->where('nso007_export_stock.type_of_stock',2);
            if(\Globals::check_lang() == 'en'){
            $clear_invoice = $clear_invoice-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.description',
                    'nso007_export_stock.*',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
            }else{
                $clear_invoice = $clear_invoice-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name',
                    'nso007_export_stock.*',
                    'nso007_delivery_order_detail.status',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.description',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                );
            }
            $clear_invoice = $clear_invoice
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                if(!empty($from_date) && !empty($to_date)){
                    $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
                }
            })
            ->when(request('status'),function($query) use ($status){
                if(!empty($status)){
                    $status_1 ='';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key].',' ;
                    }
                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                }
            })
            ->where(function($query) use ($merchant){
                if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                    $query->where('merchant_id',\Auth::user()->id);
                }else if(\Globals::is_Driver() == 'Driver'){
                    $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
                }else{
                    $query->where('merchant_id','LIKE',$merchant);
            }
        })

        ->where('nso007_delivery_order_detail.status_paid',null)
        ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')

        ->orderByRaw("FIELD(nso007_delivery_order_detail.status, $ids_ordered)")


        ->get();

        $clear_invoice = $data;
        $package = [];
        $increas = '';
        if ($request->ajax()) {
            $id = '';
            if (empty($clear_invoice)) {
                return redirect()->back()->with('danger', 'Not Data');
            }
            $increas = '';
            $last_id =  DB::table('nso007_invoice_payment')->max('id');
            $inovice = DB::table('nso007_invoice_payment')->latest('id')->first();

            if ($inovice) {
                $tran_num = $inovice->invoice_payment;
                $tran_num =substr($tran_num, -6);
                $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
            } else {
                $increas = 'IV-'.date('ym').'000001';
            }
            $invoicepayment     =   new InvoicePaymentModel();
            $invoicepayment->invoice_payment    =   $increas;
            $invoicepayment->user_create        =   Auth::user()->id;
            $invoicepayment->date               =   date('Y-m-d');
            $invoicepayment->from_date          =   $from_date;
            $invoicepayment->to_date            =   $to_date ;
            $invoicepayment->shop_id            =   $merchant;

            $deliveryOrder=  DeliveryOrderModel::
                    join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                    ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                    ->select('nso007_delivery_order_detail.status', 'nso007_delivery_order_detail.export_id')
                    ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                        if (!empty($from_date) && !empty($to_date)) {
                            $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date,$to_date]);
                        }
                    })
                    ->when($date,function($q) use($date){
                        $q->whereIn('nso007_delivery_order.delivery_date',$date);
                    })
                ->where(function ($query) use ($merchant) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    } elseif (\Globals::is_Driver() == 'Driver') {
                        $query->where('nso007_delivery_order.driver_id', \Auth::user()->id);
                    } else {
                        $query->where('nso007_export_stock.merchant_id', 'LIKE', $merchant);
                    }
                })

                ->when(request('referance'), function ($query) use ($referance) {
                    if (!empty($referance)) {
                        $query->where('nso007_export_stock.referance', $referance);
                    }
                })
                ->whereIn('nso007_delivery_order_detail.status', [3,7])
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->whereNull('nso007_delivery_order_detail.status_paid');

            $deliveryOrder1  = $deliveryOrder;
            $deliveryOrder2  = $deliveryOrder->get();
            $id_ = '';
            if ($deliveryOrder1->count() != 0) {
                $invoicepayment->save();
                $id = $invoicepayment->id;
                $invoice        = $invoicepayment->invoice_payment;
                $deliveryOrder->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
                foreach ($deliveryOrder2 as $key => $value) {
                    $id_ .= $deliveryOrder2[$key]->export_id.',';
                }
                DeliveryOrderDetailCancelModel::WhereIn('nso007_delivery_order_detail_cancel.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_cancel.invoice_payment_id'=>$invoicepayment->id]);
                ;
                DeliveryOrderDetailSuccessModel::WhereIn('nso007_delivery_order_detail_success.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_success.invoice_payment_id'=>$invoicepayment->id]);
                // ;
            }
        }
        $box_in_stock = DB::table('nso007_export_stock')->where('merchant_id',$id)->where('status',1)->count();
        $last_date = $request->date;
            $shop = User::find($shop_id);
            $title_name = 'KL'.sprintf('%04d', ($shop->prefix_pdf)).'_'.($shop->facebook_page ? $shop->facebook_page : $shop->shop_name).'_'.date('d-m-Y');
            if($request->print_out){
                return view('administrator.report.shop-new.shop_detail1',compact('data','shop','title_name','last_date','box_in_stock','not_success'));
            }

        return view('administrator.report.shop-new.shop_detail1',compact('data','shop','title_name','last_date','box_in_stock','not_success'));
    }
    public function clear_multi(Request $request){
        if(count($request->obj)){
            try{
                DB::beginTransaction();
                foreach($request->obj as $val){
                        $data = \DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                            ->selectRaw("nso007_export_stock.id")
                            ->whereIn('nso007_delivery_order_detail.status',[3,7])
                            ->where('nso007_delivery_order.delivery_date',$val['date'])
                            ->where('nso007_delivery_order_detail.status_paid',null)
                            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                            ->where('nso007_export_stock.merchant_id',$val['merchant_id']);
                        if($data->count()){
                            $increas = '';
                            $inovice = DB::table('nso007_invoice_payment')->latest('id')->first();

                            if ($inovice) {
                                $tran_num = $inovice->invoice_payment;
                                $tran_num =substr($tran_num, -6);
                                $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
                            } else {
                                $increas = 'IV-'.date('ym').'000001';
                            }
                            $invoicepayment     =   new InvoicePaymentModel();
                            $invoicepayment->invoice_payment    =   $increas;
                            $invoicepayment->user_create        =   Auth::user()->id;
                            $invoicepayment->date               =   date('Y-m-d');
                            $invoicepayment->shop_id            =   $val['merchant_id'];
                            $invoicepayment->save();
                            foreach($data->cursor() as $key=>$clear){
                                DB::table("nso007_delivery_order_detail")->where("export_id",$clear->id)->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
                            }
                        }
                    }
                DB::commit();
                return response()->json(['status'=>200,'message'=>'Clear Successfully!']);
            }catch(Exception $e){
                DB::rollBack();
                return response()->json(['status'=>403,'message'=>$e->getMessage()]);
            }
        }
    }
    public function excel(Request $request){
        $per_page = $request->per_page??50;
        $shop_id = $request->shop_id;
        $data = DeliveryOrderModel::join(DB::raw("(SELECT
                    dod.status,dod.delivery_order_id,
                    exs.merchant_id,
                    exs.extra_fee_type,
                    exs.done_date,
                    users.shop_name,users.phone,dod.export_id,
                    users.bank_account,users.bank_account_kh,users.bank_name_kh,users.name as account_name
                FROM
                    nso007_delivery_order_detail as dod
                LEFT JOIN
                    nso007_export_stock as exs
                ON
                    exs.id = dod.export_id
                INNER JOIN
                    users
                ON
                    users.id = exs.merchant_id
                WHERE
                    dod.status_paid IS NULL
                AND
                    dod.invoice_payment_id IS NULL
                AND
                    dod.status = 3
                ) as items"),"items.delivery_order_id","nso007_delivery_order.id")
                ->selectRaw('nso007_delivery_order.id,nso007_delivery_order.delivery_date,items.*,
                        COUNT(( CASE WHEN items.status = 1 THEN items.status END )) AS processing,
                        COUNT(( CASE WHEN items.status = 2 THEN items.status END )) AS pending,
                        COUNT(( CASE WHEN items.status = 3 THEN items.status END )) AS success,
                        COUNT(( CASE WHEN items.status = 4 THEN items.status END )) AS cancel,
                        COUNT(( CASE WHEN items.status = 7 THEN items.status END )) AS return_to_shop,
                        GROUP_CONCAT(items.export_id) as item_export_id
                        '
                        )
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('items.merchant_id',$shop_id);
                })
                ->groupBy(['nso007_delivery_order.delivery_date','items.merchant_id'])
                ->orderBy('nso007_delivery_order.delivery_date','DESC');
        if(!$request->export_excel){
            return response()->json([
                'success'=>true,
                'view'=>view('administrator.report.shop-new.print-excel',compact('data'))->render()
            ]);
        }else{
            return Excel::download(new ShopVoucherExport($data), 'Report-'.date('d-m-Y').'.xlsx');
        }
    }
    public function excel_shop(Request $request){
        $per_page = $request->per_page??50;
        $shop_id = $request->shop_id;
        $data = ExportStockModel::join('users','users.id','nso007_export_stock.merchant_id')
                ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.export_id','nso007_export_stock.id')
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('nso007_export_stock.merchant_id',$shop_id);
                })
                ->whereNull('nso007_delivery_order_detail.status_paid')
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->where('nso007_delivery_order_detail.status',3)
                ->select(
                    DB::raw('SUM(nso007_delivery_order_detail.total_dollar) as total_dollar'),
                    DB::raw('SUM(nso007_export_stock.delivery_fee) as delivery_fee'),
                    DB::raw('SUM(nso007_export_stock.taxi_shop_fee) as taxi_shop_fee'),
                    DB::raw('SUM(nso007_export_stock.total_product) as total_product'),
                    DB::raw('SUM(nso007_delivery_order_detail.total_riel) as totals_riel'),
                    'nso007_export_stock.delivery_status',
                    'users.shop_name',
                    'nso007_export_stock.merchant_id'

                )
                ->groupBy(['nso007_export_stock.merchant_id'])
                ->orderBy('nso007_export_stock.merchant_id','ASC')->get();

        if(!$request->export_excel){
            return response()->json([
                'success'=>true,
                'view'=>view('administrator.report.shop-new.print-excel-shop',compact('data'))->render()
            ]);
        }else{
            return Excel::download(new ShopVoucherExportShop($data), 'Report-'.date('d-m-Y').'.xlsx');
        }
    }
    public function excel_qty(Request $request){
        $per_page = $request->per_page??50;
        $shop_id = $request->shop_id;

        $data = ExportStockModel::join('users','users.id','nso007_export_stock.merchant_id')
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('nso007_export_stock.merchant_id',$shop_id);
                })
//                ->whereNull('nso007_delivery_order_detail.status_paid')
//                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
//                ->whereNotIn('nso007_export_stock.id',$paid)
                ->whereIn('nso007_export_stock.status',[1,4,5])
                ->selectRaw('users.shop_name,
                            nso007_export_stock.merchant_id,
                            COUNT( CASE WHEN nso007_export_stock.status = 1 THEN nso007_export_stock.status END ) AS instock,
                            COUNT( CASE WHEN nso007_export_stock.status = 4 THEN nso007_export_stock.status END ) AS padding,
                            COUNT( CASE WHEN nso007_export_stock.status = 5 THEN nso007_export_stock.status END ) AS cancel
                            '
                )
                ->groupBy('nso007_export_stock.merchant_id')
                ->orderBy('nso007_export_stock.merchant_id','ASC');

        if(!$request->export_excel){
            return response()->json([
                'success'=>true,
                'view'=>view('administrator.report.shop-new.print-excel-qty',compact('data'))->render()
            ]);
        }else{
            return Excel::download(new ShopVoucherExportQty($data), 'Report-'.date('d-m-Y').'.xlsx');
        }
    }
}
