<?php

namespace App\Http\Controllers\Administrator;

use App\Exports\ShopBoxExport;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class ReportShopLastController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->export){
            $from_date = $request->from_date;
            $to_date = $request->to_date;
            $shop_id = $request->shop_id;
            return Excel::download(new ShopBoxExport($from_date,$to_date,$shop_id), 'shop_package.xlsx');
        }
        if ($request->ajax()) {
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $shop_id = $request->shop_id;

            $data = ExportStockModel::join('users as shop', 'shop.id', 'nso007_export_stock.merchant_id')
                ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                    $q->whereBetween(DB::raw("DATE_FORMAT(nso007_export_stock.done_date,'%Y-%m-%d')"), [$from_date, $to_date]);
                })
                ->selectRaw('nso007_export_stock.done_date,nso007_export_stock.merchant_id,shop.shop_name,COUNT(nso007_export_stock.id) as total_box')
                ->where('nso007_export_stock.status', 3)
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('nso007_export_stock.merchant_id',$shop_id);
                })
                ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
//                    $q->where('staff_id',Auth::user()->id);
                })
                ->groupBy([DB::raw("DATE_FORMAT(nso007_export_stock.done_date, '%Y %m')"), 'nso007_export_stock.merchant_id'])
                ->orderBy('nso007_export_stock.done_date','DESC');
//            dd($data);
            $rows = view('administrator.shop-report.shop-box-data', compact('data','from_date','to_date'))->render();


            return response()->json(['success' => true, 'data' => $rows]);
        }
        $shop = $merchant = User::where('user_type', 3)->whereIn('status', [1,2])
            ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
//                $q->where('staff_id',Auth::user()->id);
            })
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        return view('administrator.shop-report.shop-box', compact('shop'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
