<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderModel;
use App\Exports\ShopRevenueExport;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class ReportShopIncomeController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->export){
            $from_date = $request->from_date;
            $to_date = $request->to_date;
            $shop_id = $request->shop_id;
            return Excel::download(new ShopRevenueExport($from_date,$to_date,$shop_id), 'shop_revenue.xlsx');
        }
        if ($request->ajax()) {
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $shop_id = $request->shop_id;
            $data = ExportStockModel::where('nso007_export_stock.status', 3)
                ->join(DB::raw('(select id,shop_name as shop_name,staff_id from users) as shop'), 'shop.id', 'nso007_export_stock.merchant_id')
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date && $to_date) {
                        $q->whereBetween(DB::raw("DATE_FORMAT(nso007_export_stock.done_date,'%Y-%m-%d')"), [$from_date, $to_date]);
                    }
                })
                ->select(
                    'nso007_export_stock.*',
                    'shop.shop_name',
                    DB::raw('COUNT(nso007_export_stock.id) as total_box'),
                    DB::raw('sum(nso007_export_stock.delivery_fee/nso007_export_stock.delivery_fee_rate) as total_delivery')
                )
                ->when($shop_id,function($q) use($shop_id){
                    $q->where('nso007_export_stock.merchant_id',$shop_id);
                })
                ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
//                    $q->where('staff_id',Auth::user()->id);
                })
                ->groupBy([DB::raw("DATE_FORMAT(done_date, '%Y %m')"), 'merchant_id'])
                ->orderBy("done_date","DESC");
            $rows = view('administrator.shop-report.shop-income-data', compact('data','from_date','to_date'))->render();
            return response()->json(['success' => true, 'data' => $rows]);
        }
        $shop = $merchant = User::where('user_type', 3)->whereIn('status', [1,2])
            ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
//                $q->where('staff_id',Auth::user()->id);
            })
            ->pluck('shop_name', 'id')
            ->prepend(__('administrator.shop_name'), '')->toArray();
        return view('administrator.shop-report.shop-income',compact('shop'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
