<?php

namespace App\Http\Controllers\Administrator;

use App\CategoryModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailSuccessModel;
use App\InvoicePaymentModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use DB;
use App\CurrencyModel;
use PDO;
use Gate;
use Yajra\DataTables\Facades\DataTables;

class ReportShopController extends Controller
{
    public function index(Request $request)
    {
        
        if($request->ajax()){
        //1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel  ,5= paid
            $ids = array(3,1,2,4); 
            $ids_ordered = implode(',', $ids);
            $shup = User::where('user_type',3)->get();
            $data = DB::table('nso007_delivery_order_detail')
            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
            ->select(
                'nso007_delivery_order.delivery_date',
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_export_stock.*',
                \DB::raw("COUNT(( CASE WHEN nso007_delivery_order_detail.status = 1 THEN nso007_delivery_order_detail.status END )) AS processing"),
                \DB::raw("COUNT(( CASE WHEN nso007_delivery_order_detail.status = 2 THEN nso007_delivery_order_detail.status END )) AS pending"), 
                \DB::raw("COUNT(( CASE WHEN nso007_delivery_order_detail.status = 3 THEN nso007_delivery_order_detail.status END )) AS success"),
                \DB::raw("COUNT(( CASE WHEN nso007_delivery_order_detail.status = 4 THEN nso007_delivery_order_detail.status END )) AS cancel"),
            )  
            ->whereNull('nso007_delivery_order_detail.status_paid')
            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
            ->groupBy('nso007_export_stock.merchant_id')
            // ->groupBy('nso007_delivery_order.delivery_date')
            // ->orderBy("nso007_delivery_order.delivery_date",'DESC') ;
            ->orderByRaw("FIELD(nso007_delivery_order_detail.status, $ids_ordered)") ;
            return DataTables::of($data)
                ->addColumn('date_', function ($data )   use ($ids_ordered) {
                    return $data->delivery_date;
                    // $ddd =  DB::table('nso007_delivery_order_detail')
                    //             ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                    //             ->where('nso007_delivery_order_detail.status',3)
                    //             ->where('nso007_export_stock.merchant_id',$data->merchant_id)
                    //             ->whereNull('nso007_delivery_order_detail.status_paid')
                    //             ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                    //             ->select(\DB::raw('concat( DATE_FORMAT(MIN(nso007_export_stock.export_date), "%d-%m-%Y")," / ",DATE_FORMAT(MAX(nso007_export_stock.export_date), "%d-%m-%Y")) new_date'))
                    //             ->first(); 
                    // return $ddd->new_date;

                })
              
                ->editColumn('phone', function ($data ) use($shup)  {
                    return $shup->find($data->merchant_id)->phone;

                })
                
                ->editColumn('status', function ($data ) use($shup)  {
                    // return  'Done('. $data->success .') / '.'Pending(' .$data->pending . ') / '.'Cancel(' .$data->cancel . ') /'.'Paid(' .$data->paid . ') ';

                    return '<button type="button" class="btn btn-primary">'.$data->processing.'</button>
                    <button type="button" class="btn btn-success">'.$data->success.'</button>
                    <button type="button" class="btn btn-warning"  style="margin-top:0px !important;">'.$data->pending.'</button>
                    <button type="button" class="btn btn-danger">'.$data->cancel.'</button>    
                    ​';
                    return $data->success;
                })
                ->editColumn('action', function ($data )  {   
                    return '
                        <a href="'.route('report-for-shop.show',$data->merchant_id) .'" class="button_primary bt-print">'.__('administrator.show').'</a>
                        <a href="'.route('report-for-shop.print',$data->merchant_id) .'" class="button_primary bt-print">'.__('administrator.print').'</a>
                        '  ;
                })

                ->rawColumns(['action'=>'action','status'=>'status'])
                ->addIndexColumn()
                ->make(true);
        }
         
        return view('administrator.report.shop.index');
    }
 
    public function create()
    {
        //
    }

   
    public function store(Request $request)
    {
        //
    }

    
    public function show($id)
    {       
        return view('administrator.report.shop.show',compact('id'));
        
    }
    public function print( Request $request,$type)
    {      
        // dd($request->all());  
        $ids = array(3,1,2,4); 
        $ids_ordered = implode(',', $ids);
        $id = '';
        $invoice = '';
        $currency  = CurrencyModel::first();
        $cus = User::find($request->merchant_id);
        $data = DeliveryOrderModel::
            join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
        if(\Globals::check_lang() == 'en'){
        $data = $data-> select(
                'nso007_export_stock.discount_id',
                'nso007_export_stock.location_name AS name_location',
                'nso007_export_stock.description',
                'nso007_export_stock.*',
                'nso007_export_stock.id As export_detail_id',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'nso007_export_stock_details.category_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                ELSE nso007_export_stock.taxi_shop_fee
                END) AS taxi_fee')
        );
        }else{
            $data = $data-> select(
                'nso007_export_stock.discount_id',
                'nso007_export_stock.location_name',
                'nso007_export_stock.*',
                'nso007_delivery_order_detail.status',
                'nso007_export_stock.id As export_detail_id',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_export_stock.description',
                'nso007_delivery_order.delivery_date',
                'nso007_delivery_order_detail.*',
                'nso007_export_stock_details.category_name',
                'nso007_export_stock_details.currency',
                DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                ELSE nso007_export_stock.taxi_shop_fee
                END) AS taxi_fee')
            );
        }
        $data = $data
    
        ->whereIn('nso007_delivery_order_detail.export_id',explode(',', $request->export_id))  
        ->where('nso007_delivery_order_detail.status_paid',null)
        ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
        // ->orderBy('nso007_delivery_order.inovice','desc')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->orderByRaw("FIELD(nso007_delivery_order_detail.status, $ids_ordered)")

        ->get();
        $package = [];
        $increas = ''; 
        if ($type ==2) { 
            if(empty($data->first())){
                return redirect()->back()->with('danger','Not Data');
            }
            $increas = '';
            $last_id =  DB::table('nso007_invoice_payment')->max('id');
            $inovice = DB::table('nso007_invoice_payment')->latest('id')->first();
            
            if ($inovice) {
                $tran_num = $inovice->invoice_payment;
                $tran_num =substr($tran_num, -6);
                $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
            } else {
                $increas = 'IV-'.date('ym').'000001';
            }
            $invoicepayment     =   new InvoicePaymentModel();
            $invoicepayment->invoice_payment    =   $increas;
            $invoicepayment->user_create        =   \Auth::user()->id;
            $invoicepayment->date               =   date('Y-m-d');
            $invoicepayment->from_date          =   date('Y-m-d');
            $invoicepayment->to_date            =   date('Y-m-d');
            $invoicepayment->shop_id            =   $request->merchant_id ;

            $deliveryOrder=  DeliveryOrderModel::
                join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->select('nso007_delivery_order_detail.status', 'nso007_delivery_order_detail.export_id')
                ->where(function ($query) {
                    $query->whereIn('nso007_delivery_order_detail.status', [3,4] );
                })
                ->whereIn('nso007_delivery_order_detail.export_id',explode(',', $request->export_id))  
                ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                ->whereNull('nso007_delivery_order_detail.status_paid');

            $deliveryOrder1  = $deliveryOrder;
            $deliveryOrder2  = $deliveryOrder->get();

            $id_ = '';
            if ($deliveryOrder1->count() != 0) {
                $invoicepayment->save();
                $id = $invoicepayment->id;
                $invoice        = $invoicepayment->invoice_payment;
                $deliveryOrder->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
                foreach ($deliveryOrder2 as $key => $value) {
                    $id_ .= $deliveryOrder2[$key]->export_id.',';
                }
                DeliveryOrderDetailCancelModel::WhereIn('nso007_delivery_order_detail_cancel.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_cancel.invoice_payment_id'=>$invoicepayment->id]);
                ;
                DeliveryOrderDetailSuccessModel::WhereIn('nso007_delivery_order_detail_success.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_success.invoice_payment_id'=>$invoicepayment->id]);
                ;
            }
        }

        $to_date = '';
        $from_date = ''; 

        $package = [] ;
        return  view('administrator.report.report_for_shop_print',compact('data','from_date','to_date','invoice','currency','package','cus','id'))->render();


    }




    public function datatable(Request $request){
        if($request->type =='Payment'){
            return  $this->Payment( $request , '');
        }
    }
    

    public function Payment( $request , $id)
    {
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        // $count_total = ProductModel::with('category', 'brand', 'detail')->where(['nso007_products.status' => 1])
        // ->count();
            $data = DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
                            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                            ->select(
                                'nso007_discount.discount',
                                'nso007_discount.discount_type',
                                'nso007_delivery_order_detail.delivery_order_id',
                                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                                'nso007_delivery_order_detail.clear_box_code',
                                'nso007_delivery_order.delivery_date',
                                'nso007_export_stock.*',
                                'nso007_export_stock.total_product AS total_price',
                                'nso007_delivery_order_detail.status AS status_detail',
                                'nso007_delivery_order_detail.status_paid',
                                'nso007_delivery_order_detail.reason AS detail_reason', 
                                'nso007_delivery_order_detail.clear_box_by',
                                'nso007_delivery_order_detail.total_dollar',
                                'nso007_delivery_order_detail.total_riel',
                                'nso007_delivery_order_detail.amount_pay_to',
                                'nso007_delivery_order_detail.pay_to',
                                'nso007_delivery_order_detail.invoice_payment_id',
                                'nso007_delivery_order.driver_name',
                                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
                            )

                            ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
                                if($from_date){
                                    $query->whereDate('nso007_delivery_order.delivery_date','>=',$from_date) ;
                                }
                                if($to_date){
                                    $query->whereDate('nso007_delivery_order.delivery_date','<=',$to_date);
                                }
                            })
                       
                            ->when(request('status'),function($query) use ($status){
                                if(!empty($status)){
                                    $status_1 ='';
                                    foreach ($status as $key => $value) {
                                        $status_1  .= $status[$key].',' ;
                                    }
                                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                                }
                            })
                            ->where('nso007_delivery_order_detail.status_paid',null)
                            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                            ->where('nso007_export_stock.merchant_id',$merchant)
                            ->orderBy('nso007_export_stock.box_code','desc');
            return Datatables::of($data)
                            
                    ->editColumn('pay_to_delivery', function ($data)  {
                        if ($data->pay_to == 'delivery'){
                            return    '$'.numberFormat( $data->amount_pay_to); 
                        }else{
                            return    '';
                        }
                    })

                    ->editColumn('pay_to_shop', function ($data)  {
                        if ($data->pay_to == 'shop'){
                            return   '$'.numberFormat( $data->amount_pay_to); 
                        }else{
                            return    '';
                        }
                    })
                    

                    ->addColumn('clear_box_code',function($data){
                        
                        if($data->clear_box_code){
                            return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                        }
                    })

                    ->addColumn('date', function ($data) {
                        return date('d-m-Y', strtotime($data->export_date)).' / '. date('d-m-Y', strtotime($data->delivery_date));
                    })

                    ->editColumn('check', function ($data)  {
                        return '<input type="checkbox" name="check" class="checkbox payment_" data-box_code="'.$data->box_code.'"  data-export_id="'.$data->id.'" >';
                    })

                    ->editColumn('total_dollar', function ($data)  { 
                        if($data->status_detail != 3){ 
                            return '<samp>'.($data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '').'</samp>';
                        }else{
                            return $data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '';
                        } 
                    })

                    ->editColumn('total_riel', function ($data)  { 
                        if($data->status_detail != 3){ 
                            return '<samp>'.($data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '').'</samp>';
                        }else{
                            return $data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '';
                        } 
                    })
                    
                    ->editColumn('other_services_fee', function ($data)  {
                        $return_1 = '';


                        if($data->other_services_type == 1){
                             $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'s') : ''  ;
                        }
                        else if($data->other_services_type == 2){ 
                             $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'c') : ''  ;
                        }else{
                             $return_1 =   '';                        
                        }


                        if($data->status_detail != 3){ 
                            return '<samp>'.$return_1 .'</samp>';
                        }else{
                            return $return_1;
                        }

                    })

                    ->editColumn('taxi_fee', function ($data)  {

                        $return_ = '';
                        if($data->taxi_status == 1){
                            $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : ''; 

                        }
                        else{
                            $return_ =   '';                        
                        }

                        if($data->status_detail != 3){ 
                            return '<samp>'.$return_ .'</samp>';
                        }else{
                            return $return_;
                        }
 
                    })

                    ->editColumn('description', function ($data)  {
                        return ($data->description == null ? "" :  $data->description) ;
                    })


                    ->editColumn('reason', function ($data)  {
                        return ($data->detail_reason == null ? "" :  $data->detail_reason) .'' . ($data->driver_note == null ? "" :  $data->driver_note) ;
                    })

                    ->editColumn('status_view', function ($data)  {
                        if($data->status_detail == 1)  // 1 = Processing,
                                return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> '.__('administrator.processing').'</strong>';
                        else if($data->status_detail == 2)  // 2 = Padding,
                                return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> '.__('administrator.padding').' </strong>';
                            else if($data->status_detail == 3)  //  3 = Done ,
                            return ' <strong class="text-info"><span class="fa fa-check"></span>  '.__('administrator.done').' </strong>';
                        else if($data->status_detail == 4)  // 4 = Cancel
                            return ' <strong class="text-danger"><span class="fa fa-ban"></span>  '.__('administrator.cancel').'</strong>';
                        else{
                            return ' <strong class="text-muted"><span class="fa fa-check"></span>  '.__('administrator.paid').'</strong>';
                        }
                    })

                    ->editColumn('status_paid', function ($data)  {
                        if($data->status_paid == 'paid'){
                            $paid = '<strong class="" style="color: #37c61a;"><span class=" fa fa-check"></span> '.__('administrator.paid').'</strong>';
                            }
                            else{
                            $paid = '';
                            }
                            return $paid;
                    })

                    ->editColumn('extra_fee', function ($data)  {

                        $return_ = '';
                        if($data->extra_fee_type == 1) {
                            $return_ =  '$'.numberFormat( $data->extra_fee)  . ' s'; }
                        else if($data->extra_fee_type == 2)   {
                            $return_ =  '$'.numberFormat( $data->extra_fee) . ' c';    }
                        else  {
                            $return_ = ''; 
                        }

                        if($data->status_detail != 3){ 
                            return '<samp>'.$return_ .'</samp>';
                        }else{
                            return $return_;
                        }


                    })

                    ->editColumn('total_price', function ($data)  {

                        if($data->status_detail != 3){ 
                            return '<samp>'. '$'.numberFormat( $data->total_price)  .'</samp>';
                        }else{
                            return '$'.numberFormat( $data->total_price);
                        }
                    })

                    ->addColumn('action', function ($data) {
                        if($data->discount_type != null || $data->discount_type != '')
                        {
                            if($data->discount_type == 1){
                                $delivery_fee = $data->discount;
                            }
                            elseif($data->discount_type == 2){
                                $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                            }
                            else{
                                $delivery_fee = $data->delivery_fee;
                            }
                        }
                        else{
                            $delivery_fee  =  $data->delivery_fee;
                        }
    
                        if($data->delivery_pay_or_paid == 'paid'){
                            $delivery_fee  =  0;
                        }
    
                        $other_services_fee =  0;
                        if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                            $other_services_fee = $data->other_services_fee ;
                        }
    
                        $edit = '';
                        if($data->status_detail == 3 && Gate::check('Report Driver Edit'))
                            { 
                                // data-price ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                                // data-href="' . route("driver.edit_price", $data->id) . '" class="button_primary fa fa-edit bt-edit"></a>';
                                $edit = '<a  
                                        data-href="' . route("driver.edit_price", $data->id) . '" 
                                        data-price                  ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                                        data-delivery_option        ="'.$data->delivery_option.'"​​ 
                                        data-taxi_status            ="'.$data->taxi_status.'"
                                        data-taxi_shop_fee          ="'.$data->taxi_shop_fee.'"
                                        data-taxi_cust_fee          ="'.$data->taxi_cust_fee.'"​​
                                        data-taxi_number            ="'.$data->taxi_number.'"
                                        data-total_riel             ="'.$data->total_riel.'"
                                        data-total_dollar           ="'.$data->total_dollar.'"​​
                                        data-extra_fee              ="'.$data->extra_fee.'"​​
                                        data-extra_fee_type         ="'.$data->extra_fee_type.'"​​
                                        data-driver_note            ="'.$data->driver_note.'"​​
                                        data-user_currency          ="'.(User::find($data->merchant_id)->user_currency).'"​​

                                        data-delivery_status          ="'.$data->delivery_status.'"​​
                                        data-delivery_fee          ="'.$data->delivery_fee.'"​​

                                        data-amount_pay_to          ="'.$data->amount_pay_to.'"​​
                                        data-pay_to                 ="'.$data->pay_to.'"  class="button_primary fa fa-edit bt-edit"></a>';


                            }
                        $delete = '';
                            $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                        if(!$data->invoice_payment_id){
                            return $delete .''.$edit ;
                        }
                    })
                    
                    ->editColumn('delivery_fee', function ($data)  {
                            $delivery_fee  = 0;
                            $dis = DiscountModel::find($data->discount_id);
                            if($dis)
                            {
                                if($data->discount_type == 1){
                                    $delivery_fee = $data->discount;
                                }
                                elseif($data->discount_type == 2){
                                    $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                                }
                                else{
                                    $delivery_fee =$data->delivery_fee;
                                }
                            }
                            else{
                                $delivery_fee  =  $data->delivery_fee;
                            }

                            if($data->delivery_status == 1){
                                $delivery_fee = '$'.numberFormat( $delivery_fee) . ' s';;
                            }
                            else{
                                $delivery_fee = '$'.numberFormat( $delivery_fee). ' c';;
                            }

                            if($data->delivery_pay_or_paid == 'paid'){
                                $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                            } 

                            if($data->status_detail != 3){ 
                                return '<samp>'.$delivery_fee .'</samp>';
                            }else{
                                return $delivery_fee;
                            } 
                    })
                        
                    ->rawColumns([ 'clear_box_code'=>"clear_box_code" ,'total_riel'=>'total_riel','total_dollar'=>'total_dollar','status_view' => 'status_view','status_paid'=>'status_paid','check'=>'check','delivery_fee'=>'delivery_fee','taxi_fee'=>'taxi_fee','extra_fee'=>'extra_fee','other_services_fee'=>'other_services_fee','total_price'=>'total_price'])
                    ->addIndexColumn()
                    ->make(true);

    }

 
    public function edit($id)
    {
        //
    }

    
    public function update($id)
    {
    }
    public function print_detail($id)
    {
        // $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        // $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        // $merchant       =   isset($request->merchant)?$request->merchant:null;
        // $status         =   isset($request->status)?$request->status:null ;
            $data = \DB::table('nso007_delivery_order_detail')
                            ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
                            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
                            ->select(
                                'nso007_discount.discount',
                                'nso007_discount.discount_type',
                                'nso007_delivery_order_detail.delivery_order_id',
                                'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                                'nso007_delivery_order_detail.clear_box_code',
                                'nso007_delivery_order.delivery_date',
                                'nso007_export_stock.*',
                                'nso007_export_stock.total_product AS total_price',
                                'nso007_delivery_order_detail.status AS status_detail',
                                'nso007_delivery_order_detail.status_paid',
                                'nso007_delivery_order_detail.reason AS detail_reason', 
                                'nso007_delivery_order_detail.clear_box_by',
                                'nso007_delivery_order_detail.total_dollar',
                                'nso007_delivery_order_detail.total_riel',
                                'nso007_delivery_order_detail.amount_pay_to',
                                'nso007_delivery_order_detail.pay_to',
                                'nso007_delivery_order_detail.invoice_payment_id',
                                'nso007_delivery_order.driver_name',
                                \DB::raw('(CASE
                                WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                                WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                                ELSE nso007_export_stock.taxi_shop_fee
                                END) AS taxi_fee')
                            )
                            // ->orderBy(\DB::raw("`nso007_delivery_order_detail.total_dollar` + `nso007_delivery_order_detail.total_riel`"), 'desc')

                            // ->when(request('from_date','to_date'), function($query) use($from_date,$to_date){
                            //     if($from_date){
                            //         $query->whereDate('nso007_delivery_order.delivery_date','>=',$from_date) ;
                            //     }
                            //     if($to_date){
                            //         $query->whereDate('nso007_delivery_order.delivery_date','<=',$to_date);
                            //     }
                            // })
                       
                            // ->when(request('status'),function($query) use ($status){
                            //     if(!empty($status)){
                            //         $status_1 ='';
                            //         foreach ($status as $key => $value) {
                            //             $status_1  .= $status[$key].',' ;
                            //         }
                            //         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                            //     }
                            // })
                            ->where('nso007_delivery_order_detail.status_paid',null)
                            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
                            ->where('nso007_export_stock.merchant_id',$id)
                            ->orderBy('nso007_delivery_order_detail.total_dollar','DESC')
                            ->orderBy('nso007_delivery_order_detail.total_riel','DESC')
                            ->orderBy('nso007_delivery_order_detail.amount_pay_to','DESC')
                            // ->orderBy(\DB::raw("SUM('nso007_delivery_order_detail.total_dollar'))",'desc')
                            ->get();
                            // dd($data);
                    return view('administrator.report.shop.shop_detail',compact('data'));

    }
    public function report_shop(Request $request){
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $status = $request->status;
        $verify = $request->verify;
     
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));

        if ($request->ajax()) {
            $shop_id       =   isset($request->shop_id)?$request->shop_id:null;
            $data = DeliveryOrderDetailModel::join('nso007_invoice_payment','nso007_invoice_payment.id','nso007_delivery_order_detail.invoice_payment_id')
            ->join('users','users.id','nso007_invoice_payment.user_create')

            ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
            ->select('nso007_invoice_payment.*','users.name')
            ->where(function($query) use ($shop_id){
                if($shop_id){
                    $query->where('shop_id','LIKE',$shop_id);
                }
            })

            ->when($from_date,function($q , $from_date){
                $q->where('date','>=',$from_date);
            } )

            ->when($to_date,function($q , $to_date){
                $q->where('date','<=',$to_date);
            } )

            
            ->when($verify,function($q , $verify){
                if($verify == 'verify'){
                    $q->whereNotNull('nso007_invoice_payment.verify_by') ;
                }else{
                    $q->whereNull('nso007_invoice_payment.verify_by' ) ;
                }
            } )
            
            ->where(function($query) use ($status){
                if($status  == 'pay'){
                    $query->whereNull('nso007_invoice_payment.status');
                }else{
                    $query->where('nso007_invoice_payment.status','paid');
                }
            })
            ->groupBy('nso007_delivery_order_detail.invoice_payment_id')
            ->where('nso007_export_stock.type_of_stock',2)
            ->orderBy('nso007_invoice_payment.id','desc')
            ->get();
            return  DataTables::of($data)
            ->editColumn('date', function($data) {
                return date('d-m-Y',strtotime($data->date));
            })

            ->editColumn('paid_date', function($data) {
                return  $data->paid_date ? date('d-m-Y H:iA',strtotime($data->paid_date)) : '';
            })

            ->editColumn('paid_by', function($data) {
                return  $data->paid_by ? ($data->paid_by) : '';
            })
       
            ->editColumn('pay_amount', function($data) {
                $data1 = DB::table('nso007_delivery_order_detail')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                -> select(
                        'nso007_export_stock.discount_id',
                        'nso007_export_stock.location_name AS name_location',
                        'nso007_export_stock.description',
                        'nso007_export_stock.*',
                        'nso007_export_stock.total_product AS total_price',
                        'nso007_export_stock.id As export_detail_id',
                        'nso007_delivery_order_detail.status',
                        'nso007_delivery_order_detail.reason',
                        'nso007_delivery_order_detail.*',
                        'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                        \DB::raw('(CASE
                        WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                        WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                        ELSE nso007_export_stock.taxi_shop_fee
                        END) AS taxi_fee')
                )
                ->where('nso007_delivery_order_detail.invoice_payment_id',$data->id)
                ->get();
                // return $data->count();
                // return $data1->first()->total_dollar;

                $other_services_fee             = 0;
                $total_aba_to_delivery          = 0;
                $total_aba_to_shop              = 0;
                $total_riel                     = 0;
                $total_dollar                   = 0;
                $សេវាកម្មដឹកជញ្ជូនសរុប                 = 0;
                $ចេញថ្លៃឡាន                       = 0;
                $សេវារៀបចំ                        = 0;
                $total_product                  = 0;
                $total_discount                 =  0;

                foreach ($data1 as $key => $value) {
                    //////////////// Delivery Fee ////////////////////
                    $delivery_fee   = 0;
                    $discount = 0;
                    if( $value->discount_id != null)
                    {
                        $dis = DB::table('nso007_discount')->find($value->discount_id);
                        if($dis->discount_type == 1){
                            $delivery_fee = $dis->discount;
                        }
                        elseif($dis->discount_type == 2){
                            $delivery_fee = ( (100 - $dis->discount )* $value->delivery_fee / $value->delivery_fee_rate ) / 100;
                        }
                        else{
                            $delivery_fee =$value->delivery_fee;

                            if($value->delivery_status == 1){
                                $discount = ($dis->discount/100)*($value->delivery_fee / $value->delivery_fee_rate);

                            }
                            else{
                                $discount = 0;
                            }
                            /* echo $discount; */
                        }
                    }
                    else{
                        $delivery_fee  =  $value->delivery_fee / $value->delivery_fee_rate;
                    }

                    if($value->delivery_pay_or_paid == '2'){
                        $delivery_fee  = 0;
                    } 
                    //////////////// Extra Fee ////////////////////

                    if($value->extra_fee_type == 1) {
                        $extra_fee_shop = $value->extra_fee ;
                        $extra_fee_cus  = 0 ;
                    }else if($value->extra_fee_type == 2)   {
                        $extra_fee_shop = 0;
                        $extra_fee_cus  = $value->extra_fee ;
                    }else  {
                        $extra_fee_shop = 0;
                        $extra_fee_cus = 0;
                    }

                    //////////////// Taxi Fee ////////////////////


                    if($value->taxi_status == 1){
                        $taxi_fee_shop 	=   $value->taxi_fee / $value->taxi_fee_rate ;
                        if ($value->taxi_pay_or_paid == '2') {
                            $taxi_fee_shop = 0;
                        }
                    } else if($value->taxi_status == 2){
                        $taxi_fee_shop =  0  ; 
                    }
                    else{
                        $taxi_fee_shop =  0  ;
                    }
                    
                    //////////////// Other Services  ////////////////////

                    if($value->other_services_pay_or_paid == 'pay'){
                        $other_services_fee				   += $value->other_services_fee;
                    }

                    if( $value->status == 3 ){
                        if ($value->pay_to == 'delivery'){
                            $total_aba_to_delivery              +=   $value->amount_pay_to;
                        }
                        if ($value->pay_to == 'shop'){
                            $total_aba_to_shop              +=   $value->amount_pay_to;
                        }

                        // $totalPaid  +=  $Paid;
                        $total_riel                   +=  $value->total_riel;
                        $total_dollar                 +=  $value->total_dollar;
                        $សេវាកម្មដឹកជញ្ជូនសរុប               +=  $delivery_fee  + $extra_fee_cus  + $extra_fee_shop;
                        $ចេញថ្លៃឡាន                     += $taxi_fee_shop ;
                        $សេវារៀបចំ                      +=   $value->service_charge ;
                        $total_product                += $value->total_price ;
                        /* $service_charge				   += $value->service_charge; */
                        $total_discount += $discount;
                    }
                }
                $rate = $data1->first()->rate ? $data1->first()->rate : 4000;
                $total_all_service = $សេវាកម្មដឹកជញ្ជូនសរុប  + $សេវារៀបចំ   + $ចេញថ្លៃឡាន  + $other_services_fee + $total_discount;
                $substrack_total_receice_riel = (($total_riel / $rate) - $total_all_service) * $rate;
                if($substrack_total_receice_riel <= 0){
                    $total_dollar += ($substrack_total_receice_riel / $rate);
                }
                // $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel / $rate : 0;
                $test = $substrack_total_receice_riel > 0 ? $substrack_total_receice_riel : 0;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($total_dollar,2).' ឬ '.number_format(round( $test, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
                return '$'. number_format($total_dollar + $test,2);
                $​តម្លៃផ្ទេរអោយហាងសរុប  = ( $total_dollar + $total_aba_to_delivery)  -  $សេវាកម្មដឹកជញ្ជូនសរុប  - $សេវារៀបចំ   - $ចេញថ្លៃឡាន  - $other_services_fee + $total_discount;
                return '<p><span style="font-size: 15px;"  class="text-danger">'.'$'.number_format($​តម្លៃផ្ទេរអោយហាងសរុប,2).' ឬ '.number_format(round( $total_riel, -2,PHP_ROUND_HALF_ODD) ,0).'៛' .'</span></p>';
            })

            ->addColumn('verify_by1', function ($data) {

                if($data->verify_by){
                    return      $data->verify_by; 
                }
                return      '<span class="class_'.$data->id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("clear-invoice.update",$data->id) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
            })


            ->addColumn('shop', function($data) {

                if($data->shop_id == null){
                    return '';
                }
                $shop = User::find($data->shop_id);
                $data->bank_account = $shop->bank_account;
                return $shop->shop_name;
            })
            ->addColumn('bank_account', function($data) {
                return $data->bank_account ;
            })
            ->addColumn('action', function($data) {
                $edit ='<a href="'. route("clear-invoice-new.show", $data->id) . '" class="btn_sm button_primary">'.__('administrator.show' ).'</a> ';
                // if($data->status !== 'paid'){
                //     $edit .=
                //     '
                //         <a href="#" class="btn_sm button_danger bt_done"  data-id="'.$data->id.'"  >'.__('administrator.paid' ).'</a>
                //        ';
                // }
                return $edit;
                })
            ->rawColumns(['pay_amount'=>'pay_amount','verify_by1'=>'verify_by1'])
                
            ->addIndexColumn()
            ->make(true);
        }
        return view('administrator.report_shop.index',compact('merchant'));
    }
}
