<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderModel;
use App\Exports\DriverRevenueExport;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;

class ReportDriverRevenueController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->export){
            $from_date = $request->from_date;
            $to_date = $request->to_date;
            $driver_id = $request->driver_id;
            return Excel::download(new DriverRevenueExport($from_date,$to_date,$driver_id), 'driver_revenue.xlsx');
        }
        if ($request->ajax()) {
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $driver_id = $request->driver_id;
            $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join("users","users.id","nso007_delivery_order.driver_id")
                ->selectRaw(
                    '
                        nso007_delivery_order.delivery_date,nso007_delivery_order.driver_id,
                        sum(nso007_export_stock.delivery_fee/nso007_export_stock.delivery_fee_rate) as total_income,
                        users.name as driver_name

                    '                    
                )
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date && $to_date) {
                        $q->whereBetween(DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
                    }
                })
                ->where('nso007_delivery_order_detail.status',3)
                ->when($driver_id,function($q) use($driver_id){
                    $q->where('nso007_delivery_order.driver_id',$driver_id);
                })
                ->groupBy([DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date, '%Y %m')"), 'driver_id'])
                ->orderBy("nso007_delivery_order.delivery_date","DESC");
            
            $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join("users","users.id","nso007_delivery_order.driver_id")
                ->selectRaw(
                    '
                        nso007_delivery_order.delivery_date,nso007_delivery_order.driver_id,
                        sum(nso007_export_stock.delivery_fee/nso007_export_stock.delivery_fee_rate) as total_income,
                        users.name as driver_name
                    '               
                )
                ->where(function ($q) use ($from_date, $to_date) {
                    if ($from_date && $to_date) {
                        $q->whereBetween(DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
                    }
                })
                ->where('nso007_delivery_order_detail.status',3)
                ->when($driver_id,function($q) use($driver_id){
                    $q->where('nso007_delivery_order.driver_id',$driver_id);
                })
                ->groupBy([DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date, '%Y %m')"), 'driver_id'])
                ->orderBy("nso007_delivery_order.delivery_date","DESC");
            $rows = view('administrator.driver-report-revenue.report-data', compact('data','from_date','to_date'))->render();
            return response()->json(['success' => true, 'data' => $rows]);
        }
        return view('administrator.driver-report-revenue.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
