<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderModel;
use App\Exports\DriverBoxExport;
use App\Exports\DriverPickupExport;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\PickupAdminModel;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\Facades\DataTables;

class ReportDriverControler extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if($request->export){
            $from_date = $request->from_date;
            $to_date = $request->to_date;
            $driver_id = $request->driver_id;
            return Excel::download(new DriverBoxExport($from_date,$to_date,$driver_id), 'driver_package.xlsx');
        }
        if ($request->ajax()) {
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $driver_id = $request->driver_id;
            $data = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
            ->join("users","users.id","nso007_delivery_order.driver_id")
            ->selectRaw(
                '
                    nso007_delivery_order.*,
                    COUNT(nso007_delivery_order_detail.export_id) as total_box,
                    users.name as driver_name
                '                    
            )
            ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                    $q->whereBetween(DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
            })
            ->where('nso007_delivery_order_detail.status',3)
            ->when($driver_id,function($q) use($driver_id){
                $q->where('nso007_delivery_order.driver_id',$driver_id);
            })
            ->groupBy([DB::raw("DATE_FORMAT(nso007_delivery_order.delivery_date, '%Y %m')"), 'driver_id'])
            ->orderBy("nso007_delivery_order.delivery_date","DESC");


            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $rows = view('administrator.driver-report.report-data', compact('data','from_date','to_date'))->render();
            return response()->json(['success' => true, 'data' => $rows]);
        }
        return view('administrator.driver-report.index');
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function report_pickup(Request $request){
        if($request->export){
            $from_date = $request->from_date;
            $to_date = $request->to_date;
            $driver_id = $request->driver_id;
            return Excel::download(new DriverPickupExport($from_date,$to_date,$driver_id), 'driver_pickup.xlsx');
        }
        if ($request->ajax()) {
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $driver_id = $request->driver_id;
            $data = PickupAdminModel::join("users","users.id","nso007_pickup_admin.driver_id")
            ->selectRaw('nso007_pickup_admin.*,sum(nso007_pickup_admin.exact_qty) as total_box,users.name as driver_name')
            ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                $q->whereBetween(DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
            })
            ->where('nso007_pickup_admin.status',4)
            ->when($driver_id,function($q) use($driver_id){
                $q->where('nso007_pickup_admin.driver_id',$driver_id);
            })
            ->groupBy([DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date, '%Y %m')"), 'nso007_pickup_admin.driver_id'])
            ->orderBy("nso007_pickup_admin.delivery_date","DESC");
            $from_date = $request->from_date ? date('Y-m-d', strtotime($request->from_date)) : '';
            $to_date = $request->to_date ? date('Y-m-d', strtotime($request->to_date)) : '';
            $rows = view('administrator.driver-report.report-pickup-data', compact('data','from_date','to_date'))->render();
            return response()->json(['success' => true, 'data' => $rows]);
        }
        return view('administrator.driver-report.report-pickup');
    }
}
