<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Imports\LocationImport;
use App\LocationModel;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class LocationWithZoneController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $lang = \Globals::check_lang();
    
        if ($request->ajax()) {
            $search = $request->input('search.value');
            $query =DB::table('nso007_location as location')
                ->where('status',1)
                ->where('location.type','=','location');
            $location = $query->select('location.id', 'location.name_'.$lang.' as location', 'location.price', 'location.name_en', 'location.name_km', 'location.status','location.currency_symbol');
            
            return  DataTables::of($location)

            ->addColumn('action', function ($location) {
                $location_edit  = '';
                $delete = '';
                if (Gate::check('Edit Location')) {
                    $location_edit  = '

                        
                <a href="#" class="button_warning edit_location" data-id="'.$location->id.'" data-name_en="'.$location->name_en.'" data-name_km="'.$location->name_km.'" data-price="'.$location->price.'" data-currency="'.$location->currency_symbol.'" ><span class="fa fa-edit"></span> '.__('administrator.edit').'</a>

                ';
                if(Gate::check('Delete Location')){
                    $delete = '<a class="button_info delete_location "   data-id="'.$location->id.'" >'. __('administrator.delete').'</a>';
                }
                //     $location_edit  = '

                // <a class="button_info delete_location "   data-id="'.$location->id.'" >'. __('administrator.delete').'</a>
                // <a href="#" class="button_warning edit_location" data-id="'.$location->id.'" data-zone="'.$location->zone_id.'" data-name_en="'.$location->name_en.'" data-name_km="'.$location->name_km.'" data-price="'.$location->price.'" data-currency="'.$location->currency_symbol.'" ><span class="fa fa-edit"></span> '.__('administrator.edit').'</a>

                // ';
                }

                return  $location_edit.$delete ;
            })
        //   <a href="'. route("location.show", $location->id) . '" class="button_info">'.__('administrator.edit').'</a>
            ->addColumn('price', function ($location) {
                if($location->currency_symbol == '៛'){
                    return number_format($location->price).'៛';
                }
                return '$'.number_format($location->price, 2);
            })
            ->addColumn('zone',function($location) use($lang){
                $zone = LocationModel::
                    whereRaw('FIND_IN_SET('.$location->id.',location_id)')
                    ->get('name_'.$lang.' as name');
                $text = "";
                foreach($zone as $key => $val){
                    $text .= $val->name;
                }
                return $text;
            })
            ->addIndexColumn()
            ->make(true);
        }
        $zone = LocationModel::where([['type','zone']])
                ->pluck('name_'.$lang.'','id');
            return view('administrator.location-zone.index',compact('zone'));
        
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request,[
            'name_km'     => 'required',
            'name_en'  => 'required',
        ]);
        try {
            DB::beginTransaction();
            $location = new LocationModel;
            $location->pearent_id   = $request->pearent_id;
            $location->name_km   = $request->name_km;
            $location->name_en   = $request->name_en;
            $location->price   = $request->price;
            $location->currency_symbol   = $request->currency_symbol;
            $location->type = 'location';
            $location->save();
            DB::commit();
            return redirect()->back()->with(['success' => 'Locaion Save Successfull !!']);
        }catch(Exception $e){
            DB::rollBack();
            throw new Exception($e->getMessage());
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request,[
            'name_km'     => 'required',
            'name_en'  => 'required',
        ]);
        try {
            DB::beginTransaction();
            $location = LocationModel::find($id);
            $location->pearent_id   = $request->pearent_id;
            $location->name_km   = $request->name_km;
            $location->name_en   = $request->name_en;
            $location->price   = $request->price;
            $location->currency_symbol   = $request->currency_symbol;
            $location->save();
            DB::commit();
            return redirect()->back()->with(['success' => 'Locaion Update Successfull !!']);
        }catch(Exception $e){
            DB::rollBack();
            throw new Exception($e->getMessage());
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function import(Request $request){
        \Excel::import(new LocationImport(),$request->file('import_file'));
        return redirect()->back()->with('message','Zone Has Been Import !');
    }
}
