<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use DB;
use App\Fun\Fun as FunFun;
use Hash;
use App\CustomerModel;
use App\ImportStockDetailModel;
use App\ImportStockModel;
use App\StockModel;
use App\ProductModel;
use App\BranchModel;
use App\Helpers\Globals;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\DataTables;

class ImportStockController extends Controller
{

    function __construct()
    {
        FunFun::lang();
        // $this->middleware('permission:Import Stock', ['only' => ['index']]);
        // $this->middleware('permission:Import Show', ['only' => ['show']]);
    }
    public function  index(Request $request)
    {
        
        if ($request->ajax()) {
            $data =ImportStockDetailModel::
                    join("nos007_inport_stock",'nos007_inport_stock.id','nos007_inport_stock_details.import_id')
                ->join("users",'users.id','nos007_inport_stock.create_by')
                ->join("users AS merchant",'merchant.id','nos007_inport_stock.merchant_id')
                ->join("nso007_products",'nso007_products.barcode','nos007_inport_stock_details.barcode')
                ->select(
                    'nos007_inport_stock.create_by','nos007_inport_stock.import_date','nos007_inport_stock.transaction_number',
                    'nos007_inport_stock_details.id AS stock_details_id',
                    'nso007_products.name_km','merchant.shop_name','users.name' ,'merchant.id AS merchant_id')
                ->groupBy('nos007_inport_stock.transaction_number');
            
            return  Datatables::of($data)
                            ->editColumn('sale_price', function ($data) {
                                return "$".$data->sale_price;
                            })
                            ->addColumn('total',function($data){
                                 return  "$".($data->sale_price *$data->import_qty  );
                            })
                            ->editColumn('import_date', function($data) {
                                return date('d-m-Y',strtotime($data->import_date));
                            })
                            ->addColumn('action', function($data) {
                                $show = '';
                                $delete = '';
                                if(Gate::check('Show Stock In')){
                                    $show = '<a href="'. route("import-stock.show", $data->transaction_number) . '" class="viewPopLink  btn btn-primary btn-sm fa fa-eye"  data-toggle="modal tooltip" data-target="#myModal"></a>';
                                }
                                if(Gate::check('Show Stock In')){
                                    $delete = ' <a href="#" class="viewPopLink  btn btn-danger btn-sm fa fa-trash" data-transaction_number="'.$data->transaction_number.'" data-merchant_id="'.$data->merchant_id.'" data-toggle="modal tooltip" data-target="#myModal"></a>';
                                }
                                return $show.$delete;
                                })
                            ->addIndexColumn()
                            ->make(true);
        }

        return \view('administrator.import-stock.index');
    }


    public function create(Request $request)
    {
        
        $merchant = User::where('user_type',3)->where('status',1)->where('type_of_merchant',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type',2)->where('status',1)->pluck('name', 'id')->prepend('Please Select', '')->toArray();

        
        if ($request->ajax()) {
            $shop_id = $request->shop_id ? $request->shop_id : '0';
            session()->forget('product_session');
            $product_list  = ProductModel::where('status',1)
                ->whereRaw('FIND_IN_SET('.$shop_id.', shop_id)');
            if(\Globals::check_lang() == 'en'){
                $product_list = $product_list->select('id','name_en as name','image','barcode','price')->paginate(12);
            }else{
                $product_list = $product_list->select('id','name_km as name','image','barcode','price')->paginate(12);
            }
            return view("administrator.import-stock.result-create",compact('product_list'))->render();
        }
        return view('administrator.import-stock.create',compact('drivers','merchant'));

    }


    public function store(Request $request)
    {
        $this->validate($request, [
            'barcode.*'             => 'required',
            'product_name.*'        => 'required',
            'category_name.*'       => 'required',
            'stockin_qty.*'         => 'required',
            'price.*'               => 'required',
            'total.*'               => 'required',
            'merchant_id'           => 'required',
            'date'                  => 'required',
        ]);
        try {
            DB::beginTransaction();
            $increas = '';
            $last_id=ImportStockModel::max('id');
            $header_invoice = BranchModel::first();


            if($last_id){
                $transaction_number = ImportStockModel::select('transaction_number')->get()->last();
                $tran_num = substr($transaction_number->transaction_number, 3);
                $increas = $header_invoice->header_invoice_import.sprintf('%07d', ($tran_num+1));
            }else{
                $increas = $header_invoice->header_invoice_import.'0000001';
            }

            $import = new ImportStockModel();
            $import->merchant_id            = $request->merchant_id;
            $import->transaction_number     = $increas;
            $import->driver_id              = $request->drivers_id;
            $import->import_date            = date('Y-m-d',strtotime($request->date));
            $import->create_by              = Auth::user()->id;
            $import->save();

            $max_id = ImportStockModel::max('id');

            $product_session = session()->get('product_session');
            foreach ($product_session as $key => $value) {
                $purchase_detail = array(
                    'import_id'     => $max_id,
                    'barcode'       => $value['barcode'],
                    'import_qty'    => $value['stockin_qty'],
                    'sale_price'    => $value['price'],
                );
                ImportStockDetailModel::insert($purchase_detail);
                $stock = StockModel::updateOrCreate(array(
                    'barcode' => $value['barcode'],
                    'merchant_id' => $request->merchant_id
                ));
                $stock->stock_qty +=        $value['stockin_qty'];
                $stock->merchant_id =       $request->merchant_id;
                $stock->price       =       $value['price'];
                $stock->save();
            }
            session()->forget('product_session');
            DB::commit();
            // all good
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger',$e->getMessage());
        }
        return redirect()->route('import-stock.index')->with('sussess','Import was add already successfully!');

    }

    public function show($id)
    {

        $data = ImportStockDetailModel::join("nos007_inport_stock",'nos007_inport_stock.id','nos007_inport_stock_details.import_id')
                ->join("users",'users.id','nos007_inport_stock.create_by')
                ->join("users AS merchant",'merchant.id','nos007_inport_stock.merchant_id')
                ->join("nso007_products",'nso007_products.barcode','nos007_inport_stock_details.barcode')
                ->join("nso007_category",'nso007_category.id','nso007_products.category_id')
                ->where('nos007_inport_stock.transaction_number',$id);
                if(\Globals::check_lang() == 'en'){
                    $data = $data->select('nos007_inport_stock_details.id AS stock_details_id','nos007_inport_stock.merchant_id','nos007_inport_stock.import_date',
                    'nos007_inport_stock_details.barcode','nos007_inport_stock_details.import_qty','nos007_inport_stock.transaction_number',
                    'nos007_inport_stock_details.sale_price','nso007_products.name_km','nso007_category.name_en AS category_name','nos007_inport_stock_details.import_qty',
                    'merchant.shop_name','merchant.phone')->get();
                }else{
                    $data = $data->select('nos007_inport_stock_details.id AS stock_details_id','nos007_inport_stock.merchant_id','nos007_inport_stock.import_date',
                    'nos007_inport_stock_details.barcode','nos007_inport_stock_details.import_qty','nos007_inport_stock.transaction_number',
                    'nos007_inport_stock_details.sale_price','nso007_products.name_km','nso007_category.name_km AS category_name','nos007_inport_stock_details.import_qty',
                    'merchant.shop_name','merchant.phone')->get();
                }
                $merchant_id = $data[0]->merchant_id ;
                $invoice = $id;
        return view('administrator.import-stock.show',compact('data','id','merchant_id','invoice'));
    }

    public function edit($id)
    {
        $data =ImportStockDetailModel::select('nos007_inport_stock_details.id AS stock_details_id','nos007_inport_stock.merchant_id','nos007_inport_stock.import_date',
                                'nos007_inport_stock_details.barcode','nos007_inport_stock_details.import_qty',
                                'nos007_inport_stock_details.sale_price','nso007_products.name_km','nso007_category.category_name','nos007_inport_stock_details.import_qty' )
                                ->join("nos007_inport_stock",'nos007_inport_stock.id','nos007_inport_stock_details.import_id')
                                ->join("users",'users.id','nos007_inport_stock.create_by')
                                ->join("users AS merchant",'merchant.id','nos007_inport_stock.merchant_id')
                                ->join("nso007_products",'nso007_products.barcode','nos007_inport_stock_details.barcode')
                                ->join("nso007_category",'nso007_category.id','nso007_products.category_id')
                                ->where('nos007_inport_stock_details.id',$id)
                                ->first();
        $total = $data->import_qty *  $data->sale_price;
        $merchant = User::where('user_type',3)->where('status',0)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();


        return view('administrator.import-stock.edit',compact('data','merchant','total'));

    }

    public function update(Request $request, $id)
    {
        //
    }


    public function destroy($id)
    {
        //
    }

    public function get_product(Request $request)
    {
        
        $id = (empty($request->id)?$request->get('term') :$request->id);
        $products  = ProductModel:: leftJoin('nso007_category','nso007_category.id','nso007_products.category_id');
        if(\Globals::check_lang() == 'en'){
            $products = $products  ->select('nso007_products.*','nso007_products.name_en AS product_name','nso007_category.name_en AS category_name')
                                    ->where('nso007_products.status',1)->where('nso007_products.barcode',$id)->first();
        }else{
            $products = $products  ->select('nso007_products.*','nso007_products.name_km AS product_name','nso007_category.name_km AS category_name')
                                    ->where('nso007_products.status',1)->where('nso007_products.barcode',$id)->first();
        }
        $status = '';

        $product_session = session()->get('product_session');
        if(!$products) {
            $status = 'Product Code is Incorrect!';
        }
        else{
            if(isset($product_session[$id])) {
                session()->put('product_session', $product_session);
                $status = 'Product is add already exist !';
            }else{
                if ($products->barcode) {
                    $product_session[$id] = [
                            "barcode"           => $products->barcode,
                            "product_name"      => $products->product_name,
                            "category_name"     => $products->category_name,
                            "stockin_qty"       => '',
                            "price"             => $products->price,
                            'total'             =>''
                        ];
                    session()->put('product_session', $product_session);
                    $status = 'success';
                }
            }
        }
        return response()->json($status);
    }

    public function autocomplete(Request $request)
    {
        $shop_id  = $request->shop_id ? $request->shop_id : '0';
        $products = [];
        if (!empty($request->value)) {
            $arraySeesion = [];
            if (!empty(session()->get('product_session'))) {
                foreach (session()->get('product_session') as $key => $value) {
                    array_push($arraySeesion, $key);
                }
            }
            $lang = Globals::check_lang();
            $search = $request->value;
            $products = ProductModel::select('barcode', 'id', 'name_km','name_en', 'status','image')
            ->where('name_'.$lang.'','LIKE','%'.$search.'%')
                        // ->where('barcode', 'LIKE', '%' . $request->value . '%')
                        // ->orwhere('name_km', 'LIKE', '%' . $request->value . '%')
                        // ->orwhere('name_en', 'LIKE', '%' . $request->value . '%');
                        ->whereRaw('FIND_IN_SET('.$shop_id.', shop_id)');
                        // ->get();
            $products = $products->whereNotIn('id', $arraySeesion)
                    ->get();
            $lang = Globals::check_lang();
        }
        $view = view('administrator.import-stock.search', compact('products'))->render();
        return response()->json(['html' => $view]);
    }


    public function get_product_upadate(){
        $session = session()->get('product_session') ? session()->get('product_session') : [];
        $tr = '';
        $i = 0;
        foreach ($session as $id => $product) {
            $i++;
            $tr.='
                <tr >
                    <td width="6%">'.$i.'</td>
                    <td width="16%">
                        <input type="text" name="barcode[]" class="form-control barcode" value="'.$product['barcode'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="text" name="product_name[]" class="form-control all_key product_name"  value="'.$product['product_name'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="text" name="category_name[]" class="form-control all_key category_name" value="'.$product['category_name'].'" readonly>
                    </td>
                    <td width="16%">
                        <input type="number" name="stockin_qty[]" class="form-control stockin_qty number-only all_key" value="'.$product['stockin_qty'].'" required  >
                    </td>
                    <td width="16%">
                        <input type="number" name="price[]" class="form-control number-only price all_key" value="'.$product['price'].'" required>
                    </td>
                    <td width="14%">
                        <input type="text" name="total[]" class="form-control total"  value="'.$product['total'].'" readonly>
                    </td>
                    <td width="9%">

                        <a class="btn-remove" data-id="'.$product['barcode'].'" ><span class="fa fa-close fa-2x  text-red"></span></a>
                    </td>
                </tr>
                    ';
        }
        echo $tr;
    }

    public function stock_removecart(Request $request)
    {
        if($request->type=='remove-one'){
            session()->forget('product_session.'.$request->id);
        }
        else{
            session()->forget('product_session');
        }
        return \redirect()->back();
    }

    public function update_all(Request $request)
    {

        $product_session = session()->get('product_session');
        $i=0;
        if(count($product_session)!=0){
            foreach($product_session as $key => $data){
                $product_session[$key]['barcode'] = $request->barcode[$i];
                $product_session[$key]['product_name'] = $request->product_name[$i];
                $product_session[$key]['category_name'] = $request->category_name[$i];
                $product_session[$key]['stockin_qty'] = $request->stockin_qty[$i];
                $product_session[$key]['price'] = $request->price[$i];
                $product_session[$key]['total'] = $request->total    [$i];
                session()->put('product_session', $product_session);
                $i++;
            }
        }
        else{
            return false;
        }
    }
    public function import_stock_update(Request $request)
    {

        $status ='';
       $data_qty = DB::table('nos007_inport_stock')->join('nos007_inport_stock_details','nos007_inport_stock.id','nos007_inport_stock_details.import_id')
        ->where('nos007_inport_stock.transaction_number', $request->invoice)
        ->where('nos007_inport_stock_details.barcode',$request->id)->first();
        // dd($data_qty->import_qty);

        if($data_qty->import_qty >  $request->qty ){
            $total = $data_qty->import_qty - $request->qty ;
            $data = DB::table('nos007__stocks')->where('merchant_id', $request->merchant_id)->where('barcode',$request->id);
            $data1 = $data->first();
            if($data1->stock_qty >=  $request->qty){
                $data->decrement('stock_qty', $total);
                DB::table('nos007_inport_stock')->join('nos007_inport_stock_details','nos007_inport_stock.id','nos007_inport_stock_details.import_id')
                ->where('nos007_inport_stock.transaction_number', $request->invoice)
                ->where('nos007_inport_stock_details.barcode',$request->id)->decrement('nos007_inport_stock_details.import_qty', $total);
                $status = 'successfully' ;
            }
            else{
                $status = 'not success' ;
            }
        }elseif($data_qty->import_qty <  $request->qty ){


            $total = $data_qty->import_qty - $request->qty ;
            $total = 0- $total ;
            $data = DB::table('nos007__stocks')->where('merchant_id', $request->merchant_id)->where('barcode',$request->id);
            $data1 = $data->first();

                $data->increment('stock_qty', $total);
                DB::table('nos007_inport_stock')->join('nos007_inport_stock_details','nos007_inport_stock.id','nos007_inport_stock_details.import_id')
                ->where('nos007_inport_stock.transaction_number', $request->invoice)
                ->where('nos007_inport_stock_details.barcode',$request->id)->increment('nos007_inport_stock_details.import_qty', $total);
                $status = 'successfully' ;
        }

        return $status;
    }
    public function import_stock_delete(Request $request)
    {
        $data  = DB::table('nos007_inport_stock')->where('transaction_number',$request->invoice)->first();
        DB::table('nos007_inport_stock_details')->where('import_id',$data->id)->where('barcode',$request->id)->delete() ;
        $data = DB::table('nos007__stocks')->where('merchant_id', $request->merchant_id)->where('barcode',$request->id)->decrement('stock_qty', $request->import_qty);
        $status = 'successfully' ;
        return $status;
    }

    public function import_stock_main_delete(Request $request)
    {
        $nos007_inport_stock =  \DB::table('nos007_inport_stock')->where('nos007_inport_stock.transaction_number',$request->transaction_number)->first();
        $merchant_id =$nos007_inport_stock->merchant_id ;
        $import_id =$nos007_inport_stock->id ;
        $nso007_export_stock_details= \DB::table('nos007_inport_stock_details')->where('nos007_inport_stock_details.import_id', $nos007_inport_stock->id)->get();
        foreach ($nso007_export_stock_details as $key => $value) {
                    DB::table('nos007__stocks')->where('merchant_id', $merchant_id)->where('barcode',$value->barcode)->decrement('stock_qty', $value->import_qty);
                    \DB::table('nos007_inport_stock')->where('nos007_inport_stock.id',$nos007_inport_stock->id)->delete();
            }
           \DB::table('nos007_inport_stock_details')->where('nos007_inport_stock_details.import_id', $import_id)->delete();
           $status = 'successfully' ;
           return $status;
    }

}
