<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DiscountModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use App\Helpers\Globals;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\LocationModel;
use App\StockModel;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class ExportStockNewController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        $paid = DeliveryOrderDetailModel::where('status',3)->where('status_paid','paid')->pluck('export_id');
        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                ->where('nso007_export_stock.type_of_stock',1)
                ->whereNotIn('nso007_export_stock.id',$paid)
                ->groupBy('nso007_export_stock.box_code')
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc'); 
            return  DataTables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    $pedding = '';
                    $cancel = '';
                    $edit = '';
                    $return_to_shop = '';
                    $print = '';
                    $all = '';
                    $return_to_proccess = '';
                    $delete =  '';
                    if (Gate::check('Delete Order')) {
                        $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; '. __('administrator.delete') .'</a></li>';
                    }
                    if (Gate::check('Pending Order List')) {
                        $pedding = '<li><a class="bt_pending" data-status="'.$data->status.'" data-export_id="'.$data->export_stock_id.'">'.__('administrator.pending').'</a>';
                    }
                    if (Gate::check('Cancel Order List')) {
                        $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'.__('administrator.cancel').'</a></li>';
                    }if (Gate::check('Return To Shop Order List')) {
                        $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->export_stock_id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                    }if (Gate::check('Edit Order List')) {
                        $edit = '<li><a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                    }if (Gate::check('Print Order List')) {
                        $print = '<li><a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="fa fa-print bt-print">&nbsp;'.__('administrator.print').'</a></li>';
                    }        $return_to_proccess = '
                            <li><a class="return_to_inpro fa fa-undo" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'.__('administrator.back_to_process').'</a></li>
                        ';
                    if($data->status == 1 || $data->status == 2 || $data->status == 4 || $data->status == 3){
                        if ($data->status == 1) {
                                $all.= $delete.$print.$edit;
                        }
                       
                        if($data->status == 2){
                            $all .= $print.$edit.$pedding.$cancel.$return_to_shop;
                        }
                        if($data->status != 4){
                            
                        }
                        // $all = $delete . $print .$edit .$pedding .$cancel.$return_to_shop;
                        
    
    
                    }
                    if($data->status == 4){
                        if(!$data->status_paid){
                            if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                $all .= $return_to_proccess.$return_to_shop;
                            }
                        }
                    }
                    if($data->status == 5){
                        $all .= $return_to_proccess;
                    }
                    if($data->status == 3){
                        // if(!$data->status_paid){
                        //     if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                        //         $all .= $return_to_proccess;
                        //     }
                        // }
                            if(!$data->status_paid){
                                if(  $data->status_paid != 'paid' &&  $data->invoice_payment_id == null ){
                                    $all .=$return_to_proccess;
                                    // $action = '
                                    //     <label class="btn btn-info btn-xs return_to_inpro_for_success"  data-export_id="'.$data->export_id.'" ><span class=" fa fa-share-square"> '.__('administrator.back_to_process').'</span></label>
                                    // ';
                                }
                            }
                    }
                    if($data->status == 7){
                        $all .= $print.$edit.$delete.$return_to_proccess;
                    }
                    
                    return '
                    <div class="dropdown">
                         <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">'. __('administrator.action') .'
                         <span class="caret"></span></button>
                         <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                         '.$all.'
                         </ul>
                     </div>
                    ';

                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else if ($data->status == 5)     // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                    else if($data->status == 6)   // 6 = paid
                        return '';
                    else 
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>';
                        
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })
                
                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1) 
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";
                        
                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name'])
                ->addIndexColumn()
                ->make(true);
        }
        return \view('administrator.export-stock.index',compact( 'merchant_show'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $merchant = User::where('user_type', 3)->where('status', 1)->where('type_of_merchant', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type', 2)->where('status', 0)->pluck('name', 'id')->prepend(__('administrator.please_select'), '')->toArray();
        $bus = \DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend('Chose Taxi','No')->toArray();
        $lang = \Globals::check_lang();
        // $from_location = LocationModel::where('status', 1)
        //     ->where('type','zone')
        //     // ->where('pearent_id', null)
        //     ->select('nso007_location.name_'.$lang.' AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        // $location = LocationModel::where('status', 1)     
        //     ->where('type','location')   
        // // ->where('pearent_id', '!=', null)
        //     ->select('nso007_location.name_'.$lang.' AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                if($request->get_zone == "province"){
                    $q->where('province',1);
                }else{
                    $q->whereNull('province');
                }
            })
            ->select('nso007_location.name_en AS name', 'id','location_id');
        $province_id = LocationModel::where('status', 1)
                        ->where('type','zone')
                        ->select('id')
                        ->where('province',1)
                        ->first();
        $province_id = optional($province_id)->id;
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)     
            ->where('type','location')   
            ->whereIn('id',$loc_id_array)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        if($request->get_zone){
            return response()->json([
                'zone'=>$from_location,
                'location'=>$location
            ]);
        }
        $exchang_rate = CurrencyModel::find(1);
        return \view('administrator.export-stock-new.create', compact('drivers', 'merchant', 'from_location', 'location', 'exchang_rate', 'bus','province_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $this->validate($request, [
            'location'          => 'required',
            'customer_receive'  => 'required',
            'delivery_fee'      => 'required',
            // 'export_date'       => 'required',
            // 'currency'          => 'required',
            'barcode.*'         => 'required',
            'export_qty.*'      => 'required|numeric',
            'total.*'           => 'required',
            'category_id.*'           => 'required',
        ]);
        DB::beginTransaction();
        $increas = '';
        $header_invoice = BranchModel::first();
        $last_id = ExportStockModel::max('id');
        if ($last_id) {
            $box_code = ExportStockModel::select('box_code')->get()->last();
            $tran_num = substr($box_code->box_code, 3);
            $increas = $header_invoice->header_invoice_import . sprintf('%09d', ($tran_num + 1));
        } else {
            $increas = $header_invoice->header_invoice_import . '000000001';
        }

        $discount = DiscountModel::where('date',date('Y-m-d'))->first();
        $exportstock = new ExportStockModel();
        if( $discount ){
            $arra_  =  explode(',', $discount->shop_id);
            if (in_array($request->merchant_id, $arra_)) {
                $exportstock->discount_id  = $discount->id;
            }
        }
        $exportstock->merchant_id           = $request->merchant_id;
        $exportstock->box_code              = $increas;
        $exportstock->export_date           = date('Y-m-d');
        $exportstock->delivery_fee          = $request->delivery_fee;
        $exportstock->delivery_fee_rate     = $request->delivery_fee_rate;
        $exportstock->delivery_fee_symbol   = $request->delivery_fee_symbol;
        $exportstock->service_charge        = $request->service_charge;
        $exportstock->from_location         = $request->from_location;
        $exportstock->location              = $request->location;
        $exportstock->customer_receive      = $request->customer_receive;
        $exportstock->delivery_status       = $request->delivery_status;
        $exportstock->delivery_option       = $request->delivery_option;
        $exportstock->created_by            = Auth::user()->id;
        $exportstock->description           = $request->description;
        $exportstock->date_delivery         =  date('Y-m-d');

        $exportstock->type_of_stock         = 1; //export stock
        $exportstock->delivery_pay_or_paid  = $request->pay_or_paid;
        $exportstock->taxi_number           = $request->taxi_number;
        $exportstock->taxi_status           = $request->taxi_status;
        if($request->taxi_status==1){
            $exportstock->taxi_shop_fee     = $request->taxi_price;
        }else{
            $exportstock->taxi_cust_fee     = $request->taxi_price;
        }
        $exportstock->taxi_fee_rate              = $request->taxi_fee_rate;
        $exportstock->taxi_fee_symbol              = $request->taxi_fee_symbol;
        $exportstock->taxi_pay_or_paid      = $request->taxi_pay_or_paid;
        
        $exportstock->other_services_fee    = $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $exportstock->other_services_type   = $request->other_services_type;
        $exportstock->other_services_pay_or_paid  = $request->other_service_pay_or_paid_;
        $exportstock->shop_name            =  FindShop($request->merchant_id);
        $exportstock->location_name        =  FindLoaction($request->location);
        $exportstock->create_by_name                 = \Auth::user()->name;
        $exportstock->update_status_by                  = update_status_by("" ,'' ,'')      ;//  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';

        $total_product = 0;

        foreach ($request->price as $key1 => $value) {
            $total_product  += ($request->price[$key1] *  $request->export_qty[$key1] );
        }
        $exportstock->total_product                 = $total_product;
        $exportstock->rate                 = CurrencyModel::find(1) ? CurrencyModel::find(1)->currency_exchange_to : 4000;

        // dd($exportstock);
        if ($exportstock->save()) {
            foreach ($request->barcode as $key => $value) {
                StockModel::where([['merchant_id', $request->merchant_id], ['barcode', $request->barcode[$key]]])->decrement('stock_qty', $request->export_qty[$key]);
                $exportdetails = array(
                    'export_id'             =>  $exportstock->id,
                    'barcode'               =>  $request->barcode[$key],
                    'currency'              =>  $request->currency,
                    'export_qty'            =>  $request->export_qty[$key],
                    'price'                 =>  $request->price[$key],
                    'category_id'           =>  $request->category_id[$key],
                    'category_name'         =>  FindCategory($request->category_id[$key]),
                );
                ExportStockdetailsMode::insert($exportdetails);
            }
        }

        if($request->driver_id){
            delivery_order($exportstock->id, $request->driver_id);
        }
        $history = array(
            "export_id"     =>  $exportstock->id,
            "status"        =>  1,
            "user_id"       =>  Auth::user()->id,
            "reason"        =>  "Create"
        );
        Globals::historyBox($history);
        DB::commit();
        session()->forget('get_product_session');
        session()->forget('session_show_product');
    // } catch (\Exception $e) {
    //     DB::rollback();
    //     return redirect()->back()->with('danger', $e->getMessage());
    // }
    if((@session()->get('back_bage')) == 1){
        return redirect()->back()->with('sussess', 'Import was add already successfully!');
    }
    return redirect()->route('export-stock-new.index')->with('sussess', 'Import was add already successfully!');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {


        if($request->get_zone){
            $from_location = LocationModel::where('status', 1)
                ->where('type','zone')
                ->when('no zone',function($q) use($request){
                    if($request->get_zone == "province"){
                        $q->where('name_en','=','Province');
                    }else{
                        $q->where('name_en','!=','Province');
                    }
                })
                ->select('nso007_location.name_en AS name', 'id','location_id');

            $province_id = LocationModel::where('status', 1)
                ->where('type','zone')
                ->select('id')
                ->where('name_en','=','Province')
                ->first();
            $province_id = optional($province_id)->id;
            $loc_id_array = array();
            $zone_location = $from_location->pluck('location_id');
            foreach($zone_location as $key=>$val){
                foreach(explode(',',$val) as $loc_id){
                    if($loc_id){
                        array_push($loc_id_array,$loc_id);
                    }
                }
            }
            $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
            $location = LocationModel::where('status', 1)     
                ->where('type','location')   
                ->whereIn('id',$loc_id_array)
                ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');


            return response()->json([
                'zone'=>$from_location,
                'location'=>$location
            ]);
        }





        $lang = \Globals::check_lang();
        $data   = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->join('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
            ->join('nso007_category', 'nso007_category.id', 'nso007_products.category_id')
            ->where('nso007_export_stock_details.export_id', $id);

        if (\Globals::check_lang() == 'en') {
            $data = $data->select(
                'nso007_export_stock_details.*',
                'nso007_products.name_en AS product_name',
                'nso007_products.category_id',
                'nso007_category.name_en AS category_name',
                'nso007_export_stock.*'
            )->get();
        } else {
            $data = $data->select(
                'nso007_export_stock_details.*',
                'nso007_products.name_km AS product_name',
                'nso007_products.category_id',
                'nso007_category.name_km AS category_name',
                'nso007_export_stock.*'
            )->get();
        }


        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($request){
                // if($request->get_zone == "province"){
                //     $q->where('id',21);
                // }else{
                //     $q->where('name_en','!=','Province');
                // }
            })
            ->when($data[0]->delivery_option,function($q) use($data,$request) {
                if(!$request->ajax()){
                    if($data[0]->delivery_option == "No"){
                        $q->where('name_en','!=','Province');
                    }else{
                        $q->where('name_en','=','Province');
                    }
                }
            })
            
            ->select('nso007_location.name_en AS name', 'id','location_id');
            $province_id = LocationModel::where('status', 1)
                ->where('type','zone')
                ->select('id')
                ->where('name_en','=','Province')
                ->first();
            $province_id = optional($province_id)->id;
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)     
            ->where('type','location')   
            ->whereIn('id',$loc_id_array)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        // dd($data[0]->delivery_option);



        if (!empty(session()->get("box_code"))) {      // មាន​ box Code
            $session_id = session()->get('box_code');
            if ($session_id != $data[0]->box_code) {       // box Code   ==  box Code អត់​​
                session()->forget('box_code');
                session()->forget('get_product_session_edit');
                if (empty(session()->get('get_product_session_edit'))) {
                    foreach ($data as $key => $datas) {
                        $stock = StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->first();
                        $get_product_session_edit[$datas->barcode] = [
                            "barcode"               => $datas->barcode,
                            "name_km"               => $datas->product_name,
                            "category_name"         => $datas->category_name,
                            "qty"                   => $datas->export_qty,
                            "price"                 => $datas->price,
                            "total"                 => $datas->export_qty * $datas->price,
                            "stock_qty"             => $stock->stock_qty,
                            "category_id"           => $datas->category_id,
                        ];
                        session()->put('get_product_session_edit', $get_product_session_edit);
                    }
                }
                session()->put('box_code', $data[0]->box_code);
            }
        } else {
            if (empty(session()->get('get_product_session_edit'))) {
                foreach ($data as $key => $datas) {
                    $stock = StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->first();
                    $get_product_session_edit[$datas->barcode] = [
                        "barcode"               => $datas->barcode,
                        "name_km"               => $datas->product_name,
                        "category_name"         => $datas->category_name,
                        "qty"                   => $datas->export_qty,
                        "price"                 => $datas->price,
                        "total"                 => $datas->export_qty * $datas->price,
                        "stock_qty"             => $stock->stock_qty,
                        "category_id"           => $datas->category_id,
                    ];
                    session()->put('get_product_session_edit', $get_product_session_edit);
                }
            }
            session()->put('box_code', $data[0]->box_code);
        }
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend($data[0]->delivery_option, $data[0]->delivery_option)->toArray();
        $merchant = User::where('user_type', 3)->where('status', 1)->where('type_of_merchant', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type', 2)->where('status', 0)->pluck('name', 'id')->prepend('Please Select', '')->toArray();
        
        
        $exchang_rate = CurrencyModel::find(1);
        return \view('administrator.export-stock-new.edit', compact('drivers', 'merchant', 'from_location', 'location', 'exchang_rate', 'data', 'bus','province_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $box_code)
    {
        // dd($request->all());
        if (!$request->export_qty) {
            return redirect()->back()->with('danger', 'Please try again');
        }
        try {

            DB::beginTransaction();
            $this->validate($request, [
                'location'          => 'required',
                'customer_receive'  => 'required',
                'delivery_fee'      => 'required', 
                // 'currency'          => 'required',
                'barcode.*'         => 'required',
                'export_qty.*'      => 'required|numeric',
                'total.*'           => 'required',
                'category_id'       => 'required',
                ]);
                
        $export = ExportStockModel::whereBox_code($box_code)->first();
        $export->delivery_fee          = $request->delivery_fee;
        $export->delivery_fee_rate     = $request->delivery_fee_rate;
        $export->delivery_fee_symbol   = $request->delivery_fee_symbol;
        $export->service_charge        = $request->service_charge;
        $export->from_location         = $request->from_location;
        $export->location              = $request->location;
        $export->customer_receive      = $request->customer_receive;
        $export->delivery_status       = $request->delivery_status;
        $export->delivery_option       = $request->delivery_option;
        $export->modify_by             = Auth::user()->id;
        $export->description           = $request->description;
        $export->type_of_stock           = 1; //export stock
        $export->delivery_pay_or_paid  = $request->pay_or_paid;
        $export->taxi_number           = $request->taxi_number;
        $export->taxi_status           = $request->taxi_status;
        $export->shop_name                     =  FindShop($request->merchant_id);
        $export->location_name                 =  FindLoaction($request->location);

        if($request->taxi_status==1){
            $export->taxi_shop_fee     = $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }else{
            $export->taxi_cust_fee     =  $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }
        $export->taxi_pay_or_paid      = $request->taxi_pay_or_paid;
        $export->other_services_fee    = $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $export->other_services_type   = $request->other_services_type;
        $export->other_services_pay_or_paid  = $request->other_services_pay_or_paid;
        update_status_by($box_code , '','edit_by');
       $total_product = 0;
        foreach ($request->price as $key1 => $value) {
            $total_product  += ($request->price[$key1] *  $request->export_qty[$key1] );
        }
        $export->total_product        = $total_product;
        $export->taxi_fee_rate              = $request->taxi_fee_rate;
        $export->taxi_fee_symbol              = $request->taxi_fee_symbol;
        $export->update();

        $data =  ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->where('nso007_export_stock.box_code', $box_code)
            ->select('nso007_export_stock.merchant_id', 'nso007_export_stock_details.barcode', 'nso007_export_stock_details.export_qty', 'nso007_export_stock.id AS export_stock_id')
            ->get();

        $data_ =  ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
        ->where('nso007_export_stock.box_code', $box_code)
        ->select(\DB::raw("SUM( nso007_export_stock_details.price *  nso007_export_stock_details.export_qty ) AS price"),
        'nso007_export_stock.*'
        )
        ->first();
        $export_stock_id =  $data[0]->export_stock_id;
        foreach ($data as $key => $datas) {
            StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->increment('stock_qty', $datas->export_qty);
            ExportStockdetailsMode::where('export_id', $datas->export_stock_id)->delete();
        }
        $price = 0;
        foreach ($request->barcode as $key => $value) {
            StockModel::where([['merchant_id', $request->merchant_id], ['barcode', $request->barcode[$key]]])->decrement('stock_qty', $request->export_qty[$key]);
            $exportdetails = array(
                'export_id'             =>  $export_stock_id,
                'barcode'               =>  $request->barcode[$key],
                'currency'              =>  $request->currency,
                'export_qty'            =>  $request->export_qty[$key],
                'price'                 =>  $request->price[$key],
                'category_id'           =>  $request->category_id[$key],
                'category_name'         =>   FindCategory($request->category_id[$key]),

            );
            $price +=  $request->price[$key] *$request->export_qty[$key] ;
            ExportStockdetailsMode::insert($exportdetails);
        }

            if ($data_->price != $price  || $data_->delivery_status != $request->delivery_status) {
                DeliveryOrderDetailModel::where('status',1)->where('export_id',$export->id)->update(['total_riel'=>0,'total_dollar'=>0]);
                DeliveryOrderDetailProccessingModel::where('status',1)->where('export_id',$export->id)->update(['total_riel'=>0,'total_dollar'=>0]);
            }

            session()->forget('get_product_session_edit');
            session()->forget('box_code');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->route('export-stock-new.index')->with('sussess', 'Import was add already successfully!');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
