<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\Exports\PaymentExport;
use App\Exports\ReturnExport;
use App\InvoicePaymentModel;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Validation\ValidationException;
use Auth;
use Hash;
use App\CustomerModel;
use App\ImportStockDetailModel;
use Exception;
use App\ImportStockModel;
use App\ExportStockModel;
use App\ExportStockdetailsMode;
use App\StockModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\DiscountModel;
use App\ProductModel;
use Gate;
use App\LocationModel;
use Maatwebsite\Excel\Facades\Excel;
use Yajra\DataTables\DataTables;
use App\Fun\Fun as FunFun;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\JournalModel;
use App\ShareLinkModel;
use Illuminate\Support\Facades\Session;

class ExportStockController extends Controller
{
    function __construct()
    {
        FunFun::lang();
        $this->middleware('permission:Export List', ['only' => ['index']]);
        $this->middleware('permission:Export InStock', ['only' => ['create', 'store']]);
    }

    public function index(Request $request)
    {
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                ->where('nso007_export_stock.type_of_stock',2)
                ->groupBy('nso007_export_stock.box_code')
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc');
            return  Datatables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paiddelete
                    $edit​​ = '';
                    $delete = '';
                    if ($data->status == 1 || $data->status == 2) {
                        if ($data->type_of_stock == 1) {
                            $edit = '<a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                        } else {
                            $edit = '<a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                        }

                    } else {
                        $edit = '<a href="#" class="button_dark fa fa-edit"></a>';
                    }


                    if ($data->status == 1 ) {
                        if(Gate::check('Export List Delete Box')){
                            $delete = '<a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                        }
                    } else {
                        $delete = '<a data-href="#" class="button_dark fa fa-trash   " ></a>';
                    }


                    return $delete .'
                        <a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="button_warning fa fa-print bt-print"></a>
                        ' . $edit;
                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else    // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })

                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1)
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";

                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name'])
                ->addIndexColumn()
                ->make(true);
        }
        return \view('administrator.export-stock.index',compact( 'merchant_show'));
    }

    public function create()
    {
        $merchant = User::where('user_type', 3)->where('status', 1)->where('type_of_merchant', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type', 2)->where('status', 0)->pluck('name', 'id')->prepend(__('administrator.please_select'), '')->toArray();
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();

        $from_location = LocationModel::where('status', 1)->where('pearent_id', null);
        $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null);

        if (\Globals::check_lang() == 'en') {
            $from_location = $from_location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.please_select'), '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.please_select'), '');
        } else {
            $from_location = $from_location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.please_select'), '');
            $location = $location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.please_select'), '');
        }
        $exchang_rate = CurrencyModel::find(1);

        return \view('administrator.export-stock.create', compact('drivers', 'merchant', 'from_location', 'location', 'exchang_rate', 'bus'));
    }

    public function store(Request $request)
    {

        // try {
            $this->validate($request, [
                'location'          => 'required',
                'customer_receive'  => 'required',
                'delivery_fee'      => 'required',
                'export_date'       => 'required',
                'currency'          => 'required',
                'barcode.*'         => 'required',
                'export_qty.*'      => 'required|numeric',
                'total.*'           => 'required',
                'category_id.*'           => 'required',
            ]);
            DB::beginTransaction();
            $increas = '';
            $header_invoice = BranchModel::first();
            $last_id = ExportStockModel::max('id');
            if ($last_id) {
                $box_code = ExportStockModel::select('box_code')->get()->last();
                $tran_num = substr($box_code->box_code, 3);
                $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
            } else {
                $increas = $header_invoice->header_invoice_import . '00000001';
            }

            $discount = DiscountModel::where('date',date('Y-m-d'))->first();
            $exportstock = new ExportStockModel();
            if( $discount ){
                $arra_  =  explode(',', $discount->shop_id);
                if (in_array($request->merchant_id, $arra_)) {
                    $exportstock->discount_id  = $discount->id;
                }
            }
            $exportstock->merchant_id           = $request->merchant_id;
            $exportstock->box_code              = $increas;
            $exportstock->export_date           = date('Y-m-d', strtotime($request->export_date));
            $exportstock->delivery_fee          = $request->delivery_fee;
            $exportstock->service_charge        = $request->service_charge;
            $exportstock->from_location         = $request->from_location;
            $exportstock->location              = $request->location;
            $exportstock->customer_receive      = $request->customer_receive;
            $exportstock->delivery_status       = $request->delivery_status;
            $exportstock->delivery_option       = $request->delivery_option;
            $exportstock->created_by            = Auth::user()->id;
            $exportstock->description           = $request->description;
            $exportstock->date_delivery         =  date('Y-m-d', strtotime($request->date_delivery));

            $exportstock->type_of_stock         = 1; //export stock
            $exportstock->delivery_pay_or_paid  = $request->pay_or_paid;
            $exportstock->taxi_number           = $request->taxi_number;
            $exportstock->taxi_status           = $request->taxi_status;
            if($request->taxi_status==1){
                $exportstock->taxi_shop_fee     = $request->taxi_price;
            }else{
                $exportstock->taxi_cust_fee     = $request->taxi_price;
            }

            $exportstock->taxi_pay_or_paid      = $request->taxi_pay_or_paid;
            $exportstock->other_services_fee    = $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
            $exportstock->other_services_type   = $request->other_services_type;
            $exportstock->other_services_pay_or_paid  = $request->other_service_pay_or_paid_;
            $exportstock->shop_name            =  FindShop($request->merchant_id);
            $exportstock->location_name        =  FindLoaction($request->location);
            $exportstock->create_by_name                 = \Auth::user()->name;
            $exportstock->update_status_by                  = update_status_by("" ,'' ,'')      ;//  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';

            $total_product = 0;

            foreach ($request->price as $key1 => $value) {
                $total_product  += ($request->price[$key1] *  $request->export_qty[$key1] );
            }
            $exportstock->total_product                 = $total_product;
            $exportstock->total_product_rate            = $request->total_product_rate;
            $exportstock->total_product_symbol          = $request->total_product_symbol;

            // dd($exportstock);
            if ($exportstock->save()) {
                foreach ($request->barcode as $key => $value) {
                    StockModel::where([['merchant_id', $request->merchant_id], ['barcode', $request->barcode[$key]]])->decrement('stock_qty', $request->export_qty[$key]);
                    $exportdetails = array(
                        'export_id'             =>  $exportstock->id,
                        'barcode'               =>  $request->barcode[$key],
                        'currency'              =>  $request->currency,
                        'export_qty'            =>  $request->export_qty[$key],
                        'price'                 =>  $request->price[$key],
                        'category_id'           =>  $request->category_id[$key],
                        'category_name'         =>  FindCategory($request->category_id[$key]),
                    );
                    ExportStockdetailsMode::insert($exportdetails);
                }
            }


            if($request->driver_id){
                delivery_order($exportstock->id, $request->driver_id);

            }
            session()->forget('get_product_session');
            session()->forget('session_show_product');
            DB::commit();
        // } catch (\Exception $e) {
        //     DB::rollback();
        //     return redirect()->back()->with('danger', $e->getMessage());
        // }
        if((@session()->get('back_bage')) == 1){
            return redirect()->back()->with('sussess', 'Import was add already successfully!');
        }
        return redirect()->route('export-stock.index')->with('sussess', 'Import was add already successfully!');
    }

    public function show($id)
    {
        $exportStock   =   ExportStockModel::find($id);
        if ($exportStock->type_of_stock == 1) {   //export stock
            $data   =   ExportStockdetailsMode::leftjoin('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->leftjoin('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
                ->leftjoin('nso007_location', 'nso007_export_stock.location', 'nso007_location.id')
                ->leftjoin('users As merchant', 'nso007_export_stock.merchant_id', 'merchant.id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                ->select(
                    'nso007_export_stock_details.*',
                    'nso007_products.name_en AS items',
                    'nso007_export_stock.*',
                    'nso007_location.name_en AS location_name',
                    'merchant.shop_name',
                    'merchant.phone',
                    'nso007_export_stock.customer_receive',
                    'nso007_export_stock.create_by_name',
                    'nso007_discount.discount',
                    'nso007_discount.discount_type'

                )
                ->where('nso007_export_stock.type_of_stock', 1)
                ->where('nso007_export_stock.id', $id)
                ->get();
        } else {   //out stock
            $data   =   ExportStockdetailsMode::leftjoin('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->leftjoin('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
                ->join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
                ->leftjoin('nso007_location', 'nso007_export_stock.location', 'nso007_location.id')
                ->leftjoin('users As merchant', 'nso007_export_stock.merchant_id', 'merchant.id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')

                ->select(
                    'nso007_export_stock_details.*',
                    // 'nso007_products.name_en AS items',
                    'nso007_category.name_en AS items',
                    'nso007_export_stock.*',
                    'nso007_location.name_en AS location_name',
                    'merchant.shop_name',
                    'merchant.phone',
                    'nso007_export_stock.customer_receive',
                    'nso007_export_stock.create_by_name',
                     'nso007_discount.discount',
                     'nso007_discount.discount_type'
                )
                ->where('nso007_export_stock.type_of_stock', 2)
                ->where('nso007_export_stock.id', $id)
                ->get();
        }
        return view('administrator.export-stock.show', compact('data'))->render();
    }
    public function print(Request $request)
    {
        $user_id = $request->user_id;
        $exportStock   =   ExportStockModel::whereIn('id',$request->id)
            ->when($user_id,function($q) use($user_id){
                $q->where('created_by',$user_id);
            })
            ->orderBy('id','DESC');
        return view('administrator.export-stock.print-all', compact('exportStock'))->render();
    }
    public function print_return_shop(Request $request)
    {
        $from_date      =   $request->from_date ? date('Y-m-d',strtotime($request->from_date)) : date("Y-m-d",strtotime("-1 week"));
        $to_date        =   $request->to_date ? date('Y-m-d',strtotime($request->to_date)) : date('Y-m-d');
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:[] ;

        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        $data = DB::table(DB::raw("(
                SELECT
                exs.id,exs.box_code,exs.export_date,exs.status,exs.type_of_stock,exs.id as export_id,
                exs.date_delivery,exs.total_product_symbol,exs.delivery_fee_symbol,
                exs.delivery_fee,exs.shop_name,exs.customer_receive,exs.location_name,
                exs.delivery_fee_rate,exs.delivery_pay_or_paid,exs.other_services_fee,
                exs.total_product_rate,exs.total_product_status,exs.delivery_status,
                exs.delivery_option,exs.taxi_status,exs.taxi_shop_fee,exs.taxi_cust_fee,
                exs.taxi_number,exs.extra_fee,exs.extra_fee_type,exs.driver_note,exs.merchant_id,exs.rate,
                exs.taxi_fee_symbol,exs.updated_at,exs.description,exs.total_product as total_price,
                exs.is_return_to_shop,
                nso007_discount.discount_type,nso007_discount.discount,items.*,
                    CASE
                        WHEN
                            delivery_option = 'No'
                        THEN
                            CONCAT(delivery_option,' (ភ្នំពេញ) ')
                        ELSE
                            CONCAT(delivery_option,' (ខេត្ត) ')
                        END
                    AS delivery_option_text
                from
                    nso007_export_stock as exs
                LEFT JOIN (
                    SELECT
                        dod.export_id as item_id,dod.delivery_order_id,
                        do.driver_name,do.driver_id,do.time_policy,do.delivery_date,
                        CASE WHEN do.time_policy = 1 THEN '(ព្រឹក)' ELSE '(ល្ងាច)' END as time_text,
                        dod.status_paid,dod.invoice_payment_id,dod.total_riel,dod.total_dollar,dod.amount_pay_to,dod.pay_to,
                        dod.reason
                    FROM
                        nso007_delivery_order_detail as dod
                    INNER JOIN
                        nso007_delivery_order  as do
                    ON
                        do.id = dod.delivery_order_id
                )
                as items
                ON
                    items.item_id = exs.id
                LEFT JOIN
                    nso007_discount
                ON
                    nso007_discount.id = exs.discount_id
                WHERE
                    items.status_paid IS NULL

            ) as nso007_export_stock"))
            ->when(request('status'),function($query) use ($status){
                if($status == 7){
                    $query->whereRaw('CASE WHEN nso007_export_stock.is_return_to_shop = 1 THEN nso007_export_stock.is_return_to_shop = 1 ELSE nso007_export_stock.status = 7 END');
                }else if ($status == 8){
                    $query->where('nso007_export_stock.status',7);
                    $query->where('nso007_export_stock.is_return_to_shop',0);
                }else{
                    $query->where('nso007_export_stock.status',$status);
                }
            })
            ->when($merchant,function($query) use ($merchant){
                $query->where('nso007_export_stock.merchant_id',$merchant);
            })
            ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                if($pro_or_city != null){
                    $operator = "!=";
                    if($pro_or_city != "No"){
                        $operator = "=";
                    }
                    $query->where('nso007_export_stock.delivery_option',$operator,"No");
                }
            })
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date,$status){
                if(!empty($from_date) && !empty($to_date) && $status == 1){
                    $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                }
                if(!empty($from_date) && !empty($to_date) && $status != 1 && $status != null){
                    $query->whereBetween('nso007_export_stock.delivery_date',[$from_date,$to_date]);
                }
            })
            ->orderBy('nso007_export_stock.updated_at', 'desc')->get();

        $merchants=DB::table('nso007_export_stock')
            ->join('users', 'users.id', 'nso007_export_stock.merchant_id')
                ->select('users.shop_name')->where('nso007_export_stock.merchant_id', $merchant)
                ->first();
        $content = view('administrator.export-stock.print-return-shop', compact('data','from_date','to_date','merchants'))->render();
        return response()->json(['success' => true, 'content' => $content]);
    }

    public function return_export_excel(Request $request){

        return Excel::download(new ReturnExport($request), 'Report-'.date('d-m-Y').'.xlsx');
    }

    public function update(Request $request, $box_code)
    {
        if (!$request->export_qty) {
            return redirect()->back()->with('danger', 'Please try again');
        }
        try {

            DB::beginTransaction();
            $this->validate($request, [
                'location'          => 'required',
                'customer_receive'  => 'required',
                'delivery_fee'      => 'required',
                'currency'          => 'required',
                'barcode.*'         => 'required',
                'export_qty.*'      => 'required|numeric',
                'total.*'           => 'required',
                'category_id'       => 'required',
                ]);

        $export = ExportStockModel::whereBox_code($box_code)->first();
        // $export->merchant_id           = $request->merchant_id;
        $export->delivery_fee          = $request->delivery_fee;
        $export->service_charge        = $request->service_charge;
        $export->from_location         = $request->from_location;
        $export->location              = $request->location;
        $export->customer_receive      = $request->customer_receive;
        $export->delivery_status       = $request->delivery_status;
        $export->delivery_option       = $request->delivery_option;
        $export->modify_by             = Auth::user()->id;
        $export->description           = $request->description;
        $export->type_of_stock           = 1; //export stock
        $export->delivery_pay_or_paid  = $request->pay_or_paid;
        $export->taxi_number           = $request->taxi_number;
        $export->taxi_status           = $request->taxi_status;
        $export->shop_name                     =  FindShop($request->merchant_id);
        $export->location_name                 =  FindLoaction($request->location);

        if($request->taxi_status==1){
            $export->taxi_shop_fee     = $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }else{
            $export->taxi_cust_fee     =  $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }
        $export->taxi_pay_or_paid      = $request->taxi_pay_or_paid;
        $export->other_services_fee    = $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $export->other_services_type   = $request->other_services_type;
        $export->other_services_pay_or_paid  = $request->other_services_pay_or_paid;
        update_status_by($box_code , '','edit_by');
       $total_product = 0;
        foreach ($request->price as $key1 => $value) {
            $total_product  += ($request->price[$key1] *  $request->export_qty[$key1] );
        }
        $export->total_product        = $total_product;
        $export->update();

        $data =  ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->where('nso007_export_stock.box_code', $box_code)
            ->select('nso007_export_stock.merchant_id', 'nso007_export_stock_details.barcode', 'nso007_export_stock_details.export_qty', 'nso007_export_stock.id AS export_stock_id')
            ->get();

        $data_ =  ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
        ->where('nso007_export_stock.box_code', $box_code)
        ->select(\DB::raw("SUM( nso007_export_stock_details.price *  nso007_export_stock_details.export_qty ) AS price"),
        'nso007_export_stock.*'
        )
        ->first();
        $export_stock_id =  $data[0]->export_stock_id;
        foreach ($data as $key => $datas) {
            StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->increment('stock_qty', $datas->export_qty);
            ExportStockdetailsMode::where('export_id', $datas->export_stock_id)->delete();
        }
        $price = 0;
        foreach ($request->barcode as $key => $value) {
            StockModel::where([['merchant_id', $request->merchant_id], ['barcode', $request->barcode[$key]]])->decrement('stock_qty', $request->export_qty[$key]);
            $exportdetails = array(
                'export_id'             =>  $export_stock_id,
                'barcode'               =>  $request->barcode[$key],
                'currency'              =>  $request->currency,
                'export_qty'            =>  $request->export_qty[$key],
                'price'                 =>  $request->price[$key],
                'category_id'           =>  $request->category_id[$key],
                'category_name'         =>   FindCategory($request->category_id[$key]),

            );
            $price +=  $request->price[$key] *$request->export_qty[$key] ;
            ExportStockdetailsMode::insert($exportdetails);
        }

            if ($data_->price != $price  || $data_->delivery_status != $request->delivery_status) {
                DeliveryOrderDetailModel::where('status',1)->where('export_id',$export->id)->update(['total_riel'=>0,'total_dollar'=>0]);
                DeliveryOrderDetailProccessingModel::where('status',1)->where('export_id',$export->id)->update(['total_riel'=>0,'total_dollar'=>0]);
            }

            session()->forget('get_product_session_edit');
            session()->forget('box_code');
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->route('export-stock.index')->with('sussess', 'Import was add already successfully!');
    }

    public function destroy($id)
    {
        //
    }
    public function get_show_product(Request $request)
    {

        if (!is_null(session()->get('session_show_product'))) {
            $session_id = session()->get('session_show_product');
            if ($session_id != $request->id) {
                session()->forget('get_product_session');
            }
        }
        session()->put('session_show_product', $request->id);
        $stock = StockModel::where('merchant_id', $request->id)->where('nos007__stocks.stock_qty', '>', 0)
            ->join('nso007_products', 'nso007_products.barcode', 'nos007__stocks.barcode');

        if (\Globals::check_lang() == 'en') {
            $stock = $stock->select('nso007_products.name_en as name', 'nso007_products.image', 'nso007_products.barcode', 'nos007__stocks.stock_qty')->get();
        } else {
            $stock = $stock->select('nso007_products.name_km as name', 'nso007_products.image', 'nso007_products.barcode', 'nos007__stocks.stock_qty')->get();
        }
        $tr = '';
        foreach ($stock as $id => $stocks) {
            $img = (empty($stocks->image) ? 'default-product.jpg' : $stocks->image);
            $tr .= '
            <div class="col-sm-3 col-xs-6 paddin-5">
                <div class="item-show">
                    <a class="add-product cursor" data-id="' . $stocks->barcode . '" data-merchant="' . $request->id . '">
                        <img src="' . asset("/images/upload/$img") . '">
                        <span class="item-show-name">
                            ' .  ($stocks->name) . '
                        </span>
                        <span class="item-show-name">
                            Quality : ' . $stocks->stock_qty . '
                        </span>
                    </a>
                </div>
            </div>
            ';
        }
        echo $tr;
    }
    public function get_product(Request $request)
    {
        $stock = StockModel::join('nso007_products', 'nso007_products.barcode', 'nos007__stocks.barcode')
            ->join('nso007_category', 'nso007_category.id', 'nso007_products.category_id')
            ->where('nos007__stocks.stock_qty', '>', 0)
            ->where('merchant_id', $request->merchant)
            ->where('nso007_products.barcode', $request->id);


        if (\Globals::check_lang() == 'en') {
            $stock = $stock->select('nos007__stocks.stock_qty', 'nso007_products.*', 'nso007_products.name_en AS product_name', 'nso007_products.*', 'nso007_category.id AS category_id', 'nso007_category.name_en AS category_name', 'nso007_category.*')->first();
        } else {
            $stock = $stock->select('nos007__stocks.stock_qty', 'nso007_products.*', 'nso007_products.name_km AS product_name', 'nso007_products.*', 'nso007_category.id AS category_id', 'nso007_category.name_km AS category_name', 'nso007_category.*')->first();
        }

        $get_product_session = session()->get('get_product_session');
        $status = '';
        if (!$stock) {
            $status = 'Product Code is Incorrect !';
        } else {
            if (isset($get_product_session[$request->id])) {
                session()->put('get_product_session', $get_product_session);
                $status = 'already';
            } else {
                $get_product_session[$request->id] = [
                    "barcode"               => $stock->barcode,
                    "name_km"               => $stock->product_name,
                    "category_name"         => $stock->category_name,
                    "qty"                   => 1,
                    "price"                 => $stock->price,
                    "total"                 => $stock->price,
                    "stock_qty"             => $stock->stock_qty,
                    "category_id"           => $stock->category_id,
                ];
                session()->put('get_product_session', $get_product_session);
                $status = 'success';
            }
        }
        echo $status;
    }
    public function get_product_view_list()
    {


        $tr = '';
        $i = 0;
        foreach (session('get_product_session') as $id => $stock) {
            $i++;
            $tr .= '
            <tr >
                <td width="5%" class="no">' . $i . '</td>
                <td  width="16%">
                    <input type="text" class="form-control barcode" name="barcode[]" value="' . $stock['barcode'] . '" readonly>
                </td>
                <td  width="16%">
                    <input type="text" class="form-control name_km all_key " name="name_km[]"  value="' . $stock['name_km'] . '" readonly>
                    <input type="hidden" class="category_id" name="category_id[]" value="' . $stock['category_id'] . '" required>
                </td>
                <td  width="16%">
                    <input type="text" class="form-control category_name" name="category_name[]" value="' . $stock['category_name'] . '" readonly>
                </td>
                <td width="16%">
                    <input type="number" class="form-control qty number-only all_key" name="export_qty[]" value="' . $stock['qty'] . '" required>
                    <input type="hidden" class="form-control stock_qty number-only all_key" name="stock_qty[]" value="' . $stock['stock_qty'] . '" required>
                </td>
                <td width="16%">
                    <input type="number" class="form-control price number-only all_key" name="price[]" value="' . $stock['price'] . '" step=any required>
                </td>
                <td width="14%">
                    <input type="text" class="form-control total" name="total[]"  value="' . $stock['total'] . '" readonly>
                </td>
                <td width="9%">
                    <a class="btn-remove" data-id="' . $stock['barcode'] . '" ><span class="fa fa-close fa-2x  text-red"></span></a>
                </td>
            </tr>

            ';
        }
        echo $tr;
    }

    public function export_stock_removecart(Request $request)
    {
        session()->forget('get_product_session.' . $request->id);
        return \redirect()->back();
    }

    public function update_all(Request $request)
    {
        $get_product_session = session()->get('get_product_session');
        $i = 0;

        if (count($get_product_session) != 0) {
            foreach ($get_product_session as $key => $data) {
                $get_product_session[$key]['barcode'] = $request->barcode[$i];
                $get_product_session[$key]['name_km'] = $request->name_km[$i];
                $get_product_session[$key]['category_name'] = $request->category_name[$i];
                $get_product_session[$key]['qty'] = $request->qty[$i];
                $get_product_session[$key]['price'] = $request->price[$i];
                $get_product_session[$key]['total'] = $request->total[$i];
                $get_product_session[$key]['stock_qty'] = $request->stock_qty[$i];
                $get_product_session[$key]['category_id'] = $request->category_id[$i];

                session()->put('get_product_session', $get_product_session);
                $i++;
            }
        } else {
            return false;
        }
    }

    public function find_location(Request $request)
    {
        $loc_id_array = array();
        $find_loc = LocationModel::whereId($request->id)->first();
            if (empty($request->id)) {
                $from_location = LocationModel::where('status', 1)
                    ->where('type', 'zone')
                    ->when('no zone', function ($q) use ($request) {
                        if ($request->choose_opt == "ខេត្ត") {
                            $q->where('name_en', 'Province');
                        } else {
                            $q->where('name_en', '!=', 'Province');
                        }
                    })
                    ->select('nso007_location.name_en AS name', 'id', 'location_id');

                    $zone_location = $from_location->pluck('location_id');
                    foreach($zone_location as $key=>$val){
                        foreach(explode(',',$val) as $loc_id){
                            if($loc_id){
                                array_push($loc_id_array,$loc_id);
                            }
                        }
                    }
            }
        $location = LocationModel::where('status', 1)//->where('pearent_id', $request->id);
            ->when($find_loc,function($q) use($find_loc){
                $q->whereIn('id',$find_loc->location_id ? explode(',',$find_loc->location_id) : [] );
            });

            // ->where(function($query) use ($request){
            //     if($request->id != ''){
            //         $query->where('pearent_id', $request->id);
            //     }
            // });
        // $location = [];
        $current_location = LocationModel::where(function($query) use ($request){
                    if($request->id != ''){
                        $query->where('id', $request->id);
                    }
                });
        // if(empty($request->id))[

        // ]
        // dd($current_location->get());
        if (\Globals::check_lang() == 'en') {
            $location = $location
                ->where('type','location')
                ->when($loc_id_array,function($q) use($loc_id_array){
                    $q->whereIn('id',is_array($loc_id_array) ? $loc_id_array : ["no"]);
                })
                // ->whereIn('id',$loc_id_array)
                ->select('nso007_location.*','nso007_location.name_en AS name', 'id')->get();
        }else{
            $location = $location
                ->where('type','location')
                ->when($loc_id_array,function($q) use($loc_id_array){
                    $q->whereIn('id',is_array($loc_id_array) ? $loc_id_array : ["no"]);
                })
                // ->whereIn('id',$loc_id_array)
                ->select('nso007_location.*','nso007_location.name_km AS name', 'id')->get();
        }
        return $location;
    }

    public function find_price_location(Request $request)
    {
        $data = LocationModel::find($request->id);
        $find_parent = LocationModel::WhereRaw('FIND_IN_SET('.$data->id.',location_id)')->first();
        if($data) {
            if($data->currency_symbol == '៛'){
                $rate = currency() ? currency()->currency_exchange_to : 4000;
            }
            if($data->currency_symbol == '$'){
                $rate = currency() ? currency()->currency_main : 1;
            }
            return [
                'zone'=>$find_parent ? $find_parent->id : 0,'price'=>$data->price,'symbol'=>$data->currency_symbol,'rate'=>$rate
            ];
        }
        return [
            'zone'=>'','price'=>'','symbol'=>'$','rate'=>1
        ];
        $price = $data->price;
        return $price;
    }
    // -----------------------Export Edit  ---------------------------
    public function edit($id)
    {
        $data   = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->join('nso007_products', 'nso007_products.barcode', 'nso007_export_stock_details.barcode')
            ->join('nso007_category', 'nso007_category.id', 'nso007_products.category_id')
            ->where('nso007_export_stock_details.export_id', $id);

        if (\Globals::check_lang() == 'en') {
            $data = $data->select(
                'nso007_export_stock_details.*',
                'nso007_products.name_en AS product_name',
                'nso007_products.category_id',
                'nso007_category.name_en AS category_name',
                'nso007_export_stock.*'
            )->get();
        } else {
            $data = $data->select(
                'nso007_export_stock_details.*',
                'nso007_products.name_km AS product_name',
                'nso007_products.category_id',
                'nso007_category.name_km AS category_name',
                'nso007_export_stock.*'
            )->get();
        }

        if (!empty(session()->get("box_code"))) {      // មាន​ box Code
            $session_id = session()->get('box_code');
            if ($session_id != $data[0]->box_code) {       // box Code   ==  box Code អត់​​
                session()->forget('box_code');
                session()->forget('get_product_session_edit');
                if (empty(session()->get('get_product_session_edit'))) {
                    foreach ($data as $key => $datas) {
                        $stock = StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->first();
                        $get_product_session_edit[$datas->barcode] = [
                            "barcode"               => $datas->barcode,
                            "name_km"               => $datas->product_name,
                            "category_name"         => $datas->category_name,
                            "qty"                   => $datas->export_qty,
                            "price"                 => $datas->price,
                            "total"                 => $datas->export_qty * $datas->price,
                            "stock_qty"             => $stock->stock_qty,
                            "category_id"           => $datas->category_id,
                        ];
                        session()->put('get_product_session_edit', $get_product_session_edit);
                    }
                }
                session()->put('box_code', $data[0]->box_code);
            }
        } else {
            if (empty(session()->get('get_product_session_edit'))) {
                foreach ($data as $key => $datas) {
                    $stock = StockModel::where([['merchant_id', $datas->merchant_id], ['barcode', $datas->barcode]])->first();
                    $get_product_session_edit[$datas->barcode] = [
                        "barcode"               => $datas->barcode,
                        "name_km"               => $datas->product_name,
                        "category_name"         => $datas->category_name,
                        "qty"                   => $datas->export_qty,
                        "price"                 => $datas->price,
                        "total"                 => $datas->export_qty * $datas->price,
                        "stock_qty"             => $stock->stock_qty,
                        "category_id"           => $datas->category_id,
                    ];
                    session()->put('get_product_session_edit', $get_product_session_edit);
                }
            }
            session()->put('box_code', $data[0]->box_code);
        }
        $bus = DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->prepend($data[0]->delivery_option, $data[0]->delivery_option)->toArray();
        $merchant = User::where('user_type', 3)->where('status', 1)->where('type_of_merchant', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $drivers = User::where('user_type', 2)->where('status', 0)->pluck('name', 'id')->prepend('Please Select', '')->toArray();
        $from_location = LocationModel::where('status', 1)->where('pearent_id', null);
        $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null);
        if (\Globals::check_lang() == 'en') {
            $from_location = $from_location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
        } else {
            $from_location = $from_location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
        }
        $exchang_rate = CurrencyModel::find(1);
        return \view('administrator.export-stock.edit', compact('drivers', 'merchant', 'from_location', 'location', 'exchang_rate', 'data', 'bus'));
    }

    public function get_show_product_edit(Request $request)
    {
        if (!is_null(session()->get('session_show_product_edit'))) {
            $session_id = session()->get('session_show_product_edit');
            if ($session_id != $request->id) {
                session()->forget('get_product_session');
            }
        }

        session()->put('session_show_product_edit', $request->id);
        $stock = StockModel::where('merchant_id', $request->id)->where('nos007__stocks.stock_qty', '>', 0)
            ->join('nso007_products', 'nso007_products.barcode', 'nos007__stocks.barcode');
        if (\Globals::check_lang() == 'en') {
            $stock = $stock->select('nso007_products.name_en as name', 'nso007_products.image', 'nso007_products.barcode', 'nos007__stocks.stock_qty')->get();
        } else {
            $stock = $stock->select('nso007_products.name_km as name', 'nso007_products.image', 'nso007_products.barcode', 'nos007__stocks.stock_qty')->get();
        }
        $tr = '';
        foreach ($stock as $id => $stocks) {
            $img = (empty($stocks->image) ? 'default-product.jpg' : $stocks->image);
            $tr .= '
            <div class="col-sm-3 col-xs-6 paddin-5">
                <div class="item-show">
                    <a class="add-product cursor" data-id="' . $stocks->barcode . '" data-merchant="' . $request->id . '">
                        <img src="' . asset("/images/upload/$img") . '">
                        <span class="item-show-name">
                            ' . ($stocks->name) . '
                        </span>
                        <span class="item-show-name">
                            Quality : ' . $stocks->stock_qty . '
                        </span>
                    </a>
                </div>
            </div>
            ';
        }
        echo $tr;
    }

    public function get_product_view_list_edit()
    {
        // dd(session()->get('get_product_session_edit'));
        $tr = '';
        $i = 0;
        foreach (session('get_product_session_edit') as $id => $stock) {
            $stock_qty = $stock['stock_qty'] + $stock['qty'];
            $i++;
            $tr .= '
            <tr >
                <td width="5%" class="no">' . $i . '</td>
                <td  width="16%">
                    <input type="text"   class="form-control barcode" name="barcode[]" value="' . $stock['barcode'] . '" readonly>
                </td>
                <td  width="16%">
                    <input type="text" class="form-control name_km all_key " name="name_km[]" value="' . $stock['name_km'] . '" readonly>
                </td>
                <td  width="16%">
                    <input type="text" class="form-control category_name" name="category_name[]" value="' . $stock['category_name'] . '" readonly>
                </td>
                <td width="16%">
                    <input type="number" class="form-control qty number-only all_key" name="export_qty[]" value="' . $stock['qty'] . '" required>
                    <input type="hidden" class="form-control stock_qty number-only all_key" name="stock_qty[]" value="' . $stock_qty . '" required>
                    <input type="hidden" class="form-control category_id number-only all_key" name="category_id[]" value="' . $stock['category_id'] . '" required>
                </td>
                <td width="16%">
                    <input type="number" class="form-control price number-only all_key" name="price[]" value="' . $stock['price'] . '" step=any required>
                </td>
                <td width="14%">
                    <input type="text" class="form-control total" name="total[]"  value="' . $stock['total'] . '" readonly>
                </td>
                <td width="9%">
                    <a class="btn-remove" data-id="' . $stock['barcode'] . '" ><span class="fa fa-close fa-2x  text-red"></span></a>
                </td>
            </tr>

            ';
        }
        echo $tr;
    }
    public function get_product_edit(Request $request)
    {
        $stock = StockModel::join('nso007_products', 'nso007_products.barcode', 'nos007__stocks.barcode')
            ->join('nso007_category', 'nso007_category.id', 'nso007_products.category_id')
            ->where('nos007__stocks.stock_qty', '>', 0)
            ->where('merchant_id', $request->merchant)
            ->where('nso007_products.barcode', $request->id);

        if (\Globals::check_lang() == 'en') {
            $stock = $stock->select('nos007__stocks.stock_qty', 'nso007_products.*', 'nso007_products.name_en AS product_name', 'nso007_products.*', 'nso007_category.name_en AS category_name', 'nso007_category.*')->first();
        } else {
            $stock = $stock->select('nos007__stocks.stock_qty', 'nso007_products.*', 'nso007_products.name_km AS product_name', 'nso007_products.*', 'nso007_category.name_km AS category_name', 'nso007_category.*')->first();
        }
        $get_product_session_edit = session()->get('get_product_session_edit');
        $status = '';
        if (!$stock) {
            $status = 'Product Code is Incorrect !';
        } else {
            if (isset($get_product_session_edit[$request->id])) {
                session()->put('get_product_session_edit', $get_product_session_edit);
                $status = 'already';
            } else {
                $get_product_session_edit[$request->id] = [
                    "barcode"               => $stock->barcode,
                    "name_km"               => $stock->name_km,
                    "category_name"         => $stock->category_name,
                    "qty"                   => 0,
                    "price"                 => $stock->price,
                    "total"                 => 0,
                    "stock_qty"             => $stock->stock_qty,
                    "category_id"             => $stock->category_id,
                ];
                session()->put('get_product_session_edit', $get_product_session_edit);
                $status = 'success';
            }
        }
        echo $status;
    }

    public function export_stock_removecart_edit(Request $request)
    {
        // dd(session()->forget('get_product_session_edit'));
        session()->forget('get_product_session_edit.' . $request->id);
        return \redirect()->back();
    }
    public function update_all_edit(Request $request)
    {
        $get_product_session_edit = session()->get('get_product_session_edit');
        $i = 0;

        if (count($get_product_session_edit) != 0) {
            foreach ($get_product_session_edit as $key => $data) {
                $get_product_session_edit[$key]['barcode'] = $request->barcode[$i];
                $get_product_session_edit[$key]['name_km'] = $request->name_km[$i];
                $get_product_session_edit[$key]['category_name'] = $request->category_name[$i];
                $get_product_session_edit[$key]['qty'] = $request->qty[$i];
                $get_product_session_edit[$key]['price'] = $request->price[$i];
                $get_product_session_edit[$key]['total'] = $request->total[$i];
                $get_product_session_edit[$key]['stock_qty'] = $request->stock_qty[$i];
                $get_product_session_edit[$key]['category_id'] = $request->category_id[$i];

                session()->put('get_product_session_edit', $get_product_session_edit);
                $i++;
            }
        } else {
            return false;
        }
    }

    function back_bage(Request $request){
        session()->put('back_bage', $request->status);

    }

    function deleteBox($id,$status){

        try{
            DB::beginTransaction();
                if($status == 'export_list'){
                    $export_data = ExportStockModel::find($id);
                    if($export_data->type_of_stock == 1 ){   // export stock
                        $ExportStockdetails =  ExportStockdetailsMode::where('export_id',$export_data->id)->get();
                        foreach ($ExportStockdetails as $key => $value) {
                            $stock = StockModel::whereBarcode($value->barcode)->first();
                            $stock->stock_qty   = $stock->stock_qty  + $value->export_qty ;
                            $stock->update();
                            $value->delete();
                        }
                        $export_data->delete();
                    }else{  //  out stock
                        ExportStockdetailsMode::where('export_id',$export_data->id)->delete();
                        $export_data->delete();
                    }
                }else{  //1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel  ,5= paid
                    $delivery_order_detail_id = DeliveryOrderDetailModel::find($id);

                    if($delivery_order_detail_id->status  == 1){            //  Processing
                    DeliveryOrderDetailProccessingModel::where('delivery_order_id',$delivery_order_detail_id->delivery_order_id)
                                            ->where('export_id',$delivery_order_detail_id->export_id)
                                            ->delete() ;
                    }else if($delivery_order_detail_id->status  == 2){      //2 = Padding
                    DeliveryOrderDetailPaddingModel::where('delivery_order_id',$delivery_order_detail_id->delivery_order_id)
                                            ->where('export_id',$delivery_order_detail_id->export_id)
                                            ->delete() ;
                    }else if($delivery_order_detail_id->status  == 3){      //3 = Done
                    DeliveryOrderDetailSuccessModel::where('delivery_order_id',$delivery_order_detail_id->delivery_order_id)
                                                    ->where('export_id',$delivery_order_detail_id->export_id)
                                                    ->delete() ;
                    }
                    else if($delivery_order_detail_id->status  == 4){      //3 = Cancel
                    DeliveryOrderDetailCancelModel::where('delivery_order_id',$delivery_order_detail_id->delivery_order_id)
                                                    ->where('export_id',$delivery_order_detail_id->export_id)
                                                    ->delete() ;
                    }


                    $export_data = ExportStockModel::find($delivery_order_detail_id->export_id);

                    if($export_data->type_of_stock == 1 ){   // export stock
                        $ExportStockdetails =  ExportStockdetailsMode::where('export_id',$export_data->id)->get();
                        foreach ($ExportStockdetails as $key => $value) {
                            $stock = StockModel::whereBarcode($value->barcode)->first();
                            $stock->stock_qty   = $stock->stock_qty  + $value->export_qty ;
                            $stock->update();
                            $value->delete();
                        }
                        $export_data->delete();
                    }else{  //  out stock
                        ExportStockdetailsMode::where('export_id',$export_data->id)->delete();
                        $export_data->delete();
                    }
                }
            DB::commit();
            return response()->json(['success' => true]);
        }
        catch(Exception $e){
            DB::rollBack();
            return response()->json(['success' => false,'error' => $e->getMessage()]);
        }
    }


}
