<?php

namespace App\Http\Controllers\Administrator;

use App\DeliveryOrderDetailModel;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use App\Helpers\Globals;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Gate;
use Yajra\DataTables\Facades\DataTables;

class DeliveryListController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;

        if ($request->ajax()) {
            $data = ExportStockdetailsMode::join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
                ->select(
                    'nso007_export_stock.*',
                    'nso007_export_stock.id AS export_stock_id',
                    'nso007_export_stock_details.category_id',
                    'nso007_export_stock_details.currency',
                    'nso007_export_stock_details.category_name',
                    DB::raw("SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS total_price")
                )
                ->where('nso007_export_stock.type_of_stock',1)
                ->groupBy('nso007_export_stock.box_code')
                ->where(function ($query) {
                    if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                        $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                    }
                })

                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_export_stock.status',explode(',', $status_1));
                    }
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                })
                ->where(function($query) use ($merchant){

                    if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                        $query->where('merchant_id',\Auth::user()->id);
                    }else if(\Globals::is_Driver() == 'Driver'){
                        $query->where('nso007_export_stock.merchant_id',\Auth::user()->id);
                    }else{
                        $query->where('merchant_id','LIKE',$merchant);
                    }
                })
                ->orderBy('nso007_export_stock.box_code', 'desc');
            return  DataTables::of($data)
                ->editColumn('export_date', function ($data) {
                    return    date_format($data->created_at ,"d/m/Y H:iA"); ;// date('d/m/Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paiddelete
                    $edit​​ = '';
                    $delete = '';
                    if ($data->status == 1 || $data->status == 2) {
                        if ($data->type_of_stock == 1) {
                            $edit = '<a href="' . route("export-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                        } else {
                            $edit = '<a href="' . route("out-stock-new.edit", $data->export_stock_id) . '" class="button_primary fa fa-edit"></a>';
                        }

                    } else {
                        $edit = '<a href="#" class="button_dark fa fa-edit"></a>';
                    }


                    if ($data->status == 1 ) {
                        if(Gate::check('Export List Delete Box')){
                            $delete = '<a data-href="' . route("export_stock_delete_box", [$data->export_stock_id,'export_list']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                        }
                    } else {
                        $delete = '<a data-href="#" class="button_dark fa fa-trash   " ></a>';
                    }


                    return $delete .'
                        <a data-href="' . route("export-stock.show", $data->export_stock_id) . '" class="button_warning fa fa-print bt-print"></a>
                        ' . $edit;
                })
                ->editColumn('status', function ($data) {
                    if ($data->status == 1)          // 1 = default,
                        return ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>';
                    else if ($data->status == 2)     // 2 = proccess,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>';
                    else if ($data->status == 3)     // 2 = done,
                        return ' <strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>';
                    else if ($data->status == 4)     // 2 = padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>';
                    else    // 5 = cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>';
                })
                ->editColumn('total_price', function ($data) {
                    if($data->total_product_symbol == '$'){
                        return  "$" . (number_format($data->total_price,2));
                    }
                    if ($data->total_product_symbol == '៛') {
                        return $data->total_price.'៛';
                    }
                })

                ->addColumn('driver_name', function ($data) {
                    if ($data->status == 1)
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    else
                        $delivery = DeliveryOrderDetailModel::join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id')
                            ->where('export_id',$data->id)
                            ->select('nso007_delivery_order.driver_id','nso007_delivery_order.driver_name','nso007_delivery_order.time_policy')
                            ->get()->last();
                        $text = '';
                            if($delivery->time_policy == "1")
                                $text = "(ព្រឹក)";
                            else
                                $text = "(ល្ងាច)";

                        return '<button type="button" class="btn btn-primary btn-sm change-driver" data-time="'.$delivery->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$delivery->driver_id.'">'.$delivery->driver_name.''.$text.'</button>';
                })

                ->editColumn('modify_by', function ($data) {
                    return  isset($data->modify_by) ? $data->modify_by : null;
                })
                ->editColumn('delivery_date', function ($data) {
                    return  date('d/m/Y', strtotime($data->date_delivery));
                })
                ->editColumn('delivery_fee', function ($data) {
                    if($data->delivery_fee_symbol == '$'){
                        return  "$" . (number_format($data->delivery_fee,2));
                    }
                    if ($data->delivery_fee_symbol == '៛') {
                        return $data->delivery_fee.'៛';
                    }
                })
                ->editColumn('delivery_option', function ($data) {
                    $text = "ខេត្ត";
                    if($data->delivery_option == "No"){
                        $text = "ភ្នំពេញ";
                    }
                    return $data->delivery_option.' ('.$text.')';
                })

                ->editColumn('action_by', function ($data) {
                    return  '';
                })

                ->addColumn('share_link',function($data){
                    if( request()->merchant && $data->status != 1){
                        return '<input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->export_stock_id.'"  >';
                    }
                })
                ->rawColumns(['status' => 'status','share_link'=>'share_link','driver_name'=>'driver_name'])
                ->addIndexColumn()
                ->make(true);
        }
        return \view('administrator.delivery-list.index',compact( 'merchant_show'));
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function list_new(Request $request){
        $merchant_show = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $from_date      =   empty($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date        =   empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant       =   isset($request->merchant)?$request->merchant:null;
        $status         =   isset($request->status)?$request->status:null ;
        $pro_or_city    =   isset($request->pro_or_city)?$request->pro_or_city:null ;
        if($request->ajax()){
            $data = DB::table(DB::raw("(
                SELECT
                exs.id,exs.box_code,exs.export_date,exs.status,exs.type_of_stock,exs.id as export_id,
                exs.date_delivery,exs.total_product_symbol,exs.delivery_fee_symbol,
                exs.delivery_fee,exs.shop_name,exs.customer_receive,exs.location_name,
                exs.delivery_fee_rate,exs.delivery_pay_or_paid,exs.other_services_fee,
                exs.total_product_rate,exs.total_product_status,exs.delivery_status,
                exs.delivery_option,exs.taxi_status,exs.taxi_shop_fee,exs.taxi_cust_fee,
                exs.taxi_number,exs.extra_fee,exs.extra_fee_type,exs.driver_note,exs.merchant_id,exs.rate,
                exs.taxi_fee_symbol,exs.updated_at,exs.description,exs.total_product as total_price,
                exs.is_return_to_shop,
                nso007_discount.discount_type,nso007_discount.discount,items.*,
                    CASE
                        WHEN
                            delivery_option = 'No'
                        THEN
                            CONCAT(delivery_option,' (ភ្នំពេញ) ')
                        ELSE
                            CONCAT(delivery_option,' (ខេត្ត) ')
                        END
                    AS delivery_option_text
                from
                    nso007_export_stock as exs
                LEFT JOIN (
                    SELECT
                        dod.export_id as item_id,dod.delivery_order_id,
                        do.driver_name,do.driver_id,do.time_policy,do.delivery_date,
                        CASE WHEN do.time_policy = 1 THEN '(ព្រឹក)' ELSE '(ល្ងាច)' END as time_text,
                        dod.status_paid,dod.invoice_payment_id,dod.total_riel,dod.total_dollar,dod.amount_pay_to,dod.pay_to,
                        dod.reason
                    FROM
                        nso007_delivery_order_detail as dod
                    INNER JOIN
                        nso007_delivery_order  as do
                    ON
                        do.id = dod.delivery_order_id
                )
                as items
                ON
                    items.item_id = exs.id
                LEFT JOIN
                    nso007_discount
                ON
                    nso007_discount.id = exs.discount_id
                WHERE
                    items.status_paid IS NULL

            ) as nso007_export_stock"))
                ->when(request('status'),function($query) use ($status){
                        if($status == 7){
                            $query->whereRaw('CASE WHEN nso007_export_stock.is_return_to_shop = 1 THEN nso007_export_stock.is_return_to_shop = 1 ELSE nso007_export_stock.status = 7 END');
                        }else if ($status == 8){
                            $query->where('nso007_export_stock.status',7);
                            $query->where('nso007_export_stock.is_return_to_shop',0);
                        }else{
                            $query->where('nso007_export_stock.status',$status);
                        }
                })
                ->when($merchant,function($query) use ($merchant){
                        $query->where('nso007_export_stock.merchant_id',$merchant);
                })
                ->when(request('pro_or_city'),function($query) use ($pro_or_city){
                    if($pro_or_city != null){
                        $operator = "!=";
                        if($pro_or_city != "No"){
                            $operator = "=";
                        }
                        $query->where('nso007_export_stock.delivery_option',$operator,"No");
                    }
                })
                ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date,$status){
                    if(!empty($from_date) && !empty($to_date) && $status == 1){
                        $query->whereBetween('nso007_export_stock.export_date',[$from_date,$to_date]);
                    }
                    if(!empty($from_date) && !empty($to_date) && $status != 1 && $status != null){
                        $query->whereBetween('nso007_export_stock.delivery_date',[$from_date,$to_date]);
                    }
                })
                ->orderBy('nso007_export_stock.updated_at', 'desc');
            return DataTables::of($data)
                ->addColumn('driver_name', function ($data) {

                    if($data->driver_id){
                        $change_driver_class = $data->status == 1 || $data->status == 2 ? "change-driver" : '';
                        return '<button type="button" class="btn btn-primary btn-sm '.$change_driver_class.'" data-time="'.$data->time_policy.'"  data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="'.$data->driver_id.'">'.$data->driver_name.'</button>';
                    }else{
                        return '<button type="button" class="btn btn-danger btn-sm change-driver"   data-delivery_date="'.$data->date_delivery.'"  data-export_id="'.$data->id.'" data-driver_id="">No Driver Yet</button>';
                    }
                })
                ->addColumn("checkall",function($data){

                    return '
                    <div class="form-check">
                        <input class="form-check-input check-export-id" type="checkbox" value="'.$data->id.'" data-status="'.$data->status.'" id="flexCheckDefault">
                        <label class="form-check-label" for="flexCheckDefault">
                        </label>
                    </div>
                    ';
                })
                ->editColumn('total_price', function ($data) {
                    return @Globals::currency_render($data->total_product_symbol,$data->total_price)??null;
                })
                ->editColumn('delivery_fee', function ($data) {
                    return @Globals::currency_render($data->delivery_fee_symbol,$data->delivery_fee)??null;
                })
                ->editColumn('delivery_option', function ($data) {
                    return @$data->delivery_option_text??null;
                })
                ->editColumn('status', function ($data) {
                    return Globals::status_render($data->status);
                })
                ->addColumn('action', function ($data) {
                    // 1 = default , 2 = proccess,  3 = done , 4 = padding , 5 = cancel  , 6 = paid , 7 = return to shop
                    $action = '';
                    if($data->status == 2){
                        if ($data->discount_type != null || $data->discount_type != '') {
                            if ($data->discount_type == 1) {
                                $delivery_fee = (float)$data->discount;
                            } elseif ($data->discount_type == 2) {
                                $delivery_fee = ((100 -  (float)$data->discount) * (float)$data->delivery_fee / (float)$data->delivery_fee_rate) / 100;
                            } else {
                                $delivery_fee = (float)$data->delivery_fee / (float)$data->delivery_fee_rate;
                            }
                        } else {
                            $delivery_fee  =  (float)$data->delivery_fee / (float)$data->delivery_fee_rate;
                        }

                        if ($data->delivery_pay_or_paid == 'paid') {
                            $delivery_fee  =  0;
                        }

                        $other_services_fee =  0;
                        if ($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2) {
                            $other_services_fee = (float)$data->other_services_fee;
                        }
                        $total_price = (float)$data->total_price / (float)$data->total_product_rate;
                        if ($data->total_product_status == 2) {
                            $total_price = 0;
                        }
                        if ($data->delivery_status == 2) {
                            $price = (float)$delivery_fee + (float)$total_price + (float)$other_services_fee;
                        } else {
                            $price = (float)$total_price +  (float)$other_services_fee;
                        }
                        $price_riel = $price * (currency() ? currency()->currency_exchange_to : 4000);
                        $edit = '
                            <label class="btn_sm button_warning bt_pending" data-status="'.$data->status.'" data-export_id="' . $data->export_id . '">' . __('administrator.pending') . '</label>
                            <label class="btn_sm button_danger bt_cencel" data-status="'.$data->status.'" data-export_id="' . $data->export_id . '" >' . __('administrator.cancel') . '</label>
                            <label class="btn_sm button_primary edit_price_of_car"
                            data-export_id              ="' . $data->export_id . '"
                            data-price                  ="' . $price . '"​​
                            data-delivery_option        ="' . $data->delivery_option . '"​​
                            data-taxi_status            ="' . $data->taxi_status . '"
                            data-taxi_shop_fee          ="' . $data->taxi_shop_fee . '"
                            data-taxi_cust_fee          ="' . $data->taxi_cust_fee . '"​​
                            data-taxi_number            ="' . $data->taxi_number . '"
                            data-total_riel             ="' . $data->total_riel . '"
                            data-total_dollar           ="' . $data->total_dollar . '"​​
                            data-extra_fee              ="' . $data->extra_fee . '"​​
                            data-extra_fee_type         ="' . $data->extra_fee_type . '"​​
                            data-driver_note            ="' . $data->driver_note . '"​​
                            data-user_currency          ="' . (User::find($data->merchant_id)->user_currency) . '"​​
                            data-amount_pay_to          ="' . $data->amount_pay_to . '"​​
                            data-pay_to                 ="' . $data->pay_to . '"
                            data-rate                   ="' . $data->rate . '"
                            data-taxi_fee_symbol        ="' . $data->taxi_fee_symbol . '"



                                >' . __('administrator.edit_delivey') . '</label>';
                        return $edit;
                    }
                    if($data->status == 3){
                        $action = '';
                        if (!$data->status_paid) {
                            if ($data->status_paid != 'paid' &&  $data->invoice_payment_id == null) {
                                $action = '
                                        <label class="btn btn-info btn-xs return_to_inpro" data-status="'.$data->status.'"  data-export_id="' . $data->export_id . '" ><span class=" fa fa-share-square"> ' . __('administrator.back_to_process') . '</span></label>
                                    ';
                            }
                        }
                        return    $action;
                    }
                    if($data->status == 4){
                        $return_to_order = '<li><a class="bt_add_to_stock fa fa-undo" data-export_id="' . $data->export_id . '" >&nbsp;' . 'Return To Order' . '</a></li>';
                        $return_to_proccess = '
                            <li><a class="return_to_inpro fa fa-undo" data-status="' . $data->status . '" data-export_id="' . $data->export_id . '" >&nbsp;' . __('administrator.back_to_process') . '</a></li>
                        ';
                        if($data->is_return_to_shop==0){
                            $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-type="request" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                        }
                        if($data->is_return_to_shop==1){
                            $return_to_proccess = "";
                            $return_to_order = "";
                            $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-reason="'.$data->reason.'" data-type="approve" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Approve Return To Shop'.'</a></li>';
                        }
                            return '
                            <div class="dropdown">
                                <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">' . __('administrator.action') . '
                                <span class="caret"></span></button>
                                <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                                ' . $return_to_proccess . $return_to_order . $return_to_shop. '
                                </ul>
                            </div>
                            ';
                    }
                    if($data->status == 5){
                        $action = '';
                        $return_to_proccess = '
                            <li><a class="return_to_inpro fa fa-undo" data-status="' . $data->status . '" data-export_id="' . $data->export_id . '" >&nbsp;' . __('administrator.back_to_process') . '</a></li>
                        ';
                            if (date('Y-m-d H:i:s') <= date('Y-m-d H:i:s', strtotime("+3 day", strtotime($data->updated_at))) && $data->status_paid != 'paid') {
                                if($data->is_return_to_shop==0){
                                    $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-type="request" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Return To Shop'.'</a></li>';
                                }
                                if($data->is_return_to_shop==1){
                                    $return_to_proccess = "";
                                    $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-reason="'.$data->reason.'" data-type="approve" data-status="'.$data->status.'" data-export_id="'.$data->id.'" >&nbsp;'. 'Approve Return To Shop'.'</a></li>';
                                }
                                $action = $return_to_proccess . $return_to_shop;
                            }
                            return '
                        <div class="dropdown">
                            <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">' . __('administrator.action') . '
                            <span class="caret"></span></button>
                            <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                            ' . $action . '
                            </ul>
                        </div>
                        ';
                    }
                    if($data->status == 7){
                            $action = '
                                <label class="btn btn-info btn-xs return_to_inpro" data-status="'.$data->status.'"  data-export_id="' . $data->export_id . '" ><span class=" fa fa-share-square"> ' . __('administrator.back_to_process') . '</span></label>
                            ';
                        return $action;
                    }
                    if($data->status == 8){
                            $action = '
                                <label class="btn btn-info btn-xs return_to_inpro" data-status="'.$data->status.'"  data-export_id="' . $data->export_id . '" ><span class=" fa fa-share-square"> ' . __('administrator.back_to_process') . '</span></label>
                            ';
                        return $action;
                    }

                    $edit = '';
                    $delete = '';
                    $pedding = '';
                    $cancel = '';
                    $edit = '';
                    $return_to_shop = '';
                    $print = '';
                    $all = '';
                    $return_to_proccess = '';
                    if (Gate::check('Delete Order')) {
                        $delete = '<li><a data-href="' . route("export_stock_delete_box", [$data->export_id, 'export_list']) . '" class=" fa fa-trash bt-delete">&nbsp; ' . __('administrator.delete') . '</a></li>';
                    }
                    if (Gate::check('Pending Order List')) {
                        $pedding = '<li><a class="bt_pending" data-status="2" data-export_id="' . $data->export_id . '">' . __('administrator.pending') . '</a>';
                    }
                    if (Gate::check('Cancel Order List')) {
                        $cancel = '<li><a class="bt_cencel fa fa-ban" data-status="3" data-export_id="' . $data->export_id . '" >&nbsp;' . __('administrator.cancel') . '</a></li>';
                    }
                    if (Gate::check('Return To Shop Order List')) {
                        $return_to_shop = '<li><a class="bt_return_to_shop fa fa-undo" data-status="' . $data->status . '" data-export_id="' . $data->export_id . '" >&nbsp;' . 'Return To Shop' . '</a></li>';
                    }        // $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_id) . '" class="fa fa-edit">&nbsp;'. __('administrator.edit') .'</a></li>';
                    if (Gate::check('Print Order List')) {
                        $print = '<li><a data-href="' . route("export-stock.show", $data->export_id) . '" class="fa fa-print bt-print">&nbsp;' . __('administrator.print') . '</a></li>';
                    }
                    $return_to_proccess = '
                        <li><a class="return_to_inpro fa fa-undo" data-status="' . $data->status . '" data-export_id="' . $data->export_id . '" >&nbsp;' . __('administrator.back_to_process') . '</a></li>
                    ';
                    if ($data->type_of_stock == 1) {
                        if (Gate::check('Edit Order List')) {
                            $edit = '<li><a href="' . route("export-stock-new.edit", $data->export_id) . '" class="fa fa-edit">&nbsp;' . __('administrator.edit') . '</a></li>';
                        }
                    } else {
                        if (Gate::check('Edit Order List')) {
                            $edit = '<li><a href="' . route("out-stock-new.edit", $data->export_id) . '" class="fa fa-edit">&nbsp;' . __('administrator.edit') . '</a></li>';
                        }
                    }
                    if ($data->status == 1) {
                        $all .= $delete . $print . $edit;
                    }

                    return '
                <div class="dropdown">
                     <button class="btn btn-sm btn-primary dropdown-toggle" type="button" data-toggle="dropdown">' . __('administrator.action') . '
                     <span class="caret"></span></button>
                     <ul class="dropdown-menu" style="z-index:9999999999999 !important;width:auto">
                     ' . $all . '
                     </ul>
                 </div>
                ';
                })
                ->rawColumns(['status' => 'status','driver_name'=>'driver_name','checkall'=>'checkall'])
                ->addIndexColumn()
                    ->make(true);
        }
        return \view('administrator.delivery-list.index1',compact( 'merchant_show','status'));
    }
}
