<?php



namespace App\Http\Controllers\Administrator;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\CategoryModel;
use Image;

use DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Gate;
use Validator;
use Yajra\DataTables\Facades\DataTables;

class CategoryController extends Controller

{
    function __construct()
    {
        // $this->middleware('permission:Category List', ['only' => ['index']]);
        // $this->middleware('permission:Category Create', ['only' => ['create','store']]);
        // $this->middleware('permission:Category Edit', ['only' => ['edit','update']]);
    }

    public function index(Request $request)
    {
        
        if($request->ajax()){
            $data = CategoryModel::where('status','!=','0');
            return DataTables::of($data)
                ->addIndexColumn()
                ->addColumn('image', function ($data) {
                    $path = "images/upload/category/" . $data->image;
                    $full_path = File::exists($path) ?  $path : 'images/default.jpg';
                    return '<img src="/' . $full_path . '" alt="" width="35px" height="35px">';
                })
                ->editColumn('created_at', function ($data) {
                    return date('d-m-Y', strtotime($data->created_at));
                })
                ->addColumn('action', function ($data) {
                    $edit = '';
                    $dis_or_en = '';
                        if ($data->name_en != 'another') {
                            if(Gate::check('Edit Category')){
                                $edit = '<a href="'. route("category.edit", $data->id) .'" class="button_info btn btn-sm">'.__('administrator.edit').'</a>';
                            }
                        }
                        $check = $data->status == 1 ? 'checked' : 'a';
                        if (Gate::check('Dis And Enable')) {
                            $dis_or_en = '<input data-route="'.route('category.destroy', $data->id).'" ' . $check . ' class="toggle dis_and_en" type="checkbox" data-toggle="toggle" data-on="Enabled" data-off="Disabled" value="'.$data->status.'">';
                        }// <a class="button_sm @if($value->status==1) button_primary @else button_danger @endif"
                            //     onclick="status('{{$value->id}}','{{$value->status}}')">@if($value->status==1) {{__('administrator.active')}} @else {{__('administrator.deactive')}} @endif</a>
                      return $edit.$dis_or_en;
                })
                ->rawColumns(['image', 'action'])
                ->make(true);
        }
        return view('administrator.category.index');
    }


    public function create()

    {
        return view('administrator.category.create');
    }

    public function store(Request $request)

    {
        $this->validate($request, [
            'name_km'      => 'required|unique:nso007_category',
            'name_en'      => 'required|unique:nso007_category',
        ]);
        $gallery = '';

        if($files = $request->file('image')){

            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload/category';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload/category';
            $files->move($destinationPath, $original_name);
            $gallery = $original_name;
        }else{
            $gallery = 'default.jpg';
        }

        $category = new CategoryModel;
        $category->name_en = $request->name_en;
        $category->name_km = $request->name_km;
        $category->description = $request->description;
        $category->image = $gallery ;
        $category->save();
        return redirect()->route('category.index')
        ->with('success','Category created successfully');

    }



    /**

     * Display the specified resource.

     *

     * @param  int  $id

     * @return \Illuminate\Http\Response

     */

    public function show($id)

    {
        $data = CategoryModel::get();
        return view('administrator.category.show',compact('data'));
    }



    public function edit($id)

    {


        $category = CategoryModel::find($id);
        return view('administrator.category.edit',compact('category'));
    }


    public function update(Request $request, $id)
    {
        // dd( $request);

        $this->validate($request, [
			'name_km' 	=> 'required|unique:nso007_category,name_km,'.$id,
			'name_en' 	=> 'required|unique:nso007_category,name_en,'.$id,

        ]);
        $gallery​ = '';
        if($files = $request->file('avartar')){
            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload/category';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload/category';
            $files->move($destinationPath, $original_name);
            $gallery= $original_name;
        }else{
            $gallery = $request->arrayImg;
        }

        $category = CategoryModel::find($id);
        $category->name_en = $request->name_en;
        $category->name_km = $request->name_km;
        $category->description = $request->description;
        $category->image = $gallery;
        $category->save();
        return redirect()->route('category.index')

        ->with('success','Category updated successfully');

    }
    public function destroy($id,Request $request)

    {
        $category = CategoryModel::find($id);
        $category->status = $request->status;
        $category->save();
        return response()->json(['success'=>'Status change successfully.']);


        // DB::table('nso007_category')->where('id',$id)->update(['status' =>0 ]);

        // return response()->json([
        //     'success' => 'Record deleted successfully!'
        // ]);

    }





    public function new_category(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'category_name' => 'required|unique:nso007_category',
        ]);

        if ($validator->fails()) {

            return response()->json(['errors'=>$validator->errors()]);

        }else{
            if ($request->ajax()){
                $category = new CategoryModel();
                $category->category_name = $request->input('category_name');
                return response($category);

            }

        }

    }

    public function get_new_category(){

         $get_category = CategoryModel::all();

         echo json_encode($get_category);

    }

     public function category_changeStatus(Request $request)

    {
        $category = CategoryModel::find($request->id);
        $category->status = $request->status;
        $category->save();
        return response()->json(['success'=>'Status change successfully.']);

    }

}

