<?php

namespace App\Http\Controllers\Administrator;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\BusModel;

class BusController extends Controller
{
    public function index(){
    	$data = BusModel::get();
    	return view('administrator.bus.index',compact('data'));
    }
    public function create()
    {
        return view('administrator.bus.create');
    }
     public function store(Request $request)
    {
        $this->validate($request, [
            'company_name'     => 'required|max:255|unique:nso007_bus,company_name',
            ]);
        // dd($request->all());
        $bus = new BusModel;
        $bus->company_name   = $request->company_name;
        $bus->price   = $request->price;
        $bus->save();
        return redirect()->route('bus.index')->with(['success' => 'Bus Create Successfull !!']);
    }
      public function edit($id)
    {
        $bus = BusModel::find($id);
        return view('administrator.bus.edit',compact('bus'));
    }
    public function update(Request $request, $id)
    {
        // dd( $request);
        $this->validate($request, [
			'company_name' 	=> 'required|unique:nso007_bus,company_name,'.$id,
        ]);
        $bus = BusModel::find($id);
        $bus->company_name = $request->company_name;
        $bus->price = $request->price;
        $bus->save();
        return redirect()->route('bus.index')
        ->with('success','bus updated successfully');
    }
    public function bus_changeStatus(Request $request)
    { 
        $bus = BusModel::find($request->id)->update(['status'=> $request->status]); 
        return response()->json(['success'=>'Status change successfully.']);
    }

    public function price(Request $request){
        $bus = BusModel::where('company_name',$request->id)->first(); 
        return $bus->price;;
    }
}
