<?php

namespace App\Http\Controllers\Administrator;

use App\CurrencyModel;
use App\DeliveryOrderDetailCancelModel;
use App\DeliveryOrderDetailSuccessModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ReportNewController extends Controller
{
    public function report_for_shop_print(Request $request ,$type){     
        $currency  = CurrencyModel::first();
        $invoice = '';
        $from_date  = empty  ($request->from_date)? '':date('Y-m-d',strtotime($request->from_date));
        $to_date    = empty($request->to_date)? '':date('Y-m-d',strtotime($request->to_date));
        $merchant   = isset($request->merchant)?$request->merchant:null;
        // dd( $merchant );
        $status     = isset($request->status)?$request->status:null ;
        $referance  = isset($request->referance)?$request->referance:null ;
        $ids = array(3,1,2,4); 
        $ids_ordered = implode(',', $ids);
        $cus = User::find($merchant);
        $data = DeliveryOrderModel::
                join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id');
            if(\Globals::check_lang() == 'en'){
            $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name AS name_location',
                    'nso007_export_stock.description',
                    'nso007_export_stock.*',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
            }else{
                $data = $data-> select(
                    'nso007_export_stock.discount_id',
                    'nso007_export_stock.location_name',
                    'nso007_export_stock.*',
                    'nso007_delivery_order_detail.status',
                    'nso007_export_stock.id As export_detail_id',
                    'nso007_delivery_order_detail.reason',
                    'nso007_delivery_order.inovice',
                    'nso007_export_stock.description',
                    'nso007_delivery_order.delivery_date',
                    'nso007_delivery_order_detail.*',
                    // 'nso007_delivery_order_detail.status',
                    'nso007_export_stock_details.category_name',
                    'nso007_export_stock_details.currency',
                    DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                );
            }
            $data = $data
            ->when(request('from_date','to_date'),function($query) use ($from_date,$to_date){
                if(!empty($from_date) && !empty($to_date)){
                    $query->whereBetween('nso007_delivery_order.delivery_date',[$from_date,$to_date]);
                }
            })
            ->when(request('status'),function($query) use ($status){
                if(!empty($status)){
                    $status_1 ='';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key].',' ;
                    }
                    $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                }
            })
            ->where(function($query) use ($merchant){
                if(\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut' ){
                    $query->where('merchant_id',\Auth::user()->id);
                }else if(\Globals::is_Driver() == 'Driver'){
                    $query->where('nso007_delivery_order.driver_id',\Auth::user()->id);
                }else{
                    $query->where('merchant_id','LIKE',$merchant);
            }
        })

        ->where('nso007_delivery_order_detail.status_paid',null)
        ->where('nso007_delivery_order_detail.status','!=',0)
        ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')

        // ->orderBy('nso007_delivery_order.inovice','desc')
        ->orderByRaw("FIELD(nso007_delivery_order_detail.status, $ids_ordered)")


        ->get();
        $package = [];
        $increas = '';

        $id = '';
        if ($type ==2) {

            if(empty($data)){
                return redirect()->back()->with('danger','Not Data');
            }
            $increas = '';
            $last_id =  DB::table('nso007_invoice_payment')->max('id');
            $inovice = DB::table('nso007_invoice_payment')->latest('id')->first();
            
            if ($inovice) {
                $tran_num = $inovice->invoice_payment;
                $tran_num =substr($tran_num, -6);
                $increas = sprintf('IV-'.date('ym').'%06d', ($tran_num+1));
            } else {
                $increas = 'IV-'.date('ym').'000001';
            }
            $invoicepayment     =   new InvoicePaymentModel();
            $invoicepayment->invoice_payment    =   $increas;
            $invoicepayment->user_create        =   Auth::user()->id;
            $invoicepayment->date               =   date('Y-m-d');
            $invoicepayment->from_date          =   $from_date;
            $invoicepayment->to_date            =   $to_date ;
            $invoicepayment->shop_id            =   $merchant ;

            $deliveryOrder=  DeliveryOrderModel::
                join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->select('nso007_delivery_order_detail.status', 'nso007_delivery_order_detail.export_id')
                ->when(request('from_date', 'to_date'), function ($query) use ($from_date,$to_date) {
                    if (!empty($from_date) && !empty($to_date)) {
                        $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date,$to_date]);
                    }
                })

            ->where(function ($query) use ($merchant) {
                if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                    $query->where('nso007_export_stock.merchant_id', \Auth::user()->id);
                } elseif (\Globals::is_Driver() == 'Driver') {
                    $query->where('nso007_delivery_order.driver_id', \Auth::user()->id);
                } else {
                    $query->where('nso007_export_stock.merchant_id', 'LIKE', $merchant);
                }
            })

            ->when(request('referance'), function ($query) use ($referance) {
                if (!empty($referance)) {
                    $query->where('nso007_export_stock.referance', $referance);
                }
            })

            ->where(function ($query) {
                $query->orwhere('nso007_delivery_order_detail.status', 3);
            })
            ->whereNull('nso007_delivery_order_detail.invoice_payment_id')
            ->whereNull('nso007_delivery_order_detail.status_paid');

            $deliveryOrder1  = $deliveryOrder;
            $deliveryOrder2  = $deliveryOrder->get();

            $id_ = '';
            if ($deliveryOrder1->count() != 0) {
                $invoicepayment->save();
                $id = $invoicepayment->id;
                $invoice        = $invoicepayment->invoice_payment;
                $deliveryOrder->update(['nso007_delivery_order_detail.invoice_payment_id'=>$invoicepayment->id]);
                foreach ($deliveryOrder2 as $key => $value) {
                    $id_ .= $deliveryOrder2[$key]->export_id.',';
                }
                DeliveryOrderDetailCancelModel::WhereIn('nso007_delivery_order_detail_cancel.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_cancel.invoice_payment_id'=>$invoicepayment->id]);
                ;
                DeliveryOrderDetailSuccessModel::WhereIn('nso007_delivery_order_detail_success.export_id', explode(',', $id_))->update(['nso007_delivery_order_detail_success.invoice_payment_id'=>$invoicepayment->id]);
                ;
            }

            
        }
        $count = ExportStockModel::where('nso007_export_stock.merchant_id', $merchant)->where('nso007_export_stock.status' ,1)->count();

        $package = [] ;
        if($count  > 0){
            $package = ExportStockModel::join('nso007_export_stock_details','nso007_export_stock.id','nso007_export_stock_details.export_id')

            ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
            ->select('nso007_export_stock.*' ,
                'nso007_export_stock_details.category_name AS category',
                'nso007_export_stock.location_name AS location',
                'nso007_discount.*',
                'nso007_export_stock_details.*',
                'nso007_export_stock.delivery_fee AS delivery_fee1',
                \DB::raw('SUM(nso007_export_stock_details.export_qty * nso007_export_stock_details.price) AS price'))
            ->where('nso007_export_stock.status' ,1)
            ->where('nso007_export_stock.merchant_id', $merchant)
            ->groupBy('nso007_export_stock.box_code')->get();
        }
        return  view('administrator.report.report_for_shop_print_new',compact('data','from_date','to_date','invoice','currency','package','cus','id'))->render();
    }
}
