<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\User;
use App\Fun\Fun as FunFun;
use Image;
use DB;
use Auth;
use Yajra\DataTables\DataTables;
use App\CategoryModel;
use App\LocationModel;
use App\ExportStockModel;
use App\ExportStockdetailsMode;
use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailPaddingModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DiscountModel;
use App\JournalModel;
use App\Http\Controllers\Administrator\journal_Taxi ;
class OutStockController extends Controller
{
    function __construct()
    {
        FunFun::lang();
        $this->middleware('permission:Export OutStock', ['only' => ['create', 'store']]);
    }

    public function index()
    {
        return \view('administrator.out-stock.index');
    }

    public function create(Request $request)
    {
        $merchant = User::where('user_type', 3)->where('status', 1)->where('type_of_merchant', 2)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $category = CategoryModel::where('status', 1);

        $from_location = LocationModel::where('status', 1)->where('pearent_id', null);
        $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null);

        $bus = \DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();
        $exchang_rate = CurrencyModel::find(1);
        if (\Globals::check_lang() == 'en') {
            $from_location = $from_location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
            $category =  $category->select('nso007_category.*', 'nso007_category.name_en AS category_name')->paginate(18);
        } else {
            $category =  $category->select('nso007_category.*', 'nso007_category.name_km AS category_name')->paginate(18);
            $from_location = $from_location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
            $location = $location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
        }

        if ($request->ajax()) {
            return view("administrator.out-stock.result-create", compact('category', 'from_location', 'location', 'merchant', 'bus', 'exchang_rate'));
        }
        return \view('administrator.out-stock.create', compact('category', 'from_location', 'location', 'merchant', 'bus', 'exchang_rate'));
    }

    public function store(Request $request)
    {
        // if (!$request->delivery_fee) {
        //     return redirect()->back()->with('danger', 'Please try again');
        // }
        // $this->validate($request, [
        //     'merchant_id.*'            => 'required',
        //     'category_id.*'         => 'required',
        //     'currency'              => 'required',
        //     'customer_receive.*'    => 'required',
        //     'location.*'            => 'required',
        //     'delivery_fee.*'        => 'required',
        //     'price.*'               => 'required|numeric',
        //     'delivery_option.*'     => 'required',
        //     'pay_or_paid.*'     => 'required',
        // ]);
        $arr = array();
        $discount = DiscountModel::where('date',date('Y-m-d'))->first();

        foreach ($request->driver_id as $k => $item) {
           $arr[$item][$k] = $item;
        }
     
        foreach ($arr as $driver_id => $tiem1) {
            if(!$driver_id == ''){
                $export_id = '';
                foreach ($tiem1 as $key => $value) {
                    $increas = '';
                    $last_id = ExportStockModel::max('id');
                    $header_invoice = BranchModel::first();
                    if ($last_id) {
                        $box_code = ExportStockModel::latest('id')->first();
                        // $box_code = ExportStockModel::select('box_code')->get()->last();

                        $tran_num = substr($box_code->box_code, 3);
                        $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
                    } else {
                        $increas = $header_invoice->header_invoice_import . '00000001';
                    }
                        $exportstock = new ExportStockModel();
                        if( $discount ){
                            $arra_  =  explode(',', $discount->shop_id);
                            if (in_array($request->merchant_id, $arra_)) {
                                $exportstock->discount_id  = $discount->id;
                            }
                        }
                        $exportstock->merchant_id                   = $request->merchant_id;
                        $exportstock->box_code                      = $increas;
                        $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
                        $exportstock->delivery_fee                  = $request->delivery_fee[$key];
                        $exportstock->from_location                 = isset($request->from_location[$key]) ? $request->from_location[$key] : '';
                        $exportstock->location                      = $request->location[$key];
                        $exportstock->customer_receive              = $request->customer_receive[$key];
                        $exportstock->delivery_status               = $request->delivery_status[$key];
                        $exportstock->delivery_option               = $request->delivery_option[$key];
                        $exportstock->created_by                    = Auth::user()->id;
                        $exportstock->description                   = $request->description[$key];
                        $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key]));
                        // $exportstock->pay_or_paid                = $request->pay_or_paid[$key];
                        $exportstock->type_of_stock                 = 2; //Out stock
                        $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key];
                        $exportstock->taxi_number                   = $request->taxi_number[$key];
                        $exportstock->taxi_status                   = $request->taxi_status[$key];
                        if($request->taxi_status[$key]==1){
                            $exportstock->taxi_shop_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
                        }else{
                            $exportstock->taxi_cust_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
                        }
                        $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key];
                        $exportstock->other_services_fee            = $request->other_service_fee[$key] == '' ? 0 : $request->other_service_fee[$key] ;
                        $exportstock->other_services_type           = $request->other_service_type[$key];
                        $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key];
                        $exportstock->shop_name                     =  FindShop($request->merchant_id);
                        $exportstock->location_name                 =  FindLoaction($request->location[$key]);
                        $exportstock->create_by_name                = \Auth::user()->name;
                        $exportstock->update_status_by              = update_status_by("" ,'','')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
                        $exportstock->total_product                 = $request->price[$key];

                        if ($exportstock->save()) {
                            $export_id  .= $exportstock->id.',';
                            $exportstockdetails = new ExportStockdetailsMode();
                            $exportstockdetails->export_id          = $exportstock->id;
                            $exportstockdetails->barcode            = $increas;
                            $exportstockdetails->currency           = $request->currency;
                            $exportstockdetails->export_qty         = 1;
                            $exportstockdetails->price              = $request->price[$key];
                            $exportstockdetails->category_id        = $request->category_id[$key];
                            $exportstock->category_name             =  FindCategory($request->category_id[$key]);
                            $exportstockdetails->save();
                        }
                    }


                    delivery_order($export_id, $driver_id);

            }else{
                foreach ($tiem1 as $key1 => $value) {
                $increas = '';
                $last_id = ExportStockModel::max('id');
                $header_invoice = BranchModel::first();
                if ($last_id) {
                    $box_code = ExportStockModel::select('box_code')->get()->last();
                    $tran_num = substr($box_code->box_code, 3);
                    $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
                } else {
                    $increas = $header_invoice->header_invoice_import . '00000001';
                }
                    $exportstock = new ExportStockModel();
                    if( $discount ){
                        $arra_  =  explode(',', $discount->shop_id);
                        if (in_array($request->merchant_id, $arra_)) {
                            $exportstock->discount_id  = $discount->id;
                        }
                    }
                    $exportstock->merchant_id                   = $request->merchant_id;
                    $exportstock->box_code                      = $increas;
                    $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
                    $exportstock->delivery_fee                  = $request->delivery_fee[$key1];
                    $exportstock->from_location                 = isset($request->from_location[$key1]) ? $request->from_location[$key1] : '';
                    $exportstock->location                      = $request->location[$key1];
                    $exportstock->customer_receive              = $request->customer_receive[$key1];
                    $exportstock->delivery_status               = $request->delivery_status[$key1];
                    $exportstock->delivery_option               = $request->delivery_option[$key1];
                    $exportstock->created_by                    = Auth::user()->id;
                    $exportstock->description                   = $request->description[$key1];
                    $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key1]));
                    // $exportstock->pay_or_paid                = $request->pay_or_paid[$key1];
                    $exportstock->type_of_stock                 = 2; //Out stock
                    $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key1];
                    $exportstock->taxi_number                   = $request->taxi_number[$key1];
                    $exportstock->taxi_status                   = $request->taxi_status[$key1];
                    if($request->taxi_status[$key1]==1){
                        $exportstock->taxi_shop_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
                    }else{
                        $exportstock->taxi_cust_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
                    }
                    $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key1];
                    $exportstock->other_services_fee            = $request->other_service_fee[$key1] == '' ? 0 : $request->other_service_fee[$key1] ;
                    $exportstock->other_services_type           = $request->other_service_type[$key1];
                    $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key1];
                    $exportstock->shop_name                     =  FindShop($request->merchant_id);
                    $exportstock->location_name                 =  FindLoaction($request->location[$key1]);
                    $exportstock->create_by_name                = \Auth::user()->name;
                    $exportstock->update_status_by              = update_status_by("" ,'','')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
                    $exportstock->total_product                 = $request->price[$key1];

                    if ($exportstock->save()) {
                        
                        $exportstockdetails = new ExportStockdetailsMode();
                        $exportstockdetails->export_id          = $exportstock->id;
                        $exportstockdetails->barcode            = $increas;
                        $exportstockdetails->currency           = $request->currency;
                        $exportstockdetails->export_qty         = 1;
                        $exportstockdetails->price              = $request->price[$key1];
                        $exportstockdetails->category_id        = $request->category_id[$key1];
                        $exportstock->category_name             =  FindCategory($request->category_id[$key1]);
                        $exportstockdetails->save();
                    }
                }
            }

        }
        

        //     DB::beginTransaction();
        //     foreach ($request->customer_receive as $key => $value) {
        //         $increas = '';
        //         $last_id = ExportStockModel::max('id');
        //         $header_invoice = BranchModel::first();

        //         if ($last_id) {
        //             $box_code = ExportStockModel::select('box_code')->get()->last();
        //             $tran_num = substr($box_code->box_code, 3);
        //             $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
        //         } else {
        //             $increas = $header_invoice->header_invoice_import . '00000001';
        //         }

        //         $exportstock = new ExportStockModel();
        //         if( $discount ){
        //             $arra_  =  explode(',', $discount->shop_id);
        //             if (in_array($request->merchant_id, $arra_)) {
        //                 $exportstock->discount_id  = $discount->id;
        //             }
        //         }
        //         $exportstock->merchant_id                   = $request->merchant_id;
        //         $exportstock->box_code                      = $increas;
        //         $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
        //         $exportstock->delivery_fee                  = $request->delivery_fee[$key];
        //         $exportstock->from_location                 = isset($request->from_location[$key]) ? $request->from_location[$key] : '';
        //         $exportstock->location                      = $request->location[$key];
        //         $exportstock->customer_receive              = $request->customer_receive[$key];
        //         $exportstock->delivery_status               = $request->delivery_status[$key];
        //         $exportstock->delivery_option               = $request->delivery_option[$key];
        //         $exportstock->created_by                    = Auth::user()->id;
        //         $exportstock->description                   = $request->description[$key];
        //         $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key]));
        //         // $exportstock->pay_or_paid                = $request->pay_or_paid[$key];
        //         $exportstock->type_of_stock                 = 2; //Out stock
        //         $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key];
        //         $exportstock->taxi_number                   = $request->taxi_number[$key];
        //         $exportstock->taxi_status                   = $request->taxi_status[$key];
        //         if($request->taxi_status[$key]==1){
        //             $exportstock->taxi_shop_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
        //         }else{
        //             $exportstock->taxi_cust_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
        //         }
        //         $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key];
        //         $exportstock->other_services_fee            = $request->other_service_fee[$key] == '' ? 0 : $request->other_service_fee[$key] ;
        //         $exportstock->other_services_type           = $request->other_service_type[$key];
        //         $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key];
        //         $exportstock->shop_name                     =  FindShop($request->merchant_id);
        //         $exportstock->location_name                 =  FindLoaction($request->location[$key]);
        //         $exportstock->create_by_name                = \Auth::user()->name;
        //         $exportstock->update_status_by              = update_status_by("" ,'','')      ;//  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
        //         $exportstock->total_product                 = $request->price[$key];


        //         if ($exportstock->save()) {
        //             $exportstockdetails = new ExportStockdetailsMode();
        //             $exportstockdetails->export_id          = $exportstock->id;
        //             $exportstockdetails->barcode            = $increas;
        //             $exportstockdetails->currency           = $request->currency;
        //             $exportstockdetails->export_qty         = 1;
        //             $exportstockdetails->price              = $request->price[$key];
        //             $exportstockdetails->category_id        = $request->category_id[$key];
        //             $exportstock->category_name             =  FindCategory($request->category_id[$key]);
        //             $exportstockdetails->save();
        //         }
            // }
        if((@session()->get('back_bage')) == 1){
            return redirect()->back()->with('sussess', 'Import was add already successfully!');
        }
        return redirect()->route('export-stock.index')->with('sussess', 'Import was add already successfully!');
    }
    // public function store(Request $request)
    // {

    //     // if (!$request->delivery_fee) {
    //     //     return redirect()->back()->with('danger', 'Please try again');
    //     // }
    //     // $this->validate($request, [
    //     //     'merchant_id.*'            => 'required',
    //     //     'category_id.*'         => 'required',
    //     //     'currency'              => 'required',
    //     //     'customer_receive.*'    => 'required',
    //     //     'location.*'            => 'required',
    //     //     'delivery_fee.*'        => 'required',
    //     //     'price.*'               => 'required|numeric',
    //     //     'delivery_option.*'     => 'required',
    //     //     'pay_or_paid.*'     => 'required',
    //     // ]);

    //     $arr = array();
    //     $discount = DiscountModel::where('date',date('Y-m-d'))->first();

    //     foreach ($request->driver_id as $k => $item) {
    //        $arr[$item][$k] = $item;
    //     }

    //     $user = User::get();
    //     $auth = Auth::user();
    //     $location =  LocationModel ::get();
    //     $header_invoice = BranchModel::first();
    //     $category =  CategoryModel ::get();

    //     foreach ($arr as $driver_id => $tiem1) {
    //         if(!$driver_id == ''){
    //             $export_id = '';
    //             foreach ($tiem1 as $key => $value) {
    //                 $increas = '';
    //                 $last_id = ExportStockModel::max('id');
                   
    //                 if ($last_id) {
    //                     $box_code = ExportStockModel::select('box_code')->get()->last();
    //                     $tran_num = substr($box_code->box_code, 3);
    //                     $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
    //                 } else {
    //                     $increas = $header_invoice->header_invoice_import . '00000001';
    //                 }
    //                     $exportstock = new ExportStockModel();
    //                     if( $discount ){
    //                         $arra_  =  explode(',', $discount->shop_id);
    //                         if (in_array($request->merchant_id, $arra_)) {
    //                             $exportstock->discount_id  = $discount->id;
    //                         }
    //                     }
    //                     $exportstock->merchant_id                   = $request->merchant_id;
    //                     $exportstock->box_code                      = $increas;
    //                     $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
    //                     $exportstock->delivery_fee                  = $request->delivery_fee[$key];
    //                     $exportstock->from_location                 = isset($request->from_location[$key]) ? $request->from_location[$key] : '';
    //                     $exportstock->location                      = $request->location[$key];
    //                     $exportstock->customer_receive              = $request->customer_receive[$key];
    //                     $exportstock->delivery_status               = $request->delivery_status[$key];
    //                     $exportstock->delivery_option               = $request->delivery_option[$key];
    //                     $exportstock->created_by                    = $auth->id;
    //                     $exportstock->description                   = $request->description[$key];
    //                     $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key]));
    //                     // $exportstock->pay_or_paid                = $request->pay_or_paid[$key];
    //                     $exportstock->type_of_stock                 = 2; //Out stock
    //                     $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key];
    //                     $exportstock->taxi_number                   = $request->taxi_number[$key];
    //                     $exportstock->taxi_status                   = $request->taxi_status[$key];
    //                     if($request->taxi_status[$key]==1){
    //                         $exportstock->taxi_shop_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
    //                     }else{
    //                         $exportstock->taxi_cust_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
    //                     }
    //                     $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key];
    //                     $exportstock->other_services_fee            = $request->other_service_fee[$key] == '' ? 0 : $request->other_service_fee[$key] ;
    //                     $exportstock->other_services_type           = $request->other_service_type[$key];
    //                     $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key];
    //                     $exportstock->shop_name                     = $user->find($request->merchant_id)->shop_name ;  //FindShop($request->merchant_id)
    //                     $exportstock->location_name                 = $location->find($request->location[$key])->name_km ;//FindLoaction($request->location[$key]);
    //                     $exportstock->create_by_name                = $auth->name;
    //                     $exportstock->update_status_by              = update_status_by("" ,'','')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
    //                     $exportstock->total_product                 = $request->price[$key];

    //                     if ($exportstock->save()) {
    //                         $export_id  .= $exportstock->id.',';
    //                         $exportstockdetails = new ExportStockdetailsMode();
    //                         $exportstockdetails->export_id          = $exportstock->id;
    //                         $exportstockdetails->barcode            = $increas;
    //                         $exportstockdetails->currency           = $request->currency;
    //                         $exportstockdetails->export_qty         = 1;
    //                         $exportstockdetails->price              = $request->price[$key];
    //                         $exportstockdetails->category_id        = $request->category_id[$key];
    //                         $exportstock->category_name             =  $category->find($request->category_id[$key]);
    //                         $exportstockdetails->save();
    //                     }
    //                 }


    //                 delivery_order($export_id, $driver_id);

    //         }else{
    //             foreach ($tiem1 as $key1 => $value) {
    //             $increas = '';
    //             $last_id = ExportStockModel::max('id');
    //             $header_invoice = BranchModel::first();
    //             if ($last_id) {
    //                 $box_code = ExportStockModel::select('box_code')->get()->last();
    //                 $tran_num = substr($box_code->box_code, 3);
    //                 $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
    //             } else {
    //                 $increas = $header_invoice->header_invoice_import . '00000001';
    //             }
    //                 $exportstock = new ExportStockModel();
    //                 if( $discount ){
    //                     $arra_  =  explode(',', $discount->shop_id);
    //                     if (in_array($request->merchant_id, $arra_)) {
    //                         $exportstock->discount_id  = $discount->id;
    //                     }
    //                 }
    //                 $exportstock->merchant_id                   = $request->merchant_id;
    //                 $exportstock->box_code                      = $increas;
    //                 $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
    //                 $exportstock->delivery_fee                  = $request->delivery_fee[$key1];
    //                 $exportstock->from_location                 = isset($request->from_location[$key1]) ? $request->from_location[$key1] : '';
    //                 $exportstock->location                      = $request->location[$key1];
    //                 $exportstock->customer_receive              = $request->customer_receive[$key1];
    //                 $exportstock->delivery_status               = $request->delivery_status[$key1];
    //                 $exportstock->delivery_option               = $request->delivery_option[$key1];
    //                 $exportstock->created_by                    = Auth::user()->id;
    //                 $exportstock->description                   = $request->description[$key1];
    //                 $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key1]));
    //                 // $exportstock->pay_or_paid                = $request->pay_or_paid[$key1];
    //                 $exportstock->type_of_stock                 = 2; //Out stock
    //                 $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key1];
    //                 $exportstock->taxi_number                   = $request->taxi_number[$key1];
    //                 $exportstock->taxi_status                   = $request->taxi_status[$key1];
    //                 if($request->taxi_status[$key1]==1){
    //                     $exportstock->taxi_shop_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
    //                 }else{
    //                     $exportstock->taxi_cust_fee             = $request->taxi_price[$key1] == '' ? 0 : $request->taxi_price[$key1] ;
    //                 }
    //                 $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key1];
    //                 $exportstock->other_services_fee            = $request->other_service_fee[$key1] == '' ? 0 : $request->other_service_fee[$key1] ;
    //                 $exportstock->other_services_type           = $request->other_service_type[$key1];
    //                 $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key1];
    //                 $exportstock->shop_name                     =  FindShop($request->merchant_id);
    //                 $exportstock->location_name                 =  FindLoaction($request->location[$key1]);
    //                 $exportstock->create_by_name                = \Auth::user()->name;
    //                 $exportstock->update_status_by              = update_status_by("" ,'','')      ; //  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
    //                 $exportstock->total_product                 = $request->price[$key1];

    //                 if ($exportstock->save()) {
                        
    //                     $exportstockdetails = new ExportStockdetailsMode();
    //                     $exportstockdetails->export_id          = $exportstock->id;
    //                     $exportstockdetails->barcode            = $increas;
    //                     $exportstockdetails->currency           = $request->currency;
    //                     $exportstockdetails->export_qty         = 1;
    //                     $exportstockdetails->price              = $request->price[$key1];
    //                     $exportstockdetails->category_id        = $request->category_id[$key1];
    //                     $exportstock->category_name             =  FindCategory($request->category_id[$key1]);
    //                     $exportstockdetails->save();
    //                 }
    //             }
    //         }

    //     }
        

    //     //     DB::beginTransaction();
    //     //     foreach ($request->customer_receive as $key => $value) {
    //     //         $increas = '';
    //     //         $last_id = ExportStockModel::max('id');
    //     //         $header_invoice = BranchModel::first();

    //     //         if ($last_id) {
    //     //             $box_code = ExportStockModel::select('box_code')->get()->last();
    //     //             $tran_num = substr($box_code->box_code, 3);
    //     //             $increas = $header_invoice->header_invoice_import . sprintf('%08d', ($tran_num + 1));
    //     //         } else {
    //     //             $increas = $header_invoice->header_invoice_import . '00000001';
    //     //         }

    //     //         $exportstock = new ExportStockModel();
    //     //         if( $discount ){
    //     //             $arra_  =  explode(',', $discount->shop_id);
    //     //             if (in_array($request->merchant_id, $arra_)) {
    //     //                 $exportstock->discount_id  = $discount->id;
    //     //             }
    //     //         }
    //     //         $exportstock->merchant_id                   = $request->merchant_id;
    //     //         $exportstock->box_code                      = $increas;
    //     //         $exportstock->export_date                   = date('Y-m-d', strtotime($request->export_date));
    //     //         $exportstock->delivery_fee                  = $request->delivery_fee[$key];
    //     //         $exportstock->from_location                 = isset($request->from_location[$key]) ? $request->from_location[$key] : '';
    //     //         $exportstock->location                      = $request->location[$key];
    //     //         $exportstock->customer_receive              = $request->customer_receive[$key];
    //     //         $exportstock->delivery_status               = $request->delivery_status[$key];
    //     //         $exportstock->delivery_option               = $request->delivery_option[$key];
    //     //         $exportstock->created_by                    = Auth::user()->id;
    //     //         $exportstock->description                   = $request->description[$key];
    //     //         $exportstock->date_delivery                 =  date('Y-m-d', strtotime($request->date_delivery[$key]));
    //     //         // $exportstock->pay_or_paid                = $request->pay_or_paid[$key];
    //     //         $exportstock->type_of_stock                 = 2; //Out stock
    //     //         $exportstock->delivery_pay_or_paid          = $request->pay_or_paid[$key];
    //     //         $exportstock->taxi_number                   = $request->taxi_number[$key];
    //     //         $exportstock->taxi_status                   = $request->taxi_status[$key];
    //     //         if($request->taxi_status[$key]==1){
    //     //             $exportstock->taxi_shop_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
    //     //         }else{
    //     //             $exportstock->taxi_cust_fee             = $request->taxi_price[$key] == '' ? 0 : $request->taxi_price[$key] ;
    //     //         }
    //     //         $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid[$key];
    //     //         $exportstock->other_services_fee            = $request->other_service_fee[$key] == '' ? 0 : $request->other_service_fee[$key] ;
    //     //         $exportstock->other_services_type           = $request->other_service_type[$key];
    //     //         $exportstock->other_services_pay_or_paid    = $request->other_service_pay_or_paid[$key];
    //     //         $exportstock->shop_name                     =  FindShop($request->merchant_id);
    //     //         $exportstock->location_name                 =  FindLoaction($request->location[$key]);
    //     //         $exportstock->create_by_name                = \Auth::user()->name;
    //     //         $exportstock->update_status_by              = update_status_by("" ,'','')      ;//  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
    //     //         $exportstock->total_product                 = $request->price[$key];


    //     //         if ($exportstock->save()) {
    //     //             $exportstockdetails = new ExportStockdetailsMode();
    //     //             $exportstockdetails->export_id          = $exportstock->id;
    //     //             $exportstockdetails->barcode            = $increas;
    //     //             $exportstockdetails->currency           = $request->currency;
    //     //             $exportstockdetails->export_qty         = 1;
    //     //             $exportstockdetails->price              = $request->price[$key];
    //     //             $exportstockdetails->category_id        = $request->category_id[$key];
    //     //             $exportstock->category_name             =  FindCategory($request->category_id[$key]);
    //     //             $exportstockdetails->save();
    //     //         }
    //         // }
    //     if((@session()->get('back_bage')) == 1){
    //         return redirect()->back()->with('sussess', 'Import was add already successfully!');
    //     }
    //     return redirect()->route('export-stock.index')->with('sussess', 'Import was add already successfully!');
    // }

    public function show($id)
    {
        //
    }

    public function edit($id, Request $request)
    {

        $data   =   ExportStockdetailsMode::join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_export_stock_details.export_id')
            ->where('nso007_export_stock_details.export_id', $id);
        $merchant = User::where('user_type', 3)->where('status', 1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $bus = \DB::table('nso007_bus')->where('status', 1)->orderBy('id', 'asc')->pluck('company_name', 'company_name')->toArray();
        $category = CategoryModel::where('status', 1);
        $from_location = LocationModel::where('status', 1)->where('pearent_id', null);

        $location = LocationModel::where('status', 1)->where('pearent_id', '!=', null);
        if (\Globals::check_lang() == 'en') {
            $from_location = $from_location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Zone', '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Location', '');
            $data = $data->select(
                'nso007_category.*',
                'nso007_export_stock.*',
                'nso007_export_stock_details.*',
                'nso007_category.name_en As category_name'
            )->first();

            $category =  $category->select('nso007_category.*', 'nso007_category.name_en AS category_name')->paginate(24);
        } else {
            $from_location = $from_location->select('nso007_location.name_km AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
            $location = $location->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend('Please Select', '');
            $data = $data->select(
                'nso007_category.*',
                'nso007_export_stock.*',
                'nso007_export_stock_details.*',
                'nso007_category.name_km As category_name'
            )->first();

            $category =  $category->select('nso007_category.*', 'nso007_category.name_km AS category_name')->paginate(24);
        }

        if ($request->ajax()) {
            return view("administrator.out-stock.result-create", compact('data', 'category', 'from_location', 'location', 'bus', 'merchant'));
        }
        return \view('administrator.out-stock.edit', compact('data', 'category', 'from_location', 'location', 'bus', 'merchant'));
    }

    public function update(Request $request, $id)
    {
        if(!$request->delivery_fee){
            return redirect()->back()->with('danger','Please try again');
        }
        $this->validate($request, [
            'merchant_id'           => 'required',
            'category_id'           => 'required',
            'currency'              => 'required',
            'customer_receive'      => 'required',
            'location'              => 'required',
            'delivery_fee'          => 'required',
            'price'                 => 'required|numeric',
            'delivery_option'       => 'required',
        ]);

        $exportstock = ExportStockModel::whereBox_code($id)
        ->select(
            'nso007_export_stock.*',
            \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            )
        ->first();


        // dd($id);
        update_status_by($id , '','edit_by');


        // { "create_by":"Super Admin","edit_by":"",  "status_proccess":"",  "status_last":""}



        $exportstock->merchant_id           = $request->merchant_id;
        $check_delivery_status              = $exportstock->delivery_status;
        $exportstock->delivery_fee          = $request->delivery_fee;
        $exportstock->from_location         = $request->from_location;
        $exportstock->location              = $request->location;
        $exportstock->customer_receive      = $request->customer_receive;
        $exportstock->delivery_status       = $request->delivery_status;
        $exportstock->delivery_option       = $request->delivery_option;
        $exportstock->modify_by            = \Auth::user()->id;
        $exportstock->description           = $request->description;
        $exportstock->type_of_stock           = 2; //Out stock
        $exportstock->delivery_pay_or_paid           = $request->delivery_pay_or_paid;
        $exportstock->taxi_number           = $request->taxi_number;
        $exportstock->taxi_status           = $request->taxi_status;
        if($request->taxi_status==1){
            $exportstock->taxi_shop_fee             =  $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }else{
            $exportstock->taxi_cust_fee             = $request->taxi_price == '' ? 0 : $request->taxi_price ;
        }
        $exportstock->taxi_pay_or_paid              = $request->taxi_pay_or_paid;
        $exportstock->other_services_fee            =   $request->other_services_fee == '' ? 0 : $request->other_services_fee ;
        $exportstock->other_services_type           = $request->other_services_type;
        $exportstock->other_services_pay_or_paid    = $request->other_services_pay_or_paid;
        $exportstock->date_delivery                 = date('Y-m-d', strtotime($request->date_delivery));
        $exportstock->shop_name                     =  FindShop($request->merchant_id);
        $exportstock->location_name                 =  FindLoaction($request->location);
        $exportstock->total_product                 = $request->price;
        if ($exportstock->update()) {
            $exportstockdetails = ExportStockdetailsMode::where('export_id', $exportstock->id)->first();
            $price = $exportstockdetails->price;
            $exportstockdetails->currency           = $request->currency;
            $exportstockdetails->export_qty         = 1;
            $exportstockdetails->price              = $request->price;
            $exportstockdetails->category_id        = $request->category_id;
            $exportstockdetails->category_name      =  FindCategory($request->category_id);

            if ($request->price != $price || $check_delivery_status != $request->delivery_status) {
                DeliveryOrderDetailModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
                DeliveryOrderDetailProccessingModel::where('status',1)->where('export_id',$exportstock->id)->update(['total_riel'=>0,'total_dollar'=>0]);
            }
            $exportstockdetails->update();
        }
        return redirect()->route('export-stock.index')->with('sussess', 'Import was add already successfully!');
    }

    public function destroy($id)
    {
    }
    public function get_product(Request $request)
    {
        $category = CategoryModel::whereId($request->id);
        if (\Globals::check_lang() == 'en') {
            $category = $category->select('id', 'nso007_category.*', 'nso007_category.name_en AS category_name')->first();
        } else {
            $category = $category->select('id', 'nso007_category.*', 'nso007_category.name_km AS category_name')->first();
        }
        echo json_encode($category);
    }
    public function autocomplete(Request $request)
    {
        if (!empty($request->value)) {
            $category = CategoryModel::select('id', 'name_km', 'name_en', 'image')
                ->orwhere('name_km', 'LIKE', '%' . $request->value . '%')
                ->orwhere('name_en', 'LIKE', '%' . $request->value . '%')
                ->get();
        }

        $view = view('administrator.out-stock.search', compact('category'))->render();
        return response()->json(['html' => $view]);
    }
}
