<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderDetailSuccessModel;
use App\Fun\Fun as FunFun;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Illuminate\Validation\ValidationException;
use Image;
use Hash;
use Exception;
use Common;
use Illuminate\Support\Facades\Crypt;
use App\LocationModel;
use Yajra\DataTables\DataTables;
use App\User;
use App\DeliveryOrderModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Gate;

class DriverController extends Controller
{
    function __construct()
    {
        FunFun::lang();
        $this->middleware('permission:List Driver', ['only' => ['index']]);
        $this->middleware('permission:Create Driver', ['only' => ['create', 'store']]);
        $this->middleware('permission:Edit Driver', ['only' => ['edit', 'update']]);
        // $this->middleware('permission:Report Driver', ['only' => ['history_driver']]);
        $this->middleware('permission:Summary Driver', ['only' => ['summary_driver']]);
    }

    public function index(Request $request)
    {
        if ($request->ajax()) {
            $data = User::where('user_type', 2);
            return  Datatables::of($data)
                ->addColumn('action', function ($driver) {
                    $status =  $driver->status == 0 ? "off" : "";
                    $edit ='';
                    // if(Gate::check('Driver Edit')){
                        $edit = '<a href="' . route("driver.edit", $driver->id) . '" class="button_sm  button_primary ">' . __('administrator.edit') . '</a>
                        <div class="bt_action toggle btn btn-success btn-success-xs ' . $status . '" data-toggle="toggle" style="width: 72px; height: 26px;">
                        <input data-id="1" data-size="mini"  class="toggle-class  " type="checkbox" data-onstyle="success" data-offstyle="danger" data-toggle="toggle" data-on="Active" data-off="InActive" checked="">
                            <div class="toggle-group">
                                <label class= " data-id btn btn-success btn-xs  toggle-on" data-id="' . $driver->id . '"   >' . __('administrator.active') . ' </label>
                                <label class=" data-id btn btn-danger btn-xs active toggle-off" data-id="' . $driver->id . '"  >' . __('administrator.inactive') . '</label><span class="toggle-handle btn btn-default btn-xs"></span></div>
                        </div>
                    ';
                    // }


                    return '
                    <a href="#" class="viewPopLink  button_sm button_success" data-id="' . $driver->id . '" data-toggle="modal tooltip" data-target="#myModal">' . __('administrator.show') . '</a>
                    '.$edit ;
                })


                ->editColumn('image', function ($data) {
                    if (!empty($data->avartar)) {
                        $barcode_img = asset("/images/upload/$data->avartar");
                    } else {
                        $barcode_img = asset("/images/default.jpg");
                    }
                    return  '<img class="img-detail zoom" src="' . $barcode_img . '" width="40">';
                })
                ->addColumn('share_fee', function ($data) {

                    if ($data->share_fee_type == 1) {   // $
                        return $data->share_fee . ' $';
                    } else {      // %
                        return $data->share_fee . ' %';
                    }
                })
                ->addColumn('date_of_birth', function ($data) {
                    return date('d-m-Y', strtotime($data->date_of_birth));
                })
                ->addColumn('join_date', function ($data) {
                    return date('d-m-Y', strtotime($data->join_date));
                })
                ->rawColumns(['image' => 'image'])
                ->addIndexColumn()
                ->make(true);
        }

        return \view('administrator.driver.index');
    }

    public function create()
    {

        return \view('administrator.driver.create');
    }

    public function store(Request $request)
    {

        // try {
        //     DB::beginTransaction();
        $this->validate($request, [
            'name' => 'required',
            'gender' => 'required',
            'phone' => 'required',
            'share_fee' => 'required',
            'gender' => 'required',
            'email'     => 'required|max:255|unique:users,email',
            'password'  => 'required|same:confirm_password|string|min:8'
        ]);

        $gallery = '';

        if ($files = $request->file('image')) {

            $original_name = $files->getClientOriginalName();
            $original_name = date('ymdhis') . $original_name;
            $destinationPath = 'images/upload';
            $thum = Image::make($files->getRealPath())->resize(300, 400);
            $thum->save($destinationPath . '/' . $original_name, 80);
            $destinationPath = 'images/upload';
            $files->move($destinationPath, $original_name);
            $gallery = $original_name;
        } else {
            $gallery = 'default.jpg';
        }

        $driver = new User;
        $driver->user_type              =   2;
        $driver->name                   =   $request->name;
        $driver->card_number            =   $request->card_number;
        $driver->date_of_birth          =   $request->date_of_birth;
        $driver->gender                 =   $request->gender;
        $driver->phone                  =   $request->phone;
        $driver->join_date              =   $request->join_date;
        $driver->place_of_birth         =   $request->place_of_birth;
        $driver->current_address        =   $request->current_address;
        $driver->share_fee              =   $request->share_fee;
        $driver->share_fee_type         =   $request->share_fee_type;
        $driver->avartar                =   $gallery;
        $driver->menu_layout            = 'top';
        $driver->hover_text             = '1e272e';
        $driver->hover_bg               = 'ecf0f1';
        $driver->secondary_background   = '34495e';
        $driver->primary_background     = '1e272e';
        $driver->secondary_text         = '34495e';
        $driver->primary_text           = 'f39c12';
        $driver->animation_duration     = '0.2';
        $driver->animation              = 'zoomInUp';
        $driver->is_role                = 'Driver';
        $driver->email                  =   $request->email;
        if ($request['password']) {
            $driver->password               =   Hash::make($request['password']);
        }
        $driver->save();
        // } catch (\Exception $e) {
        //     DB::rollback();
        //     return redirect()->back()->with('danger', $e->getMessage());
        // }
        return redirect()->route('driver.index')->with('success', 'Driver created successfully');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $data = User::whereId($id)->first();
        return view('administrator.driver.edit', compact('data'));
    }

    public function update(Request $request, $id)
    {
        // dd($request);

        try {
            DB::beginTransaction();
            $this->validate($request, [
                'name' => 'required',
                'gender' => 'required',
                'phone' => 'required',
                'share_fee' => 'required',
                'gender' => 'required',
            ]);
            $gallery​ = '';
            if ($files = $request->file('avartar')) {
                $original_name = $files->getClientOriginalName();
                $original_name = date('ymdhis') . $original_name;
                $destinationPath = 'images/upload';
                $thum = Image::make($files->getRealPath())->resize(300, 400);
                $thum->save($destinationPath . '/' . $original_name, 80);
                $destinationPath = 'images/upload';
                $files->move($destinationPath, $original_name);
                $gallery = $original_name;
            } else {
                $gallery = $request->arrayImg;
            }

            $driver = User::find($id);
            $driver->user_type          =   2;
            $driver->name               =   $request->name;
            $driver->email               =   $request->email;
            $driver->card_number        =   $request->card_number;
            $driver->date_of_birth      =   $request->date_of_birth;
            $driver->gender             =   $request->gender;
            $driver->phone              =   $request->phone;
            $driver->join_date          =   $request->join_date;
            $driver->place_of_birth     =   $request->place_of_birth;
            $driver->current_address    =   $request->current_address;
            $driver->share_fee          =   $request->share_fee;
            $driver->share_fee_type     =   $request->share_fee_type;
            if ($request['password'] != null || $request['password'] != '') {
                $driver->password           = Hash::make($request['password']);
            }
            $driver->avartar            =    $gallery;
            $driver->save();
            DB::commit();
        } catch (\Exception $e) {
            DB::rollback();
            return redirect()->back()->with('danger', $e->getMessage());
        }
        return redirect()->route('driver.index')->with('success', 'Driver updated successfully');
    }

   
    public function driver_status(Request $request)
    {
        $user = User::find($request->user_id);
        $user->status = $request->status;
        $user->save();
        return response()->json(['success' => 'Status change successfully.']);
    }

    public function driver_info(Request $request)
    {
        $id = $request->showid;
        $driver_info = DB::table('users')
            ->where('users.id', $id)
            ->first();

        echo json_encode($driver_info);
    }

    public function history_driver()
    {
        return view('administrator.report.driver.history-driver');
    }
    

    public function datable_history_driver(Request $request)
    {
        $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers        = isset($request->drivers) ? $request->drivers : null;
        $status         = isset($request->status) ? $request->status : null;
        $clear          = isset($request->clear) ? $request->clear : null;
        $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
        $data = DB::table('nso007_delivery_order_detail')
        ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        ->select(
            'nso007_discount.discount',
            'nso007_discount.discount_type',
            'nso007_delivery_order_detail.clear_box_by',
            'nso007_delivery_order_detail.clear_box_code',
            'nso007_delivery_order_detail.delivery_order_id',
            'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
            'nso007_delivery_order.delivery_date',
            'nso007_export_stock.*',
            'nso007_export_stock.total_product AS total_price',
            'nso007_delivery_order_detail.status AS status_detail',
            'nso007_delivery_order_detail.status_paid',
            'nso007_delivery_order_detail.reason AS detail_reason',
            'nso007_delivery_order.driver_name',
            'nso007_delivery_order.inovice As driver_voucher',  
            'nso007_delivery_order_detail.total_riel',
            'nso007_delivery_order_detail.total_dollar',
            'nso007_delivery_order_detail.amount_pay_to',
            'nso007_delivery_order_detail.pay_to',
            'nso007_delivery_order_detail.invoice_payment_id',
            'nso007_delivery_order_detail.verify_by',

            \DB::raw('(CASE
            WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
            WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
            ELSE nso007_export_stock.taxi_shop_fee
            END) AS taxi_fee')
        )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                } 
            })
 
            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })

            ->when(request('clear'), function ($query) use ($clear) {
                if (!empty($clear)) {
                    if($clear == 'not_clear'){
                        $query->whereNull('nso007_delivery_order_detail.clear_box_code');

                    }else{
                        $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                    }
                }
            })
            ->where(function ($query) use ($drivers) {
                if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                    $query->where('merchant_id', \Auth::user()->id);
                } else if (\Globals::is_Driver() == 'Driver') {
                    $query->where('driver_id', \Auth::user()->id);
                } else {
                    $query->where('driver_id', 'LIKE', $drivers);
                }
            })
        ->where('driver_id', 'LIKE', $drivers)
        ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
        ->where('nso007_delivery_order_detail.status', '!=',0)
        ->orderBy('nso007_export_stock.box_code','desc');

            return DataTables::of($data)
                ->editColumn('pay_to_delivery', function ($data)  {
                    if ($data->pay_to == 'delivery'){
                        return    '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })

                ->editColumn('pay_to_shop', function ($data)  {
                    if ($data->pay_to == 'shop'){
                        return   '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })
                
                ->addColumn('price', function ($data) {
                    return '$' . numberFormat($data->total_price);
                })

                ->addColumn('reason', function ($data) {
                    return ($data->detail_reason == null ? "" :  $data->detail_reason ). ' '. ($data->driver_note == null ? "" :  $data->driver_note);
                })

                ->addColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->export_date)) .' <br> '. date('d-m-Y', strtotime($data->delivery_date));
                })


                ->addColumn('verify_by', function ($data) {

                    if($data->verify_by){
                        return      $data->verify_by; 
                    }
                    return      '<span class="class_'.$data->id.'_'.$data->delivery_order_id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("driver.verify_by", [$data->id,$data->delivery_order_id]) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                })

                ->editColumn('taxi_fee', function ($data)  {

                    $return_ = '';
                    if($data->taxi_status == 1){
                        if ($data->taxi_fee_symbol == '៛') {
                            $return_ = $data->taxi_fee >=1 ?(numberFormat( $data->taxi_fee).' ៛') : ''; 
                        }elseif($data->taxi_fee_symbol == '$'){
                            $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : ''; 
                        }
                    }
                    else{
                        $return_ =   '';                        
                    }

                    if($data->status_detail != 3){ 
                        if($data->taxi_fee_symbol == '៛'){
                            return '<riel>'.$return_ .'</riel>';
                        }
                        return $return_ ;
                    }else{
                        if($data->taxi_fee_symbol == '៛'){
                            return '<riel>'.$return_ .'</riel>';
                        }
                        return $return_;
                    }

                })


                ->editColumn('delivery_fee', function ($data)  {
                    $delivery_fee  = 0;
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee =$data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if($data->delivery_status == 1){
                        if ($data->delivery_fee_symbol == '$') {
                            $delivery_fee = '$'.numberFormat($delivery_fee) . ' s';
                        }elseif($data->delivery_fee_symbol == '៛'){
                            $delivery_fee = '<riel>'.numberFormat($delivery_fee) . '៛ s</riel>';
                        }
                    }
                    else{
                        if ($data->delivery_fee_symbol == '$') {
                            $delivery_fee = '$'.numberFormat( $delivery_fee). ' c';;
                        }elseif($data->delivery_fee_symbol == '៛'){
                            $delivery_fee = '<riel>'.numberFormat($delivery_fee) . '៛ c</riel>';
                        }
                        
                    }

                    if($data->delivery_pay_or_paid == 'paid'){
                        $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                    } 

                    if($data->status_detail != 3){ 
                        return $delivery_fee ;
                    }else{
                        return $delivery_fee;
                    } 
                })

                // ->addColumn('extra_fee_view', function ($data)  {
                //     if($data->extra_fee_type == 1) {
                //         return  '$'.number_format( $data->extra_fee,2)  . ' s'; }
                //     else if($data->extra_fee_type == 2)   {
                //         return  '$'.number_format( $data->extra_fee,2) . ' c';    }
                //     else  {
                //         return '$0';  } 
                // })

                ->editColumn('extra_fee', function ($data)  {

                    $return_ = '';
                    if($data->extra_fee_type == 1) {
                        $return_ =  '$'.numberFormat( $data->extra_fee)  . ' s'; }
                    else if($data->extra_fee_type == 2)   {
                        $return_ =  '$'.numberFormat( $data->extra_fee) . ' c';    }
                    else  {
                        $return_ = ''; 
                    }

                    if($data->status_detail != 3){ 
                        return $return_ ;
                    }else{
                        return $return_;
                    }


                })
                ->editColumn('other_service_fee', function ($data)  {
                    $return_1 = '';


                    if($data->other_services_type == 1){
                         $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'s') : ''  ;
                    }
                    else if($data->other_services_type == 2){ 
                         $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'c') : ''  ;
                    }else{
                         $return_1 =   '';                        
                    }


                    if($data->status_detail != 3){ 
                        return $return_1 ;
                    }else{
                        return $return_1;
                    }

                })
                
                ->addColumn('status', function ($data) {
                    if ($data->status_detail == 1)  // 1 = Processing,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
                    else if ($data->status_detail == 2)  // 2 = Padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
                    else if ($data->status_detail == 3)  //  3 = Done ,
                        return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
                    else if ($data->status_detail == 4)  // 4 = Cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
                    else {
                        return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
                    }
                })
                ->addColumn('clear_box_code',function($data){
                    if( request()->drivers && $data->clear_box_code != 1 ){
                        return '<div><input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                    }
                    
                    if($data->clear_box_code){
                        return '<span >  '.explode(',',$data->clear_box_by)[1].'</span>';
                    }
                })

                ->addColumn('clear_with_shop',function($data){
                    if( $data->invoice_payment_id ){
                        return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                    }
                    
                }) 

                ->addColumn('user_currency',function($data){
                    return  (User::find($data->merchant_id)->user_currency);
                })  
               
                ->addColumn('action', function ($data) {
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee = $data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if($data->delivery_pay_or_paid == 'paid'){
                        $delivery_fee  =  0;
                    }

                    $other_services_fee =  0;
                    if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                        $other_services_fee = $data->other_services_fee ;
                    }

                    $edit = '';
                    if($data->status_detail == 3 && Gate::check('Report Driver Edit'))
                        {
                            $edit = '<a 
                            data-price ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                            data-href="' . route("driver.edit_price", $data->id) . '" class="button_primary fa fa-edit bt-edit"></a>';
                        }
                    $delete = '';
                        $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    if(!$data->invoice_payment_id){
                        return $delete .''.$edit ;
                    }
                })

                ->editColumn('total_dollar', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return ($data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '');
                    }else{
                        return $data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '';
                    } 
                })

                ->editColumn('total_riel', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return ($data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '');
                    }else{
                        return $data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '';
                    } 
                })
                

                ->editColumn('total_price', function ($data)  {
                    if($data->status_detail != 3){ 
                        
                        if($data->total_product_symbol == '៛'){
                            return  '<riel>'.numberFormat( $data->total_price).' ៛</riel>' ;
                        }
                        return  '$'.numberFormat( $data->total_price) ;
                    }else{
                        
                        if($data->total_product_symbol == '៛'){
                            return  '<riel>'.numberFormat($data->total_price).' ៛</riel>' ;
                        }
                        return  '$'.numberFormat( $data->total_price) ;
                    }
                })
                
                ->rawColumns([ 'verify_by'=>'verify_by', 'other_service_fee'=>'other_service_fee','taxi_fee'=>'taxi_fee','total_price'=>'total_price','extra_fee'=>'extra_fee','delivery_fee'=>'delivery_fee','total_dollar'=>'total_dollar','total_riel'=>'total_riel','status' => 'status','clear_box_code'=>'clear_box_code','clear_by'=>'clear_by','action'=>'action','clear_with_shop'=>'clear_with_shop','date'=>'date'])
                ->addIndexColumn()
                ->make(true);
    }
    public function history_driver_detail(Request $request)
    {
        $time_policy = $request->time_policy;
        $from_date      = empty($request->date_delivery) ? '' : date('Y-m-d', strtotime($request->date_delivery));
        $to_date        = empty($request->date_delivery) ? '' : date('Y-m-d', strtotime($request->date_delivery));
        $drivers        = isset($request->driver_id) ? $request->driver_id : null;
        $status         = isset($request->status) ? $request->status : null;
        $clear          = isset($request->clear) ? $request->clear : null;
        $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
        if($request->ajax()){
                $data = \DB::table('nso007_delivery_order_detail')
                ->join('nso007_delivery_order', 'nso007_delivery_order.id', 'nso007_delivery_order_detail.delivery_order_id')
                ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
                ->leftjoin('nso007_discount', 'nso007_discount.id', 'nso007_export_stock.discount_id')
                ->select(
                    'nso007_discount.discount',
                    'nso007_discount.discount_type',
                    'nso007_delivery_order_detail.clear_box_by',
                    'nso007_delivery_order_detail.clear_box_code',
                    'nso007_delivery_order_detail.delivery_order_id',
                    'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
                    'nso007_delivery_order.delivery_date',
                    'nso007_export_stock.*',
                    'nso007_export_stock.total_product AS total_price',
                    'nso007_delivery_order_detail.status AS status_detail',
                    'nso007_delivery_order_detail.status_paid',
                    'nso007_delivery_order_detail.reason AS detail_reason',
                    'nso007_delivery_order.driver_name',
                    'nso007_delivery_order.inovice As driver_voucher',
                    'nso007_delivery_order_detail.total_riel',
                    'nso007_delivery_order_detail.total_dollar',
                    'nso007_delivery_order_detail.amount_pay_to',
                    'nso007_delivery_order_detail.pay_to',
                    'nso007_delivery_order_detail.invoice_payment_id',
                    'nso007_delivery_order_detail.verify_by',
                    \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
                )
                    ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                        if (!empty($from_date) && !empty($to_date)) {
                            $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                        }
                    })
                    ->when($time_policy, function ($query) use ($time_policy) {
                            $query->where('nso007_delivery_order.time_policy', $time_policy);
                    })
        
                    ->when(request('status'), function ($query) use ($status) {
                        if (!empty($status)) {
                            $status_1 = '';
                            foreach ($status as $key => $value) {
                                $status_1  .= $status[$key] . ',';
                            }
                            $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                        }
                    })

                    ->when(request('clear'), function ($query) use ($clear) {
                        if (!empty($clear)) {
                            if ($clear == 'not_clear') {
                                $query->whereNull('nso007_delivery_order_detail.clear_box_code');
                            } else {
                                $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                            }
                        }
                    })
                    ->where(function ($query) use ($drivers) {
                        if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                            $query->where('merchant_id', \Auth::user()->id);
                        } elseif (\Globals::is_Driver() == 'Driver') {
                            $query->where('driver_id', \Auth::user()->id);
                        } else {
                            $query->where('driver_id', 'LIKE', $drivers);
                        }
                    })
                ->where('driver_id', 'LIKE', $drivers)
                ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
                ->where('nso007_delivery_order_detail.status', '!=', 0)
                ->orderBy('nso007_export_stock.box_code', 'desc');

        return DataTables::of($data)
                ->editColumn('pay_to_delivery', function ($data) {
                    if ($data->pay_to == 'delivery') {
                        return    '$'.numberFormat($data->amount_pay_to);
                    } else {
                        return    '';
                    }
                })

                ->editColumn('pay_to_shop', function ($data) {
                    if ($data->pay_to == 'shop') {
                        return   '$'.numberFormat($data->amount_pay_to);
                    } else {
                        return    '';
                    }
                })
                
                ->addColumn('price', function ($data) {
                    // return  $data->total_product_symbol = '$' ? '$' . numberFormat($data->total_price) : numberFormat($data->total_price).' ៛';
                    return '$' . numberFormat($data->total_price);
                })

                ->addColumn('reason', function ($data) {
                    return ($data->detail_reason == null ? "" :  $data->detail_reason). ' '. ($data->driver_note == null ? "" :  $data->driver_note);
                })

                ->addColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->export_date)) .' <br> '. date('d-m-Y', strtotime($data->delivery_date));
                })


                ->addColumn('verify_by', function ($data) {
                    if ($data->verify_by) {
                        return      $data->verify_by;
                    }
                    return      '<span class="class_'.$data->id.'_'.$data->delivery_order_id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("driver.verify_by", [$data->id,$data->delivery_order_id]) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                })

                ->editColumn('taxi_fee', function ($data) {
                    $return_ = '';
                    if ($data->taxi_status == 1) {
                        // $return_ = $data->taxi_fee >=1 ?('$'.numberFormat($data->taxi_fee).' s') : '';
                        if($data->taxi_fee_symbol == '$'){
                           $return_ = '<dollar>$'.numberFormat($data->taxi_fee).' s</dollar>';
                        }
                        if($data->taxi_fee_symbol == '៛'){
                            $return_ = '<riel>'.numberFormat($data->taxi_fee).'៛ s<riel>';
                        }
                    } else {
                        $return_ =   '';
                    }
                    if ($data->status_detail != 3) {
                        return $return_ ;
                    } else {
                        return $return_;
                    }
                })


                ->editColumn('delivery_fee', function ($data) {
                    $delivery_fee  = 0;
                    if ($data->discount_type != null || $data->discount_type != '') {
                        if ($data->discount_type == 1) {
                            $delivery_fee = $data->discount;
                        } elseif ($data->discount_type == 2) {
                            $delivery_fee = ((100 - $data->discount)* $data->delivery_fee) / 100;
                        } else {
                            $delivery_fee =$data->delivery_fee;
                        }
                    } else {
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if ($data->delivery_status == 1) {
                        if($data->delivery_fee_symbol == "៛"){
                            $delivery_fee = '<riel>'.numberFormat($delivery_fee) . '៛ s</riel>';
                        }
                        if($data->delivery_fee_symbol == "$"){
                            $delivery_fee = '$'.numberFormat($delivery_fee) . ' s';
                        }
                        
                    } else {
                        if($data->delivery_fee_symbol == "$"){
                            $delivery_fee = '$'.numberFormat($delivery_fee). ' c';
                        }
                        if($data->delivery_fee_symbol == "៛"){
                            $delivery_fee = '<riel>'.numberFormat($delivery_fee). '៛ c</riel>';
                        }
                        
                    }

                    if ($data->delivery_pay_or_paid == 'paid') {
                        $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                    }

                    if ($data->status_detail != 3) {
                        return $delivery_fee ;
                    } else {
                        return $delivery_fee;
                    }
                })
                ->editColumn('extra_fee', function ($data) {
                    $return_ = '';
                    if ($data->extra_fee_type == 1) {
                        $return_ =  '$'.numberFormat($data->extra_fee)  . ' s';
                    } elseif ($data->extra_fee_type == 2) {
                        $return_ =  '$'.numberFormat($data->extra_fee) . ' c';
                    } else {
                        $return_ = '';
                    }

                    if ($data->status_detail != 3) {
                        return $return_ ;
                    } else {
                        return $return_;
                    }
                })
                ->editColumn('other_service_fee', function ($data) {
                    $return_1 = '';


                    if ($data->other_services_type == 1) {
                        $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat($data->other_services_fee).'s') : ''  ;
                    } elseif ($data->other_services_type == 2) {
                        $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat($data->other_services_fee).'c') : ''  ;
                    } else {
                        $return_1 =   '';
                    }


                    if ($data->status_detail != 3) {
                        return $return_1 ;
                    } else {
                        return $return_1;
                    }
                })
                
                ->addColumn('status', function ($data) {
                    if ($data->status_detail == 1) {  // 1 = Processing,
                        return ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '</strong>';
                    } elseif ($data->status_detail == 2) {  // 2 = Padding,
                        return '  <strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . ' </strong>';
                    } elseif ($data->status_detail == 3) {  //  3 = Done ,
                        return ' <strong class="text-info"><span class="fa fa-check"></span>  ' . __('administrator.done') . ' </strong>';
                    } elseif ($data->status_detail == 4) {  // 4 = Cancel
                        return ' <strong class="text-danger"><span class="fa fa-ban"></span>  ' . __('administrator.cancel') . '</strong>';
                    } else {
                        return ' <strong class="text-muted"><span class="fa fa-check"></span>  ' . __('administrator.paid') . '</strong>';
                    }
                })
                ->addColumn('clear_box_code', function ($data) {
                    if (request()->drivers && $data->clear_box_code != 1) {
                        return '<div><input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                    }
                    
                    if ($data->clear_box_code) {
                        return '<span >  '.explode(',', $data->clear_box_by)[1].'</span>';
                    }
                })

                ->addColumn('clear_with_shop', function ($data) {
                    if ($data->invoice_payment_id) {
                        return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                    }
                })

                ->addColumn('user_currency', function ($data) {
                    return  (User::find($data->merchant_id)->user_currency);
                })
               
                ->addColumn('action', function ($data) {
                    if ($data->discount_type != null || $data->discount_type != '') {
                        if ($data->discount_type == 1) {
                            $delivery_fee = $data->discount;
                        } elseif ($data->discount_type == 2) {
                            $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee) / 100;
                        } else {
                            $delivery_fee = $data->delivery_fee;
                        }
                    } else {
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if ($data->delivery_pay_or_paid == 'paid') {
                        $delivery_fee  =  0;
                    }

                    $other_services_fee =  0;
                    if ($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2) {
                        $other_services_fee = $data->other_services_fee ;
                    }

                    $edit = '';
                    if ($data->status_detail == 3 && Gate::check('Report Driver Edit')) {
                        $edit = '<a 
                            data-price ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                            data-href="' . route("driver.edit_price", $data->id) . '" class="button_primary fa fa-edit bt-edit"></a>';
                    }
                    $delete = '';
                    $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    if (!$data->invoice_payment_id) {
                        return $delete .''.$edit ;
                    }
                })

                ->editColumn('total_dollar', function ($data) {
                    if ($data->status_detail != 3) {
                        return ($data->total_dollar > 0 ? ('$'.numberFormat($data->total_dollar)) : '');
                    } else {
                        return $data->total_dollar > 0 ? ('$'.numberFormat($data->total_dollar)) : '';
                    }
                })

                ->editColumn('total_riel', function ($data) {
                    if ($data->status_detail != 3) {
                        return ($data->total_riel > 0 ? (''.numberFormat($data->total_riel)).'៛' : '');
                    } else {
                        return $data->total_riel > 0 ? (''.numberFormat($data->total_riel)).'៛' : '';
                    }
                })
                

                ->editColumn('total_price', function ($data) {
                    $total_price =  $data->total_product_symbol == '$' ? '$' . numberFormat($data->total_price) : '<riel>'.numberFormat($data->total_price).' ៛';
                    // return $total_price;
                    if ($data->status_detail != 3) {
                        return '<samp>'. $total_price  ;
                    } else {
                        return $total_price;
                    }
                })
                
                ->rawColumns([ 'verify_by'=>'verify_by', 'other_service_fee'=>'other_service_fee','taxi_fee'=>'taxi_fee','total_price'=>'total_price','extra_fee'=>'extra_fee','delivery_fee'=>'delivery_fee','total_dollar'=>'total_dollar','total_riel'=>'total_riel','status' => 'status','clear_box_code'=>'clear_box_code','clear_by'=>'clear_by','action'=>'action','clear_with_shop'=>'clear_with_shop','date'=>'date'])
                ->addIndexColumn()
                ->make(true);
        }
        return view('administrator.report.driver.history-driver-detail',compact('drivers','from_date','time_policy'));
    }
    public function summary_driver()
        {

            $data = User::where('user_type',2)->where('status',1)->get();
            $secondArray = []; $firstArray = [];
            foreach($data as $key => $value)
            {
                $exprt = DeliveryOrderModel::where('delivery_date',date('Y-m-d'))->where('driver_id',$value->id)->groupBy('driver_id')->get();
                if( $exprt->count() > 0 ){
                    $value->name  =   '->  ' .$value->name  ;
                    $firstArray[$value->id] = $value->name;
                }else{
                    $value->name  =  $value->name  ;
                    $secondArray[$value->id] = $value->name;
                }
            }
            $drivers = array(
                ''=> __('administrator.please_choose'),
            );
            foreach($firstArray as $key => $value){
                $drivers[$key] = $value;
            }
            foreach($secondArray as $key => $value){
                $drivers[$key] = $value;
            }

            return view('administrator.report.summary-driver', compact('drivers'));
        }

    public function datable_summary_driver(Request $request)
    {

        $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers        = isset($request->drivers) ? $request->drivers : null;
        $status         = isset($request->status) ? $request->status : null;
        $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
        $data   =  DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
            ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
            ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
            ->select('nso007_delivery_order_detail.*', 'nso007_delivery_order.*','nso007_export_stock.*','nso007_export_stock_details.*')
            ->groupBy('nso007_delivery_order.driver_id ')
            ->whereIn('nso007_delivery_order_detail.status',[3,5])
            ->get();
        if ($request->isMethod('get')) {
            return DataTables::of($data)
                ->editColumn('driver_name', function ($data) {
                    return $data[0]->driver_name;
                })
                ->editColumn('box', function ($data) {
                    $box = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                        ->whereIn('nso007_delivery_order_detail.status',[3,5])->count();

                    return $box;
                })
                ->editColumn('share_commission', function ($data) {
                    if($data[0]->commission_type == 1){
                        return number_format($data[0]->driver_commission,2).'$';
                    }else{
                        return number_format($data[0]->driver_commission,0).'%';
                    }
                })
                ->editColumn('driver_commission', function ($data) {
                    $total_box = DeliveryOrderModel::join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
                        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                        ->whereIn('nso007_delivery_order_detail.status',[3,5])->get();

                    $commission = 0 ;
//                    dd($total_box);
                    foreach ($total_box as $box){
                        if($box->commission_type == 1){
                            $commission += $total_box->count() * $box->driver_commission;
                        }else{
                            $commission += $box->delivery_fee * ($box->driver_commission/100);
                        }
                    }

                    return  number_format($commission,2).'$' ;
                })

//                ->rawColumns(['status' => 'status'])
                ->addIndexColumn()
                ->make(true);
        } else {
            echo json_encode($data);
        }
    }

   

    public function history_driver_print(Request $request)
    {
        // dd($request->all());
        $branch  =  BranchModel::first();

        $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers        = isset($request->drivers) ? $request->drivers : null;
        $clear          = isset($request->clear) ? $request->clear : null;
        $status         = isset($request->status) ? $request->status : null;
        $driver_voucher = isset($request->driver_voucher) ? $request->driver_voucher : null;
        $time_policy = $request->time_policy;
        $data = DeliveryOrderModel::
        join('nso007_delivery_order_detail', 'nso007_delivery_order_detail.delivery_order_id', 'nso007_delivery_order.id')
        ->join('nso007_export_stock', 'nso007_export_stock.id', 'nso007_delivery_order_detail.export_id')
        ->join('users AS merchant', 'merchant.id', 'nso007_export_stock.merchant_id')
        ->join('nso007_location', 'nso007_location.id', 'nso007_export_stock.location')
        ->join('nso007_export_stock_details', 'nso007_export_stock_details.export_id', 'nso007_export_stock.id')
        ->join('nso007_category', 'nso007_category.id', 'nso007_export_stock_details.category_id')
        ->join('users AS driver', 'driver.id', 'nso007_delivery_order.driver_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id');

        if (\Globals::check_lang() == 'en') {
            $data = $data->select(
                'nso007_discount.*',
                'nso007_export_stock.*',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order_detail.*',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'driver.id AS driver_id',
                'nso007_location.name_en AS name_location',
                'nso007_category.name_en AS category_name',
                'driver.name AS driver_name',
                'nso007_delivery_order_detail.commission_type AS share_fee_type',
                'nso007_delivery_order_detail.driver_commission AS share_fee',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                'nso007_delivery_order.inovice As driver_voucher',
                'nso007_delivery_order.delivery_date',


                \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
        } else {
            $data = $data->select(
                'nso007_discount.*',
                'nso007_export_stock.*',
                'nso007_delivery_order_detail.status',
                'nso007_delivery_order_detail.reason',
                'nso007_delivery_order_detail.clear_box_code',
                'nso007_delivery_order.inovice',
                'nso007_delivery_order_detail.*',
                'merchant.shop_name',
                'merchant.id AS merchant_id',
                'driver.id AS driver_id',
                'nso007_location.name_km AS name_location',
                'nso007_category.name_km AS category_name',
                'nso007_delivery_order_detail.commission_type AS share_fee_type',
                'nso007_delivery_order_detail.driver_commission AS share_fee',
                'nso007_delivery_order.inovice As driver_voucher',
                'nso007_delivery_order.delivery_date',

                'driver.name AS driver_name',
                'nso007_delivery_order_detail.id AS delivery_order_detail_id',
                \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
                \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee')
            );
        }
        $data = $data
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                }
            })
            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })
            ->when(request('time_policy'), function ($query) use ($time_policy) {
                $query->where('nso007_delivery_order.time_policy',$time_policy);
            })
            
            ->where(function ($query) use ($drivers) {
                if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                    $query->where('merchant_id', \Auth::user()->id);
                } else if (\Globals::is_Driver() == 'Driver') {
                    $query->where('driver_id', \Auth::user()->id);
                } else {
                    $query->where('driver_id', 'LIKE', $drivers);
                }
            })
            ->when(request('clear'), function ($query) use ($clear) {
                if (!empty($clear)) {
                    if($clear == 'not_clear'){
                        $query->whereNull('nso007_delivery_order_detail.clear_box_code');

                    }else{
                        $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                    }
                }
            })

            ->where('driver_id', 'LIKE', $drivers)
            ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
            ->orderBy('nso007_delivery_order.inovice', 'desc')
            ->groupBy('nso007_delivery_order_detail.delivery_order_id')
            ->groupBy('nso007_export_stock_details.export_id')
            ->get();
            return view('administrator.report.driver.history-driver-print',compact('data','branch'));
    }

    function driver_clear_box( Request $request){
        try{
            DB::beginTransaction();
            if($request->export_id){
                DeliveryOrderDetailModel::whereIn('id',explode(',',$request->export_id))->update(['clear_box_code'=>'1','clear_box_by'=> (\Auth::user()->id .',' .FindDUser(\Auth::user()->id)->name ) ]);
                DB::commit();
                return response()->json(['success' => true]);
            }else{
                return response()->json(['success' => false,'error' =>'please check and try again']);
            }
        }catch(Exception $e){
            DB::rollBack();
            return response()->json(['success' => false,'error' => $e->getMessage()]);
        }
    }   

    function edit_price( Request $request , $id){



        try {
            \DB::beginTransaction();

            // 1 = Processing, 2 = Padding, 3 = Done , 4 = Cancel  ,5= paid
            if($request->status == 'no_taxi'){

                $export_stock = ExportStockModel::find($id);
                $export_stock->driver_note  = $request->driver_note ;
                $export_stock->delivery_fee  = $request->delivery_fee ;



                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->update();
                } 


                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$id)->where('status',3)->first();
                $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;
                $deliveryorderdetail->update();

                $deliveryorderdetailSuccess = DeliveryOrderDetailSuccessModel::where('export_id',$id)->first();

                $deliveryorderdetailSuccess->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetailSuccess->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetailSuccess->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetailSuccess->pay_to                    =       $request->pay_to;

                $deliveryorderdetailSuccess->update();
            }
            else{ 
                $export_stock = ExportStockModel::find($id);
                $export_stock->delivery_fee  = $request->delivery_fee ;
                $export_stock->driver_note  = $request->driver_note ;

                if($request->extra_fee_type != '' && $request->extra_fee !== "" &&  $request->extra_fee > 0){
                    $export_stock->extra_fee_type       =   $request->extra_fee_type;
                    $export_stock->extra_fee            =   $request->extra_fee;
                    $export_stock->update();
                }
                else{
                    $export_stock->extra_fee_type       =   null;
                    $export_stock->extra_fee            =   0;
                    $export_stock->update();
                } 

                $deliveryorderdetail = DeliveryOrderDetailModel::where('export_id',$id)->where('status',3)->first();
                $deliveryorderdetail->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetail->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetail->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetail->pay_to                    =       $request->pay_to;

                $deliveryorderdetail->update();

                $deliveryorderdetailSuccess = DeliveryOrderDetailSuccessModel::where('export_id',$id)->first();
                $deliveryorderdetailSuccess->total_riel                =       $request->currency_rial == '' ? 0 : $request->currency_rial ;
                $deliveryorderdetailSuccess->total_dollar              =       $request->currency_usd == '' ? 0 : $request->currency_usd ;
                $deliveryorderdetailSuccess->amount_pay_to             =       $request->amount_pay_to_aba;
                $deliveryorderdetailSuccess->pay_to                    =       $request->pay_to;

                $deliveryorderdetailSuccess->update();


                $export_stock = ExportStockModel::find($id);

                if($request->taxi_status == 1){
                    $export_stock->taxi_shop_fee    =   $request->taxi_fee;
                    $export_stock->taxi_cust_fee    =   0;

                }else{
                    $export_stock->taxi_cust_fee    =   $request->taxi_fee;
                    $export_stock->taxi_shop_fee    =   0;
                }
                $export_stock->taxi_number      = $request->taxi_number;
                $export_stock->taxi_status      =  $request->taxi_status;
                $export_stock->update();
            }


            \DB::commit();
                return response ()->json(200) ;
            } catch (\Exception $e) {
                throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
        } 
    }
    
    function verify_by( Request $request , $id, $delivery_order_id){

 
        $auth = \Auth::user();


        try {
            \DB::beginTransaction();
                $data = DeliveryOrderDetailModel::where('export_id',$id)->where('delivery_order_id',$delivery_order_id)->first();
                $data->verify_id  = $auth->id;
                $data->verify_by  = $auth->name;
                $data->update();

                \DB::commit();
                return response()->json(['success' => 200 ,'class'=> 'class_'.$id.'_'.$delivery_order_id ,'verify_by'=> $auth->name]);


            } catch (\Exception $e) {
                throw ValidationException::withMessages(['field_name' => 'ERRER SERVER' ]);
        } 
    }
    public function history_by_driver(Request $request){
        if($request->ajax()){
            $from_date      = empty($request->from_date) ? '' : date('Y-m-d', strtotime($request->from_date));
        $to_date        = empty($request->to_date) ? '' : date('Y-m-d', strtotime($request->to_date));
        $drivers        = isset($request->drivers) ? $request->drivers : null;
        $status         = isset($request->status) ? $request->status : null;
        $clear          = isset($request->clear) ? $request->clear : null;
        $driver_voucher         = isset($request->driver_voucher) ? $request->driver_voucher : null;
        $data = \DB::table('nso007_delivery_order_detail')
        ->join('nso007_delivery_order','nso007_delivery_order.id','nso007_delivery_order_detail.delivery_order_id') 
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->leftjoin('nso007_discount','nso007_discount.id','nso007_export_stock.discount_id')
        ->select(
            'nso007_discount.discount',
            'nso007_discount.discount_type',
            'nso007_delivery_order_detail.clear_box_by',
            'nso007_delivery_order_detail.clear_box_code',
            'nso007_delivery_order_detail.delivery_order_id',
            'nso007_delivery_order_detail.id As nso007_delivery_order_detail_id',
            'nso007_delivery_order.delivery_date',
            'nso007_delivery_order.driver_id',
            'nso007_export_stock.*',
            // 'nso007_export_stock.total_product AS total_price',
            'nso007_delivery_order_detail.status AS status_detail',
            'nso007_delivery_order_detail.status_paid',
            'nso007_delivery_order_detail.reason AS detail_reason',
            'nso007_delivery_order.driver_name',
            'nso007_delivery_order.time_policy',
            'nso007_delivery_order.inovice As driver_voucher',  
            // 'nso007_delivery_order_detail.total_riel',
            // 'nso007_delivery_order_detail.total_dollar',
            'nso007_delivery_order_detail.amount_pay_to',
            'nso007_delivery_order_detail.pay_to',
            'nso007_delivery_order_detail.invoice_payment_id',
            'nso007_delivery_order_detail.verify_by',

            \DB::raw('(CASE
            WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
            WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
            ELSE nso007_export_stock.taxi_shop_fee
            END) AS taxi_fee'),
            \DB::raw('sum(nso007_delivery_order_detail.status = 3) as total_done'),
            \DB::raw('sum(nso007_delivery_order_detail.status = 1) as total_proccessing'),
            \DB::raw('sum(nso007_delivery_order_detail.status = 2) as total_padding'),
            \DB::raw('sum(nso007_delivery_order_detail.status = 4) as total_cancel'),
            \DB::raw('sum(nso007_delivery_order_detail.total_dollar) as total_dollar'),
            \DB::raw('sum(nso007_delivery_order_detail.total_riel) as total_riel'),
            \DB::raw('sum(nso007_export_stock.total_product) as total_price'),
            \DB::raw('sum(CASE WHEN nso007_export_stock.total_product_symbol = "៛" THEN nso007_export_stock.total_product ELSE 0 END) as total_price_riel'),
            \DB::raw('sum(CASE WHEN nso007_export_stock.total_product_symbol = "$" THEN nso007_export_stock.total_product ELSE 0 END) as total_price_dollar'),

        )
            ->when(request('from_date', 'to_date'), function ($query) use ($from_date, $to_date) {
                if (!empty($from_date) && !empty($to_date)) {
                    $query->whereBetween('nso007_delivery_order.delivery_date', [$from_date, $to_date]);
                } 
            })
 
            ->when(request('status'), function ($query) use ($status) {
                if (!empty($status)) {
                    $status_1 = '';
                    foreach ($status as $key => $value) {
                        $status_1  .= $status[$key] . ',';
                    }
                    $query->whereIn('nso007_delivery_order_detail.status', explode(',', $status_1));
                }
            })

            ->when(request('clear'), function ($query) use ($clear) {
                if (!empty($clear)) {
                    if($clear == 'not_clear'){
                        $query->whereNull('nso007_delivery_order_detail.clear_box_code');

                    }else{
                        $query->whereNotNull('nso007_delivery_order_detail.clear_box_code');
                    }
                }
            })
            ->where(function ($query) use ($drivers) {
                if (\Globals::is_MerchantIn() == 'MerchantIn' || \Globals::is_MerchantOut() == 'MerchantOut') {
                    $query->where('merchant_id', \Auth::user()->id);
                } else if (\Globals::is_Driver() == 'Driver') {
                    $query->where('driver_id', \Auth::user()->id);
                } else {
                    $query->where('driver_id', 'LIKE', $drivers);
                }
            })
        ->where('driver_id', 'LIKE', $drivers)
        ->where('nso007_delivery_order.inovice', 'LIKE', $driver_voucher)
        ->where('nso007_delivery_order_detail.status', '!=', 0)
        ->orderBy('nso007_export_stock.box_code','desc')
        ->groupBy(['nso007_delivery_order.driver_id','nso007_delivery_order.delivery_date','nso007_delivery_order.time_policy']);

            return DataTables::of($data)
                ->editColumn('pay_to_delivery', function ($data)  {
                    if ($data->pay_to == 'delivery'){
                        return    '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })

                ->editColumn('pay_to_shop', function ($data)  {
                    if ($data->pay_to == 'shop'){
                        return   '$'.numberFormat( $data->amount_pay_to); 
                    }else{
                        return    '';
                    }
                })
                
                ->addColumn('price', function ($data) {
                    return '$' . numberFormat($data->total_price);
                })
                ->addColumn('driver_name', function ($data) {
                    $text = '';
                    if($data->time_policy == 1){
                        $text = "(ព្រឹក)";
                    }
                    if($data->time_policy == 2){
                        $text = "(ល្ងាច)";
                    }
                    return $data->driver_name.' '.$text;
                })

                ->addColumn('reason', function ($data) {
                    return ($data->detail_reason == null ? "" :  $data->detail_reason ). ' '. ($data->driver_note == null ? "" :  $data->driver_note);
                })

                ->addColumn('date', function ($data) {
                    return date('d-m-Y', strtotime($data->export_date)) .' <br> '. date('d-m-Y', strtotime($data->delivery_date));
                })


                ->addColumn('verify_by', function ($data) {

                    if($data->verify_by){
                        return      $data->verify_by; 
                    }
                    return      '<span class="class_'.$data->id.'_'.$data->delivery_order_id.'"> <span class="btn-light btn-xs verify_by"  style="border: 1px solid;" data-href="'. route("driver.verify_by", [$data->id,$data->delivery_order_id]) . '" >  <i class="fa fa-check" aria-hidden="true"></i></span> </span > ';// '<div><input type="checkbox" name="check_verify_by" class="checkbox_verify_by" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                })

                ->editColumn('taxi_fee', function ($data)  {

                    $return_ = '';
                    if($data->taxi_status == 1){
                        $return_ = $data->taxi_fee >=1 ?( '$'.numberFormat( $data->taxi_fee).' s') : ''; 

                    }
                    else{
                        $return_ =   '';                        
                    }

                    if($data->status_detail != 3){ 
                        return '<samp>'.$return_ ;
                    }else{
                        return $return_;
                    }

                })


                ->editColumn('delivery_fee', function ($data)  {
                    $delivery_fee  = 0;
                    if($data->discount_type != null || $data->discount_type != '')
                    {
                        if($data->discount_type == 1){
                            $delivery_fee = $data->discount;
                        }
                        elseif($data->discount_type == 2){
                            $delivery_fee = ( (100 - $data->discount )* $data->delivery_fee ) / 100;
                        }
                        else{
                            $delivery_fee =$data->delivery_fee;
                        }
                    }
                    else{
                        $delivery_fee  =  $data->delivery_fee;
                    }

                    if($data->delivery_status == 1){
                        $delivery_fee = '$'.numberFormat( $delivery_fee) . ' s';;
                    }
                    else{
                        $delivery_fee = '$'.numberFormat( $delivery_fee). ' c';;
                    }

                    if($data->delivery_pay_or_paid == 'paid'){
                        $delivery_fee =   '  <strike> '.$delivery_fee . '  </strike>';
                    } 

                    if($data->status_detail != 3){ 
                        return '<samp>'.$delivery_fee ;
                    }else{
                        return $delivery_fee;
                    } 
                })

                // ->addColumn('extra_fee_view', function ($data)  {
                //     if($data->extra_fee_type == 1) {
                //         return  '$'.number_format( $data->extra_fee,2)  . ' s'; }
                //     else if($data->extra_fee_type == 2)   {
                //         return  '$'.number_format( $data->extra_fee,2) . ' c';    }
                //     else  {
                //         return '$0';  } 
                // })

                ->editColumn('extra_fee', function ($data)  {

                    $return_ = '';
                    if($data->extra_fee_type == 1) {
                        $return_ =  '$'.numberFormat( $data->extra_fee)  . ' s'; }
                    else if($data->extra_fee_type == 2)   {
                        $return_ =  '$'.numberFormat( $data->extra_fee) . ' c';    }
                    else  {
                        $return_ = ''; 
                    }

                    if($data->status_detail != 3){ 
                        return '<samp>'.$return_ ;
                    }else{
                        return $return_;
                    }


                })
                ->editColumn('other_service_fee', function ($data)  {
                    $return_1 = '';


                    if($data->other_services_type == 1){
                         $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'s') : ''  ;
                    }
                    else if($data->other_services_type == 2){ 
                         $return_1 =  $data->other_services_fee >   0 ? ('$'.numberFormat( $data->other_services_fee).'c') : ''  ;
                    }else{
                         $return_1 =   '';                        
                    }


                    if($data->status_detail != 3){ 
                        return '<samp>'.$return_1 ;
                    }else{
                        return $return_1;
                    }

                })
                
                ->addColumn('status', function ($data) {
                    return '<button type="button" class="btn btn-primary">'.$data->total_proccessing.'</button>
                    <button type="button" class="btn btn-success">'.$data->total_done.'</button>
                    <button type="button" class="btn btn-warning"  style="margin-top:0px !important;">'.$data->total_padding.'</button>
                    <button type="button" class="btn btn-danger">'.$data->total_cancel.'</button>    
                    ​';
                })
                ->addColumn('clear_box_code',function($data){
                    if( request()->drivers && $data->clear_box_code != 1 ){
                        return '<div><input type="checkbox" name="check" class="checkbox" data-export_id="'.$data->nso007_delivery_order_detail_id.'"  ></div>';
                    }
                    
                    if($data->clear_box_code){
                        return '<span >  '.explode(',',$data->clear_box_by)[1].'</span>';
                    }
                })

                ->addColumn('clear_with_shop',function($data){
                    if( $data->invoice_payment_id ){
                        return '<span class="btn-info btn-xs" style="background: red;">  Clear</span>';
                    }
                    
                }) 

                ->addColumn('user_currency',function($data){
                    return  (User::find($data->merchant_id)->user_currency);
                })  
               
                ->addColumn('action', function ($data) {
                    // if($data->discount_type != null || $data->discount_type != '')
                    // {
                    //     if($data->discount_type == 1){
                    //         $delivery_fee = $data->discount;
                    //     }
                    //     elseif($data->discount_type == 2){
                    //         $delivery_fee = ((100 -  $data->discount) * $data->delivery_fee ) / 100;
                    //     }
                    //     else{
                    //         $delivery_fee = $data->delivery_fee;
                    //     }
                    // }
                    // else{
                    //     $delivery_fee  =  $data->delivery_fee;
                    // }

                    // if($data->delivery_pay_or_paid == 'paid'){
                    //     $delivery_fee  =  0;
                    // }

                    // $other_services_fee =  0;
                    // if($data->other_services_fee > 0 && $data->other_services_pay_or_paid == 'pay' && $data->other_services_type == 2){
                    //     $other_services_fee = $data->other_services_fee ;
                    // }

                    // $edit = '';
                    // if($data->status_detail == 3 && Gate::check('Report Driver Edit'))
                    //     {
                    //         $edit = '<a 
                    //         data-price ="'.($data->delivery_status == 2 ? $delivery_fee+$data->total_price+ $other_services_fee :  $data->total_price +  $other_services_fee).'"​​
                    //         data-href="' . route("driver.edit_price", $data->id) . '" class="button_primary fa fa-edit bt-edit"></a>';
                    //     }
                    // $delete = '';
                    //     $delete = '<a data-href="' . route("export_stock_delete_box", [$data->nso007_delivery_order_detail_id,'in_processing']) . '" class="button_warning fa fa-trash bt-delete" style="background: #d93830;"></a>';
                    // if(!$data->invoice_payment_id){
                    //     return $delete .''.$edit ;
                    // }
                    $edit = '<a href="'. route("history_driver_detail","driver_id=".$data->driver_id)."&&date_delivery=".$data->delivery_date."&&time_policy=".$data->time_policy .'"  data-href="{{route("history_driver_detail")}}" class="button_primary fa fa-eye"></a>';

                    return $edit;
                })

                ->editColumn('total_dollar', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return '<samp>'.($data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '');
                    }else{
                        return $data->total_dollar > 0 ? ('$'.numberFormat( $data->total_dollar)) : '';
                    } 
                })

                ->editColumn('total_riel', function ($data)  { 
                    if($data->status_detail != 3){ 
                        return '<samp>'.($data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '');
                    }else{
                        return $data->total_riel > 0 ? (''.numberFormat( $data->total_riel)).'៛' : '';
                    } 
                    
                })
                

                ->addColumn('total_price_riel', function ($data)  {

                    if($data->status_detail != 3){ 
                        if($data->total_product_symbol == "៛"){
                            return '<samp>'. numberFormat( $data->total_price_riel).' ៛';
                        }
                        return '';
                        // return '<samp>'. '$'.numberFormat( $data->total_price_riel)  ;
                    }else{
                        if($data->total_product_symbol == "៛"){
                            return numberFormat( $data->total_price_riel).' ៛' ;
                        }
                        return '';
                        // return '$'.numberFormat( $data->total_price);
                    }
                })
                ->addColumn('total_price_dollar', function ($data)  {
                    if($data->status_detail != 3){ 
                        return '<samp>'. '$'.numberFormat( $data->total_price_dollar)  ;
                    }else{
                        return '$'.numberFormat( $data->total_price_dollar);
                    }
                })
                ->editColumn('total_price', function ($data)  {

                    if($data->status_detail != 3){ 
                        return '<samp>'. '$'.numberFormat( $data->total_price)  ;
                    }else{
                        return '$'.numberFormat( $data->total_price);
                    }
                })
                
                ->rawColumns([ 'verify_by'=>'verify_by', 'other_service_fee'=>'other_service_fee','taxi_fee'=>'taxi_fee','total_price'=>'total_price','extra_fee'=>'extra_fee','delivery_fee'=>'delivery_fee','total_dollar'=>'total_dollar','total_riel'=>'total_riel','status' => 'status','clear_box_code'=>'clear_box_code','clear_by'=>'clear_by','action'=>'action','clear_with_shop'=>'clear_with_shop','date'=>'date'])
                ->addIndexColumn()
                ->make(true);
        }
        return view('administrator.report.driver.history-by-driver');
    }
}
