<?php

namespace App\Http\Controllers\Administrator;

use App\DiscountDaliyModel;
use App\DiscountModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\InvoicePaymentModel;
use App\User;
class DiscountController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('All Shop'), 'All Shop')->toArray();

        $discountmodel = DiscountModel::orderBy('created_at', 'desc')->first();
        $data  =  '';
        if($discountmodel){
            $data   =  $discountmodel->date;
        }


        return view('administrator.discount.create',compact( 'merchant','data','discountmodel'));
    }
    public function forshop(){
        // dd();

        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('All Shop'), 'All Shop')->toArray();

        $discountmodel = DiscountModel::orderBy('created_at', 'desc')->first();
        $data  =  '';
        if($discountmodel){
            $data   =  $discountmodel->date;
        }

        return view('administrator.discount_for_shop.create',compact( 'merchant','data','discountmodel'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $arr_ = '';
        if($request->shop_id[0] != 'All Shop' ){
            foreach ($request->shop_id as $key => $value) {
                $arr_ .= $request->shop_id[$key] .',';
            }
        }else{
            $merchant = User::where('user_type',3)->where('status',1) ->get();
            foreach ($merchant as $key => $value) {
                $arr_ .= $value->id .',';
            }
        }
        $data = new  DiscountModel();
        $data->discount_name    = $request->discount_name;
        $data->discount         = $request->discount;
        $data->discount_type    = $request->discount_type;
        $data->shop_id          = $arr_;
        $data->date             =  date('Y-m-d',strtotime($request->date)) ;
        $data->save();
        return redirect()->back();
    }


    // 94


    // 17117906     DV-2020002941       181
    /**
     * Display the specified resource.
     * 2941
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $arr_ = '';
        if($request->shop_id[0] != 'All Shop' ){
            foreach ($request->shop_id as $key => $value) {
                $arr_ .= $request->shop_id[$key] .',';
            }
        }else{
            $merchant = User::where('user_type',3)->where('status',1) ->get();
            foreach ($merchant as $key => $value) {
                $arr_ .= $value->id .',';
            }
        }
        $data = DiscountModel::orderBy('created_at', 'desc')->first();

        $data->discount_name    = $request->discount_name;
        $data->discount         = $request->discount;
        $data->discount_type    = $request->discount_type;
        $data->shop_id          = $arr_;
        $data->date             =  date('Y-m-d',strtotime($request->date)) ;
        $data->update();
        return redirect()->back();
    }


    public function destroy($id)
    {
        //
    }

    public function discount_daliy(Request $request)
    {
        $data = new  DiscountDaliyModel();
        $data->export_id            = $request->export_detail_id;
        $data->date                 = $request->date;
        $data->create_by            = \Auth::user()->id;
        $data->discount_amount      = $request->discount_amount;
        $data->note                 = $request->note;
        if($data->save()){
            InvoicePaymentModel::where('invoice_payment',$request->invoice)->update(['discount_daily_id'=>$data->id]) ;
            return 200;
        }else{
            return 500 ;
        }
    }
}
