<?php

namespace App\Http\Controllers\Administrator;

use App\BranchModel;
use App\CategoryModel;
use App\CurrencyModel;
use App\ExportStockdetailsMode;
use App\ExportStockModel;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\RequestPickup;
use App\RequestPickupDetailModel;
use DB;
use Auth;
use App\User;
use Yajra\DataTables\Facades\DataTables;

class AssignToDriverController extends Controller
{
    public function index(Request $request)
    {
        $data = RequestPickup::
                join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
                ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
                ->select('nso007_request_pickup.*',
                        'shop.shop_name AS shop_name',
                        'driver.name AS driver_name',
                        'nso007_request_pickup.id as request_pickup_id'
                )
            ->where('nso007_request_pickup.status',4)

                ->groupBy('nso007_request_pickup.id')
                ->groupBy('nso007_request_pickup.date')
                ->orderBy('nso007_request_pickup.id','desc')
                ->get();
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $driver = User::where('user_type',2)->where('status',1)->pluck('name', 'id')->prepend(__('administrator.please_select' ), '')->toArray();
        $exchange_rate = DB::table('nso007_currency')->first();
        if ($request->ajax()) {
            if ($request->isMethod('get')) {
                return DataTables::of($data)
                ->editColumn('date_pickup', function ($data) {
                    return date('d-m-Y', strtotime($data->date));
                })
                ->editColumn('driver_pick_up_id', function ($data) {
                    return $data->id;
                })
                ->editColumn('count_', function ($data) {
                    $count_  = RequestPickupDetailModel::where('request_pickup_id',$data->request_pickup_id)->count();
                    return   $count_ ;
                })
                ->addColumn('action', function($data) {
                    return  '
                            <a href="'. route("assign-to-driver.show", $data->id).'" target="_blank" class="button_sm button_refresh"><span class="fa fa-print"></span> </a>
                        ' ;
                })
                ->editColumn('status', function ($data) {
                    $status = '';
                    if($data->type == 1){
                        $status = 'Out-Stock';
                    }
                    else if($data->type == 2){
                        $status = 'Import Stock';
                    }
                    else if($data->type == 3){
                        $status = 'Export-stock';
                    }
                })
                ->rawColumns(['action' => 'action'])
                ->addIndexColumn()
                ->make(true);
            }
        }
        // <button type="button" class="button_sm button_success bt_add" data-toggle="modal" data-target="#exampleModal" data-id="'.$data->id.'"  data-whatever="@mdo"> <span class="fa fa-plus  "></span></button>

        return view('administrator.assign-driver.index',compact('driver','merchant','exchange_rate'));
    }



    public function assign_to_order($id){

        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')
        ->select('nso007_request_pickup_detail.*',
                'nso007_request_pickup.exchange_rate',
                'nso007_request_pickup.invoice_pickup',
                'shop.shop_name AS shop_name',
                'shop.id AS merchant_id',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();
        foreach ($data as $key => $value) {
            $increas = '';
            $last_id=ExportStockModel::max('id');
            $header_invoice = BranchModel::first();

            if ($last_id) {
                $box_code = ExportStockModel::select('box_code')->get()->last();
                $tran_num = substr($box_code->box_code, 3);
                $increas = $header_invoice->header_invoice_import.sprintf('%08d', ($tran_num+1));
            } else {
                $increas = $header_invoice->header_invoice_import.'00000001';
            }
            $exportstock = new ExportStockModel();
            $exportstock->invoice_reference     = $value->invoice_pickup;
            $exportstock->merchant_id           = $value->merchant_id;
            $exportstock->box_code              = $increas;
            $exportstock->export_date           = date('Y-m-d');
            $exportstock->delivery_fee          = $value->delivery_fee;
            $exportstock->delivery_status       = $value->delivery_status ;
            $exportstock->from_location         = isset($value->zoon_id)?$value->zoon_id:'';
            $exportstock->location              = $value->location_id;
            $exportstock->customer_receive      = $value->customer_receive;
            $exportstock->delivery_option       = $value->delivery_option;
            $exportstock->created_by            = Auth::user()->id;
            $exportstock->description           = $value->description;
            $exportstock->taxi_number           = $value->taxi_number;
            $exportstock->type_of_stock           = 2; //Out stock
            if ($exportstock->save()) {
                $exportstockdetails = new ExportStockdetailsMode();
                $exportstockdetails->export_id          = $exportstock->id;
                $exportstockdetails->barcode            = $increas;
                $exportstockdetails->currency           = $value->exchange_rate;
                $exportstockdetails->export_qty         = 1;
                $exportstockdetails->price              = $value->price;
                $exportstockdetails->category_id        = $value->category_id ;
                $exportstockdetails->save();
            }
        }
        RequestPickup::where('id',$id)->update(['status'=>4]);

        return redirect()->back();

    }
    public function assign_show( Request $request){
        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        ->select('nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$request->driver_pick_up_id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();
        // dd($data );
        echo json_encode($data);

    }
    public function create( Request $request )
    {
        $data = RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name'
        )
        ->where('nso007_request_pickup.status','!=',4)

        ->groupBy('nso007_request_pickup.id')
        ->groupBy('nso007_request_pickup.date')
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();
        $merchant = User::where('user_type',3)->where('status',1)->pluck('shop_name', 'id')->prepend(__('administrator.shop_name'), '')->toArray();
        $driver = User::where('user_type',2)->where('status',1)->pluck('name', 'id')->prepend(__('administrator.driver_name' ), '')->toArray();
        $exchange_rate = DB::table('nso007_currency')->first();
        if ($request->ajax()) {
            if ($request->isMethod('get')) {
                return DataTables::of($data)
                ->editColumn('date_pickup', function ($data) {
                    return date('d-m-Y', strtotime($data->date));
                })
                ->editColumn('driver_pick_up_id', function ($data) {
                    return $data->id;
                })
                ->addColumn('action', function($data) {
                    $edit  = '';
                    if($data->status == 1 || $data->status == 2 ){
                        $edit = '
                            <a href="#" class="button_sm button_success btn-done" data-list_id="'.$data->id.'"  ><span ">Done</span> </a>
                            <button class="button_sm  button_warning bt_assign " data-list_id="'.$data->id.'" type="button"><span class=" "></span> Assign </button>
                            <button class="button_sm button_info bt_delete_main" data-id="'.$data->id.'" type="button"><span class="fa fa-trash "></span> </button>
                        ' ;
                    }
                    else{
                        if ($data->status != 4) {
                                $edit ='
                                <button class="button_sm button_success bt_to_order" data-list_id="'.$data->id.'" type="button"><span class=" "></span> To Order </button>
                            ';
                        }
                    }
                    return $edit.'
                            <a href="'. route("assign-to-driver.show", $data->id).'" target="_blank" class="button_sm button_refresh"><span class="fa fa-print"></span> </a>
                        ' ;
                    })
                    ->editColumn('status', function ($data) {
                        $status = '';
                        if($data->type == 1){
                            $status = 'Out-Stock';
                        }
                        else if($data->type == 2){
                            $status = 'Import Stock';
                        }
                        else if($data->type == 3){
                            $status = 'Export-stock';
                        }
                        return   $status;
                    })
                ->rawColumns(['action' => 'action'])
                ->addIndexColumn()
                ->make(true);
            }
        }
        // <button type="button" class="button_sm button_success bt_add" data-toggle="modal" data-target="#exampleModal" data-id="'.$data->id.'"  data-whatever="@mdo"> <span class="fa fa-plus  "></span></button>

        return view('administrator.assign-driver.create',compact('driver','merchant','exchange_rate'));
    }


    public function store(Request $request)
    {
        $last_id = RequestPickup::
                where('invoice_pickup','!=','null')
                ->where('invoice_pickup','!=','')
                ->orderBy('invoice_pickup','desc')
                ->first();
        $header_invoice = BranchModel::first();

        if ($last_id) {

            $box_code = $last_id->invoice_pickup;
            $tran_num = substr($box_code, 3);
            $increas = $header_invoice->header_invoice_pickup.sprintf('%08d', ($tran_num+1));
        } else {

            $increas = $header_invoice->header_invoice_pickup.'00000001';
        }

        $data = new RequestPickup ;
        $data->invoice_pickup       =  $increas  ;
        $data->merchant_id          =  $request->merchant  ;
        $data->date                 =  date('Y-m-d', strtotime($request->date));
        $data->driver_pick_up_id    =  $request->driver_id  ;
        $data->exchange_rate        =  $request->exchange_rate  ;
        $data->status               = 2 ;
        $data->type                 = $request->type;
        $data->description          = $request->description ;
        $data->save();
        return redirect()->back();
    }

    public function show($id)
    {
        $exchang_rate = CurrencyModel::find(1);
        $currency  = $exchang_rate->currency_exchange_to;

        $data = RequestPickup::
        join('nso007_request_pickup_detail','nso007_request_pickup_detail.request_pickup_id','nso007_request_pickup.id')
        ->join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->join('nso007_location','nso007_request_pickup_detail.location_id','nso007_location.id')
        ->join('nso007_category','nso007_request_pickup_detail.category_id','nso007_category.id')

        ->select('nso007_request_pickup_detail.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name',
                'nso007_location.name_km AS location_name',
                'nso007_category.name_km AS category_name'
        )
        ->where('request_pickup_id',$id)
        ->orderBy('nso007_request_pickup.id','desc')
        ->get();

        $master =RequestPickup::
        join('users AS shop','shop.id','nso007_request_pickup.merchant_id')
        ->leftJoin('users AS driver','driver.id','nso007_request_pickup.driver_pick_up_id')
        ->select('nso007_request_pickup.*',
                'shop.shop_name AS shop_name',
                'driver.name AS driver_name'
        )
        ->find($id);
        // dd($master);
        return view('administrator.assign-driver.show',compact('currency','data','master'));
    }


    public function edit($id)
    {
        //
    }
    public function update(Request $request, $id)
    {
        //
    }

    public function destroy($id)
    {
        dd($id);
    }
    public function assign_driver_pickup(Request $request)
    {
        // $last_id = RequestPickup::
        //         where('invoice_pickup','!=','null')
        //         ->where('invoice_pickup','!=','')
        //         ->orderBy('invoice_pickup','desc')
        //         ->first();
        // $header_invoice = BranchModel::first();

        // if ($last_id) {

        //     $box_code = $last_id->invoice_pickup;
        //     $tran_num = substr($box_code, 3);
        //     $increas = $header_invoice->header_invoice_pickup.sprintf('%08d', ($tran_num+1));
        // } else {

        //     $increas = $header_invoice->header_invoice_pickup.'00000001';
        // }
        // $data = RequestPickup::where('id',$list_id)->first();
        // if($data->invoice_pickup == null && $data->invoice_pickup == ''){

        //     RequestPickup::where('id',$list_id)->update(['driver_pick_up_id'=>$driver,'status'=>2,'invoice_pickup'=> $increas ]);
        // }
        // else{
        //     RequestPickup::where('id',$list_id)->update(['driver_pick_up_id'=>$driver,'status'=>2]);
        // }
        // return redirect()->back();
    }

    public function box_pickup_done(Request $request ){

        $reqdetail  = RequestPickup::where('id',$request->id)->update(['status'=>3]);
        return $reqdetail;
    }


        public function box_pickup_delete(Request $request ){

        $reqdetail = RequestPickupDetailModel::where('id', '=' ,$request->id)->delete();
        return $reqdetail;
    }
    public function box_pickup_delete_main(Request $request ){
        RequestPickup::where('id',$request->id)->delete();
        RequestPickupDetailModel::where('request_pickup_id', '=' ,$request->id)->delete();
        $data = "success";
        return $data ;
    }
}

