<?php

namespace App\Http\Controllers\Accounting;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Yajra\DataTables\DataTables;
use App\JournalModel;
use App\AccountChartModel;
use Illuminate\Support\Facades\Auth;

class IncomeController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:List Income', ['only' => ['index']]);
        $this->middleware('permission:Create Income', ['only' => ['create','store']]);
        $this->middleware('permission:Edit Income', ['only' => ['edit','update']]);
        $this->middleware('permission:Delete Income ', ['only' => ['delete_income']]);
        // $this->middleware('permission:Report Income', ['only' => ['getReportIncome','reportIncomePrint']]);
    }
    public function index(Request $request)
    {
        $data = JournalModel::join('users AS created','created.id','nso007_journal.journal_by')
                ->Leftjoin('users AS modify','modify.id','nso007_journal.modify_by')
                ->join('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                // ->groupBy('nso007_account_chart.id')
                ->select(
                    'nso007_journal.*',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'created.name AS created_by',
                    'modify.name AS modify_by',
                    'nso007_account_chart.id AS account_code'
                )
                ->groupBy('nso007_account_chart.id')
                ->where('nso007_account_chart.acctype',40)->get();
                
        if($request->ajax()){
            return  DataTables::of($data)
                    ->addColumn('account_name',function($data){
                        if(\App\Helpers\Globals::check_lang() =='en'){
                            return $data->account_code.' '.$data->acc_name_en;
                        }else{
                            return $data->account_code.' '.$data->acc_name_km;
                        }
                    })
                    ->addColumn('amount',function($data){
                        return '$'.number_format($data->journal_debit,2);
                    })
                    ->addColumn('journal_paydate',function($data){
                        return date('d-m-Y',strtotime($data->journal_paydate));
                    })
                    ->addColumn('action',function($data){
                        
                        if($data->closing_entry == 1){
                            return '<a href="'.route('income.edit',$data->id).'" class="button_primary">'.__('administrator.edit').'</a>
                            <a class="button_info delete_income "   data-id="'.$data->id.'" >'. __('administrator.delete').'</a>';
                        }else{
                            return '<a href="" class="button_dark">'.__('administrator.edit').'</a>';
                        }

                    })
                    ->addIndexColumn()
                    ->make(true);
        }
        return view('accounting.income.index');
    }

    public function create()
    {
        if(\Globals::check_lang() =='en'){
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_en) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        }else{
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_km) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('សូមជ្រើសរើស', '');
        }
        return view('accounting.income.create',compact('account_chart'));
    }

    public function store(Request $request)
    { 
        $this->validate($request, [
            'journal_acccode'      => 'required',
            'journal_paydate'      => 'required',
            'journal_debit'     => 'required',
        ]);

        $journal = new JournalModel;
        $journal->journal_paydate           = date('Y-m-d',strtotime($request->journal_paydate));
        $journal->journal_acccode           = $request->journal_acccode;
        $journal->journal_des               = $request->journal_des;
        $journal->journal_debit             = $request->journal_debit;
        $journal->journal_invoice             = $request->journal_invoice;
        $journal->journal_transactiondate   = date('dmYhiA');
        $journal->journal_by                = \Auth::user()->id;
        $journal->closing_entry             = 1;
        $journal->save();

        return redirect()->route('income.index')->with(['success' => 'Your Create Successfull']);
    }

    public function edit($id)
    {
        $journal = JournalModel::find($id);
        if(\Globals::check_lang() =='en'){
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_en) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        }else{
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_km) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('សូមជ្រើសរើស', '');
        }
        return view('accounting.income.edit',compact('account_chart','journal'));
    }


    public function update(Request $request, $id)
    {
        $this->validate($request, [
            'journal_acccode'      => 'required',
            'journal_paydate'      => 'required',
            'journal_debit'     => 'required',
        ]);

        $journal = JournalModel::find($id);
        $journal->journal_paydate           = date('Y-m-d',strtotime($request->journal_paydate));
        $journal->journal_acccode           = $request->journal_acccode;
        $journal->journal_des               = $request->journal_des;
        $journal->journal_debit             = $request->journal_debit;
        $journal->journal_invoice             = $request->journal_invoice;
        $journal->modify_by                = \Auth::user()->id;
        $journal->save();

        return redirect()->route('income.index')->with(['success' => 'Your Create Successfull']);
    }


    public function reportIncome()
    {
        if(\Globals::check_lang() =='en'){
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_en) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('Please Select', '');
        }else{
            $account_chart = AccountChartModel::select(
            \DB::raw('CONCAT(id," ",acc_name_km) AS account_mixed'),'id')
            ->where('acctype',40)
            ->pluck('account_mixed','id')
            ->prepend('សូមជ្រើសរើស', '');
        }
        return view('accounting.report.report-income',compact('account_chart'));
    }

    public function getReportIncome(Request $request)
    {
        $from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $data = JournalModel::leftJoin('users AS created','created.id','nso007_journal.journal_by')
                ->leftJoin('users AS modify','modify.id','nso007_journal.modify_by')
                ->leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    'nso007_journal.*',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'created.name AS created_by',
                    'modify.name AS modify_by',
                    'nso007_account_chart.id AS account_code'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.id','LIKE',isset($request->account_code)?$request->account_code:null)
                ->where('nso007_account_chart.acctype',40)
                ->orderBy('nso007_journal.journal_paydate','ASC')
                ->get();

        if($request->isMethod('get')){
            return  DataTables::of($data)
                    ->addColumn('account_name',function($data){
                        if(\Globals::check_lang() =='en'){
                            return $data->account_code.' '.$data->acc_name_en;
                        }else{
                            return $data->account_code.' '.$data->acc_name_km;
                        }
                    })
                    ->addColumn('amount',function($data){
                        return '$'.number_format($data->journal_debit,2);
                    })
                    ->addColumn('journal_paydate',function($data){
                        return date('d-m-Y',strtotime($data->journal_paydate));
                    })
                    ->addIndexColumn()
                    ->make(true);
        }else{
            echo json_encode($data);
        }
    }

    public function reportIncomePrint(Request $request)
    {
        $from_date = empty($request->from_date)? date('Y-m-d',strtotime('first day of this month')):date('Y-m-d',strtotime($request->from_date));
        $to_date = empty($request->to_date)? date('Y-m-d',strtotime('last day of this month')):date('Y-m-d',strtotime($request->to_date));

        $data = JournalModel::leftJoin('users AS created','created.id','nso007_journal.journal_by')
                ->leftJoin('users AS modify','modify.id','nso007_journal.modify_by')
                ->leftJoin('nso007_account_chart','nso007_account_chart.id','nso007_journal.journal_acccode')
                ->select(
                    'nso007_journal.*',
                    'nso007_account_chart.acc_name_en',
                    'nso007_account_chart.acc_name_km',
                    'created.name AS created_by',
                    'modify.name AS modify_by',
                    'nso007_account_chart.id AS account_code'
                )
                ->where(function($query) use ($from_date,$to_date){
                    if(!empty($from_date) && !empty($to_date)){
                        $query->whereBetween('nso007_journal.journal_paydate',[$from_date,$to_date]);
                    }
                })
                ->where('nso007_account_chart.id','LIKE',isset($request->account_code)?$request->account_code:null)
                ->where('nso007_account_chart.acctype',40)
                ->orderBy('nso007_journal.journal_paydate','ASC')
                ->get();

        return view('accounting.report.report-income-print',compact('data','from_date','to_date'));

    }

    public function delete_income(Request $request)
    {
        $data = JournalModel::find($request->id)->delete();
        return redirect()->route('expense.index')->with(['success' => 'Your Delete Successfull']);
    }
}
