<?php

use App\CategoryModel;
use App\CurrencyModel;
use App\DeliveryOrderDetailModel;
use App\DeliveryOrderDetailProccessingModel;
use App\DeliveryOrderModel;
use App\ExportStockModel;
use App\InvoicePaymentModel;
use App\LocationModel;
use App\PickupAdminModel;
use App\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Permission;

// get total amount from sale_id
    function total_amount($id)
    {

        return $total = DB::table('nso007_sale_details')->where('sale_id', $id)
                                                ->select(DB::raw('SUM(sale_price - (sale_price*dis/100)) as total_sales'))
                                                ->first()->total_sales;
    }

    // get warehouse for select form collective
    function warehouse(){
        return App\WarehouseModel::where('status', 1)->get()
                    ->pluck('full_name', 'id');
    }

    function get_notifications()
    {
        return DB::table('notifications')->whereNull('read_at')->get();
    }
    function getTable($query) {
        return collect(DB::select($query))->map(function ($x){return (array)$x;})->toArray();
    }

    function  getOneRow($sql) {
        $getTable = getTable($sql);
        if(count($getTable)>0){
            return $getTable[0];
        }else{
            return [];
        }

    }
    function filterDuration()
    {
        return [
            1 =>  'Today',
            2 =>  'Yesterday',
            3 =>  'This Week',
            4 =>  'This Month',
            5 =>  'This Year',
        ];
    }

    function getOne($sql) {
        $getOneRow = getOneRow($sql);
        if(count($getOneRow)>0){
            return reset($getOneRow);
        }else{
            return '';
        }
    }
    function getTimDiffMinute($_ftime,$_ttime){
        return getOne("SELECT TIME_TO_SEC(timediff('{$_ttime}', '{$_ftime}'))/60 as t");
    }
    function FindShop($merchant_id){
       return User::find($merchant_id)->shop_name;
    }

    function FindLoaction($locatin_id){
        $data =  LocationModel ::find($locatin_id);
        return $data->name_km   ;
     }

     function FindCategory($category){
        $data =  CategoryModel ::find($category);
        return $data->name_km  ;
     }


     function FindDriver($driver_id){
        return User::find($driver_id)->name;
     }



     function update_invoice_price($id,$pay_dollar,$pay_riel){
        InvoicePaymentModel::find($id)->update(['pay_dollar'=>$pay_dollar,'pay_riel'=>$pay_riel]);
     }
     function FindDUser($id){
        return User::find($id);
     }

    function payment($merchant_id,$from_date,$to_date,$status){
        $payment = DeliveryOrderModel::
        select(
            \DB::raw('(CASE
                    WHEN nso007_export_stock.taxi_status = "1" THEN  nso007_export_stock.taxi_shop_fee
                    WHEN nso007_export_stock.taxi_status = "2" THEN  nso007_export_stock.taxi_cust_fee
                    ELSE nso007_export_stock.taxi_shop_fee
                    END) AS taxi_fee'),
                'nso007_export_stock.*',
                'nso007_export_stock.status',
                'nso007_delivery_order_detail.total_riel',
                'nso007_delivery_order_detail.total_dollar',
                'nso007_delivery_order_detail.commission_type AS share_fee_type',
                'nso007_delivery_order_detail.driver_commission AS share_fee',
                'nso007_discount.discount',
                'nso007_discount.discount_type',
                'nso007_delivery_order.delivery_date'
        )
        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
        ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
        ->leftJoin('nso007_discount','nso007_export_stock.discount_id','nso007_discount.id')

        ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
        ->where('nso007_export_stock.merchant_id',$merchant_id)
        ->where(function ($query) use ($from_date, $to_date) {
            if($from_date){
                $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
            }
            if($to_date){
                $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
            }
        })
        ->when(request('status'),function($query) use ($status){
            if(!empty($status)){
                $status_1 ='';
                foreach ($status as $key => $value) {
                    $status_1  .= $status[$key].',' ;
                }
                $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
            }
        })
        ->groupBy('nso007_export_stock_details.export_id')
        ->groupBy('nso007_delivery_order_detail.delivery_order_id')
        ->groupBy('nso007_delivery_order_detail.status')
        ->get();

            $total = 0;
            $total_dollar = 0;
            $total_riel = 0;
            $delivery_fee_paid = 0;

            $other_services_paid   = 0;
            $other_services_pay   = 0;
            $other_services_pay_cus   = 0;
            $delivery_fee_pay   = 0;
            $delivery_fee_pay_cus   = 0;

            $taxi_paid   = 0;
            $taxi_pay   = 0;
            $commission_driver   = 0;
            $taxi_pay_cus   = 0;

            foreach ($payment as $key => $value) {
                if( $value->status == 3){


                    if($value->share_fee_type == 1){
                        $commission_driver += number_format($value->share_fee, 3) ;
                    }else{
                        $commission_driver += number_format(($value->share_fee/100)*($value->delivery_fee   +   $value->extra_fee),3)   ;
                    }

                    if ($value->other_services_fee > 0 || $value->other_services_fee != null) {
                        if ($value->other_services_type == 1) {
                            if ($value->other_services_pay_or_paid == 'pay') {
                                $other_services_pay     +=  $value->other_services_fee ;
                            } else {
                                $other_services_paid    +=  $value->other_services_fee ;
                            }
                        } else {
                            $other_services_pay_cus     += $value->other_services_fee ;
                        }
                    }
                    $total_riel         +=  $value->total_riel;
                    $total_dollar       +=  $value->total_dollar;

                    if ($value->delivery_status == 1) {   //shop
                        if ($value->delivery_pay_or_paid == 'pay') {
                            $delivery_fee_pay     +=  $value->delivery_fee ;
                        } else {
                            $delivery_fee_paid    +=  $value->delivery_fee ;
                        }
                    } else {
                        $delivery_fee_pay_cus     += $value->delivery_fee ;
                    }

                    if ($value->taxi_status == 1) {   //shop
                        if ($value->taxi_pay_or_paid == 'pay') {
                            $taxi_pay     +=  $value->taxi_fee ;
                        } else {
                            $taxi_paid    +=  $value->taxi_fee ;
                        }
                    } else {
                        $taxi_pay_cus     += $value->taxi_fee ;
                    }
                }
            }

        $total_paid =  $other_services_paid  +  $delivery_fee_paid   +   $taxi_paid   ;
        $total_serve =  $other_services_pay_cus +  $other_services_pay +  $delivery_fee_pay  +  $delivery_fee_pay_cus + $taxi_pay_cus + $taxi_pay;
        $total  =   $total_dollar  -  $other_services_pay_cus  -  $other_services_pay  - $delivery_fee_pay   -  $delivery_fee_pay_cus -$taxi_pay_cus -$taxi_pay     ;
        // session()->put('total_paid',$total_paid);
        // session()->put('total_serve',$total_serve);
        // session()->put('commission_driver',$commission_driver);
        // session()->put('total_receive',$total);

        $data1  = [
            'data'=>    ('$'. $total .' / '. number_format( $total_riel ,2).'៛') ,
            'total_paid'=>   $total_paid,
            'total_serve'=>   $total_serve,
            'commission_driver'=>   $commission_driver,
            'total'=>   $total,
            'total_riel'=>   $total_riel,
        ]   ;

        return  $data1;

    }
    //  function received($merchant_id,$from_date,$to_date,$status){
    //     $delivery = DeliveryOrderDetailModel::
    //                 select(
    //                     'nso007_export_stock_details.price',
    //                     \DB::raw('SUM(nso007_export_stock_details.price * nso007_export_stock_details.export_qty) as total_price'),
    //                     \DB::raw('SUM(nso007_delivery_order_detail.total_riel) as total_riel'),
    //                     \DB::raw('SUM(nso007_delivery_order_detail.total_dollar) as total_dollar'),
    //                 )
    //                 ->join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
    //                 ->join('nso007_export_stock_details','nso007_export_stock_details.export_id','nso007_export_stock.id')
    //                 ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
    //                 ->where('nso007_export_stock.merchant_id',$merchant_id)
    //                 ->where(function ($query) use ($from_date, $to_date) {
    //                     if($from_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
    //                     }
    //                     if($to_date){
    //                         $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
    //                     }
    //                 })
    //                 ->when(request('status'),function($query) use ($status){
    //                     if(!empty($status)){
    //                         $status_1 ='';
    //                         foreach ($status as $key => $value) {
    //                             $status_1  .= $status[$key].',' ;
    //                         }
    //                         $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
    //                     }
    //                 })
    //                 ->first();

    //                 $data  = [
    //                     'view' => '$'.number_format( $delivery->total_dollar  ,2)  .' / '.number_format( $delivery->total_riel,2). '៛' ,
    //                     'total_dollar'=>   $delivery->total_dollar,
    //                     'total_riel'=>   $delivery->total_riel,
    //                 ]   ;


    //                 return     $data   ;

    // }
     function transaction($merchant_id,$from_date,$to_date,$status){
        $delivery = DeliveryOrderDetailModel::
                join('nso007_export_stock','nso007_export_stock.id','nso007_delivery_order_detail.export_id')
                ->join('nso007_delivery_order','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                ->where('nso007_export_stock.merchant_id',$merchant_id)
                ->where(function ($query) use ($from_date, $to_date) {
                    if($from_date){
                        $query->whereDate('nso007_delivery_order.delivery_date', '>=',date('Y-m-d',strtotime($from_date)));
                    }
                    if($to_date){
                        $query->whereDate('nso007_delivery_order.delivery_date', '<=',date('Y-m-d',strtotime($to_date)));
                    }
                })
                ->when(request('status'),function($query) use ($status){
                    if(!empty($status)){
                        $status_1 ='';
                        foreach ($status as $key => $value) {
                            $status_1  .= $status[$key].',' ;
                        }
                        $query->whereIn('nso007_delivery_order_detail.status',explode(',', $status_1));
                    }
                })
                ->count();
        return  $delivery ;

    }
    function update_status_by($export_id,$status,$action){
        if($export_id == ''){
            return  '{ "create_by":"'.\Auth::user()->name.'","edit_by":"",  "status_proccess":"",  "status_last":""}';
        }else{
            $nso007_export_stock =  ExportStockModel::where('id',$export_id)->orWhere('box_code',$export_id)->first();
            $update_status_by   =   json_decode($nso007_export_stock->update_status_by, true);

            // { "create_by":"Super Admin","edit_by":"",  "status_proccess":"",  "status_last":""}

            if($action == 'edit_by'){
                $nso007_export_stock->update_status_by   = '{ "create_by":"'. $update_status_by['create_by'].'","edit_by":"'.\Auth::user()->name.'",  "status_proccess":"'. $update_status_by['status_proccess'].'",  "status_last":"'. $update_status_by['status_last'].'"}' ;
            }


            if($action == 'status_proccess'){
                $nso007_export_stock->update_status_by   = '{ "create_by":"'. $update_status_by['create_by'].'","edit_by":"'. $update_status_by['edit_by'].'",  "status_proccess":"'.\Auth::user()->name.'",  "status_last":"'. $update_status_by['status_last'].'"}' ;
            }


            if($action == 'status_last'){
                $nso007_export_stock->update_status_by   = '{ "create_by":"'. $update_status_by['create_by'].'","edit_by":"'. $update_status_by['edit_by'].'",  "status_proccess":"'.$update_status_by['status_proccess'].'",  "status_last":"'.\Auth::user()->name.'"}' ;
            }

            $nso007_export_stock->status   = $status == '' ? $nso007_export_stock->status  :  $status ;
            // $nso007_export_stock->update_status_by   = '{ "create_by":"Super Admin","edit_by":"",  "status_proccess":"",  "status_last":""}' ;
            $nso007_export_stock->update();
        }
    }
    function historyBox($export_id,$status,$reason){
        DB::table('nso007_box_history')->insert([
            'export_id'=>$export_id,
            'status'=>$status,
            'reason'=>$reason,
            'user_id'=>Auth::user()->id
        ]);
    }
    function getDriver(){
        return  User::where('user_type',2)->where('status',1)->pluck('name', 'id')->prepend(__('administrator.please_select' ), '')->toArray();
    }



    function delivery_order($export_id, $driver_id){

            $increas = '';
            $last_id =  DeliveryOrderModel::max('id');

            if ($last_id) {
                $inovice = DeliveryOrderModel::select('inovice')->get()->last();
                $tran_num = $inovice->inovice;
                $tran_num = explode('DV', $tran_num);
                $increas = sprintf('DV'.'%08d', ($tran_num[1]+1));
            } else {
                $increas = 'DV00000001';
            }
            $deliveryorder = new  DeliveryOrderModel();
            $deliveryorder->inovice         = $increas;
            $deliveryorder->driver_id       = $driver_id;
            $deliveryorder->driver_name       = FindDriver($driver_id);
            $deliveryorder->delivery_date   =    date('Y-m-d');
            $driver  =   User::find($driver_id);
            if ($deliveryorder->save()) {
                foreach (explode(',',$export_id) as $key => $value) {
                    if($value != ''){
                        update_status_by($value  , '2','status_proccess');
                        // ExportStockModel::where('id',$request->export_id[$key])
                        //                             ->update(
                        //                                     [
                        //                                         'status' => 2,
                        //                                         'update_status_by'  => ' {  "status_proccess":"'.(\Auth::user()->name).'",  "status_last":""     }   '
                        //                                     ]);
                        $delivery_order_detail =array(
                            'delivery_order_id'         =>  $deliveryorder->id ,
                            'export_id'                 =>  $value ,
                            'status'                    =>  1,
                            'driver_commission'         =>  $driver->share_fee,
                            'commission_type'           =>  $driver->share_fee_type,
                        );
                        DeliveryOrderDetailModel::insert($delivery_order_detail);
                        $delivery_order_detail['date'] = date('Y-m-d');
                        DeliveryOrderDetailProccessingModel::insert($delivery_order_detail);
                    }
                }
            }
    }



    function numberFormat($data){
        if(intval($data) == floatval($data)){
            return intval($data);
        }
        return  number_format($data ,2);
    }
    function currency(){
       return CurrencyModel::first();
    }
    function compressDriver(){
        $drivers = User::where('user_type',2)
            ->where('status',1)
            ->select('name', 'id')
            ->get();
        $array = array();
        $index = $drivers->count() * 2;
        $in = 0;
        $time_policy = array(['id'=>'1','name'=>'ព្រឹក']);
        for($d=0;$d<$drivers->count();$d++){
            for($i=0;$i<1;$i++){
                array_push($array, ['id' => $drivers[$in]['id'], 'name' => $drivers[$in]['name'],'time_policy_id'=>$time_policy[$i]['id'],'time_policy_name'=>$time_policy[$i]['name']]);
            }
            $in +=1;
        }
        $last_array = array();
        foreach ($array as $key=>$val){
            $last_array[$array[$key]['id'].'||'.$array[$key]['time_policy_id']]=$array[$key]['name'];
        }
        return $last_array;
    }
    function getZonePP(){
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->where('name_en','!=','Province')
            ->select('nso007_location.name_en AS name', 'id','location_id');
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        return $from_location;
    }
    function getZoneByDir($con=''){
        $from_location = LocationModel::where('status', 1)
            ->where('type','zone')
            ->when('no zone',function($q) use($con){
                if($con == "province"){
                    $q->where('id',21);
                }
                if($con == "pp"){
                    $q->where('name_en','!=','Province');
                }
            })

            ->select('nso007_location.name_en AS name', 'id','location_id');
        $loc_id_array = array();
        $zone_location = $from_location->pluck('location_id');
        foreach($zone_location as $key=>$val){
            foreach(explode(',',$val) as $loc_id){
                if($loc_id){
                    array_push($loc_id_array,$loc_id);
                }
            }
        }
        $from_location = $from_location->pluck('name', 'id')->prepend(__('administrator.select_zoon'), '');
        $location = LocationModel::where('status', 1)
            ->where('type','location')
            ->whereIn('id',$loc_id_array)
            ->select('nso007_location.name_en AS name', 'id')->pluck('name', 'id')->prepend(__('administrator.location'), '');
            return $from_location;
    }
    function permmissionByGroupName($group_name,$not_child='',$has_child=''){
        return Permission::where('group_name',$group_name)
            ->whereNull('sub_name')
            ->when($not_child,function($q) use($not_child){
                $q->where('not_child',$not_child);
            })
            ->when($has_child,function($q) use($has_child){
                $q->where('has_child',$has_child);
            })
            ->get();
    }

    function permmissionBySubName($group_name,$not_child=0){
        return Permission::where('sub_name',$group_name)
            // ->where('not_child',$not_child)
            // ->where('has_child',1)
            ->get();
    }
    function allPermission($id,$group_name,$sub_name=""){
        return DB::table("role_has_permissions")
                ->join('permissions','permissions.id','role_has_permissions.permission_id')
                ->where('permissions.group_name',$group_name)

                ->when('a',function($q) use($sub_name){
                    if($sub_name){
                        $q->where('permissions.sub_name',$sub_name);
                    }else{
                        $q->whereNull('permissions.sub_name');
                    }
                })
                ->where("role_has_permissions.role_id", $id);
    }
    function subGroup($group_name){
        return Permission::where('permissions.sub_group',$group_name)->groupBy('group_name')->get();

    }
    function totalBoxPerDay($driver_id,$date){
        $date = date('Y-m-d',strtotime($date));
        $data = DeliveryOrderModel::where('driver_id',$driver_id)
                        ->whereDate('delivery_date',$date)
                        ->selectRaw('nso007_delivery_order_detail.export_id')
                        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                        ->where('nso007_delivery_order_detail.status',3)
                        ->count();
        return $data;
    }
    function totalPickupPerDay($driver_id,$date){
        $date = date('Y-m-d',strtotime($date));
        return PickupAdminModel::where('driver_id',$driver_id)
            ->where('delivery_date',$date)
            ->where('status',4)
            ->sum('exact_qty');

    }
    function totalBoxIncomePerDay($driver_id,$date){
        $date = date('Y-m-d',strtotime($date));
        $export_id = DeliveryOrderModel::where('driver_id',$driver_id)
                        ->whereDate('delivery_date',$date)
                        ->selectRaw('nso007_delivery_order_detail.export_id')
                        ->join('nso007_delivery_order_detail','nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                        ->where('nso007_delivery_order_detail.status',3)
                        ->pluck("nso007_delivery_order_detail.export_id");
        $total = ExportStockModel::whereIN('id',$export_id)
                    ->sum(DB::raw("delivery_fee/delivery_fee_rate"));
        return $total;

        $data = DeliveryOrderModel::where('driver_id',$driver_id)
                        ->whereDate('delivery_date',$date)
                        ->join(DB::raw('(select status,delivery_order_id,export_id,total_dollar,total_riel from nso007_delivery_order_detail where status =3) as nso007_delivery_order_detail'),'nso007_delivery_order_detail.delivery_order_id','nso007_delivery_order.id')
                        ->join(DB::raw('(select id as export_id,delivery_fee,delivery_fee_rate from nso007_export_stock) as exp'),'exp.export_id','nso007_delivery_order_detail.export_id')
                        ->select(
                            DB::raw('sum(delivery_fee/delivery_fee_rate) as total_income')
                            )
                        ->first();
        return optional($data)->total_income;

    }
    function totalShopBoxPerDay($shop_id,$date){
        $date = date('Y-m-d',strtotime($date));
        $data = ExportStockModel::where('merchant_id',$shop_id)
                        ->whereDate('done_date',$date)
                        ->where('status',3)
                        ->join(DB::raw('(select id,name as shop_name from users) as shop'),'shop.id','nso007_export_stock.merchant_id')
                        ->count();
        return $data;

    }
    function totalShopPricePerDay($shop_id,$date){
        $date = date('Y-m-d',strtotime($date));
        $data = ExportStockModel::where('merchant_id',$shop_id)
                        ->where('status',3)
                        ->whereDate('done_date',$date)
                        ->selectRaw("nso007_export_stock.delivery_fee,nso007_export_stock.delivery_fee_rate")
                        ->sum(DB::raw('nso007_export_stock.delivery_fee/nso007_export_stock.delivery_fee_rate'));
        return $data;
        $data = ExportStockModel::where('merchant_id',$shop_id)
                        ->where('status',3)
                        ->whereDate('done_date',$date)
                        ->join(DB::raw('(select id,name as shop_name from users) as shop'),'shop.id','nso007_export_stock.merchant_id')
                        ->select(DB::raw('SUM(nso007_export_stock.delivery_fee/nso007_export_stock.delivery_fee_rate) as total_delivery_fee'))
                        ->first()->total_delivery_fee;
                        // ->sum('nso007_export_stock.delivery_fee_rate');
        return $data;

    }
