<?php


namespace App\Helpers;

use Request;
use Phanna\Converter\KhmerDatetime;
use App\User;
use App\BranchModel;
use Auth;
use Fun;
use App\SettingSystemModel;
use Illuminate\Support\Facades\DB;
use Jenssegers\Agent\Agent;
class Globals

{

    public static function setting(){
        $setting_system = SettingSystemModel::find(1);
        $data =  array(

            'order_by' => $setting_system->order_by,
            'length_table' => $setting_system->length_table,
            'searching_tbl' => $setting_system->searching_tbl,

        );
        return $data;
    }
    public static function is_Administrator(){
      return Auth::user()->is_role;

    }
    public static function is_MerchantIn(){
      return Auth::user()->is_role;

    }
    public static function is_MerchantOut(){
      return Auth::user()->is_role;

    }
    public static function is_Driver(){
      return Auth::user()->is_role;

    }

    public static function branches(){
      $branches = BranchModel::first();
      return $branches;
    }

    public static function checkDeivce(){
        $agent = new Agent();
        if($agent->isMobile()){
          return 'mobile.';

        }else if($agent->isTablet()){
          return 'tablet.';

        }else{
          return 'desktop.';

        }
    }

    public static function date_khmers($date)
    {
      $khmer = new KhmerDatetime($date);
      $month = $khmer->getFullMonth();
      $year = $khmer->getFullYear();
      $day = $khmer->getFullDay();
      $new_date = $day." ខែ ". $month ." ឆ្នាំ ".$year;
      return $new_date;
    }

    public static function check_lang()
    {
        $lang = Fun::lang();
        return $lang;
    }
    public static function historyBox($data){
      DB::table("nso007_box_history")->insert($data);
    }
    public static function actionBooking($data){
      DB::table("nso007_action_booking")->insert($data);
    }
    public static function status($dir){
        $status_name = array(
                            '1' => 'In Stock Delivery',
                            '2' => 'Proccessing',
                            '3' => 'Done' ,
                            '4' => 'Pedding' ,
                            '5' => 'Cancel',
                            '7' => 'Return to shop'
                        );
        return $status_name[$dir];
    }
    public static function status_render($dir){
        $status_name = array(
                            // 1 = default,
                            '1' => ' <strong class="text-secondary"><span class="fa fa-square"></span> ' . __('administrator.in_stock_delivery') . ' </strong>',
                            //2 = proccess
                            '2' => ' <strong class="text-primary"><span class=" fa fa-spinner"></span> ' . __('administrator.processing') . '   </strong>',
                            // 3 = done
                            '3' => '<strong class="text-info"><span class="fa fa-square"></span> ' . __('administrator.done') . '  </strong>' ,
                            // 4 = padding,
                            '4' => '<strong class="text-warning"><span class="fa fa-bullseye"></span> ' . __('administrator.padding') . '    </strong>' ,
                            // 5 = cancel
                            '5' => '<strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.cancel') . ' </strong>',
                            // 6 = paid
                            '6' => '<strong class="text-danger"><span class="fa fa-ban"></span> ' . __('administrator.paid') . ' </strong>',
                            // 7 = Return to To Shop
                            '7' => '<strong class="text-danger"><span class="fa fa-ban"></span> ' . 'Return To Shop' . ' </strong>'
                        );
        return $status_name[$dir];
    }
    public static function currency_render($symbol,$value){

            switch($symbol){
                case "$" :
                    return  "$ " . (number_format((float)$value,2));
                default:
                return number_format((float)$value,0).' ៛';
            }
    }
    public static function getDrivers($disactive=false){
      $status = $disactive ? [1,2] : [1];
      return  User::where('user_type',2)->whereIn('status',$status)->pluck('name', 'id')->prepend(__('administrator.please_select' ), '')->toArray();
    }
}
