<?php

namespace App\Exports;

use App\ExportStockModel;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromView;

class ShopBoxExport implements FromView
{
    private $from_date,$to_date,$shop_id;
    public function __construct($from_date,$to_date,$shop_id)
    {
        $this->from_date = $from_date;
        $this->to_date = $to_date;
        $this->shop_id = $shop_id;
    }
    public function view(): View
    {
        $from_date = $this->from_date ? date('Y-m-d', strtotime($this->from_date)) : '';
        $to_date = $this->to_date ? date('Y-m-d', strtotime($this->to_date)) : '';
        $shop_id = $this->shop_id;
        $data = ExportStockModel::join('users as shop', 'shop.id', 'nso007_export_stock.merchant_id')
            ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                $q->whereBetween(DB::raw("DATE_FORMAT(nso007_export_stock.done_date,'%Y-%m-%d')"), [$from_date, $to_date]);
            })
            ->selectRaw('nso007_export_stock.done_date,nso007_export_stock.merchant_id,shop.shop_name,COUNT(nso007_export_stock.id) as total_box')
            ->where('nso007_export_stock.status', 3)
            ->when($shop_id,function($q) use($shop_id){
                $q->where('nso007_export_stock.merchant_id',$shop_id);
            })
            ->when(!in_array("Administrator",Auth::user()->getRoleNames()->toArray()),function($q){
                $q->where('staff_id',Auth::user()->id);
            })
            ->groupBy([DB::raw("DATE_FORMAT(nso007_export_stock.done_date, '%Y %m')"), 'nso007_export_stock.merchant_id'])
            ->orderBy('nso007_export_stock.done_date','DESC');
        return view('administrator.shop-report.export-shop-box', compact('data','from_date','to_date'));
    }
}
