<?php

namespace App\Exports;

use App\PickupAdminModel;
use Maatwebsite\Excel\Concerns\FromView;
use Illuminate\Contracts\View\View;
use Illuminate\Support\Facades\DB;

class DriverPickupExport implements FromView
{
    private $from_date,$to_date,$driver_id;
    public function __construct($from_date,$to_date,$driver_id)
    {
        $this->from_date = $from_date;
        $this->to_date = $to_date;
        $this->driver_id = $driver_id;
    }
    public function view(): View
    {
        // $from_date = $this->from_date ? date('Y-m-d', strtotime($this->from_date)) : '';
        // $to_date = $this->to_date ? date('Y-m-d', strtotime($this->to_date)) : '';
        // $driver_id = $this->driver_id;
        // $data = PickupAdminModel::join("users","users.id","nso007_pickup_admin.driver_id")
        //     ->selectRaw('nso007_pickup_admin.*,COUNT(nso007_pickup_admin.id) as total_box,users.name as driver_name')
        //     ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
        //         $q->whereBetween(DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
        //     })
        //     ->where('nso007_pickup_admin.status',4)
        //     ->when($driver_id,function($q) use($driver_id){
        //         $q->where('nso007_pickup_admin.driver_id',$driver_id);
        //     })
        //     ->groupBy([DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date, '%Y %m')"), 'nso007_pickup_admin.driver_id'])
        //     ->orderBy("nso007_pickup_admin.delivery_date","DESC");
            
            
            $from_date = $this->from_date ? date('Y-m-d', strtotime($this->from_date)) : '';
            $to_date = $this->to_date ? date('Y-m-d', strtotime($this->to_date)) : '';
            $driver_id = $this->driver_id;
            $data = PickupAdminModel::join("users","users.id","nso007_pickup_admin.driver_id")
            ->selectRaw('nso007_pickup_admin.*,sum(nso007_pickup_admin.exact_qty) as total_box,users.name as driver_name')
            ->when($from_date && $to_date,function ($q) use ($from_date, $to_date) {
                $q->whereBetween(DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date,'%Y-%m-%d')"), [$from_date, $to_date]);
            })
            ->where('nso007_pickup_admin.status',4)
            ->when($driver_id,function($q) use($driver_id){
                $q->where('nso007_pickup_admin.driver_id',$driver_id);
            })
            ->groupBy([DB::raw("DATE_FORMAT(nso007_pickup_admin.delivery_date, '%Y %m')"), 'nso007_pickup_admin.driver_id'])
            ->orderBy("nso007_pickup_admin.delivery_date","DESC");
        return view('administrator.driver-report.export-pickup', compact('data','from_date','to_date'));

    }
}
