<?php
	namespace App\Classes;
	use DB;
	use Auth;
	use App\SaleStockModel;
	use App\CommissionModel;
	use App\CommissionItemReportModel;
	use App\FundsRegisterModel;
	use App\FundsTransactionModel;
	use App\CommissionItemModel;
	use App\SaleStockDetailModel;
	use App\LoanModel;
	use App\User;

	class AgencyCommission
	{
		/**
	     *  Put commission when making payment
	     */ 
	    public function agency_commission_external_project($amount_payment, $sale_id)
	    {
	        $commission_id	= $this->get_commissionid_by_saleid($sale_id);
	        $sale_record 	= $this->get_agencyid_by_saleid($sale_id);
	    	$item_name 		= $this->get_itemname_by_saleid($sale_id);
	        $agency_id 		= $sale_record->agency_id;
	        $sale_cost 		= $sale_record->sale_amount;
	        $receive_paid 	= $sale_record->sale_payment;
	        $deposit_paid 	= $sale_record->sale_receive;
	        $sale_status 	= $sale_record->sale_status;
	        if ($sale_status == 1) {
	        	$amount_paid  	= $receive_paid + $deposit_paid;
	        } elseif ($sale_status == 2) {
	        	$amount_paid  	= $receive_paid;
	        }

	        $get_parent 	= DB::select("
	            SELECT
	            level1.id AS level_1_id,
	            level2.id AS level_2_id,
	            level3.id AS level_3_id,
	            level4.id AS level_4_id,
	            level5.id AS level_5_id,
	            level6.id AS level_6_id
	            FROM users level1
	            LEFT JOIN users level2 on level1.parent_id = level2.id
	            LEFT JOIN users level3 ON level2.parent_id = level3.id
	            LEFT JOIN users level4 ON level3.parent_id = level4.id
	            LEFT JOIN users level5 ON level4.parent_id = level5.id
	            LEFT JOIN users level6 ON level5.parent_id = level6.id
	            WHERE level1.id = $agency_id
	        ");

	        $parent = [];

	        empty($get_parent[0]->level_1_id)? : $parent['parent_lvl_1_id'] = $get_parent[0]->level_1_id;
	        empty($get_parent[0]->level_2_id)? : $parent['parent_lvl_2_id'] = $get_parent[0]->level_2_id;
	        empty($get_parent[0]->level_3_id)? : $parent['parent_lvl_3_id'] = $get_parent[0]->level_3_id;
	        empty($get_parent[0]->level_4_id)? : $parent['parent_lvl_4_id'] = $get_parent[0]->level_4_id;
	        empty($get_parent[0]->level_5_id)? : $parent['parent_lvl_5_id'] = $get_parent[0]->level_5_id;
	        empty($get_parent[0]->level_6_id)? : $parent['parent_lvl_6_id'] = $get_parent[0]->level_6_id;

	        $count_parent = count($parent);

	        if ($count_parent == 1) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }
	        }elseif ($count_parent == 2) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }

	            $lvl2__id 			= $parent['parent_lvl_2_id'];
	            $lvl2_account_number= $this->get_funds_account_number($lvl2__id);
	            $lvl2_item_id 		= $this->get_id_commission_list($lvl2__id, $commission_id);
	            $lvl2_commission	= $this->get_commission_in_commission_list($lvl2_item_id);
	            $lvl2_condition		= $this->get_condition_in_commission_list($lvl2_item_id);
	            $commission_level2 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 2, $lvl2_commission, $lvl2_condition);
	            if (!empty($commission_level2)) {
	            	$this->put_commission_to_report($lvl2_item_id, $commission_level2);
	                $this->increment_funds_balance($lvl2__id, $commission_level2, $item_name, $lvl2_account_number);
	                $this->increment_commission_receive($lvl2__id, $commission_level2, $commission_id);
	            }
	        }elseif ($count_parent == 3) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }

	            $lvl2__id 			= $parent['parent_lvl_2_id'];
	            $lvl2_account_number= $this->get_funds_account_number($lvl2__id);
	            $lvl2_item_id 		= $this->get_id_commission_list($lvl2__id, $commission_id);
	            $lvl2_commission	= $this->get_commission_in_commission_list($lvl2_item_id);
	            $lvl2_condition		= $this->get_condition_in_commission_list($lvl2_item_id);
	            $commission_level2 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 2, $lvl2_commission, $lvl2_condition);
	            if (!empty($commission_level2)) {
	            	$this->put_commission_to_report($lvl2_item_id, $commission_level2);
	                $this->increment_funds_balance($lvl2__id, $commission_level2, $item_name, $lvl2_account_number);
	                $this->increment_commission_receive($lvl2__id, $commission_level2, $commission_id);
	            }

	            $lvl3__id 			= $parent['parent_lvl_3_id'];
	            $lvl3_account_number= $this->get_funds_account_number($lvl3__id);
	            $lvl3_item_id 		= $this->get_id_commission_list($lvl3__id, $commission_id);
	            $lvl3_commission	= $this->get_commission_in_commission_list($lvl3_item_id);
	            $lvl3_condition		= $this->get_condition_in_commission_list($lvl3_item_id);
	            $commission_level3 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 3, $lvl3_commission, $lvl3_condition);
	            if (!empty($commission_level3)) {
	            	$this->put_commission_to_report($lvl3_item_id, $commission_level3);
	                $this->increment_funds_balance($lvl3__id, $commission_level3, $item_name, $lvl3_account_number);
	                $this->increment_commission_receive($lvl3__id, $commission_level3, $commission_id);
	            }
	        }elseif ($count_parent == 4) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }

	            $lvl2__id 			= $parent['parent_lvl_2_id'];
	            $lvl2_account_number= $this->get_funds_account_number($lvl2__id);
	            $lvl2_item_id 		= $this->get_id_commission_list($lvl2__id, $commission_id);
	            $lvl2_commission	= $this->get_commission_in_commission_list($lvl2_item_id);
	            $lvl2_condition		= $this->get_condition_in_commission_list($lvl2_item_id);
	            $commission_level2 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 2, $lvl2_commission, $lvl2_condition);
	            if (!empty($commission_level2)) {
	            	$this->put_commission_to_report($lvl2_item_id, $commission_level2);
	                $this->increment_funds_balance($lvl2__id, $commission_level2, $item_name, $lvl2_account_number);
	                $this->increment_commission_receive($lvl2__id, $commission_level2, $commission_id);
	            }

	            $lvl3__id 			= $parent['parent_lvl_3_id'];
	            $lvl3_account_number= $this->get_funds_account_number($lvl3__id);
	            $lvl3_item_id 		= $this->get_id_commission_list($lvl3__id, $commission_id);
	            $lvl3_commission	= $this->get_commission_in_commission_list($lvl3_item_id);
	            $lvl3_condition		= $this->get_condition_in_commission_list($lvl3_item_id);
	            $commission_level3 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 3, $lvl3_commission, $lvl3_condition);
	            if (!empty($commission_level3)) {
	            	$this->put_commission_to_report($lvl3_item_id, $commission_level3);
	                $this->increment_funds_balance($lvl3__id, $commission_level3, $item_name, $lvl3_account_number);
	                $this->increment_commission_receive($lvl3__id, $commission_level3, $commission_id);
	            }

	            $lvl4__id 			= $parent['parent_lvl_4_id'];
	            $lvl4_account_number= $this->get_funds_account_number($lvl4__id);
	            $lvl4_item_id 		= $this->get_id_commission_list($lvl4__id, $commission_id);
	            $lvl4_commission	= $this->get_commission_in_commission_list($lvl4_item_id);
	            $lvl4_condition		= $this->get_condition_in_commission_list($lvl4_item_id);
	            $commission_level4 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 4, $lvl4_commission, $lvl4_condition);
	            if (!empty($commission_level4)) {
	            	$this->put_commission_to_report($lvl4_item_id, $commission_level4);
	                $this->increment_funds_balance($lvl4__id, $commission_level4, $item_name, $lvl4_account_number);
	                $this->increment_commission_receive($lvl4__id, $commission_level4, $commission_id);
	            }
	        }elseif ($count_parent == 5) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }

	            $lvl2__id 			= $parent['parent_lvl_2_id'];
	            $lvl2_account_number= $this->get_funds_account_number($lvl2__id);
	            $lvl2_item_id 		= $this->get_id_commission_list($lvl2__id, $commission_id);
	            $lvl2_commission	= $this->get_commission_in_commission_list($lvl2_item_id);
	            $lvl2_condition		= $this->get_condition_in_commission_list($lvl2_item_id);
	            $commission_level2 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 2, $lvl2_commission, $lvl2_condition);
	            if (!empty($commission_level2)) {
	            	$this->put_commission_to_report($lvl2_item_id, $commission_level2);
	                $this->increment_funds_balance($lvl2__id, $commission_level2, $item_name, $lvl2_account_number);
	                $this->increment_commission_receive($lvl2__id, $commission_level2, $commission_id);
	            }

	            $lvl3__id 			= $parent['parent_lvl_3_id'];
	            $lvl3_account_number= $this->get_funds_account_number($lvl3__id);
	            $lvl3_item_id 		= $this->get_id_commission_list($lvl3__id, $commission_id);
	            $lvl3_commission	= $this->get_commission_in_commission_list($lvl3_item_id);
	            $lvl3_condition		= $this->get_condition_in_commission_list($lvl3_item_id);
	            $commission_level3 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 3, $lvl3_commission, $lvl3_condition);
	            if (!empty($commission_level3)) {
	            	$this->put_commission_to_report($lvl3_item_id, $commission_level3);
	                $this->increment_funds_balance($lvl3__id, $commission_level3, $item_name, $lvl3_account_number);
	                $this->increment_commission_receive($lvl3__id, $commission_level3, $commission_id);
	            }

	            $lvl4__id 			= $parent['parent_lvl_4_id'];
	            $lvl4_account_number= $this->get_funds_account_number($lvl4__id);
	            $lvl4_item_id 		= $this->get_id_commission_list($lvl4__id, $commission_id);
	            $lvl4_commission	= $this->get_commission_in_commission_list($lvl4_item_id);
	            $lvl4_condition		= $this->get_condition_in_commission_list($lvl4_item_id);
	            $commission_level4 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 4, $lvl4_commission, $lvl4_condition);
	            if (!empty($commission_level4)) {
	            	$this->put_commission_to_report($lvl4_item_id, $commission_level4);
	                $this->increment_funds_balance($lvl4__id, $commission_level4, $item_name, $lvl4_account_number);
	                $this->increment_commission_receive($lvl4__id, $commission_level4, $commission_id);
	            }

	            $lvl5__id 			= $parent['parent_lvl_5_id'];
	            $lvl5_account_number= $this->get_funds_account_number($lvl5__id);
	            $lvl5_item_id 		= $this->get_id_commission_list($lvl5__id, $commission_id);
	            $lvl5_commission	= $this->get_commission_in_commission_list($lvl5_item_id);
	            $lvl5_condition		= $this->get_condition_in_commission_list($lvl5_item_id);
	            $commission_level5 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 5, $lvl5_commission, $lvl5_condition);
	            if (!empty($commission_level5)) {
	            	$this->put_commission_to_report($lvl5_item_id, $commission_level5);
	                $this->increment_funds_balance($lvl5__id, $commission_level5, $item_name, $lvl5_account_number);
	                $this->increment_commission_receive($lvl5__id, $commission_level5, $commission_id);
	            }
	        }elseif ($count_parent == 6) {
	            $lvl1__id 			= $parent['parent_lvl_1_id'];
	            $lvl1_account_number= $this->get_funds_account_number($lvl1__id);
	            $lvl1_item_id 		= $this->get_id_commission_list($lvl1__id, $commission_id);
	            $lvl1_commission	= $this->get_commission_in_commission_list($lvl1_item_id);
	            $lvl1_condition		= $this->get_condition_in_commission_list($lvl1_item_id);
	            $commission_level1 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 1, $lvl1_commission, $lvl1_condition);
	            if (!empty($commission_level1)) {
	            	$this->put_commission_to_report($lvl1_item_id, $commission_level1);
	                $this->increment_funds_balance($lvl1__id, $commission_level1, $item_name, $lvl1_account_number);
	                $this->increment_commission_receive($lvl1__id, $commission_level1, $commission_id);
	            }

	            $lvl2__id 			= $parent['parent_lvl_2_id'];
	            $lvl2_account_number= $this->get_funds_account_number($lvl2__id);
	            $lvl2_item_id 		= $this->get_id_commission_list($lvl2__id, $commission_id);
	            $lvl2_commission	= $this->get_commission_in_commission_list($lvl2_item_id);
	            $lvl2_condition		= $this->get_condition_in_commission_list($lvl2_item_id);
	            $commission_level2 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 2, $lvl2_commission, $lvl2_condition);
	            if (!empty($commission_level2)) {
	            	$this->put_commission_to_report($lvl2_item_id, $commission_level2);
	                $this->increment_funds_balance($lvl2__id, $commission_level2, $item_name, $lvl2_account_number);
	                $this->increment_commission_receive($lvl2__id, $commission_level2, $commission_id);
	            }

	            $lvl3__id 			= $parent['parent_lvl_3_id'];
	            $lvl3_account_number= $this->get_funds_account_number($lvl3__id);
	            $lvl3_item_id 		= $this->get_id_commission_list($lvl3__id, $commission_id);
	            $lvl3_commission	= $this->get_commission_in_commission_list($lvl3_item_id);
	            $lvl3_condition		= $this->get_condition_in_commission_list($lvl3_item_id);
	            $commission_level3 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 3, $lvl3_commission, $lvl3_condition);
	            if (!empty($commission_level3)) {
	            	$this->put_commission_to_report($lvl3_item_id, $commission_level3);
	                $this->increment_funds_balance($lvl3__id, $commission_level3, $item_name, $lvl3_account_number);
	                $this->increment_commission_receive($lvl3__id, $commission_level3, $commission_id);
	            }

	            $lvl4__id 			= $parent['parent_lvl_4_id'];
	            $lvl4_account_number= $this->get_funds_account_number($lvl4__id);
	            $lvl4_item_id 		= $this->get_id_commission_list($lvl4__id, $commission_id);
	            $lvl4_commission	= $this->get_commission_in_commission_list($lvl4_item_id);
	            $lvl4_condition		= $this->get_condition_in_commission_list($lvl4_item_id);
	            $commission_level4 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 4, $lvl4_commission, $lvl4_condition);
	            if (!empty($commission_level4)) {
	            	$this->put_commission_to_report($lvl4_item_id, $commission_level4);
	                $this->increment_funds_balance($lvl4__id, $commission_level4, $item_name, $lvl4_account_number);
	                $this->increment_commission_receive($lvl4__id, $commission_level4, $commission_id);
	            }

	            $lvl5__id 			= $parent['parent_lvl_5_id'];
	            $lvl5_account_number= $this->get_funds_account_number($lvl5__id);
	            $lvl5_item_id 		= $this->get_id_commission_list($lvl5__id, $commission_id);
	            $lvl5_commission	= $this->get_commission_in_commission_list($lvl5_item_id);
	            $lvl5_condition		= $this->get_condition_in_commission_list($lvl5_item_id);
	            $commission_level5 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 5, $lvl5_commission, $lvl5_condition);
	            if (!empty($commission_level5)) {
	            	$this->put_commission_to_report($lvl5_item_id, $commission_level5);
	                $this->increment_funds_balance($lvl5__id, $commission_level5, $item_name, $lvl5_account_number);
	                $this->increment_commission_receive($lvl5__id, $commission_level5, $commission_id);
	            }

	            $lvl6__id 			= $parent['parent_lvl_6_id'];
	            $lvl6_account_number= $this->get_funds_account_number($lvl6__id);
	            $lvl6_item_id 		= $this->get_id_commission_list($lvl6__id, $commission_id);
	            $lvl6_commission	= $this->get_commission_in_commission_list($lvl6_item_id);
	            $lvl6_condition		= $this->get_condition_in_commission_list($lvl6_item_id);
	            $commission_level6 	= $this->calculate_commission_payment($sale_cost, $amount_paid, $amount_payment, 6, $lvl6_commission, $lvl6_condition);
	            if (!empty($commission_level6)) {
	            	$this->put_commission_to_report($lvl6_item_id, $commission_level6);
	                $this->increment_funds_balance($lvl6__id, $commission_level6, $item_name, $lvl6_account_number);
	                $this->increment_commission_receive($lvl6__id, $commission_level6, $commission_id);
	            }
	        }
	    }

	    public function get_agencyid_by_saleid($sale_id)
	    {
	    	return SaleStockModel::find($sale_id, [
	    		'agency_id', 
	    		'sale_amount', 
	    		'sale_receive', 
	    		'sale_payment',
	    		'sale_status'
	    	]);
	    }
	    public function get_commissionid_by_saleid($sale_id)
	    {
	    	$data = CommissionModel::where('sale_id', $sale_id)->get(['id']);
	    	return $data[0]->id;
	    }
	    /**
	     *  Calculate commission
	     */ 
	    public function calculate_commission_payment($cost, $paid, $payment, $level, $commission, $condition)
	    {
	        $lvl_no 		= $level;
	        $get_commission = 0;
            $condition 		= $cost * $condition / 100;

	        if ($lvl_no == 1) {
	            $agency_commission = $cost * $commission / 100;
	        } elseif ($lvl_no == 2) {
	            $agency_commission = $cost * 0.1 / 100;
	        } elseif ($lvl_no == 3) {
	            $agency_commission = $cost * 0.1 / 100;
	        } elseif ($lvl_no == 4) {
	            $agency_commission = $cost * 0.1 / 100;
	        } elseif ($lvl_no == 5) {
	            $agency_commission = $cost * 0.1 / 100;
	        } elseif ($lvl_no == 6) {
	            $agency_commission = $cost * 0.1 / 100;
	        }

            if ($paid < $condition) {
                if (($paid + $payment) <= $condition) {
                    $payment_commission	= $payment / $condition;
                    $get_commission 	= $agency_commission * $payment_commission;
                } elseif (($paid + $payment) > $condition) {
                    $payment_commission	= ($condition - $paid) / $condition;
                    $get_commission 	= $agency_commission * $payment_commission;
                }
            }
	        return $get_commission;
	    }
	    /**
	     *  Put commission to report
	     */ 
	    public function put_commission_to_report($commission_item_id, $commission_amount)
	    {
	        $data = array(
	            'commission_item_id' => $commission_item_id,
	            'amount' => $commission_amount
	        );
	        CommissionItemReportModel::insert($data);
	    }
	    /**
	     *  Increment balance funds
	     */ 
	    public function increment_funds_balance($agency_id, $commission_amount, $item_name, $account_number)
	    {
	        $agency_mix = $this->get_agency_info_in_getcommission($item_name);
	        FundsRegisterModel::where('user_id', $agency_id)->increment('balance', $commission_amount);
	        $balance = FundsRegisterModel::where('user_id', $agency_id)->first()->balance;
	        $revenue = New FundsTransactionModel;
	        $revenue->operation_type    = 3;
	        $revenue->account_number    = $account_number;
	        $revenue->amount            = $commission_amount;
	        $revenue->balance           = $balance;
	        $revenue->request_date      = date('d-m-Y H:i:s A');
	        $revenue->remark            = "Get commission from ".$agency_mix."/".$item_name;
	        $revenue->user_log          = Auth::user()->id;
	        $revenue->status            = 1;
	        $revenue->save();
	    }
	    /**
	     *  Increment commision agency recieve
	     */ 
	    public function increment_commission_receive($agency_id, $commission_amount, $commissionid)
	    {
	        CommissionItemModel::where('commission_id', $commissionid)
	        ->where('agency_id', $agency_id)
	        ->increment('receive', $commission_amount);
	    }
	    /**
	     *  Get funds account number
	     */ 
	    public function get_funds_account_number($agency_id)
	    {
	    	$data = FundsRegisterModel::where('user_id', $agency_id)->get(['account_number']);
	    	return $data[0]->account_number;
	    }
	    /**
	     *  Get ID commission list
	     */ 
	    public function get_id_commission_list($agency_id, $commission_id)
	    {
	    	$data = CommissionItemModel::where('commission_id', $commission_id)->where('agency_id', $agency_id)->get(['id']);
	    	return $data[0]->id;
	    }
	    /**
	     *  Active Agency Commission When Making Contract
	     */ 
	    public function active_agency_commission($sale_id)
	    {
	        CommissionModel::where('sale_id', $sale_id)->update(['status' => 1]);
	        $data_commission = CommissionModel::where('sale_id', $sale_id)->get();
	        $commission_id = $data_commission[0]->id;
	        CommissionItemModel::where('commission_id', $commission_id)->update(['status' => 1]);
	    }
	    /**
	     *	Get Account Funds Name and Number Agency By Item Name/Code
	     */ 
	    public function get_agency_info_in_getcommission($item_name)
	    {
	        $data = DB::select("
	            SELECT 
	            CONCAT(users.user_firstname, ' ',users.user_lastname, ' (', users.user_code, ')') AS mix_agency
	            FROM nso007_item_stock AS item
	            INNER JOIN nso007_sale_detail_stock AS detail ON detail.saledetail_itemid = item.id
	            INNER JOIN nso007_sale_stock AS stock ON stock.id = detail.saledetail_saleid
	            INNER JOIN users ON users.id = stock.agency_id
	            WHERE item.item_name = '$item_name'
	        ");
	        return $data[0]->mix_agency;
	    }
	    /**
	     *	Get Item Name By Sale Id
	     */ 
	    public function get_itemname_by_saleid($sale_id)
	    {
	    	$data = SaleStockDetailModel::where('saledetail_saleid', $sale_id)
        	->leftjoin('nso007_item_stock as item', 'nso007_sale_detail_stock.saledetail_itemid', '=', 'item.id')
	    	->select('item_name')->get();
        	return $data[0]->item_name;
	    }
	    /**
	     * Get Commission In Commission Item List
	     */ 
	    public function get_commission_in_commission_list($id)
	    {
	    	$data = CommissionItemModel::find($id);
	    	return $data->commission;
	    }
	    /**
	     * Get Commission In Condition Item List
	     */ 
	    public function get_condition_in_commission_list($id)
	    {
	    	$data = CommissionItemModel::find($id);
	    	return $data->condition;
	    }
	    /**
	     *	Get sale id by loan id
	     */ 
	    public function get_saleid_by_loanid($loanid)
	    {
	    	$data = LoanModel::find($loanid);
	    	return $data->loan_saleid;
	    }
	    /**
	     *	Get Agency Type By Agency ID
	     */ 
	    public function get_agencytype_by_agencyid($id)
	    {
	    	$data = User::find($id);
	    	return $data->agency_type;
	    }
	}
?>