
<?php $__env->startSection('content'); ?>
    <?php Fun::lang()?>
    <div class="top-header">
        <ol class="breadcrumb">
            <li><a href="<?php echo e(route('app_dashboard')); ?>"><?php echo e(__('administrator.dashboard')); ?></a></li>
            <li><a href="<?php echo e(route('location.index')); ?>"><?php echo e(__('administrator.zone')); ?></a></li>
            <li><a href="#" class="active"><?php echo e(__('administrator.location')); ?></a></li>
        </ol>
    </div>
    <div class="page">
        <div class=container-fluid>
            <div class="top-content">
                <div class="row">
                    <div class="col-sm-12 col-xs-12">
                        <div class="title-add">
                            
                                <div class="pull-left">
                                    <h3><span class="fa fa-th"></span> <?php echo e(__('administrator.location')); ?></h3>
                                </div>
                                <div class="pull-right">
                                    <a href="<?php echo e(route('location.index')); ?>" class="button_sm button_warning pull-right">
                                    <span class=" fa fa-arrow-circle-left"></span> <?php echo e(__('administrator.back')); ?></a>
                                </div>

                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Create Location')): ?>
                                        <a href="#" class="button_sm button_primary pull-right bt_location">
                                        <span class=" fa fa-plus"></span> <?php echo e(__('administrator.location')); ?></a>
                                    <?php endif; ?>
                                </div>
                                <div class="pull-right">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('Import Location From Excel')): ?>
                                        <a href="#" class="button_sm button_primary pull-right bt_import">
                                        <span class=" fa fa-plus"></span> <?php echo e(__('administrator.import_from_excel')); ?></a>
                                    <?php endif; ?>
                                </div>
                            

                        </div>
                    </div>
                </div>
            </div>
            <div class="wrapper-table ">
                <table id="datatable_location" width="100%" class="table table-striped table-hover  ">
                    <thead>
                    <tr>
                        <th>#</th>
                        <th><?php echo e(__('administrator.zone')); ?></th>
                        <th><?php echo e(__('administrator.location')); ?></th>
                        <th><?php echo e(__('administrator.price')); ?></th>
                        <th><?php echo e(__('administrator.action')); ?></th>
                    </tr>
                    </thead>
                    <tbody>

                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <div class="modal fade" id="loginModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('administrator.edit_location')); ?> </h4>
                </div>

                <div class="modal-body">
                    <form id="idForm" method="POST" action="<?php echo e(route('location-with-zone.update','id')); ?>" class="form-horizontal edit_loc" enctype="multipart/form-data">
                        <?php echo method_field('PATCH'); ?>
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.name_en')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::text('name_en', null, array('placeholder' =>__('administrator.name_en'),'class' => 'form-control','required')); ?>

                                <?php echo Form::hidden('id', null, array('placeholder' =>'','class' => 'form-control','required')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.name_km')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::text('name_km', null, array('placeholder' =>__('administrator.name_km'),'class' => 'form-control','required')); ?>

                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.price')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::number('price', null, array('placeholder' =>__('administrator.price'),'class' => 'form-control','step'=>'any')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.currency')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::select('currency_symbol', ['$'=>__('administrator.dollars'),'៛'=>__('administrator.riel')],null, array('class' => 'form-control','required')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-12 col-xs-12">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> <?php echo e(__('administrator.save')); ?></button>
                                <button type="button"data-dismiss="modal" aria-hidden="true" class="button_sm button_danger pull-right">
                                    <span class="fa fa-close"></span> <?php echo e(__('administrator.close')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="add_location" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('administrator.location')); ?></h4>
                </div>

                <div class="modal-body">
                    <form id="idForm" method="post" action="<?php echo e(route('location-with-zone.store')); ?>" class="form-horizontal">
                        <?php echo csrf_field(); ?>
                        
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.name_en')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::text('name_en', null, array('placeholder' =>__('administrator.name_en'),'class' => 'form-control','required')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.name_km')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::text('name_km', null, array('placeholder' =>__('administrator.name_km'),'class' => 'form-control','required')); ?>

                            </div>
                        </div>

                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.price')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::number('price', null, array('placeholder' =>__('administrator.price'),'class' => 'form-control','step'=>'any')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <label class="col-sm-4"><?php echo e(__('administrator.currency')); ?></label>
                            <div class="col-sm-8">
                                <?php echo Form::select('currency_symbol', ['$'=>__('administrator.dollars'),'៛'=>__('administrator.riel')],null, array('class' => 'form-control','required')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-12 col-xs-12">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> <?php echo e(__('administrator.save')); ?></button>
                                <button type="button"data-dismiss="modal" aria-hidden="true" class="button_sm button_danger pull-right">
                                    <span class="fa fa-close"></span> <?php echo e(__('administrator.close')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="import_excel" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true" data-backdrop="static">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                    <h4 class="modal-title"><?php echo e(__('administrator.location')); ?></h4>
                </div>

                <div class="modal-body">
                    <form id="idForm" method="post" action="<?php echo e(route('location-import')); ?>" class="form-horizontal" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label class="col-sm-4">Import Excel File</label>
                            <div class="col-sm-8">
                                <?php echo Form::file('import_file', null, array('placeholder' =>__('administrator.name_en'),'class' => 'form-control','required')); ?>

                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-sm-12 col-xs-12">
                                <button type="submit" class="button_sm button_primary pull-right"><span class="fa fa-save"></span> <?php echo e(__('administrator.save')); ?></button>
                                <button type="button"data-dismiss="modal" aria-hidden="true" class="button_sm button_danger pull-right">
                                    <span class="fa fa-close"></span> <?php echo e(__('administrator.close')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            
            
            $(document).on('click','.bt_import',function(){
                $('#import_excel').modal('show');
            });
            $(document).on('click','.bt_location',function(){
                $('#add_location').modal('show');
            });
            $(document).on('click','.delete_location',function(){
                var id = $(this).data('id');

                $('#loading').show();

                if ($.confirm({
                    title: '<strong style="color:darkcyan;"><?php echo e(__('administrator.are_you_sure')); ?></strong>',
                    content: "<b> <?php echo e(__('administrator.are_you_sure')); ?> </b>",
                    type: "red",
                    buttons: {

                        '<?php echo e(__('administrator.cancel')); ?>':
                            {
                                btnClass: 'btn-red',
                                action:
                                    function () {
                                    }
                            }
                        ,
                        '<?php echo e(__('administrator.ok')); ?>':
                            {
                                btnClass: 'btn-blue',
                                action:

                                    function () {
                                        $.ajax({
                                            type: "POST",
                                            dataType: "json",
                                            url: '<?php echo e(route("location_delete")); ?>',
                                            data: {'id': id,  _token: '<?php echo e(csrf_token()); ?>'},
                                            success: function (data) {
                                                $('#loading').hide();
                                                location.reload();

                                            }

                                        });
                                    }
                            }
                    }
                }))

                    return false;
            });

            $('#datatable_location').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                    },
                },
                "bStateSave": true,
                "fnStateSave": function (oSettings, oData) {
                    localStorage.setItem('offersDataTables', JSON.stringify(oData));
                },
                "fnStateLoad": function (oSettings) {
                    return JSON.parse(localStorage.getItem('offersDataTables'));
                },
                ordering: false,
                serverSide: true,
                lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
                ajax: window.location,
                columns:
                    [
                        {data: 'DT_RowIndex','searchable':false},
                        {data: 'zone',name:'location.name_en'},
                        {data: 'location',name:'location.name_en'},
                        {data: 'price'},
                        {data: 'action'},

                    ],

                "initComplete": function (settings, json) {
                }
            });


            $(document).on('click','.edit_location',function(){

                var name_en = $(this).data('name_en');
                var name_km = $(this).data('name_km');
                var price = $(this).data('price');
                let zone_id = $(this).data('zone');
                let currency = $(this).data('currency');
                var id = $(this).data('id');
                let method = $('.edit_loc').attr('action').replace('id',id);
                $('.edit_loc').attr('action',method);
                $('#loginModal').modal('show');
                $('#loginModal input[name="name_en"]').val(name_en);
                $('#loginModal input[name="name_km"]').val(name_km);
                $('#loginModal input[name="price"]').val(price);
                $('#loginModal input[name="id"]').val(id);
                $('#loginModal select[name="pearent_id"]').val(zone_id).change();
                $('#loginModal select[name="currency_symbol"]').val(currency).change();

            });

        });
        
    </script>
<?php $__env->stopSection(); ?>





<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/location-zone/index.blade.php ENDPATH**/ ?>