<div class="panel-group" id="accordion" role="tablist" aria-multiselectable="true">
    <div class="panel panel-default">
    <div class="panel-heading active" role="tab" id="headingOne">
        <h4 class="panel-title">
        <a role="button" onclick="" data-toggle="collapse" data-parent="#accordion" href="#collapse_padding" aria-expanded="true" aria-controls="collapse_padding">
                Filtering
        </a>
        <a style="float: right" role="button" data-toggle="collapse" data-parent="#accordion" href="#collapse_padding" aria-expanded="true" aria-controls="collapse_padding">
                <i class="fa fa-arrow-down"></i>
        </a>
        </h4>
    </div>
    <div id="collapse_padding" class="panel-collapse collapse in" role="tabpanel" aria-labelledby="headingOne">
        <div class="panel-body" style="padding: 0 !important;border: none !important;">
            
            <form  action="" method="post" class=" submit" enctype="multipart/form-data" >
                <?php echo csrf_field(); ?>
                <div class="form-search" style="margin: 0 !important">
                <div class="form-group col-sm-3 col-xs-3">
                    <label for=""><?php echo e(__('administrator.shop_name')); ?></label>
                    <?php echo Form::select('merchant', $merchant_show, null, ['class' => 'form-control pad_merchant']); ?>

                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">City / Province</label>
                    <select name="province_or_city[]" id="pad_province_or_city" class="form-control chosen-select">
                        <option value="">  <?php echo e(__('administrator.please_choose')); ?> </option>
                        <option value="pp">  Phnom Penh </option>
                        <option value="No">  Provice </option>
                    </select>
                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">From Date</label>
                    <?php echo Form::text('from_date', date('d-m-Y'), array('placeholder' => __('administrator.from_date'),'class' => 'form-control pad_from_date date_picker')); ?>

                </div>
                <div class="form-group col-sm-3 col-xs-3">
                    <label for="">To Date</label>
                    <?php echo Form::text('to_date',date('d-m-Y'), array('placeholder' => __('administrator.to_date'),'class' => 'form-control pad_to_date date_picker')); ?>

                </div>

                
                </div>
            </form>
        </div>
    </div>
    </div>

</div>
<div class="wrapper-table ">
    <table id="table_padding" width="100%" class="table table-striped hover">
        <thead>
        <tr>
            <th>    <?php echo e(__('administrator.no')); ?>          </th>
            <th>    <?php echo e(__('administrator.date')); ?>        </th>
            <th >   <?php echo e(__('administrator.box_code')); ?>    </th>
            <th >   <?php echo e(__('administrator.shop_name')); ?>   </th>
            <th>    <?php echo e(__('administrator.location')); ?>    </th>
            <th>    <?php echo e(__('administrator.customer_receive')); ?>  </th>
            <th>    <?php echo e(__('administrator.driver')); ?>      </th>
            <th>    <?php echo e(__('administrator.driver_number')); ?>  </th>
            <th>    <?php echo e(__('administrator.price')); ?>       </th>
            <th>    <?php echo e(__('administrator.delivery_fee')); ?></th>
            <th>    <?php echo e(__('administrator.price_of_car')); ?></th>
            <th>    <?php echo e(__('administrator.reason')); ?>      </th>
            <th>    <?php echo e(__('administrator.action')); ?>      </th>

        </tr>
        <tbody class="tbody">

        </tbody>

    </table>
</div>


<script>
    $(document).ready(function () {
        paddingAjax();
        function paddingAjax(from_date= "", to_date="", merchant= '',status='',pro_or_city='',driver_id){
            $('#table_padding').DataTable().destroy();
            $('#table_padding').DataTable({
                "oLanguage": {
                    "sSearch": "<?php echo e(__('administrator.search')); ?>:",
                    "sLengthMenu": "<?php echo e(__('administrator.display')); ?> _MENU_ <?php echo e(__('administrator.record_per_page')); ?>",
                    "sZeroRecords": "<?php echo e(__('administrator.Nothing_foundsorry')); ?>",
                    "sInfo": "<?php echo e(__('administrator.showing')); ?> _START_ <?php echo e(__('administrator.to')); ?> _END_ <?php echo e(__('administrator.of')); ?> _TOTAL_ <?php echo e(__('administrator.record')); ?>",
                    "sInfoEmpty": "<?php echo e(__('administrator.showing')); ?> 0 <?php echo e(__('administrator.to')); ?> 0 <?php echo e(__('administrator.of')); ?> 0 <?php echo e(__('administrator.record')); ?>",
                    "sInfoFiltered": "(<?php echo e(__('administrator.filter_form')); ?> _MAX_ <?php echo e(__('administrator.total_records')); ?>)",
                    "oPaginate": {
                        "sFirst": "<?php echo e(__('administrator.first')); ?>",
                        "sLast": "<?php echo e(__('administrator.last')); ?>",
                        "sNext": "<?php echo e(__('administrator.next')); ?>",
                        "sPrevious": "<?php echo e(__('administrator.prevoius')); ?>"
                    },
                },
                ordering: false,
                serverSide: true,
                lengthMenu: [[100, 200, 500, 1000,-1], [100, 200, 500, 1000,'All']],
                ajax:{
                        url: "<?php echo e(route('list_delivery_padding')); ?>",
                        data:{
                            driver_id:driver_id, 
                            from_date:from_date,
                            to_date:to_date,
                            merchant:merchant,
                            status:status,
                            pro_or_city:pro_or_city
                        }
                    },
                columns:
                    [
                        {data: 'DT_RowIndex'},
                        {data: 'date'},
                        {data: 'box_code'},
                        {data: 'shop_name'},
                        {data: 'name_location'},
                        {data: 'customer_receive'},
                        {data: 'driver_name'},
                        {data: 'phone'},
                        {data: 'price'},
                        {data: 'delivery_fee'},
                        {data: 'bus_fee'},
                        {data: 'reason'},
                        {data: 'action'},
                    ],

                "initComplete": function (settings, json) {
                }
            });
        }
        $(document).on('change','.pad_merchant,#pad_province_or_city,.pad_from_date,.pad_to_date',function(){
            let from_date = $('.pad_from_date').val();
            let to_date = $('.pad_to_date').val();
            let merchant = $('.pad_merchant').val();
            let provice = $('#pad_province_or_city').val();
            paddingAjax(from_date,to_date,merchant,'',provice);
        });
});
</script><?php /**PATH /home/nsowos/public_html/kl-delivery.com/resources/views/administrator/delivery-list/padding.blade.php ENDPATH**/ ?>